#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1160
#define LARGE_STATE_COUNT 166
#define SYMBOL_COUNT 148
#define ALIAS_COUNT 4
#define TOKEN_COUNT 67
#define EXTERNAL_TOKEN_COUNT 15
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 6

enum ts_symbol_identifiers {
  sym__backslash_escape = 1,
  sym_entity_reference = 2,
  sym_numeric_character_reference = 3,
  anon_sym_LBRACK = 4,
  anon_sym_RBRACK = 5,
  anon_sym_LT = 6,
  anon_sym_GT = 7,
  anon_sym_BANG = 8,
  anon_sym_DQUOTE = 9,
  anon_sym_POUND = 10,
  anon_sym_DOLLAR = 11,
  anon_sym_PERCENT = 12,
  anon_sym_AMP = 13,
  anon_sym_SQUOTE = 14,
  anon_sym_STAR = 15,
  anon_sym_PLUS = 16,
  anon_sym_COMMA = 17,
  anon_sym_DASH = 18,
  anon_sym_DOT = 19,
  anon_sym_SLASH = 20,
  anon_sym_COLON = 21,
  anon_sym_SEMI = 22,
  anon_sym_EQ = 23,
  anon_sym_QMARK = 24,
  anon_sym_AT = 25,
  anon_sym_BSLASH = 26,
  anon_sym_CARET = 27,
  anon_sym__ = 28,
  anon_sym_BQUOTE = 29,
  anon_sym_LBRACE = 30,
  anon_sym_PIPE = 31,
  anon_sym_RBRACE = 32,
  anon_sym_TILDE = 33,
  anon_sym_LPAREN = 34,
  anon_sym_RPAREN = 35,
  sym__newline_token = 36,
  sym_uri_autolink = 37,
  sym_email_autolink = 38,
  sym__attribute_name = 39,
  aux_sym__attribute_value_token1 = 40,
  anon_sym_LT_BANG_DASH_DASH = 41,
  anon_sym_DASH_DASH_GT = 42,
  anon_sym_LT_QMARK = 43,
  anon_sym_QMARK_GT = 44,
  aux_sym__declaration_token1 = 45,
  anon_sym_LT_BANG_LBRACKCDATA_LBRACK = 46,
  anon_sym_RBRACK_RBRACK_GT = 47,
  sym__whitespace_ge_2 = 48,
  aux_sym__whitespace_token1 = 49,
  sym__word_no_digit = 50,
  sym__digits = 51,
  sym__error = 52,
  sym__trigger_error = 53,
  sym__code_span_start = 54,
  sym__code_span_close = 55,
  sym__emphasis_open_star = 56,
  sym__emphasis_open_underscore = 57,
  sym__emphasis_close_star = 58,
  sym__emphasis_close_underscore = 59,
  sym__last_token_whitespace = 60,
  sym__last_token_punctuation = 61,
  sym__strikethrough_open = 62,
  sym__strikethrough_close = 63,
  sym__latex_span_start = 64,
  sym__latex_span_close = 65,
  sym__unclosed_span = 66,
  sym_inline = 67,
  sym_backslash_escape = 68,
  sym_link_label = 69,
  sym_link_destination = 70,
  sym__link_destination_parenthesis = 71,
  sym__text_no_angle = 72,
  sym_link_title = 73,
  sym_code_span = 74,
  sym_latex_block = 75,
  sym__link_text = 76,
  sym__link_text_non_empty = 77,
  sym_shortcut_link = 78,
  sym_full_reference_link = 79,
  sym_collapsed_reference_link = 80,
  sym_inline_link = 81,
  sym_image = 82,
  sym__image_inline_link = 83,
  sym__image_shortcut_link = 84,
  sym__image_full_reference_link = 85,
  sym__image_collapsed_reference_link = 86,
  sym__image_description = 87,
  sym__image_description_non_empty = 88,
  sym__html_tag = 89,
  sym__open_tag = 90,
  sym__closing_tag = 91,
  sym__tag_name = 92,
  sym__attribute = 93,
  sym__attribute_value = 94,
  sym__html_comment = 95,
  sym__processing_instruction = 96,
  sym__declaration = 97,
  sym__cdata_section = 98,
  sym_hard_line_break = 99,
  sym__whitespace = 100,
  sym__word = 101,
  sym__soft_line_break = 102,
  sym__inline_base = 103,
  sym__text_base = 104,
  sym__text_inline_no_link = 105,
  sym__inline_element = 106,
  aux_sym__inline = 107,
  sym__inline_element_no_star = 108,
  aux_sym__inline_no_star = 109,
  sym__inline_element_no_underscore = 110,
  aux_sym__inline_no_underscore = 111,
  sym__inline_element_no_tilde = 112,
  aux_sym__inline_no_tilde = 113,
  sym__strikethrough = 114,
  sym__emphasis_star = 115,
  sym__strong_emphasis_star = 116,
  sym__emphasis_underscore = 117,
  sym__strong_emphasis_underscore = 118,
  sym__inline_element_no_link = 119,
  aux_sym__inline_no_link = 120,
  sym__inline_element_no_star_no_link = 121,
  aux_sym__inline_no_star_no_link = 122,
  sym__inline_element_no_underscore_no_link = 123,
  aux_sym__inline_no_underscore_no_link = 124,
  sym__inline_element_no_tilde_no_link = 125,
  aux_sym__inline_no_tilde_no_link = 126,
  sym__strikethrough_no_link = 127,
  sym__emphasis_star_no_link = 128,
  sym__strong_emphasis_star_no_link = 129,
  sym__emphasis_underscore_no_link = 130,
  sym__strong_emphasis_underscore_no_link = 131,
  aux_sym_link_label_repeat1 = 132,
  aux_sym_link_destination_repeat1 = 133,
  aux_sym_link_destination_repeat2 = 134,
  aux_sym_link_title_repeat1 = 135,
  aux_sym_link_title_repeat2 = 136,
  aux_sym_link_title_repeat3 = 137,
  aux_sym_code_span_repeat1 = 138,
  aux_sym_inline_link_repeat1 = 139,
  aux_sym__open_tag_repeat1 = 140,
  aux_sym__tag_name_repeat1 = 141,
  aux_sym__attribute_value_repeat1 = 142,
  aux_sym__attribute_value_repeat2 = 143,
  aux_sym__html_comment_repeat1 = 144,
  aux_sym__processing_instruction_repeat1 = 145,
  aux_sym__declaration_repeat1 = 146,
  aux_sym__inline_base_repeat1 = 147,
  alias_sym_emphasis = 148,
  alias_sym_html_tag = 149,
  alias_sym_image_description = 150,
  alias_sym_link_text = 151,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__backslash_escape] = "_backslash_escape",
  [sym_entity_reference] = "entity_reference",
  [sym_numeric_character_reference] = "numeric_character_reference",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG] = "!",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_PERCENT] = "%",
  [anon_sym_AMP] = "&",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_STAR] = "*",
  [anon_sym_PLUS] = "+",
  [anon_sym_COMMA] = ",",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT] = ".",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AT] = "@",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_CARET] = "^",
  [anon_sym__] = "_",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LBRACE] = "{",
  [anon_sym_PIPE] = "|",
  [anon_sym_RBRACE] = "}",
  [anon_sym_TILDE] = "~",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym__newline_token] = "_newline_token",
  [sym_uri_autolink] = "uri_autolink",
  [sym_email_autolink] = "email_autolink",
  [sym__attribute_name] = "_attribute_name",
  [aux_sym__attribute_value_token1] = "_attribute_value_token1",
  [anon_sym_LT_BANG_DASH_DASH] = "<!--",
  [anon_sym_DASH_DASH_GT] = "-->",
  [anon_sym_LT_QMARK] = "<\?",
  [anon_sym_QMARK_GT] = "\?>",
  [aux_sym__declaration_token1] = "_declaration_token1",
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = "<![CDATA[",
  [anon_sym_RBRACK_RBRACK_GT] = "]]>",
  [sym__whitespace_ge_2] = "_whitespace_ge_2",
  [aux_sym__whitespace_token1] = "_whitespace_token1",
  [sym__word_no_digit] = "_word_no_digit",
  [sym__digits] = "_digits",
  [sym__error] = "_error",
  [sym__trigger_error] = "_trigger_error",
  [sym__code_span_start] = "code_span_delimiter",
  [sym__code_span_close] = "code_span_delimiter",
  [sym__emphasis_open_star] = "_emphasis_open_star",
  [sym__emphasis_open_underscore] = "_emphasis_open_underscore",
  [sym__emphasis_close_star] = "emphasis_delimiter",
  [sym__emphasis_close_underscore] = "emphasis_delimiter",
  [sym__last_token_whitespace] = "_last_token_whitespace",
  [sym__last_token_punctuation] = "_last_token_punctuation",
  [sym__strikethrough_open] = "_strikethrough_open",
  [sym__strikethrough_close] = "emphasis_delimiter",
  [sym__latex_span_start] = "latex_span_delimiter",
  [sym__latex_span_close] = "latex_span_delimiter",
  [sym__unclosed_span] = "_unclosed_span",
  [sym_inline] = "inline",
  [sym_backslash_escape] = "backslash_escape",
  [sym_link_label] = "link_label",
  [sym_link_destination] = "link_destination",
  [sym__link_destination_parenthesis] = "_link_destination_parenthesis",
  [sym__text_no_angle] = "_text_no_angle",
  [sym_link_title] = "link_title",
  [sym_code_span] = "code_span",
  [sym_latex_block] = "latex_block",
  [sym__link_text] = "_link_text",
  [sym__link_text_non_empty] = "_link_text_non_empty",
  [sym_shortcut_link] = "shortcut_link",
  [sym_full_reference_link] = "full_reference_link",
  [sym_collapsed_reference_link] = "collapsed_reference_link",
  [sym_inline_link] = "inline_link",
  [sym_image] = "image",
  [sym__image_inline_link] = "_image_inline_link",
  [sym__image_shortcut_link] = "_image_shortcut_link",
  [sym__image_full_reference_link] = "_image_full_reference_link",
  [sym__image_collapsed_reference_link] = "_image_collapsed_reference_link",
  [sym__image_description] = "_image_description",
  [sym__image_description_non_empty] = "_image_description_non_empty",
  [sym__html_tag] = "_html_tag",
  [sym__open_tag] = "_open_tag",
  [sym__closing_tag] = "_closing_tag",
  [sym__tag_name] = "_tag_name",
  [sym__attribute] = "_attribute",
  [sym__attribute_value] = "_attribute_value",
  [sym__html_comment] = "_html_comment",
  [sym__processing_instruction] = "_processing_instruction",
  [sym__declaration] = "_declaration",
  [sym__cdata_section] = "_cdata_section",
  [sym_hard_line_break] = "hard_line_break",
  [sym__whitespace] = "_whitespace",
  [sym__word] = "_word",
  [sym__soft_line_break] = "_soft_line_break",
  [sym__inline_base] = "_inline_base",
  [sym__text_base] = "_text_base",
  [sym__text_inline_no_link] = "_text_inline_no_link",
  [sym__inline_element] = "_inline_element",
  [aux_sym__inline] = "_inline",
  [sym__inline_element_no_star] = "_inline_element_no_star",
  [aux_sym__inline_no_star] = "_inline_no_star",
  [sym__inline_element_no_underscore] = "_inline_element_no_underscore",
  [aux_sym__inline_no_underscore] = "_inline_no_underscore",
  [sym__inline_element_no_tilde] = "_inline_element_no_tilde",
  [aux_sym__inline_no_tilde] = "_inline_no_tilde",
  [sym__strikethrough] = "strikethrough",
  [sym__emphasis_star] = "_emphasis_star",
  [sym__strong_emphasis_star] = "strong_emphasis",
  [sym__emphasis_underscore] = "_emphasis_underscore",
  [sym__strong_emphasis_underscore] = "strong_emphasis",
  [sym__inline_element_no_link] = "_inline_element_no_link",
  [aux_sym__inline_no_link] = "_inline_no_link",
  [sym__inline_element_no_star_no_link] = "_inline_element_no_star_no_link",
  [aux_sym__inline_no_star_no_link] = "_inline_no_star_no_link",
  [sym__inline_element_no_underscore_no_link] = "_inline_element_no_underscore_no_link",
  [aux_sym__inline_no_underscore_no_link] = "_inline_no_underscore_no_link",
  [sym__inline_element_no_tilde_no_link] = "_inline_element_no_tilde_no_link",
  [aux_sym__inline_no_tilde_no_link] = "_inline_no_tilde_no_link",
  [sym__strikethrough_no_link] = "strikethrough",
  [sym__emphasis_star_no_link] = "_emphasis_star_no_link",
  [sym__strong_emphasis_star_no_link] = "strong_emphasis",
  [sym__emphasis_underscore_no_link] = "_emphasis_underscore_no_link",
  [sym__strong_emphasis_underscore_no_link] = "strong_emphasis",
  [aux_sym_link_label_repeat1] = "link_label_repeat1",
  [aux_sym_link_destination_repeat1] = "link_destination_repeat1",
  [aux_sym_link_destination_repeat2] = "link_destination_repeat2",
  [aux_sym_link_title_repeat1] = "link_title_repeat1",
  [aux_sym_link_title_repeat2] = "link_title_repeat2",
  [aux_sym_link_title_repeat3] = "link_title_repeat3",
  [aux_sym_code_span_repeat1] = "code_span_repeat1",
  [aux_sym_inline_link_repeat1] = "inline_link_repeat1",
  [aux_sym__open_tag_repeat1] = "_open_tag_repeat1",
  [aux_sym__tag_name_repeat1] = "_tag_name_repeat1",
  [aux_sym__attribute_value_repeat1] = "_attribute_value_repeat1",
  [aux_sym__attribute_value_repeat2] = "_attribute_value_repeat2",
  [aux_sym__html_comment_repeat1] = "_html_comment_repeat1",
  [aux_sym__processing_instruction_repeat1] = "_processing_instruction_repeat1",
  [aux_sym__declaration_repeat1] = "_declaration_repeat1",
  [aux_sym__inline_base_repeat1] = "_inline_base_repeat1",
  [alias_sym_emphasis] = "emphasis",
  [alias_sym_html_tag] = "html_tag",
  [alias_sym_image_description] = "image_description",
  [alias_sym_link_text] = "link_text",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__backslash_escape] = sym__backslash_escape,
  [sym_entity_reference] = sym_entity_reference,
  [sym_numeric_character_reference] = sym_numeric_character_reference,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym__] = anon_sym__,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym__newline_token] = sym__newline_token,
  [sym_uri_autolink] = sym_uri_autolink,
  [sym_email_autolink] = sym_email_autolink,
  [sym__attribute_name] = sym__attribute_name,
  [aux_sym__attribute_value_token1] = aux_sym__attribute_value_token1,
  [anon_sym_LT_BANG_DASH_DASH] = anon_sym_LT_BANG_DASH_DASH,
  [anon_sym_DASH_DASH_GT] = anon_sym_DASH_DASH_GT,
  [anon_sym_LT_QMARK] = anon_sym_LT_QMARK,
  [anon_sym_QMARK_GT] = anon_sym_QMARK_GT,
  [aux_sym__declaration_token1] = aux_sym__declaration_token1,
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
  [anon_sym_RBRACK_RBRACK_GT] = anon_sym_RBRACK_RBRACK_GT,
  [sym__whitespace_ge_2] = sym__whitespace_ge_2,
  [aux_sym__whitespace_token1] = aux_sym__whitespace_token1,
  [sym__word_no_digit] = sym__word_no_digit,
  [sym__digits] = sym__digits,
  [sym__error] = sym__error,
  [sym__trigger_error] = sym__trigger_error,
  [sym__code_span_start] = sym__code_span_start,
  [sym__code_span_close] = sym__code_span_start,
  [sym__emphasis_open_star] = sym__emphasis_open_star,
  [sym__emphasis_open_underscore] = sym__emphasis_open_underscore,
  [sym__emphasis_close_star] = sym__emphasis_close_star,
  [sym__emphasis_close_underscore] = sym__emphasis_close_star,
  [sym__last_token_whitespace] = sym__last_token_whitespace,
  [sym__last_token_punctuation] = sym__last_token_punctuation,
  [sym__strikethrough_open] = sym__strikethrough_open,
  [sym__strikethrough_close] = sym__emphasis_close_star,
  [sym__latex_span_start] = sym__latex_span_start,
  [sym__latex_span_close] = sym__latex_span_start,
  [sym__unclosed_span] = sym__unclosed_span,
  [sym_inline] = sym_inline,
  [sym_backslash_escape] = sym_backslash_escape,
  [sym_link_label] = sym_link_label,
  [sym_link_destination] = sym_link_destination,
  [sym__link_destination_parenthesis] = sym__link_destination_parenthesis,
  [sym__text_no_angle] = sym__text_no_angle,
  [sym_link_title] = sym_link_title,
  [sym_code_span] = sym_code_span,
  [sym_latex_block] = sym_latex_block,
  [sym__link_text] = sym__link_text,
  [sym__link_text_non_empty] = sym__link_text_non_empty,
  [sym_shortcut_link] = sym_shortcut_link,
  [sym_full_reference_link] = sym_full_reference_link,
  [sym_collapsed_reference_link] = sym_collapsed_reference_link,
  [sym_inline_link] = sym_inline_link,
  [sym_image] = sym_image,
  [sym__image_inline_link] = sym__image_inline_link,
  [sym__image_shortcut_link] = sym__image_shortcut_link,
  [sym__image_full_reference_link] = sym__image_full_reference_link,
  [sym__image_collapsed_reference_link] = sym__image_collapsed_reference_link,
  [sym__image_description] = sym__image_description,
  [sym__image_description_non_empty] = sym__image_description_non_empty,
  [sym__html_tag] = sym__html_tag,
  [sym__open_tag] = sym__open_tag,
  [sym__closing_tag] = sym__closing_tag,
  [sym__tag_name] = sym__tag_name,
  [sym__attribute] = sym__attribute,
  [sym__attribute_value] = sym__attribute_value,
  [sym__html_comment] = sym__html_comment,
  [sym__processing_instruction] = sym__processing_instruction,
  [sym__declaration] = sym__declaration,
  [sym__cdata_section] = sym__cdata_section,
  [sym_hard_line_break] = sym_hard_line_break,
  [sym__whitespace] = sym__whitespace,
  [sym__word] = sym__word,
  [sym__soft_line_break] = sym__soft_line_break,
  [sym__inline_base] = sym__inline_base,
  [sym__text_base] = sym__text_base,
  [sym__text_inline_no_link] = sym__text_inline_no_link,
  [sym__inline_element] = sym__inline_element,
  [aux_sym__inline] = aux_sym__inline,
  [sym__inline_element_no_star] = sym__inline_element_no_star,
  [aux_sym__inline_no_star] = aux_sym__inline_no_star,
  [sym__inline_element_no_underscore] = sym__inline_element_no_underscore,
  [aux_sym__inline_no_underscore] = aux_sym__inline_no_underscore,
  [sym__inline_element_no_tilde] = sym__inline_element_no_tilde,
  [aux_sym__inline_no_tilde] = aux_sym__inline_no_tilde,
  [sym__strikethrough] = sym__strikethrough,
  [sym__emphasis_star] = sym__emphasis_star,
  [sym__strong_emphasis_star] = sym__strong_emphasis_star,
  [sym__emphasis_underscore] = sym__emphasis_underscore,
  [sym__strong_emphasis_underscore] = sym__strong_emphasis_star,
  [sym__inline_element_no_link] = sym__inline_element_no_link,
  [aux_sym__inline_no_link] = aux_sym__inline_no_link,
  [sym__inline_element_no_star_no_link] = sym__inline_element_no_star_no_link,
  [aux_sym__inline_no_star_no_link] = aux_sym__inline_no_star_no_link,
  [sym__inline_element_no_underscore_no_link] = sym__inline_element_no_underscore_no_link,
  [aux_sym__inline_no_underscore_no_link] = aux_sym__inline_no_underscore_no_link,
  [sym__inline_element_no_tilde_no_link] = sym__inline_element_no_tilde_no_link,
  [aux_sym__inline_no_tilde_no_link] = aux_sym__inline_no_tilde_no_link,
  [sym__strikethrough_no_link] = sym__strikethrough,
  [sym__emphasis_star_no_link] = sym__emphasis_star_no_link,
  [sym__strong_emphasis_star_no_link] = sym__strong_emphasis_star,
  [sym__emphasis_underscore_no_link] = sym__emphasis_underscore_no_link,
  [sym__strong_emphasis_underscore_no_link] = sym__strong_emphasis_star,
  [aux_sym_link_label_repeat1] = aux_sym_link_label_repeat1,
  [aux_sym_link_destination_repeat1] = aux_sym_link_destination_repeat1,
  [aux_sym_link_destination_repeat2] = aux_sym_link_destination_repeat2,
  [aux_sym_link_title_repeat1] = aux_sym_link_title_repeat1,
  [aux_sym_link_title_repeat2] = aux_sym_link_title_repeat2,
  [aux_sym_link_title_repeat3] = aux_sym_link_title_repeat3,
  [aux_sym_code_span_repeat1] = aux_sym_code_span_repeat1,
  [aux_sym_inline_link_repeat1] = aux_sym_inline_link_repeat1,
  [aux_sym__open_tag_repeat1] = aux_sym__open_tag_repeat1,
  [aux_sym__tag_name_repeat1] = aux_sym__tag_name_repeat1,
  [aux_sym__attribute_value_repeat1] = aux_sym__attribute_value_repeat1,
  [aux_sym__attribute_value_repeat2] = aux_sym__attribute_value_repeat2,
  [aux_sym__html_comment_repeat1] = aux_sym__html_comment_repeat1,
  [aux_sym__processing_instruction_repeat1] = aux_sym__processing_instruction_repeat1,
  [aux_sym__declaration_repeat1] = aux_sym__declaration_repeat1,
  [aux_sym__inline_base_repeat1] = aux_sym__inline_base_repeat1,
  [alias_sym_emphasis] = alias_sym_emphasis,
  [alias_sym_html_tag] = alias_sym_html_tag,
  [alias_sym_image_description] = alias_sym_image_description,
  [alias_sym_link_text] = alias_sym_link_text,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__backslash_escape] = {
    .visible = false,
    .named = true,
  },
  [sym_entity_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_numeric_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym__newline_token] = {
    .visible = false,
    .named = true,
  },
  [sym_uri_autolink] = {
    .visible = true,
    .named = true,
  },
  [sym_email_autolink] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_name] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__attribute_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT_BANG_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__declaration_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__whitespace_ge_2] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__whitespace_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__word_no_digit] = {
    .visible = false,
    .named = true,
  },
  [sym__digits] = {
    .visible = false,
    .named = true,
  },
  [sym__error] = {
    .visible = false,
    .named = true,
  },
  [sym__trigger_error] = {
    .visible = false,
    .named = true,
  },
  [sym__code_span_start] = {
    .visible = true,
    .named = true,
  },
  [sym__code_span_close] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_open_star] = {
    .visible = false,
    .named = true,
  },
  [sym__emphasis_open_underscore] = {
    .visible = false,
    .named = true,
  },
  [sym__emphasis_close_star] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_close_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym__last_token_whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__last_token_punctuation] = {
    .visible = false,
    .named = true,
  },
  [sym__strikethrough_open] = {
    .visible = false,
    .named = true,
  },
  [sym__strikethrough_close] = {
    .visible = true,
    .named = true,
  },
  [sym__latex_span_start] = {
    .visible = true,
    .named = true,
  },
  [sym__latex_span_close] = {
    .visible = true,
    .named = true,
  },
  [sym__unclosed_span] = {
    .visible = false,
    .named = true,
  },
  [sym_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_link_label] = {
    .visible = true,
    .named = true,
  },
  [sym_link_destination] = {
    .visible = true,
    .named = true,
  },
  [sym__link_destination_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__text_no_angle] = {
    .visible = false,
    .named = true,
  },
  [sym_link_title] = {
    .visible = true,
    .named = true,
  },
  [sym_code_span] = {
    .visible = true,
    .named = true,
  },
  [sym_latex_block] = {
    .visible = true,
    .named = true,
  },
  [sym__link_text] = {
    .visible = false,
    .named = true,
  },
  [sym__link_text_non_empty] = {
    .visible = false,
    .named = true,
  },
  [sym_shortcut_link] = {
    .visible = true,
    .named = true,
  },
  [sym_full_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_collapsed_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_link] = {
    .visible = true,
    .named = true,
  },
  [sym_image] = {
    .visible = true,
    .named = true,
  },
  [sym__image_inline_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_shortcut_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_full_reference_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_collapsed_reference_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_description] = {
    .visible = false,
    .named = true,
  },
  [sym__image_description_non_empty] = {
    .visible = false,
    .named = true,
  },
  [sym__html_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__open_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__closing_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__tag_name] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__html_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__processing_instruction] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__cdata_section] = {
    .visible = false,
    .named = true,
  },
  [sym_hard_line_break] = {
    .visible = true,
    .named = true,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__word] = {
    .visible = false,
    .named = true,
  },
  [sym__soft_line_break] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_base] = {
    .visible = false,
    .named = true,
  },
  [sym__text_base] = {
    .visible = false,
    .named = true,
  },
  [sym__text_inline_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_element] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_star] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_star] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_underscore] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_underscore] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_tilde] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_tilde] = {
    .visible = false,
    .named = false,
  },
  [sym__strikethrough] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_star] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_star] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_underscore] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym__inline_element_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_star_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_star_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_underscore_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_underscore_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_tilde_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_tilde_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__strikethrough_no_link] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_star_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_star_no_link] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_underscore_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_underscore_no_link] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_link_label_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_code_span_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_link_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__open_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__tag_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_value_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__processing_instruction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inline_base_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_emphasis] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_html_tag] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_image_description] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_link_text] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_html_tag,
  },
  [2] = {
    [0] = alias_sym_emphasis,
  },
  [3] = {
    [0] = sym__emphasis_close_star,
  },
  [4] = {
    [1] = alias_sym_link_text,
  },
  [5] = {
    [2] = alias_sym_image_description,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__html_tag, 2,
    sym__html_tag,
    alias_sym_html_tag,
  aux_sym__inline, 2,
    aux_sym__inline,
    alias_sym_image_description,
  sym__emphasis_star, 2,
    sym__emphasis_star,
    alias_sym_emphasis,
  sym__emphasis_underscore, 2,
    sym__emphasis_underscore,
    alias_sym_emphasis,
  aux_sym__inline_no_link, 2,
    aux_sym__inline_no_link,
    alias_sym_link_text,
  sym__emphasis_star_no_link, 2,
    sym__emphasis_star_no_link,
    alias_sym_emphasis,
  sym__emphasis_underscore_no_link, 2,
    sym__emphasis_underscore_no_link,
    alias_sym_emphasis,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 13,
  [17] = 17,
  [18] = 15,
  [19] = 19,
  [20] = 12,
  [21] = 11,
  [22] = 17,
  [23] = 23,
  [24] = 11,
  [25] = 12,
  [26] = 19,
  [27] = 19,
  [28] = 3,
  [29] = 4,
  [30] = 6,
  [31] = 31,
  [32] = 17,
  [33] = 15,
  [34] = 17,
  [35] = 13,
  [36] = 36,
  [37] = 15,
  [38] = 19,
  [39] = 13,
  [40] = 15,
  [41] = 19,
  [42] = 11,
  [43] = 43,
  [44] = 44,
  [45] = 11,
  [46] = 46,
  [47] = 12,
  [48] = 48,
  [49] = 12,
  [50] = 13,
  [51] = 17,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 55,
  [59] = 53,
  [60] = 53,
  [61] = 48,
  [62] = 53,
  [63] = 57,
  [64] = 54,
  [65] = 65,
  [66] = 53,
  [67] = 54,
  [68] = 55,
  [69] = 65,
  [70] = 57,
  [71] = 65,
  [72] = 54,
  [73] = 55,
  [74] = 57,
  [75] = 55,
  [76] = 54,
  [77] = 65,
  [78] = 57,
  [79] = 53,
  [80] = 65,
  [81] = 53,
  [82] = 65,
  [83] = 65,
  [84] = 65,
  [85] = 53,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 89,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 100,
  [107] = 102,
  [108] = 105,
  [109] = 105,
  [110] = 104,
  [111] = 104,
  [112] = 103,
  [113] = 113,
  [114] = 100,
  [115] = 101,
  [116] = 116,
  [117] = 116,
  [118] = 101,
  [119] = 102,
  [120] = 105,
  [121] = 121,
  [122] = 116,
  [123] = 102,
  [124] = 101,
  [125] = 103,
  [126] = 126,
  [127] = 103,
  [128] = 116,
  [129] = 129,
  [130] = 104,
  [131] = 100,
  [132] = 100,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 136,
  [139] = 136,
  [140] = 137,
  [141] = 137,
  [142] = 142,
  [143] = 136,
  [144] = 142,
  [145] = 142,
  [146] = 137,
  [147] = 142,
  [148] = 148,
  [149] = 149,
  [150] = 148,
  [151] = 148,
  [152] = 148,
  [153] = 149,
  [154] = 149,
  [155] = 149,
  [156] = 148,
  [157] = 149,
  [158] = 149,
  [159] = 148,
  [160] = 149,
  [161] = 148,
  [162] = 148,
  [163] = 149,
  [164] = 149,
  [165] = 148,
  [166] = 166,
  [167] = 167,
  [168] = 167,
  [169] = 167,
  [170] = 167,
  [171] = 166,
  [172] = 166,
  [173] = 167,
  [174] = 166,
  [175] = 167,
  [176] = 166,
  [177] = 166,
  [178] = 166,
  [179] = 167,
  [180] = 180,
  [181] = 180,
  [182] = 180,
  [183] = 180,
  [184] = 167,
  [185] = 180,
  [186] = 167,
  [187] = 180,
  [188] = 166,
  [189] = 180,
  [190] = 166,
  [191] = 180,
  [192] = 180,
  [193] = 193,
  [194] = 194,
  [195] = 193,
  [196] = 196,
  [197] = 196,
  [198] = 198,
  [199] = 194,
  [200] = 198,
  [201] = 196,
  [202] = 194,
  [203] = 193,
  [204] = 198,
  [205] = 198,
  [206] = 196,
  [207] = 193,
  [208] = 194,
  [209] = 209,
  [210] = 210,
  [211] = 209,
  [212] = 212,
  [213] = 213,
  [214] = 213,
  [215] = 198,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 210,
  [220] = 220,
  [221] = 221,
  [222] = 218,
  [223] = 210,
  [224] = 209,
  [225] = 212,
  [226] = 210,
  [227] = 217,
  [228] = 228,
  [229] = 220,
  [230] = 209,
  [231] = 221,
  [232] = 213,
  [233] = 194,
  [234] = 216,
  [235] = 220,
  [236] = 236,
  [237] = 221,
  [238] = 221,
  [239] = 210,
  [240] = 210,
  [241] = 216,
  [242] = 217,
  [243] = 210,
  [244] = 244,
  [245] = 212,
  [246] = 196,
  [247] = 247,
  [248] = 216,
  [249] = 218,
  [250] = 228,
  [251] = 221,
  [252] = 193,
  [253] = 213,
  [254] = 212,
  [255] = 220,
  [256] = 218,
  [257] = 209,
  [258] = 258,
  [259] = 217,
  [260] = 218,
  [261] = 220,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 213,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 217,
  [280] = 280,
  [281] = 281,
  [282] = 271,
  [283] = 283,
  [284] = 284,
  [285] = 216,
  [286] = 213,
  [287] = 287,
  [288] = 288,
  [289] = 212,
  [290] = 290,
  [291] = 268,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 288,
  [301] = 301,
  [302] = 273,
  [303] = 263,
  [304] = 213,
  [305] = 269,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 268,
  [313] = 269,
  [314] = 271,
  [315] = 315,
  [316] = 316,
  [317] = 271,
  [318] = 318,
  [319] = 213,
  [320] = 268,
  [321] = 297,
  [322] = 296,
  [323] = 276,
  [324] = 277,
  [325] = 278,
  [326] = 326,
  [327] = 327,
  [328] = 269,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 210,
  [333] = 258,
  [334] = 334,
  [335] = 335,
  [336] = 273,
  [337] = 337,
  [338] = 262,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 331,
  [344] = 311,
  [345] = 265,
  [346] = 266,
  [347] = 267,
  [348] = 272,
  [349] = 288,
  [350] = 310,
  [351] = 308,
  [352] = 307,
  [353] = 281,
  [354] = 293,
  [355] = 301,
  [356] = 295,
  [357] = 299,
  [358] = 329,
  [359] = 274,
  [360] = 360,
  [361] = 288,
  [362] = 362,
  [363] = 330,
  [364] = 315,
  [365] = 360,
  [366] = 366,
  [367] = 367,
  [368] = 362,
  [369] = 369,
  [370] = 367,
  [371] = 369,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 334,
  [379] = 372,
  [380] = 373,
  [381] = 273,
  [382] = 213,
  [383] = 269,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 374,
  [393] = 327,
  [394] = 326,
  [395] = 318,
  [396] = 316,
  [397] = 335,
  [398] = 306,
  [399] = 390,
  [400] = 297,
  [401] = 296,
  [402] = 264,
  [403] = 309,
  [404] = 298,
  [405] = 287,
  [406] = 283,
  [407] = 276,
  [408] = 268,
  [409] = 277,
  [410] = 271,
  [411] = 283,
  [412] = 287,
  [413] = 278,
  [414] = 390,
  [415] = 263,
  [416] = 306,
  [417] = 316,
  [418] = 318,
  [419] = 326,
  [420] = 327,
  [421] = 331,
  [422] = 389,
  [423] = 388,
  [424] = 298,
  [425] = 309,
  [426] = 387,
  [427] = 386,
  [428] = 264,
  [429] = 385,
  [430] = 329,
  [431] = 330,
  [432] = 375,
  [433] = 265,
  [434] = 266,
  [435] = 267,
  [436] = 272,
  [437] = 274,
  [438] = 334,
  [439] = 281,
  [440] = 293,
  [441] = 295,
  [442] = 299,
  [443] = 301,
  [444] = 307,
  [445] = 308,
  [446] = 310,
  [447] = 311,
  [448] = 315,
  [449] = 360,
  [450] = 335,
  [451] = 362,
  [452] = 367,
  [453] = 369,
  [454] = 372,
  [455] = 373,
  [456] = 374,
  [457] = 375,
  [458] = 376,
  [459] = 342,
  [460] = 341,
  [461] = 340,
  [462] = 339,
  [463] = 262,
  [464] = 384,
  [465] = 385,
  [466] = 386,
  [467] = 387,
  [468] = 388,
  [469] = 389,
  [470] = 390,
  [471] = 335,
  [472] = 334,
  [473] = 376,
  [474] = 288,
  [475] = 330,
  [476] = 329,
  [477] = 264,
  [478] = 309,
  [479] = 298,
  [480] = 278,
  [481] = 277,
  [482] = 276,
  [483] = 283,
  [484] = 287,
  [485] = 296,
  [486] = 297,
  [487] = 263,
  [488] = 306,
  [489] = 316,
  [490] = 318,
  [491] = 326,
  [492] = 327,
  [493] = 331,
  [494] = 384,
  [495] = 262,
  [496] = 339,
  [497] = 340,
  [498] = 341,
  [499] = 499,
  [500] = 342,
  [501] = 273,
  [502] = 265,
  [503] = 266,
  [504] = 267,
  [505] = 272,
  [506] = 274,
  [507] = 281,
  [508] = 293,
  [509] = 295,
  [510] = 299,
  [511] = 301,
  [512] = 307,
  [513] = 308,
  [514] = 310,
  [515] = 311,
  [516] = 315,
  [517] = 360,
  [518] = 362,
  [519] = 367,
  [520] = 369,
  [521] = 372,
  [522] = 373,
  [523] = 374,
  [524] = 375,
  [525] = 376,
  [526] = 342,
  [527] = 341,
  [528] = 340,
  [529] = 339,
  [530] = 384,
  [531] = 385,
  [532] = 386,
  [533] = 387,
  [534] = 388,
  [535] = 389,
  [536] = 315,
  [537] = 309,
  [538] = 267,
  [539] = 267,
  [540] = 267,
  [541] = 267,
  [542] = 327,
  [543] = 326,
  [544] = 318,
  [545] = 316,
  [546] = 306,
  [547] = 263,
  [548] = 287,
  [549] = 283,
  [550] = 298,
  [551] = 274,
  [552] = 264,
  [553] = 295,
  [554] = 301,
  [555] = 390,
  [556] = 389,
  [557] = 297,
  [558] = 296,
  [559] = 388,
  [560] = 387,
  [561] = 276,
  [562] = 386,
  [563] = 277,
  [564] = 385,
  [565] = 384,
  [566] = 307,
  [567] = 308,
  [568] = 310,
  [569] = 311,
  [570] = 376,
  [571] = 375,
  [572] = 374,
  [573] = 373,
  [574] = 372,
  [575] = 369,
  [576] = 278,
  [577] = 329,
  [578] = 367,
  [579] = 362,
  [580] = 331,
  [581] = 330,
  [582] = 342,
  [583] = 360,
  [584] = 341,
  [585] = 275,
  [586] = 334,
  [587] = 335,
  [588] = 262,
  [589] = 280,
  [590] = 294,
  [591] = 340,
  [592] = 265,
  [593] = 266,
  [594] = 267,
  [595] = 272,
  [596] = 299,
  [597] = 339,
  [598] = 281,
  [599] = 293,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 601,
  [604] = 604,
  [605] = 601,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 600,
  [610] = 610,
  [611] = 611,
  [612] = 611,
  [613] = 610,
  [614] = 614,
  [615] = 606,
  [616] = 601,
  [617] = 602,
  [618] = 602,
  [619] = 600,
  [620] = 608,
  [621] = 607,
  [622] = 604,
  [623] = 607,
  [624] = 606,
  [625] = 625,
  [626] = 626,
  [627] = 604,
  [628] = 614,
  [629] = 611,
  [630] = 610,
  [631] = 614,
  [632] = 607,
  [633] = 608,
  [634] = 604,
  [635] = 635,
  [636] = 606,
  [637] = 610,
  [638] = 614,
  [639] = 600,
  [640] = 640,
  [641] = 641,
  [642] = 602,
  [643] = 608,
  [644] = 611,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 646,
  [650] = 648,
  [651] = 647,
  [652] = 645,
  [653] = 647,
  [654] = 648,
  [655] = 655,
  [656] = 656,
  [657] = 648,
  [658] = 646,
  [659] = 645,
  [660] = 647,
  [661] = 647,
  [662] = 645,
  [663] = 648,
  [664] = 646,
  [665] = 646,
  [666] = 645,
  [667] = 216,
  [668] = 166,
  [669] = 212,
  [670] = 670,
  [671] = 166,
  [672] = 167,
  [673] = 167,
  [674] = 217,
  [675] = 301,
  [676] = 311,
  [677] = 180,
  [678] = 331,
  [679] = 295,
  [680] = 180,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 194,
  [691] = 691,
  [692] = 692,
  [693] = 198,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 194,
  [701] = 198,
  [702] = 702,
  [703] = 703,
  [704] = 212,
  [705] = 216,
  [706] = 212,
  [707] = 217,
  [708] = 702,
  [709] = 703,
  [710] = 710,
  [711] = 702,
  [712] = 703,
  [713] = 702,
  [714] = 702,
  [715] = 703,
  [716] = 702,
  [717] = 717,
  [718] = 703,
  [719] = 702,
  [720] = 720,
  [721] = 721,
  [722] = 703,
  [723] = 703,
  [724] = 217,
  [725] = 216,
  [726] = 726,
  [727] = 727,
  [728] = 301,
  [729] = 307,
  [730] = 308,
  [731] = 310,
  [732] = 311,
  [733] = 342,
  [734] = 341,
  [735] = 340,
  [736] = 339,
  [737] = 262,
  [738] = 335,
  [739] = 334,
  [740] = 330,
  [741] = 329,
  [742] = 278,
  [743] = 277,
  [744] = 276,
  [745] = 296,
  [746] = 297,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 727,
  [751] = 751,
  [752] = 747,
  [753] = 753,
  [754] = 726,
  [755] = 755,
  [756] = 295,
  [757] = 757,
  [758] = 747,
  [759] = 748,
  [760] = 749,
  [761] = 727,
  [762] = 751,
  [763] = 755,
  [764] = 726,
  [765] = 753,
  [766] = 748,
  [767] = 753,
  [768] = 727,
  [769] = 755,
  [770] = 751,
  [771] = 727,
  [772] = 755,
  [773] = 749,
  [774] = 726,
  [775] = 749,
  [776] = 748,
  [777] = 753,
  [778] = 274,
  [779] = 278,
  [780] = 747,
  [781] = 751,
  [782] = 755,
  [783] = 297,
  [784] = 296,
  [785] = 276,
  [786] = 277,
  [787] = 726,
  [788] = 329,
  [789] = 330,
  [790] = 753,
  [791] = 334,
  [792] = 755,
  [793] = 726,
  [794] = 751,
  [795] = 753,
  [796] = 335,
  [797] = 262,
  [798] = 339,
  [799] = 799,
  [800] = 340,
  [801] = 727,
  [802] = 341,
  [803] = 342,
  [804] = 311,
  [805] = 310,
  [806] = 308,
  [807] = 751,
  [808] = 747,
  [809] = 799,
  [810] = 753,
  [811] = 749,
  [812] = 307,
  [813] = 751,
  [814] = 727,
  [815] = 301,
  [816] = 748,
  [817] = 295,
  [818] = 748,
  [819] = 747,
  [820] = 274,
  [821] = 748,
  [822] = 749,
  [823] = 749,
  [824] = 726,
  [825] = 755,
  [826] = 747,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 828,
  [832] = 828,
  [833] = 828,
  [834] = 828,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 836,
  [841] = 841,
  [842] = 828,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 836,
  [847] = 828,
  [848] = 836,
  [849] = 849,
  [850] = 216,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 836,
  [858] = 836,
  [859] = 217,
  [860] = 836,
  [861] = 861,
  [862] = 862,
  [863] = 331,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 311,
  [876] = 876,
  [877] = 301,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 882,
  [886] = 217,
  [887] = 216,
  [888] = 216,
  [889] = 889,
  [890] = 217,
  [891] = 217,
  [892] = 216,
  [893] = 893,
  [894] = 301,
  [895] = 311,
  [896] = 896,
  [897] = 301,
  [898] = 898,
  [899] = 899,
  [900] = 311,
  [901] = 901,
  [902] = 301,
  [903] = 311,
  [904] = 904,
  [905] = 898,
  [906] = 906,
  [907] = 907,
  [908] = 217,
  [909] = 216,
  [910] = 910,
  [911] = 911,
  [912] = 311,
  [913] = 301,
  [914] = 914,
  [915] = 915,
  [916] = 915,
  [917] = 915,
  [918] = 915,
  [919] = 915,
  [920] = 915,
  [921] = 915,
  [922] = 717,
  [923] = 923,
  [924] = 924,
  [925] = 924,
  [926] = 926,
  [927] = 923,
  [928] = 928,
  [929] = 924,
  [930] = 928,
  [931] = 928,
  [932] = 926,
  [933] = 923,
  [934] = 928,
  [935] = 926,
  [936] = 923,
  [937] = 928,
  [938] = 923,
  [939] = 926,
  [940] = 926,
  [941] = 924,
  [942] = 924,
  [943] = 943,
  [944] = 944,
  [945] = 943,
  [946] = 943,
  [947] = 944,
  [948] = 948,
  [949] = 944,
  [950] = 944,
  [951] = 951,
  [952] = 943,
  [953] = 953,
  [954] = 944,
  [955] = 943,
  [956] = 956,
  [957] = 957,
  [958] = 943,
  [959] = 944,
  [960] = 944,
  [961] = 943,
  [962] = 962,
  [963] = 962,
  [964] = 964,
  [965] = 717,
  [966] = 966,
  [967] = 962,
  [968] = 966,
  [969] = 962,
  [970] = 966,
  [971] = 971,
  [972] = 966,
  [973] = 966,
  [974] = 966,
  [975] = 717,
  [976] = 962,
  [977] = 962,
  [978] = 962,
  [979] = 979,
  [980] = 966,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 217,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 217,
  [992] = 992,
  [993] = 216,
  [994] = 990,
  [995] = 983,
  [996] = 986,
  [997] = 992,
  [998] = 998,
  [999] = 998,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 981,
  [1004] = 988,
  [1005] = 983,
  [1006] = 989,
  [1007] = 1007,
  [1008] = 1000,
  [1009] = 1007,
  [1010] = 1010,
  [1011] = 982,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1001,
  [1017] = 1010,
  [1018] = 982,
  [1019] = 1002,
  [1020] = 1007,
  [1021] = 988,
  [1022] = 989,
  [1023] = 985,
  [1024] = 984,
  [1025] = 981,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 982,
  [1029] = 1029,
  [1030] = 1002,
  [1031] = 1027,
  [1032] = 1026,
  [1033] = 1027,
  [1034] = 1010,
  [1035] = 216,
  [1036] = 1002,
  [1037] = 1026,
  [1038] = 1012,
  [1039] = 1013,
  [1040] = 984,
  [1041] = 985,
  [1042] = 1027,
  [1043] = 1026,
  [1044] = 1014,
  [1045] = 984,
  [1046] = 985,
  [1047] = 984,
  [1048] = 990,
  [1049] = 985,
  [1050] = 1027,
  [1051] = 1015,
  [1052] = 1052,
  [1053] = 990,
  [1054] = 983,
  [1055] = 986,
  [1056] = 992,
  [1057] = 990,
  [1058] = 998,
  [1059] = 1000,
  [1060] = 1001,
  [1061] = 990,
  [1062] = 1015,
  [1063] = 988,
  [1064] = 1014,
  [1065] = 989,
  [1066] = 981,
  [1067] = 1013,
  [1068] = 1007,
  [1069] = 1010,
  [1070] = 1026,
  [1071] = 1012,
  [1072] = 1013,
  [1073] = 1014,
  [1074] = 1015,
  [1075] = 986,
  [1076] = 1015,
  [1077] = 1012,
  [1078] = 982,
  [1079] = 1010,
  [1080] = 1007,
  [1081] = 1002,
  [1082] = 1001,
  [1083] = 992,
  [1084] = 1014,
  [1085] = 1013,
  [1086] = 981,
  [1087] = 989,
  [1088] = 1088,
  [1089] = 988,
  [1090] = 990,
  [1091] = 1000,
  [1092] = 1012,
  [1093] = 998,
  [1094] = 1001,
  [1095] = 1002,
  [1096] = 1000,
  [1097] = 1002,
  [1098] = 983,
  [1099] = 998,
  [1100] = 992,
  [1101] = 986,
  [1102] = 301,
  [1103] = 311,
  [1104] = 311,
  [1105] = 301,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1115,
  [1117] = 1117,
  [1118] = 1115,
  [1119] = 1117,
  [1120] = 1115,
  [1121] = 1117,
  [1122] = 1115,
  [1123] = 1117,
  [1124] = 1117,
  [1125] = 1125,
  [1126] = 1125,
  [1127] = 1125,
  [1128] = 1125,
  [1129] = 216,
  [1130] = 1125,
  [1131] = 1125,
  [1132] = 1125,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1137,
  [1139] = 1135,
  [1140] = 1140,
  [1141] = 1137,
  [1142] = 1137,
  [1143] = 1143,
  [1144] = 1135,
  [1145] = 301,
  [1146] = 1134,
  [1147] = 1137,
  [1148] = 1134,
  [1149] = 1135,
  [1150] = 1134,
  [1151] = 1134,
  [1152] = 1135,
  [1153] = 1134,
  [1154] = 1137,
  [1155] = 1134,
  [1156] = 1135,
  [1157] = 1135,
  [1158] = 1158,
  [1159] = 1137,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(2179);
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2196,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2202,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2187,
        '=', 2207,
        '>', 2189,
        '?', 2209,
        '@', 2210,
        '[', 2183,
        '\\', 2212,
        ']', 2185,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2196,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2188,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '\\', 2212,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0 &&
          (lookahead < '[' || '`' < lookahead)) ADVANCE(2241);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2196,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2186,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2212,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2202,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2188,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2202,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2186,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2188,
        '=', 2207,
        '>', 2189,
        '?', 2209,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2188,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2185,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2188,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2186,
        '=', 2207,
        '>', 2189,
        '?', 2209,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2186,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2185,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2195,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2186,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2211,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 11:
      if (lookahead == '\t') ADVANCE(2238);
      if (lookahead == '\n') ADVANCE(2222);
      if (lookahead == '\r') ADVANCE(2223);
      if (lookahead == ' ') ADVANCE(2240);
      if (lookahead == '"') ADVANCE(2191);
      if (lookahead == '\'') ADVANCE(2197);
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '`') ADVANCE(2227);
      END_STATE();
    case 12:
      if (lookahead == '\t') ADVANCE(2238);
      if (lookahead == '\n') ADVANCE(2222);
      if (lookahead == '\r') ADVANCE(2223);
      if (lookahead == ' ') ADVANCE(2240);
      if (lookahead == '/') ADVANCE(2204);
      if (lookahead == '>') ADVANCE(2189);
      if (lookahead == ':' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2226);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '@') ADVANCE(2173);
      if (lookahead == '[') ADVANCE(427);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2234);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(386);
      END_STATE();
    case 14:
      if (lookahead == '-') ADVANCE(2229);
      if (lookahead == '@') ADVANCE(2173);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(386);
      END_STATE();
    case 15:
      if (lookahead == '-') ADVANCE(137);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(136);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(17);
      if (lookahead == '[') ADVANCE(427);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2235);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(2228);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(2174);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(2174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(22);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(18);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(18);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(26);
      END_STATE();
    case 25:
      if (lookahead == '-') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(26);
      END_STATE();
    case 26:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(20);
      END_STATE();
    case 27:
      if (lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(20);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(31);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(30);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(35);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 33:
      if (lookahead == '-') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 35:
      if (lookahead == '-') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(39);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 37:
      if (lookahead == '-') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 38:
      if (lookahead == '-') ADVANCE(33);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 39:
      if (lookahead == '-') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 40:
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(42);
      END_STATE();
    case 41:
      if (lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 43:
      if (lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 44:
      if (lookahead == '-') ADVANCE(47);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(41);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(51);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 50:
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(44);
      END_STATE();
    case 51:
      if (lookahead == '-') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(44);
      END_STATE();
    case 52:
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 53:
      if (lookahead == '-') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 54:
      if (lookahead == '-') ADVANCE(49);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 55:
      if (lookahead == '-') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 56:
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 57:
      if (lookahead == '-') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == '-') ADVANCE(53);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 59:
      if (lookahead == '-') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 60:
      if (lookahead == '-') ADVANCE(63);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 61:
      if (lookahead == '-') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 63:
      if (lookahead == '-') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 64:
      if (lookahead == '-') ADVANCE(67);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 65:
      if (lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 66:
      if (lookahead == '-') ADVANCE(61);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 67:
      if (lookahead == '-') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 68:
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 69:
      if (lookahead == '-') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == '-') ADVANCE(65);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 71:
      if (lookahead == '-') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 72:
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 73:
      if (lookahead == '-') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 74:
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 75:
      if (lookahead == '-') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 76:
      if (lookahead == '-') ADVANCE(79);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 77:
      if (lookahead == '-') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 78:
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 79:
      if (lookahead == '-') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 80:
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 81:
      if (lookahead == '-') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 82:
      if (lookahead == '-') ADVANCE(77);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 83:
      if (lookahead == '-') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 84:
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 85:
      if (lookahead == '-') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 86:
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 87:
      if (lookahead == '-') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 88:
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 89:
      if (lookahead == '-') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 90:
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 91:
      if (lookahead == '-') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 92:
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 93:
      if (lookahead == '-') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 94:
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 95:
      if (lookahead == '-') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 96:
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(98);
      END_STATE();
    case 97:
      if (lookahead == '-') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(98);
      END_STATE();
    case 98:
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 99:
      if (lookahead == '-') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 100:
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(102);
      END_STATE();
    case 101:
      if (lookahead == '-') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(102);
      END_STATE();
    case 102:
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 103:
      if (lookahead == '-') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 104:
      if (lookahead == '-') ADVANCE(107);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 105:
      if (lookahead == '-') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 106:
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 107:
      if (lookahead == '-') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 108:
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      if (lookahead == '-') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      if (lookahead == '-') ADVANCE(105);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 111:
      if (lookahead == '-') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 112:
      if (lookahead == '-') ADVANCE(115);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 113:
      if (lookahead == '-') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 114:
      if (lookahead == '-') ADVANCE(109);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 115:
      if (lookahead == '-') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 116:
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 117:
      if (lookahead == '-') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 118:
      if (lookahead == '-') ADVANCE(113);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(112);
      END_STATE();
    case 119:
      if (lookahead == '-') ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(112);
      END_STATE();
    case 120:
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 121:
      if (lookahead == '-') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 122:
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 123:
      if (lookahead == '-') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 124:
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 125:
      if (lookahead == '-') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 126:
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 127:
      if (lookahead == '-') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 128:
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 129:
      if (lookahead == '-') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 130:
      if (lookahead == '-') ADVANCE(125);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 131:
      if (lookahead == '-') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 132:
      if (lookahead == '-') ADVANCE(135);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(134);
      END_STATE();
    case 133:
      if (lookahead == '-') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(134);
      END_STATE();
    case 134:
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 135:
      if (lookahead == '-') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 136:
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(132);
      END_STATE();
    case 137:
      if (lookahead == '-') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(132);
      END_STATE();
    case 138:
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      END_STATE();
    case 139:
      if (lookahead == '.') ADVANCE(2173);
      if (lookahead == '>') ADVANCE(2225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 140:
      if (lookahead == '1') ADVANCE(2153);
      if (lookahead == '3') ADVANCE(143);
      END_STATE();
    case 141:
      if (lookahead == '1') ADVANCE(2167);
      if (lookahead == ';') ADVANCE(2181);
      END_STATE();
    case 142:
      if (lookahead == '1') ADVANCE(369);
      if (lookahead == '2') ADVANCE(2154);
      if (lookahead == '3') ADVANCE(366);
      if (lookahead == '4') ADVANCE(145);
      if (lookahead == '5') ADVANCE(2155);
      if (lookahead == '7') ADVANCE(146);
      END_STATE();
    case 143:
      if (lookahead == '4') ADVANCE(148);
      END_STATE();
    case 144:
      if (lookahead == '4') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(1664);
      END_STATE();
    case 145:
      if (lookahead == '5') ADVANCE(148);
      END_STATE();
    case 146:
      if (lookahead == '8') ADVANCE(148);
      END_STATE();
    case 147:
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == '@') ADVANCE(2173);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '/' ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(386);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(147);
      END_STATE();
    case 148:
      if (lookahead == ';') ADVANCE(2181);
      END_STATE();
    case 149:
      ADVANCE_MAP(
        ';', 2181,
        'A', 589,
        'B', 579,
        'E', 276,
        'H', 542,
        'a', 815,
        'b', 580,
        'c', 607,
        'd', 799,
        'e', 273,
        'f', 1257,
        'g', 163,
        'h', 625,
        'j', 750,
        'l', 199,
        'm', 1240,
        'n', 460,
        'o', 550,
        'p', 629,
        'r', 583,
        's', 530,
        't', 226,
        'u', 1774,
        'v', 1067,
      );
      END_STATE();
    case 150:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'a') ADVANCE(1758);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'q') ADVANCE(2075);
      if (lookahead == 's') ADVANCE(972);
      if (lookahead == 'x') ADVANCE(1299);
      END_STATE();
    case 151:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'A') ADVANCE(1877);
      END_STATE();
    case 152:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'A') ADVANCE(1877);
      if (lookahead == 'V') ADVANCE(1068);
      END_STATE();
    case 153:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'B') ADVANCE(542);
      END_STATE();
    case 154:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'B') ADVANCE(542);
      if (lookahead == 'D') ADVANCE(1648);
      END_STATE();
    case 155:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'B') ADVANCE(542);
      if (lookahead == 'E') ADVANCE(1736);
      END_STATE();
    case 156:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'B') ADVANCE(542);
      if (lookahead == 'L') ADVANCE(1070);
      END_STATE();
    case 157:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'B') ADVANCE(542);
      if (lookahead == 'R') ADVANCE(1321);
      END_STATE();
    case 158:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'B') ADVANCE(542);
      if (lookahead == 'U') ADVANCE(1692);
      END_STATE();
    case 159:
      ADVANCE_MAP(
        ';', 2181,
        'C', 1659,
        'D', 1633,
        'E', 1368,
        'G', 1893,
        'H', 2086,
        'L', 1042,
        'N', 1009,
        'P', 1854,
        'R', 1043,
        'S', 1737,
        'T', 1246,
        'V', 1082,
      );
      END_STATE();
    case 160:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'C') ADVANCE(568);
      END_STATE();
    case 161:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'D') ADVANCE(1594);
      if (lookahead == 'E') ADVANCE(1736);
      END_STATE();
    case 162:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'D') ADVANCE(441);
      END_STATE();
    case 163:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(148);
      END_STATE();
    case 164:
      ADVANCE_MAP(
        ';', 2181,
        'E', 148,
        'a', 1673,
        'c', 2064,
        'e', 225,
        'i', 1495,
        'n', 459,
        'o', 878,
        's', 1251,
        'u', 1805,
      );
      END_STATE();
    case 165:
      ADVANCE_MAP(
        ';', 2181,
        'E', 148,
        'd', 1594,
        'e', 236,
        'm', 2071,
        'n', 2156,
        'p', 1444,
        'r', 579,
        's', 1022,
      );
      END_STATE();
    case 166:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'v') ADVANCE(2169);
      END_STATE();
    case 167:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 168:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(877);
      if (lookahead == 'o') ADVANCE(1899);
      if (lookahead == 'p') ADVANCE(1825);
      END_STATE();
    case 169:
      ADVANCE_MAP(
        ';', 2181,
        'E', 293,
        'a', 817,
        'b', 1745,
        'c', 1287,
        'd', 1594,
        'e', 294,
        'f', 1746,
        'g', 276,
        'i', 1480,
        'j', 750,
        'l', 365,
        'n', 460,
        'o', 1676,
        'r', 533,
        's', 785,
        't', 227,
        'v', 1067,
      );
      END_STATE();
    case 170:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(1736);
      END_STATE();
    case 171:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(1736);
      if (lookahead == 'F') ADVANCE(2093);
      if (lookahead == 'G') ADVANCE(1886);
      if (lookahead == 'L') ADVANCE(968);
      if (lookahead == 'S') ADVANCE(1454);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 172:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(1736);
      if (lookahead == 'F') ADVANCE(2093);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 173:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(1736);
      if (lookahead == 'G') ADVANCE(1886);
      if (lookahead == 'L') ADVANCE(968);
      if (lookahead == 'S') ADVANCE(1454);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 174:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(1736);
      if (lookahead == 'S') ADVANCE(1454);
      END_STATE();
    case 175:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E') ADVANCE(1736);
      if (lookahead == 'S') ADVANCE(1454);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 176:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'G') ADVANCE(148);
      END_STATE();
    case 177:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'H') ADVANCE(148);
      END_STATE();
    case 178:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'I') ADVANCE(1576);
      if (lookahead == 'S') ADVANCE(2057);
      if (lookahead == 'U') ADVANCE(1557);
      END_STATE();
    case 179:
      ADVANCE_MAP(
        ';', 2181,
        'J', 750,
        'a', 816,
        'c', 609,
        'e', 1099,
        'f', 1746,
        'l', 253,
        'm', 1239,
        'o', 1524,
        's', 782,
        'T', 148,
        't', 148,
      );
      END_STATE();
    case 180:
      ADVANCE_MAP(
        ';', 2181,
        'J', 750,
        'a', 1496,
        'b', 1745,
        'c', 976,
        'd', 1594,
        'f', 1746,
        'o', 1676,
        'r', 994,
        's', 774,
        'T', 148,
        'g', 148,
        't', 148,
      );
      END_STATE();
    case 181:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'L') ADVANCE(968);
      END_STATE();
    case 182:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'N') ADVANCE(148);
      END_STATE();
    case 183:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'P') ADVANCE(148);
      END_STATE();
    case 184:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'P') ADVANCE(1444);
      END_STATE();
    case 185:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'T') ADVANCE(148);
      END_STATE();
    case 186:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 187:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'Y') ADVANCE(148);
      END_STATE();
    case 188:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(780);
      if (lookahead == 'p') ADVANCE(1410);
      END_STATE();
    case 189:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1131);
      if (lookahead == 'o') ADVANCE(2009);
      END_STATE();
    case 190:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(2171);
      END_STATE();
    case 191:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(774);
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 192:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1746);
      END_STATE();
    case 193:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(788);
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 194:
      ADVANCE_MAP(
        ';', 2181,
        'a', 1674,
        'c', 2064,
        'e', 245,
        'i', 1813,
        'n', 459,
        'p', 1669,
        's', 1251,
        'E', 148,
        'y', 148,
      );
      END_STATE();
    case 195:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(301);
      if (lookahead == 's') ADVANCE(1252);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 196:
      ADVANCE_MAP(
        ';', 2181,
        'a', 1673,
        'b', 272,
        'f', 1899,
        'h', 1335,
        'l', 1673,
        'p', 1354,
        's', 1251,
        't', 1354,
        'c', 148,
        'w', 148,
      );
      END_STATE();
    case 197:
      ADVANCE_MAP(
        ';', 2181,
        'a', 846,
        'c', 1229,
        'd', 2165,
        'm', 305,
        's', 1251,
        't', 2117,
        'b', 148,
        'e', 148,
      );
      END_STATE();
    case 198:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(846);
      if (lookahead == 'i') ADVANCE(877);
      if (lookahead == 'o') ADVANCE(1899);
      if (lookahead == 'p') ADVANCE(1819);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 199:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'c') ADVANCE(1645);
      if (lookahead == 'h') ADVANCE(644);
      if (lookahead == 't') ADVANCE(1781);
      END_STATE();
    case 200:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'd') ADVANCE(268);
      if (lookahead == 'i') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1409);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 201:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1899);
      END_STATE();
    case 202:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1910);
      if (lookahead == 'c') ADVANCE(1229);
      if (lookahead == 'd') ADVANCE(1601);
      END_STATE();
    case 203:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1354);
      END_STATE();
    case 204:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1799);
      if (lookahead == 'e') ADVANCE(917);
      if (lookahead == 'i') ADVANCE(1813);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 205:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1359);
      if (lookahead == 'c') ADVANCE(1954);
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 206:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1499);
      if (lookahead == 'b') ADVANCE(1868);
      if (lookahead == 'c') ADVANCE(572);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 207:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1499);
      if (lookahead == 's') ADVANCE(1409);
      if (lookahead == 'd' ||
          lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 208:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(839);
      END_STATE();
    case 209:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'c') ADVANCE(1186);
      if (lookahead == 'o') ADVANCE(1833);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 210:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1378);
      END_STATE();
    case 211:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1762);
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 212:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1708);
      if (lookahead == 'c') ADVANCE(2084);
      if (lookahead == 'e') ADVANCE(1728);
      if (lookahead == 'n') ADVANCE(666);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 213:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1259);
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 214:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a') ADVANCE(1453);
      if (lookahead == 's') ADVANCE(1354);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 215:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b') ADVANCE(1594);
      if (lookahead == 'c') ADVANCE(1229);
      if (lookahead == 'f') ADVANCE(314);
      END_STATE();
    case 216:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b') ADVANCE(148);
      if (lookahead == 'd') ADVANCE(352);
      END_STATE();
    case 217:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b') ADVANCE(148);
      if (lookahead == 'h') ADVANCE(1946);
      END_STATE();
    case 218:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b') ADVANCE(192);
      END_STATE();
    case 219:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'd') ADVANCE(148);
      END_STATE();
    case 220:
      ADVANCE_MAP(
        ';', 2181,
        'b', 272,
        'f', 1899,
        'h', 1335,
        'l', 1673,
        'p', 1354,
        's', 1251,
        't', 1354,
      );
      END_STATE();
    case 221:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b') ADVANCE(542);
      if (lookahead == 'e') ADVANCE(1728);
      END_STATE();
    case 222:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b') ADVANCE(1821);
      if (lookahead == 'c') ADVANCE(572);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'o') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 223:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(148);
      END_STATE();
    case 224:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(256);
      if (lookahead == 'f') ADVANCE(1562);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 's') ADVANCE(846);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 225:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(212);
      END_STATE();
    case 226:
      ADVANCE_MAP(
        ';', 2181,
        'c', 759,
        'd', 1594,
        'h', 1795,
        'i', 1493,
        'l', 579,
        'q', 2076,
        'r', 501,
      );
      END_STATE();
    case 227:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(759);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'l') ADVANCE(500);
      if (lookahead == 'q') ADVANCE(2076);
      if (lookahead == 'r') ADVANCE(567);
      END_STATE();
    case 228:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 229:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(758);
      if (lookahead == 'd') ADVANCE(1638);
      if (lookahead == 'l') ADVANCE(263);
      END_STATE();
    case 230:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(758);
      if (lookahead == 'd') ADVANCE(1639);
      if (lookahead == 'g') ADVANCE(263);
      if (lookahead == 's') ADVANCE(665);
      END_STATE();
    case 231:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(596);
      if (lookahead == 'e') ADVANCE(1164);
      if (lookahead == 'l') ADVANCE(651);
      if (lookahead == 'p') ADVANCE(1806);
      END_STATE();
    case 232:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(1229);
      if (lookahead == 'w') ADVANCE(148);
      END_STATE();
    case 233:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(2064);
      if (lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 234:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(2064);
      if (lookahead == 'e' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 235:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c') ADVANCE(686);
      if (lookahead == 'f') ADVANCE(1274);
      if (lookahead == 'o') ADVANCE(872);
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 236:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(1594);
      END_STATE();
    case 237:
      ADVANCE_MAP(
        ';', 2181,
        'd', 1594,
        'e', 321,
        'g', 163,
        'l', 163,
        'n', 922,
        'p', 1444,
        'r', 579,
      );
      END_STATE();
    case 238:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 's') ADVANCE(354);
      if (lookahead == 'E' ||
          lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 239:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(148);
      END_STATE();
    case 240:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(922);
      END_STATE();
    case 241:
      ADVANCE_MAP(
        ';', 2181,
        'd', 1595,
        'e', 236,
        'h', 1912,
        'l', 579,
        'm', 2071,
        'n', 2156,
        'p', 1444,
        's', 1022,
      );
      if (('1' <= lookahead && lookahead <= '3') ||
          lookahead == 'E') ADVANCE(148);
      END_STATE();
    case 242:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(1587);
      if (lookahead == 'l') ADVANCE(982);
      if (lookahead == 'r') ADVANCE(1282);
      END_STATE();
    case 243:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(1587);
      if (lookahead == 'l') ADVANCE(982);
      if (lookahead == 'u') ADVANCE(1673);
      END_STATE();
    case 244:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(1587);
      if (lookahead == 'l') ADVANCE(1075);
      if (lookahead == 'q') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1325);
      END_STATE();
    case 245:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'd') ADVANCE(1259);
      END_STATE();
    case 246:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 247:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(922);
      if (lookahead == 'm') ADVANCE(1929);
      if (lookahead == 'r') ADVANCE(1983);
      if (lookahead == 's') ADVANCE(1696);
      if (lookahead == 'z') ADVANCE(579);
      END_STATE();
    case 248:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1010);
      END_STATE();
    case 249:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1746);
      END_STATE();
    case 250:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1729);
      if (lookahead == 'm') ADVANCE(1311);
      if (lookahead == 'p') ADVANCE(1444);
      if (lookahead == 's') ADVANCE(1743);
      END_STATE();
    case 251:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1954);
      END_STATE();
    case 252:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1157);
      END_STATE();
    case 253:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1102);
      END_STATE();
    case 254:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 255:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1728);
      END_STATE();
    case 256:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1728);
      if (lookahead == 'l') ADVANCE(942);
      END_STATE();
    case 257:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 258:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(848);
      if (lookahead == 'i') ADVANCE(1483);
      if (lookahead == 'o') ADVANCE(901);
      END_STATE();
    case 259:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(317);
      END_STATE();
    case 260:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1733);
      END_STATE();
    case 261:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1733);
      if (lookahead == 'n') ADVANCE(987);
      END_STATE();
    case 262:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(595);
      END_STATE();
    case 263:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1899);
      END_STATE();
    case 264:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1930);
      END_STATE();
    case 265:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1554);
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 266:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1831);
      if (lookahead == 's') ADVANCE(957);
      END_STATE();
    case 267:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1787);
      if (lookahead == 's') ADVANCE(1673);
      END_STATE();
    case 268:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1797);
      if (lookahead == 'f' ||
          lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 269:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e') ADVANCE(1786);
      END_STATE();
    case 270:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 271:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1583);
      if (lookahead == 'y') ADVANCE(331);
      END_STATE();
    case 272:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'f') ADVANCE(1899);
      END_STATE();
    case 273:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'f') ADVANCE(1959);
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 'q') ADVANCE(322);
      if (lookahead == 's') ADVANCE(230);
      END_STATE();
    case 274:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'f') ADVANCE(1500);
      if (lookahead == 'l') ADVANCE(943);
      END_STATE();
    case 275:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'f') ADVANCE(1984);
      if (lookahead == 'q') ADVANCE(322);
      if (lookahead == 's') ADVANCE(330);
      END_STATE();
    case 276:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 277:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(1975);
      if (lookahead == 'm') ADVANCE(1707);
      END_STATE();
    case 278:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'g') ADVANCE(1954);
      END_STATE();
    case 279:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'g') ADVANCE(922);
      END_STATE();
    case 280:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 281:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(1625);
      END_STATE();
    case 282:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'h') ADVANCE(1584);
      END_STATE();
    case 283:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(1232);
      if (lookahead == 'n') ADVANCE(1114);
      if (lookahead == 'o') ADVANCE(1975);
      END_STATE();
    case 284:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(896);
      if (lookahead == 'o') ADVANCE(1516);
      END_STATE();
    case 285:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(1776);
      if (lookahead == 'u') ADVANCE(1990);
      if (lookahead == 'E' ||
          lookahead == 'd' ||
          lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 286:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(1776);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 287:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(1534);
      if (lookahead == 'p') ADVANCE(648);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 288:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(2013);
      END_STATE();
    case 289:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(861);
      END_STATE();
    case 290:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(1508);
      if (lookahead == 'n') ADVANCE(1242);
      END_STATE();
    case 291:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(1436);
      END_STATE();
    case 292:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'i') ADVANCE(1573);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 's') ADVANCE(236);
      END_STATE();
    case 293:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 294:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 'q') ADVANCE(322);
      if (lookahead == 's') ADVANCE(229);
      END_STATE();
    case 295:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(2012);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 296:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(1954);
      END_STATE();
    case 297:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(1625);
      END_STATE();
    case 298:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(1625);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 299:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(922);
      if (lookahead == 'd' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 300:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(2016);
      if (lookahead == 'm') ADVANCE(568);
      END_STATE();
    case 301:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'l') ADVANCE(1395);
      END_STATE();
    case 302:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 303:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'm') ADVANCE(267);
      END_STATE();
    case 304:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'm') ADVANCE(602);
      END_STATE();
    case 305:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 306:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'n') ADVANCE(621);
      END_STATE();
    case 307:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 308:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(326);
      END_STATE();
    case 309:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(293);
      END_STATE();
    case 310:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(1092);
      END_STATE();
    case 311:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(2123);
      END_STATE();
    case 312:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(2112);
      END_STATE();
    case 313:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(846);
      END_STATE();
    case 314:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(1800);
      END_STATE();
    case 315:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(2029);
      END_STATE();
    case 316:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(1539);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 317:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'o') ADVANCE(1564);
      END_STATE();
    case 318:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 319:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 't') ADVANCE(290);
      END_STATE();
    case 320:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'p') ADVANCE(1825);
      END_STATE();
    case 321:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'q') ADVANCE(148);
      END_STATE();
    case 322:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'q') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1439);
      END_STATE();
    case 323:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'q') ADVANCE(322);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 324:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'q') ADVANCE(321);
      END_STATE();
    case 325:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'q') ADVANCE(2075);
      END_STATE();
    case 326:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 327:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'r') ADVANCE(560);
      if (lookahead == 's') ADVANCE(236);
      END_STATE();
    case 328:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'r') ADVANCE(1267);
      END_STATE();
    case 329:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'r') ADVANCE(1245);
      END_STATE();
    case 330:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 331:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(1746);
      END_STATE();
    case 332:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(239);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 333:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(219);
      END_STATE();
    case 334:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(2145);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 335:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(1459);
      END_STATE();
    case 336:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(1354);
      END_STATE();
    case 337:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(2017);
      END_STATE();
    case 338:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(957);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 339:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(1012);
      END_STATE();
    case 340:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(1025);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 341:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 's') ADVANCE(2079);
      END_STATE();
    case 342:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 343:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 344:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(1584);
      END_STATE();
    case 345:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 346:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(730);
      END_STATE();
    case 347:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(1354);
      END_STATE();
    case 348:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(828);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 349:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(675);
      END_STATE();
    case 350:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(1608);
      END_STATE();
    case 351:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 't') ADVANCE(1267);
      END_STATE();
    case 352:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 353:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'u') ADVANCE(1237);
      END_STATE();
    case 354:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 355:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'v') ADVANCE(2169);
      END_STATE();
    case 356:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'v') ADVANCE(719);
      END_STATE();
    case 357:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'v') ADVANCE(1024);
      END_STATE();
    case 358:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 359:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'b' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 360:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'c' ||
          lookahead == 'w') ADVANCE(148);
      END_STATE();
    case 361:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e' ||
          lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 362:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e' ||
          lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 363:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'f' ||
          lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 364:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 365:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'E' ||
          lookahead == 'a' ||
          lookahead == 'j') ADVANCE(148);
      END_STATE();
    case 366:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == '4' ||
          lookahead == '5' ||
          lookahead == '8') ADVANCE(148);
      END_STATE();
    case 367:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'D' ||
          lookahead == 'U' ||
          lookahead == 'd' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 368:
      if (lookahead == ';') ADVANCE(2181);
      if (lookahead == 'H' ||
          lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'h' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 369:
      if (lookahead == ';') ADVANCE(2181);
      if (('2' <= lookahead && lookahead <= '6') ||
          lookahead == '8') ADVANCE(148);
      END_STATE();
    case 370:
      if (lookahead == ';') ADVANCE(2182);
      END_STATE();
    case 371:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 372:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(370);
      END_STATE();
    case 373:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(371);
      END_STATE();
    case 374:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 375:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 376:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 377:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(370);
      END_STATE();
    case 378:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(377);
      END_STATE();
    case 379:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(378);
      END_STATE();
    case 380:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(379);
      END_STATE();
    case 381:
      if (lookahead == ';') ADVANCE(2182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(380);
      END_STATE();
    case 382:
      if (lookahead == '>') ADVANCE(2230);
      END_STATE();
    case 383:
      if (lookahead == '>') ADVANCE(2237);
      END_STATE();
    case 384:
      if (lookahead == '>') ADVANCE(2224);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '<') ADVANCE(384);
      END_STATE();
    case 385:
      if (lookahead == '@') ADVANCE(2173);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '/' ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(386);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(147);
      END_STATE();
    case 386:
      if (lookahead == '@') ADVANCE(2173);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(386);
      END_STATE();
    case 387:
      ADVANCE_MAP(
        'A', 505,
        'a', 821,
        'c', 1285,
        'f', 1746,
        'i', 1373,
        'o', 1679,
        's', 795,
        'u', 1472,
      );
      END_STATE();
    case 388:
      ADVANCE_MAP(
        'A', 589,
        'B', 579,
        'H', 542,
        'a', 768,
        'b', 580,
        'c', 607,
        'd', 798,
        'e', 205,
        'f', 1257,
        'h', 626,
        'i', 1147,
        'l', 585,
        'm', 1657,
        'n', 1473,
        'o', 551,
        'p', 633,
        'r', 579,
        's', 531,
        't', 1213,
        'u', 1399,
        'x', 148,
      );
      END_STATE();
    case 389:
      if (lookahead == 'A') ADVANCE(523);
      END_STATE();
    case 390:
      ADVANCE_MAP(
        'A', 750,
        'I', 750,
        'U', 750,
        'a', 808,
        'c', 1287,
        'f', 1746,
        'o', 1676,
        's', 774,
        'u', 1481,
      );
      END_STATE();
    case 391:
      if (lookahead == 'A') ADVANCE(444);
      END_STATE();
    case 392:
      ADVANCE_MAP(
        'A', 1571,
        'C', 1084,
        'D', 1589,
        'F', 1398,
        'R', 1320,
        'T', 1029,
        'U', 1687,
        'V', 1063,
        'a', 1877,
        'r', 1313,
      );
      END_STATE();
    case 393:
      if (lookahead == 'A') ADVANCE(514);
      END_STATE();
    case 394:
      ADVANCE_MAP(
        'A', 1765,
        'B', 636,
        'D', 575,
        'a', 1531,
        'c', 2135,
        'd', 575,
        'e', 935,
        'f', 1746,
        'l', 2012,
        'n', 1928,
        'o', 1676,
        'p', 1815,
        'r', 2012,
        's', 797,
        'z', 1260,
      );
      END_STATE();
    case 395:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'd') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(275);
      if (lookahead == 's') ADVANCE(1251);
      if (lookahead == 't') ADVANCE(329);
      END_STATE();
    case 396:
      ADVANCE_MAP(
        'A', 1765,
        'H', 542,
        'a', 1130,
        'b', 1351,
        'c', 612,
        'd', 189,
        'e', 277,
        'f', 1258,
        'h', 619,
        'i', 590,
        'j', 750,
        'l', 764,
        'o', 1402,
        'r', 726,
        's', 766,
        't', 876,
        'u', 584,
        'w', 594,
        'z', 755,
      );
      END_STATE();
    case 397:
      ADVANCE_MAP(
        'A', 1765,
        'H', 542,
        'a', 809,
        'b', 1768,
        'c', 1266,
        'd', 581,
        'f', 1258,
        'g', 1807,
        'h', 620,
        'l', 857,
        'm', 191,
        'o', 1134,
        'p', 691,
        'r', 856,
        's', 774,
        't', 873,
        'u', 586,
        'w', 594,
      );
      END_STATE();
    case 398:
      ADVANCE_MAP(
        'A', 1765,
        'a', 1273,
        'b', 542,
        'c', 1285,
        'e', 673,
        'f', 1746,
        'k', 1900,
        'o', 587,
        's', 787,
        'y', 728,
      );
      END_STATE();
    case 399:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'a') ADVANCE(1765);
      END_STATE();
    case 400:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'p') ADVANCE(542);
      END_STATE();
    case 401:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'a') ADVANCE(1758);
      if (lookahead == 'c') ADVANCE(342);
      if (lookahead == 'm') ADVANCE(1219);
      if (lookahead == 's') ADVANCE(2118);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'x') ADVANCE(1954);
      END_STATE();
    case 402:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'a') ADVANCE(1758);
      if (lookahead == 'n') ADVANCE(2118);
      END_STATE();
    case 403:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'a') ADVANCE(1758);
      if (lookahead == 'n') ADVANCE(971);
      END_STATE();
    case 404:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'a') ADVANCE(1857);
      if (lookahead == 'i') ADVANCE(1150);
      if (lookahead == 't') ADVANCE(1840);
      END_STATE();
    case 405:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 't') ADVANCE(328);
      END_STATE();
    case 406:
      if (lookahead == 'A') ADVANCE(1765);
      if (lookahead == 't') ADVANCE(1835);
      END_STATE();
    case 407:
      ADVANCE_MAP(
        'A', 1880,
        'D', 1648,
        'E', 1739,
        'T', 1014,
        'a', 1877,
        'd', 1655,
        'p', 1023,
        's', 1236,
      );
      END_STATE();
    case 408:
      if (lookahead == 'A') ADVANCE(814);
      END_STATE();
    case 409:
      if (lookahead == 'A') ADVANCE(814);
      if (lookahead == 'D') ADVANCE(1592);
      if (lookahead == 'G') ADVANCE(1798);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 410:
      if (lookahead == 'A') ADVANCE(1396);
      END_STATE();
    case 411:
      ADVANCE_MAP(
        'A', 1572,
        'C', 1084,
        'D', 1589,
        'F', 1398,
        'T', 1029,
        'U', 1687,
        'V', 1063,
        'a', 1877,
      );
      END_STATE();
    case 412:
      if (lookahead == 'A') ADVANCE(1877);
      END_STATE();
    case 413:
      if (lookahead == 'A') ADVANCE(1877);
      if (lookahead == 'D') ADVANCE(1648);
      END_STATE();
    case 414:
      if (lookahead == 'A') ADVANCE(1877);
      if (lookahead == 'R') ADVANCE(1321);
      END_STATE();
    case 415:
      if (lookahead == 'A') ADVANCE(1877);
      if (lookahead == 'R') ADVANCE(1321);
      if (lookahead == 'T') ADVANCE(999);
      END_STATE();
    case 416:
      if (lookahead == 'A') ADVANCE(1877);
      if (lookahead == 'T') ADVANCE(999);
      END_STATE();
    case 417:
      if (lookahead == 'A') ADVANCE(1877);
      if (lookahead == 'V') ADVANCE(1068);
      END_STATE();
    case 418:
      if (lookahead == 'A') ADVANCE(1881);
      if (lookahead == 'B') ADVANCE(1745);
      if (lookahead == 'L') ADVANCE(1061);
      if (lookahead == 'R') ADVANCE(1319);
      if (lookahead == 'T') ADVANCE(1014);
      if (lookahead == 'a') ADVANCE(1877);
      END_STATE();
    case 419:
      if (lookahead == 'B') ADVANCE(545);
      if (lookahead == 'P') ADVANCE(694);
      END_STATE();
    case 420:
      ADVANCE_MAP(
        'B', 579,
        'E', 176,
        'a', 818,
        'c', 609,
        'e', 357,
        'f', 1746,
        'h', 1584,
        'i', 1128,
        'o', 1682,
        'r', 1313,
        's', 781,
        'u', 1389,
      );
      END_STATE();
    case 421:
      if (lookahead == 'B') ADVANCE(542);
      END_STATE();
    case 422:
      if (lookahead == 'B') ADVANCE(542);
      if (lookahead == 'L') ADVANCE(1268);
      if (lookahead == 'S') ADVANCE(1056);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 423:
      if (lookahead == 'B') ADVANCE(1878);
      END_STATE();
    case 424:
      if (lookahead == 'B') ADVANCE(1870);
      if (lookahead == 'n') ADVANCE(425);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 425:
      if (lookahead == 'B') ADVANCE(1875);
      END_STATE();
    case 426:
      if (lookahead == 'C') ADVANCE(478);
      if (lookahead == 'c') ADVANCE(2135);
      END_STATE();
    case 427:
      if (lookahead == 'C') ADVANCE(447);
      END_STATE();
    case 428:
      if (lookahead == 'C') ADVANCE(568);
      END_STATE();
    case 429:
      if (lookahead == 'C') ADVANCE(1649);
      if (lookahead == 'T') ADVANCE(1300);
      END_STATE();
    case 430:
      if (lookahead == 'C') ADVANCE(1326);
      END_STATE();
    case 431:
      if (lookahead == 'C') ADVANCE(1421);
      END_STATE();
    case 432:
      if (lookahead == 'C') ADVANCE(2083);
      END_STATE();
    case 433:
      if (lookahead == 'C') ADVANCE(1665);
      END_STATE();
    case 434:
      if (lookahead == 'C') ADVANCE(1665);
      if (lookahead == 'D') ADVANCE(1591);
      if (lookahead == 'L') ADVANCE(1073);
      if (lookahead == 'R') ADVANCE(1323);
      if (lookahead == 'U') ADVANCE(1688);
      if (lookahead == 'V') ADVANCE(1082);
      END_STATE();
    case 435:
      if (lookahead == 'D') ADVANCE(1594);
      END_STATE();
    case 436:
      if (lookahead == 'D') ADVANCE(1594);
      if (lookahead == 'M') ADVANCE(1311);
      if (lookahead == 'P') ADVANCE(1444);
      if (lookahead == 'T') ADVANCE(1300);
      END_STATE();
    case 437:
      if (lookahead == 'D') ADVANCE(1594);
      if (lookahead == 'a') ADVANCE(1765);
      END_STATE();
    case 438:
      if (lookahead == 'D') ADVANCE(1594);
      if (lookahead == 'o') ADVANCE(1954);
      END_STATE();
    case 439:
      if (lookahead == 'D') ADVANCE(1594);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 440:
      ADVANCE_MAP(
        'D', 315,
        'J', 750,
        'S', 750,
        'Z', 750,
        'a', 1132,
        'c', 612,
        'e', 1355,
        'f', 1746,
        'i', 554,
        'o', 1680,
        's', 795,
      );
      END_STATE();
    case 441:
      if (lookahead == 'D') ADVANCE(148);
      END_STATE();
    case 442:
      ADVANCE_MAP(
        'D', 438,
        'a', 812,
        'c', 610,
        'd', 1594,
        'e', 148,
        'f', 439,
        'g', 327,
        'l', 292,
        'm', 541,
        'n', 1117,
        'o', 1134,
        'p', 623,
        'q', 805,
        'r', 437,
        's', 775,
        't', 358,
        'u', 1461,
        'x', 833,
      );
      END_STATE();
    case 443:
      ADVANCE_MAP(
        'D', 435,
        'a', 760,
        'c', 1650,
        'd', 575,
        'e', 658,
        'f', 1746,
        'h', 1584,
        'i', 849,
        'l', 813,
        'n', 1704,
        'o', 913,
        'p', 148,
        's', 794,
        'u', 300,
      );
      END_STATE();
    case 444:
      if (lookahead == 'D') ADVANCE(458);
      END_STATE();
    case 445:
      ADVANCE_MAP(
        'D', 2170,
        'H', 367,
        'U', 2170,
        'V', 368,
        'b', 1599,
        'd', 2170,
        'h', 367,
        'm', 1311,
        'p', 1444,
        't', 1300,
        'u', 2170,
        'v', 368,
      );
      END_STATE();
    case 446:
      if (lookahead == 'D') ADVANCE(750);
      END_STATE();
    case 447:
      if (lookahead == 'D') ADVANCE(393);
      END_STATE();
    case 448:
      ADVANCE_MAP(
        'D', 575,
        'H', 579,
        'a', 1673,
        'd', 575,
        'g', 2162,
        'i', 1518,
        'l', 405,
        'r', 406,
        's', 1251,
      );
      END_STATE();
    case 449:
      ADVANCE_MAP(
        'D', 575,
        'b', 542,
        'c', 2135,
        'd', 578,
        'e', 925,
        'f', 1746,
        'o', 1676,
        's', 774,
        'v', 893,
      );
      END_STATE();
    case 450:
      if (lookahead == 'D') ADVANCE(575);
      if (lookahead == 'd') ADVANCE(575);
      END_STATE();
    case 451:
      if (lookahead == 'D') ADVANCE(1648);
      if (lookahead == 'L') ADVANCE(1070);
      if (lookahead == 'R') ADVANCE(1321);
      if (lookahead == 'U') ADVANCE(1692);
      END_STATE();
    case 452:
      if (lookahead == 'D') ADVANCE(1250);
      END_STATE();
    case 453:
      if (lookahead == 'D') ADVANCE(1016);
      END_STATE();
    case 454:
      if (lookahead == 'D') ADVANCE(1656);
      if (lookahead == 'E') ADVANCE(1736);
      END_STATE();
    case 455:
      if (lookahead == 'D') ADVANCE(1660);
      if (lookahead == 'T') ADVANCE(1035);
      if (lookahead == 'V') ADVANCE(1063);
      END_STATE();
    case 456:
      if (lookahead == 'D') ADVANCE(1670);
      if (lookahead == 'Q') ADVANCE(2094);
      END_STATE();
    case 457:
      ADVANCE_MAP(
        'E', 1394,
        'M', 183,
        'a', 808,
        'b', 1745,
        'c', 1266,
        'f', 1746,
        'g', 1807,
        'l', 1675,
        'm', 537,
        'n', 877,
        'o', 1134,
        'p', 1700,
        'r', 1241,
        's', 792,
        't', 1288,
        'u', 1460,
      );
      END_STATE();
    case 458:
      if (lookahead == 'E') ADVANCE(148);
      END_STATE();
    case 459:
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1673);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 460:
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1691);
      if (lookahead == 'e') ADVANCE(324);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 461:
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'e') ADVANCE(323);
      if (lookahead == 's') ADVANCE(1251);
      if (lookahead == 't') ADVANCE(326);
      END_STATE();
    case 462:
      if (lookahead == 'E') ADVANCE(1367);
      if (lookahead == 'U') ADVANCE(1723);
      END_STATE();
    case 463:
      ADVANCE_MAP(
        'E', 750,
        'J', 1400,
        'O', 750,
        'a', 808,
        'c', 1266,
        'd', 1594,
        'f', 1746,
        'g', 1807,
        'm', 188,
        'n', 1982,
        'o', 1135,
        's', 774,
        't', 1314,
        'u', 1343,
      );
      END_STATE();
    case 464:
      if (lookahead == 'E') ADVANCE(1366);
      END_STATE();
    case 465:
      ADVANCE_MAP(
        'E', 1400,
        'a', 808,
        'c', 1266,
        'd', 748,
        'f', 1746,
        'g', 1807,
        'm', 539,
        'o', 1676,
        'p', 986,
        'r', 148,
        's', 789,
        't', 1235,
        'u', 1460,
        'v', 1001,
      );
      END_STATE();
    case 466:
      if (lookahead == 'E') ADVANCE(1739);
      END_STATE();
    case 467:
      if (lookahead == 'E') ADVANCE(1736);
      END_STATE();
    case 468:
      if (lookahead == 'E') ADVANCE(1741);
      if (lookahead == 'F') ADVANCE(2093);
      if (lookahead == 'G') ADVANCE(1886);
      if (lookahead == 'L') ADVANCE(968);
      if (lookahead == 'S') ADVANCE(1454);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 469:
      if (lookahead == 'E') ADVANCE(1742);
      if (lookahead == 'F') ADVANCE(2093);
      if (lookahead == 'G') ADVANCE(1886);
      if (lookahead == 'L') ADVANCE(968);
      if (lookahead == 'S') ADVANCE(1454);
      if (lookahead == 'T') ADVANCE(1314);
      END_STATE();
    case 470:
      if (lookahead == 'F') ADVANCE(513);
      END_STATE();
    case 471:
      if (lookahead == 'F') ADVANCE(2087);
      END_STATE();
    case 472:
      if (lookahead == 'G') ADVANCE(148);
      END_STATE();
    case 473:
      ADVANCE_MAP(
        'G', 1118,
        'L', 1049,
        'R', 1313,
        'V', 450,
        'a', 732,
        'b', 1901,
        'c', 562,
        'd', 575,
        'e', 150,
        'f', 1746,
        'g', 461,
        'h', 400,
        'i', 332,
        'j', 750,
        'l', 395,
        'm', 1218,
        'o', 319,
        'p', 631,
        'r', 404,
        's', 767,
        't', 1138,
        'u', 303,
        'v', 448,
        'w', 403,
      );
      END_STATE();
    case 474:
      if (lookahead == 'G') ADVANCE(1886);
      END_STATE();
    case 475:
      if (lookahead == 'G') ADVANCE(1895);
      if (lookahead == 'L') ADVANCE(1051);
      END_STATE();
    case 476:
      ADVANCE_MAP(
        'H', 426,
        'O', 470,
        'a', 814,
        'c', 204,
        'f', 1746,
        'h', 1651,
        'i', 1136,
        'm', 656,
        'o', 1676,
        'q', 1772,
        's', 774,
        't', 542,
        'u', 716,
      );
      END_STATE();
    case 477:
      ADVANCE_MAP(
        'H', 498,
        'R', 391,
        'S', 482,
        'a', 2159,
        'c', 609,
        'f', 1746,
        'h', 956,
        'i', 1382,
        'o', 1676,
        'r', 1293,
        's', 795,
      );
      END_STATE();
    case 478:
      if (lookahead == 'H') ADVANCE(750);
      END_STATE();
    case 479:
      if (lookahead == 'H') ADVANCE(750);
      if (lookahead == 'J') ADVANCE(750);
      if (lookahead == 'a') ADVANCE(1697);
      if (lookahead == 'c') ADVANCE(977);
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 's') ADVANCE(774);
      END_STATE();
    case 480:
      ADVANCE_MAP(
        'H', 750,
        'O', 499,
        'a', 820,
        'c', 608,
        'd', 1594,
        'e', 910,
        'f', 1746,
        'h', 1219,
        'i', 1793,
        'l', 1598,
        'o', 1438,
        'r', 1600,
        's', 774,
        'u', 1683,
      );
      END_STATE();
    case 481:
      ADVANCE_MAP(
        'H', 750,
        'a', 814,
        'c', 612,
        'd', 1594,
        'e', 1803,
        'f', 1746,
        'o', 1676,
        's', 774,
      );
      END_STATE();
    case 482:
      if (lookahead == 'H') ADVANCE(750);
      if (lookahead == 'c') ADVANCE(2135);
      END_STATE();
    case 483:
      if (lookahead == 'H') ADVANCE(2095);
      END_STATE();
    case 484:
      if (lookahead == 'I') ADVANCE(148);
      END_STATE();
    case 485:
      if (lookahead == 'I') ADVANCE(1494);
      END_STATE();
    case 486:
      if (lookahead == 'I') ADVANCE(1561);
      END_STATE();
    case 487:
      ADVANCE_MAP(
        'J', 750,
        'a', 814,
        'c', 609,
        'e', 1139,
        'f', 1746,
        'o', 424,
        's', 774,
        't', 1288,
        'u', 148,
      );
      END_STATE();
    case 488:
      if (lookahead == 'L') ADVANCE(968);
      END_STATE();
    case 489:
      if (lookahead == 'L') ADVANCE(1268);
      END_STATE();
    case 490:
      if (lookahead == 'L') ADVANCE(1066);
      if (lookahead == 'R') ADVANCE(1321);
      END_STATE();
    case 491:
      if (lookahead == 'L') ADVANCE(1066);
      if (lookahead == 'R') ADVANCE(1321);
      if (lookahead == 'l') ADVANCE(1048);
      if (lookahead == 'r') ADVANCE(1313);
      END_STATE();
    case 492:
      if (lookahead == 'L') ADVANCE(1070);
      if (lookahead == 'R') ADVANCE(1321);
      END_STATE();
    case 493:
      if (lookahead == 'M') ADVANCE(1052);
      if (lookahead == 'T') ADVANCE(1201);
      if (lookahead == 'V') ADVANCE(1040);
      END_STATE();
    case 494:
      if (lookahead == 'M') ADVANCE(1311);
      END_STATE();
    case 495:
      ADVANCE_MAP(
        'N', 1594,
        'a', 804,
        'b', 1789,
        'c', 1615,
        'd', 1735,
        'e', 869,
        'f', 1746,
        'i', 1119,
        'k', 674,
        'l', 555,
        'n', 934,
        'o', 1681,
        'p', 1816,
        'r', 932,
        's', 776,
        'u', 1401,
      );
      END_STATE();
    case 496:
      ADVANCE_MAP(
        'N', 472,
        'T', 177,
        'a', 808,
        'c', 611,
        'd', 1594,
        'f', 1746,
        'g', 1807,
        'l', 1053,
        'm', 540,
        'o', 1134,
        'p', 1950,
        'q', 2047,
        's', 784,
        't', 528,
        'u', 1460,
        'x', 1244,
      );
      END_STATE();
    case 497:
      if (lookahead == 'O') ADVANCE(185);
      END_STATE();
    case 498:
      if (lookahead == 'O') ADVANCE(504);
      END_STATE();
    case 499:
      if (lookahead == 'P') ADVANCE(187);
      END_STATE();
    case 500:
      if (lookahead == 'P') ADVANCE(542);
      END_STATE();
    case 501:
      if (lookahead == 'P') ADVANCE(542);
      if (lookahead == 'i') ADVANCE(364);
      END_STATE();
    case 502:
      if (lookahead == 'P') ADVANCE(1444);
      END_STATE();
    case 503:
      if (lookahead == 'Q') ADVANCE(2094);
      END_STATE();
    case 504:
      if (lookahead == 'R') ADVANCE(182);
      END_STATE();
    case 505:
      if (lookahead == 'R') ADVANCE(446);
      END_STATE();
    case 506:
      if (lookahead == 'R') ADVANCE(1324);
      if (lookahead == 'T') ADVANCE(1035);
      if (lookahead == 'V') ADVANCE(1063);
      END_STATE();
    case 507:
      ADVANCE_MAP(
        'S', 148,
        'a', 811,
        'c', 1266,
        'd', 576,
        'e', 1400,
        'f', 847,
        'g', 1626,
        'h', 723,
        'i', 1512,
        'l', 582,
        'm', 538,
        'o', 1676,
        'p', 543,
        'r', 200,
        's', 790,
        't', 1283,
        'u', 1460,
        'v', 721,
      );
      END_STATE();
    case 508:
      if (lookahead == 'S') ADVANCE(1498);
      END_STATE();
    case 509:
      if (lookahead == 'S') ADVANCE(1498);
      if (lookahead == 'V') ADVANCE(1038);
      END_STATE();
    case 510:
      if (lookahead == 'S') ADVANCE(1716);
      END_STATE();
    case 511:
      if (lookahead == 'S') ADVANCE(2057);
      END_STATE();
    case 512:
      if (lookahead == 'S') ADVANCE(1743);
      END_STATE();
    case 513:
      if (lookahead == 'T') ADVANCE(750);
      END_STATE();
    case 514:
      if (lookahead == 'T') ADVANCE(389);
      END_STATE();
    case 515:
      if (lookahead == 'T') ADVANCE(1215);
      END_STATE();
    case 516:
      if (lookahead == 'T') ADVANCE(1196);
      END_STATE();
    case 517:
      if (lookahead == 'T') ADVANCE(1035);
      if (lookahead == 'V') ADVANCE(1063);
      END_STATE();
    case 518:
      if (lookahead == 'T') ADVANCE(1897);
      END_STATE();
    case 519:
      if (lookahead == 'U') ADVANCE(497);
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 's') ADVANCE(774);
      END_STATE();
    case 520:
      if (lookahead == 'V') ADVANCE(1082);
      END_STATE();
    case 521:
      if (lookahead == 'V') ADVANCE(1068);
      END_STATE();
    case 522:
      if (lookahead == 'W') ADVANCE(1270);
      END_STATE();
    case 523:
      if (lookahead == '[') ADVANCE(2236);
      END_STATE();
    case 524:
      if (lookahead == '_') ADVANCE(524);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(2241);
      END_STATE();
    case 525:
      ADVANCE_MAP(
        'a', 808,
        'b', 1745,
        'c', 285,
        'e', 1394,
        'f', 326,
        'g', 1807,
        'l', 933,
        'm', 193,
        'n', 881,
        'o', 1134,
        'p', 198,
        'r', 1241,
        's', 793,
        't', 1288,
        'u', 1460,
        'w', 829,
      );
      END_STATE();
    case 526:
      ADVANCE_MAP(
        'a', 808,
        'c', 286,
        'e', 757,
        'f', 2163,
        'g', 1807,
        'i', 283,
        'j', 1400,
        'm', 534,
        'n', 235,
        'o', 754,
        'p', 1806,
        'q', 2062,
        's', 786,
        't', 291,
        'u', 1343,
      );
      END_STATE();
    case 527:
      ADVANCE_MAP(
        'a', 800,
        'c', 2135,
        'e', 835,
        'f', 1746,
        'o', 1676,
        'r', 931,
        's', 774,
        'u', 1471,
      );
      END_STATE();
    case 528:
      if (lookahead == 'a') ADVANCE(148);
      END_STATE();
    case 529:
      if (lookahead == 'a') ADVANCE(326);
      END_STATE();
    case 530:
      if (lookahead == 'a') ADVANCE(1735);
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(1465);
      if (lookahead == 'q') ADVANCE(715);
      if (lookahead == 't') ADVANCE(1817);
      END_STATE();
    case 531:
      if (lookahead == 'a') ADVANCE(1735);
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 'q') ADVANCE(715);
      END_STATE();
    case 532:
      ADVANCE_MAP(
        'a', 819,
        'c', 557,
        'd', 1594,
        'e', 903,
        'f', 1746,
        'h', 752,
        'i', 1750,
        'l', 2052,
        'o', 1448,
        'r', 588,
        's', 796,
        't', 872,
        'u', 920,
        'w', 829,
        'y', 1391,
      );
      END_STATE();
    case 533:
      if (lookahead == 'a') ADVANCE(2109);
      END_STATE();
    case 534:
      if (lookahead == 'a') ADVANCE(779);
      if (lookahead == 'o') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(921);
      END_STATE();
    case 535:
      if (lookahead == 'a') ADVANCE(1408);
      if (lookahead == 'e') ADVANCE(1721);
      if (lookahead == 'i') ADVANCE(879);
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 536:
      if (lookahead == 'a') ADVANCE(363);
      END_STATE();
    case 537:
      if (lookahead == 'a') ADVANCE(774);
      END_STATE();
    case 538:
      if (lookahead == 'a') ADVANCE(774);
      if (lookahead == 'e') ADVANCE(1127);
      if (lookahead == 'i') ADVANCE(841);
      END_STATE();
    case 539:
      if (lookahead == 'a') ADVANCE(774);
      if (lookahead == 'e') ADVANCE(1127);
      if (lookahead == 'i') ADVANCE(840);
      END_STATE();
    case 540:
      if (lookahead == 'a') ADVANCE(774);
      if (lookahead == 'p') ADVANCE(1981);
      END_STATE();
    case 541:
      if (lookahead == 'a') ADVANCE(774);
      if (lookahead == 'p') ADVANCE(1989);
      if (lookahead == 's') ADVANCE(1686);
      END_STATE();
    case 542:
      if (lookahead == 'a') ADVANCE(1746);
      END_STATE();
    case 543:
      if (lookahead == 'a') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1794);
      if (lookahead == 'l') ADVANCE(2061);
      END_STATE();
    case 544:
      if (lookahead == 'a') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(2061);
      END_STATE();
    case 545:
      if (lookahead == 'a') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(624);
      END_STATE();
    case 546:
      ADVANCE_MAP(
        'a', 810,
        'b', 1768,
        'c', 1266,
        'd', 748,
        'f', 1746,
        'g', 1807,
        'm', 537,
        'n', 891,
        'o', 1134,
        'p', 407,
        'r', 1256,
        's', 774,
        't', 1314,
        'u', 1460,
      );
      END_STATE();
    case 547:
      if (lookahead == 'a') ADVANCE(1512);
      END_STATE();
    case 548:
      if (lookahead == 'a') ADVANCE(354);
      END_STATE();
    case 549:
      ADVANCE_MAP(
        'a', 1871,
        'b', 1800,
        'c', 609,
        'd', 1594,
        'e', 1449,
        'f', 1746,
        'h', 963,
        'i', 1437,
        'o', 954,
        'p', 1816,
        'r', 661,
        's', 765,
        'w', 1223,
      );
      END_STATE();
    case 550:
      ADVANCE_MAP(
        'a', 1522,
        'b', 1800,
        'n', 1125,
        'o', 1722,
        'p', 544,
        't', 1300,
        'w', 592,
        'z', 265,
      );
      END_STATE();
    case 551:
      if (lookahead == 'a') ADVANCE(1522);
      if (lookahead == 'b') ADVANCE(1800);
      if (lookahead == 'p') ADVANCE(544);
      if (lookahead == 't') ADVANCE(1300);
      END_STATE();
    case 552:
      if (lookahead == 'a') ADVANCE(1954);
      END_STATE();
    case 553:
      if (lookahead == 'a') ADVANCE(1954);
      if (lookahead == 'l') ADVANCE(1248);
      if (lookahead == 't') ADVANCE(1528);
      END_STATE();
    case 554:
      if (lookahead == 'a') ADVANCE(863);
      if (lookahead == 'f') ADVANCE(1103);
      END_STATE();
    case 555:
      if (lookahead == 'a') ADVANCE(830);
      if (lookahead == 'k') ADVANCE(140);
      if (lookahead == 'o') ADVANCE(823);
      END_STATE();
    case 556:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 557:
      if (lookahead == 'a') ADVANCE(1698);
      if (lookahead == 'e') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(1813);
      if (lookahead == 'u') ADVANCE(1706);
      END_STATE();
    case 558:
      if (lookahead == 'a') ADVANCE(914);
      END_STATE();
    case 559:
      if (lookahead == 'a') ADVANCE(334);
      END_STATE();
    case 560:
      if (lookahead == 'a') ADVANCE(2107);
      END_STATE();
    case 561:
      if (lookahead == 'a') ADVANCE(770);
      if (lookahead == 'o') ADVANCE(2123);
      END_STATE();
    case 562:
      if (lookahead == 'a') ADVANCE(1674);
      if (lookahead == 'e') ADVANCE(917);
      if (lookahead == 'o') ADVANCE(1535);
      if (lookahead == 'u') ADVANCE(1673);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 563:
      if (lookahead == 'a') ADVANCE(342);
      END_STATE();
    case 564:
      ADVANCE_MAP(
        'a', 769,
        'c', 1287,
        'e', 305,
        'f', 1746,
        'i', 750,
        'o', 1676,
        's', 774,
        'u', 756,
      );
      END_STATE();
    case 565:
      ADVANCE_MAP(
        'a', 1796,
        'c', 2135,
        'f', 1746,
        'h', 1219,
        'i', 148,
        'l', 2056,
        'o', 1284,
        'r', 258,
        's', 783,
      );
      END_STATE();
    case 566:
      if (lookahead == 'a') ADVANCE(1697);
      END_STATE();
    case 567:
      if (lookahead == 'a') ADVANCE(1709);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'e') ADVANCE(1730);
      if (lookahead == 'l') ADVANCE(968);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 568:
      if (lookahead == 'a') ADVANCE(1673);
      END_STATE();
    case 569:
      ADVANCE_MAP(
        'a', 1673,
        'c', 2135,
        'e', 898,
        'f', 1746,
        'i', 1552,
        'o', 1676,
        's', 774,
        'u', 148,
      );
      END_STATE();
    case 570:
      if (lookahead == 'a') ADVANCE(1673);
      if (lookahead == 'i') ADVANCE(1813);
      if (lookahead == 'u') ADVANCE(1673);
      END_STATE();
    case 571:
      if (lookahead == 'a') ADVANCE(1673);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 572:
      if (lookahead == 'a') ADVANCE(1673);
      if (lookahead == 'u') ADVANCE(1673);
      END_STATE();
    case 573:
      if (lookahead == 'a') ADVANCE(1116);
      END_STATE();
    case 574:
      ADVANCE_MAP(
        'a', 1456,
        'c', 2135,
        'e', 1486,
        'f', 1281,
        'i', 1400,
        'j', 1400,
        'l', 553,
        'n', 1586,
        'o', 1677,
        'p', 664,
        'r', 561,
        's', 774,
      );
      END_STATE();
    case 575:
      if (lookahead == 'a') ADVANCE(1920);
      END_STATE();
    case 576:
      if (lookahead == 'a') ADVANCE(1920);
      if (lookahead == 'b') ADVANCE(1434);
      if (lookahead == 'i') ADVANCE(2104);
      if (lookahead == 'o') ADVANCE(1954);
      if (lookahead == 's') ADVANCE(1636);
      END_STATE();
    case 577:
      if (lookahead == 'a') ADVANCE(1335);
      END_STATE();
    case 578:
      if (lookahead == 'a') ADVANCE(1923);
      END_STATE();
    case 579:
      if (lookahead == 'a') ADVANCE(1765);
      END_STATE();
    case 580:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'b') ADVANCE(1800);
      if (lookahead == 'r') ADVANCE(614);
      END_STATE();
    case 581:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'b') ADVANCE(1434);
      if (lookahead == 'h') ADVANCE(542);
      END_STATE();
    case 582:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'c') ADVANCE(1230);
      if (lookahead == 'i') ADVANCE(1534);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 583:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'c') ADVANCE(1645);
      if (lookahead == 'h') ADVANCE(645);
      if (lookahead == 'm') ADVANCE(148);
      if (lookahead == 't') ADVANCE(1781);
      END_STATE();
    case 584:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'h') ADVANCE(542);
      END_STATE();
    case 585:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'h') ADVANCE(542);
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 586:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'm') ADVANCE(293);
      END_STATE();
    case 587:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'm') ADVANCE(1996);
      if (lookahead == 'o') ADVANCE(1338);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 'r') ADVANCE(721);
      END_STATE();
    case 588:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'o') ADVANCE(1925);
      END_STATE();
    case 589:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'r') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(675);
      END_STATE();
    case 590:
      if (lookahead == 'a') ADVANCE(1463);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'g') ADVANCE(657);
      if (lookahead == 's') ADVANCE(1263);
      if (lookahead == 'v') ADVANCE(284);
      END_STATE();
    case 591:
      if (lookahead == 'a') ADVANCE(2146);
      END_STATE();
    case 592:
      if (lookahead == 'a') ADVANCE(1910);
      if (lookahead == 'b') ADVANCE(542);
      END_STATE();
    case 593:
      if (lookahead == 'a') ADVANCE(1910);
      if (lookahead == 'c') ADVANCE(1285);
      if (lookahead == 'd') ADVANCE(575);
      if (lookahead == 'R' ||
          lookahead == 'S') ADVANCE(148);
      END_STATE();
    case 594:
      if (lookahead == 'a') ADVANCE(1533);
      END_STATE();
    case 595:
      if (lookahead == 'a') ADVANCE(1993);
      END_STATE();
    case 596:
      if (lookahead == 'a') ADVANCE(1354);
      END_STATE();
    case 597:
      ADVANCE_MAP(
        'a', 1752,
        'c', 2135,
        'e', 1753,
        'f', 1746,
        'h', 1233,
        'i', 348,
        'l', 613,
        'm', 148,
        'o', 1294,
        'r', 164,
        's', 783,
        'u', 1532,
      );
      END_STATE();
    case 598:
      if (lookahead == 'a') ADVANCE(1987);
      if (lookahead == 'e') ADVANCE(1934);
      if (lookahead == 'o') ADVANCE(342);
      END_STATE();
    case 599:
      if (lookahead == 'a') ADVANCE(1178);
      END_STATE();
    case 600:
      if (lookahead == 'a') ADVANCE(1352);
      END_STATE();
    case 601:
      if (lookahead == 'a') ADVANCE(1377);
      if (lookahead == 'l') ADVANCE(1268);
      if (lookahead == 's') ADVANCE(2081);
      END_STATE();
    case 602:
      if (lookahead == 'a') ADVANCE(1800);
      END_STATE();
    case 603:
      if (lookahead == 'a') ADVANCE(1913);
      END_STATE();
    case 604:
      if (lookahead == 'a') ADVANCE(1500);
      END_STATE();
    case 605:
      if (lookahead == 'a') ADVANCE(758);
      END_STATE();
    case 606:
      if (lookahead == 'a') ADVANCE(1534);
      END_STATE();
    case 607:
      if (lookahead == 'a') ADVANCE(1799);
      if (lookahead == 'e') ADVANCE(918);
      if (lookahead == 'u') ADVANCE(714);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 608:
      if (lookahead == 'a') ADVANCE(1799);
      if (lookahead == 'e') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(1813);
      if (lookahead == 'o') ADVANCE(1562);
      END_STATE();
    case 609:
      if (lookahead == 'a') ADVANCE(1799);
      if (lookahead == 'e') ADVANCE(917);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 610:
      if (lookahead == 'a') ADVANCE(1799);
      if (lookahead == 'i') ADVANCE(1776);
      if (lookahead == 'o') ADVANCE(1384);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 611:
      if (lookahead == 'a') ADVANCE(1799);
      if (lookahead == 'i') ADVANCE(1776);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 612:
      if (lookahead == 'a') ADVANCE(1799);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 613:
      if (lookahead == 'a') ADVANCE(1506);
      if (lookahead == 'u') ADVANCE(1904);
      END_STATE();
    case 614:
      if (lookahead == 'a') ADVANCE(772);
      if (lookahead == 'k') ADVANCE(926);
      END_STATE();
    case 615:
      if (lookahead == 'a') ADVANCE(1695);
      if (lookahead == 'u') ADVANCE(1695);
      END_STATE();
    case 616:
      if (lookahead == 'a') ADVANCE(883);
      END_STATE();
    case 617:
      if (lookahead == 'a') ADVANCE(1371);
      END_STATE();
    case 618:
      if (lookahead == 'a') ADVANCE(1371);
      if (lookahead == 'i') ADVANCE(1416);
      END_STATE();
    case 619:
      if (lookahead == 'a') ADVANCE(1755);
      END_STATE();
    case 620:
      if (lookahead == 'a') ADVANCE(1755);
      if (lookahead == 'b') ADVANCE(1385);
      END_STATE();
    case 621:
      if (lookahead == 'a') ADVANCE(1390);
      END_STATE();
    case 622:
      if (lookahead == 'a') ADVANCE(1390);
      if (lookahead == 'e') ADVANCE(1910);
      if (lookahead == 'i') ADVANCE(2106);
      END_STATE();
    case 623:
      if (lookahead == 'a') ADVANCE(1790);
      if (lookahead == 'l') ADVANCE(2061);
      if (lookahead == 's') ADVANCE(1226);
      END_STATE();
    case 624:
      if (lookahead == 'a') ADVANCE(773);
      END_STATE();
    case 625:
      if (lookahead == 'a') ADVANCE(1785);
      if (lookahead == 'b') ADVANCE(1385);
      END_STATE();
    case 626:
      if (lookahead == 'a') ADVANCE(1785);
      if (lookahead == 'o') ADVANCE(354);
      END_STATE();
    case 627:
      if (lookahead == 'a') ADVANCE(1717);
      END_STATE();
    case 628:
      if (lookahead == 'a') ADVANCE(858);
      END_STATE();
    case 629:
      if (lookahead == 'a') ADVANCE(1783);
      END_STATE();
    case 630:
      if (lookahead == 'a') ADVANCE(1383);
      END_STATE();
    case 631:
      if (lookahead == 'a') ADVANCE(1775);
      if (lookahead == 'o') ADVANCE(1450);
      if (lookahead == 'r') ADVANCE(233);
      END_STATE();
    case 632:
      if (lookahead == 'a') ADVANCE(1381);
      END_STATE();
    case 633:
      if (lookahead == 'a') ADVANCE(1770);
      if (lookahead == 'p') ADVANCE(1669);
      END_STATE();
    case 634:
      if (lookahead == 'a') ADVANCE(1756);
      if (lookahead == 'r') ADVANCE(705);
      END_STATE();
    case 635:
      if (lookahead == 'a') ADVANCE(1361);
      END_STATE();
    case 636:
      if (lookahead == 'a') ADVANCE(1769);
      END_STATE();
    case 637:
      if (lookahead == 'a') ADVANCE(1369);
      END_STATE();
    case 638:
      if (lookahead == 'a') ADVANCE(1356);
      END_STATE();
    case 639:
      if (lookahead == 'a') ADVANCE(1362);
      END_STATE();
    case 640:
      if (lookahead == 'a') ADVANCE(1357);
      END_STATE();
    case 641:
      if (lookahead == 'a') ADVANCE(1823);
      END_STATE();
    case 642:
      if (lookahead == 'a') ADVANCE(1375);
      END_STATE();
    case 643:
      if (lookahead == 'a') ADVANCE(1363);
      END_STATE();
    case 644:
      if (lookahead == 'a') ADVANCE(1744);
      END_STATE();
    case 645:
      if (lookahead == 'a') ADVANCE(1773);
      END_STATE();
    case 646:
      if (lookahead == 'a') ADVANCE(1749);
      END_STATE();
    case 647:
      if (lookahead == 'a') ADVANCE(1827);
      END_STATE();
    case 648:
      if (lookahead == 'a') ADVANCE(1771);
      END_STATE();
    case 649:
      if (lookahead == 'a') ADVANCE(2011);
      END_STATE();
    case 650:
      if (lookahead == 'a') ADVANCE(1838);
      END_STATE();
    case 651:
      if (lookahead == 'a') ADVANCE(1811);
      END_STATE();
    case 652:
      if (lookahead == 'a') ADVANCE(1802);
      END_STATE();
    case 653:
      if (lookahead == 'a') ADVANCE(1808);
      END_STATE();
    case 654:
      ADVANCE_MAP(
        'a', 814,
        'b', 1735,
        'c', 194,
        'd', 1623,
        'e', 401,
        'f', 1766,
        'h', 209,
        'i', 1155,
        'l', 579,
        'm', 535,
        'o', 1100,
        'p', 558,
        'q', 802,
        'r', 579,
        's', 777,
        't', 634,
        'u', 717,
        'w', 402,
        'z', 1394,
      );
      END_STATE();
    case 655:
      ADVANCE_MAP(
        'a', 814,
        'c', 612,
        'd', 1594,
        'e', 1059,
        'f', 1746,
        'h', 750,
        'i', 1149,
        'o', 1676,
        's', 774,
        'w', 1334,
      );
      END_STATE();
    case 656:
      if (lookahead == 'a') ADVANCE(1406);
      END_STATE();
    case 657:
      if (lookahead == 'a') ADVANCE(1475);
      END_STATE();
    case 658:
      if (lookahead == 'a') ADVANCE(1932);
      END_STATE();
    case 659:
      ADVANCE_MAP(
        'a', 1701,
        'c', 977,
        'f', 1746,
        'g', 1810,
        'h', 750,
        'j', 750,
        'o', 1676,
        's', 774,
      );
      END_STATE();
    case 660:
      if (lookahead == 'a') ADVANCE(852);
      END_STATE();
    case 661:
      if (lookahead == 'a') ADVANCE(899);
      if (lookahead == 'i') ADVANCE(706);
      if (lookahead == 'p') ADVANCE(961);
      END_STATE();
    case 662:
      if (lookahead == 'a') ADVANCE(1859);
      END_STATE();
    case 663:
      if (lookahead == 'a') ADVANCE(2008);
      END_STATE();
    case 664:
      if (lookahead == 'a') ADVANCE(1826);
      END_STATE();
    case 665:
      if (lookahead == 'a') ADVANCE(1708);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'e') ADVANCE(1731);
      if (lookahead == 'g') ADVANCE(1974);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 666:
      if (lookahead == 'a') ADVANCE(1708);
      if (lookahead == 'e') ADVANCE(1734);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 667:
      if (lookahead == 'a') ADVANCE(1708);
      if (lookahead == 's') ADVANCE(1251);
      END_STATE();
    case 668:
      if (lookahead == 'a') ADVANCE(838);
      END_STATE();
    case 669:
      if (lookahead == 'a') ADVANCE(1860);
      if (lookahead == 'l') ADVANCE(2137);
      if (lookahead == 'r') ADVANCE(930);
      if (lookahead == 'v') ADVANCE(1079);
      END_STATE();
    case 670:
      if (lookahead == 'a') ADVANCE(1545);
      END_STATE();
    case 671:
      if (lookahead == 'a') ADVANCE(1396);
      if (lookahead == 'k') ADVANCE(354);
      END_STATE();
    case 672:
      if (lookahead == 'a') ADVANCE(2018);
      END_STATE();
    case 673:
      if (lookahead == 'a') ADVANCE(1872);
      if (lookahead == 'l') ADVANCE(1411);
      if (lookahead == 'r') ADVANCE(822);
      END_STATE();
    case 674:
      if (lookahead == 'a') ADVANCE(1822);
      END_STATE();
    case 675:
      if (lookahead == 'a') ADVANCE(1259);
      END_STATE();
    case 676:
      if (lookahead == 'a') ADVANCE(1259);
      if (lookahead == 'i') ADVANCE(1596);
      END_STATE();
    case 677:
      if (lookahead == 'a') ADVANCE(2072);
      END_STATE();
    case 678:
      if (lookahead == 'a') ADVANCE(1418);
      END_STATE();
    case 679:
      if (lookahead == 'a') ADVANCE(1863);
      END_STATE();
    case 680:
      if (lookahead == 'a') ADVANCE(2074);
      END_STATE();
    case 681:
      if (lookahead == 'a') ADVANCE(2026);
      END_STATE();
    case 682:
      if (lookahead == 'a') ADVANCE(1546);
      END_STATE();
    case 683:
      if (lookahead == 'a') ADVANCE(1865);
      END_STATE();
    case 684:
      if (lookahead == 'a') ADVANCE(1403);
      END_STATE();
    case 685:
      if (lookahead == 'a') ADVANCE(1855);
      END_STATE();
    case 686:
      if (lookahead == 'a') ADVANCE(1814);
      END_STATE();
    case 687:
      if (lookahead == 'a') ADVANCE(1861);
      END_STATE();
    case 688:
      if (lookahead == 'a') ADVANCE(1862);
      END_STATE();
    case 689:
      if (lookahead == 'a') ADVANCE(1453);
      END_STATE();
    case 690:
      if (lookahead == 'a') ADVANCE(1877);
      END_STATE();
    case 691:
      if (lookahead == 'a') ADVANCE(1877);
      if (lookahead == 'd') ADVANCE(1655);
      if (lookahead == 'h') ADVANCE(647);
      if (lookahead == 'l') ADVANCE(2061);
      if (lookahead == 's') ADVANCE(1228);
      if (lookahead == 'u') ADVANCE(1727);
      END_STATE();
    case 692:
      if (lookahead == 'a') ADVANCE(1877);
      if (lookahead == 'd') ADVANCE(1671);
      if (lookahead == 'h') ADVANCE(647);
      END_STATE();
    case 693:
      if (lookahead == 'a') ADVANCE(1877);
      if (lookahead == 'r') ADVANCE(1313);
      END_STATE();
    case 694:
      if (lookahead == 'a') ADVANCE(1888);
      END_STATE();
    case 695:
      if (lookahead == 'a') ADVANCE(2034);
      END_STATE();
    case 696:
      if (lookahead == 'a') ADVANCE(1882);
      if (lookahead == 'h') ADVANCE(707);
      if (lookahead == 'l') ADVANCE(1071);
      if (lookahead == 'r') ADVANCE(1328);
      if (lookahead == 's') ADVANCE(1738);
      if (lookahead == 't') ADVANCE(1216);
      END_STATE();
    case 697:
      if (lookahead == 'a') ADVANCE(1882);
      if (lookahead == 'h') ADVANCE(707);
      if (lookahead == 'l') ADVANCE(1091);
      if (lookahead == 'r') ADVANCE(1322);
      if (lookahead == 't') ADVANCE(1216);
      END_STATE();
    case 698:
      if (lookahead == 'a') ADVANCE(2036);
      END_STATE();
    case 699:
      if (lookahead == 'a') ADVANCE(1883);
      END_STATE();
    case 700:
      if (lookahead == 'a') ADVANCE(1883);
      if (lookahead == 'd') ADVANCE(593);
      END_STATE();
    case 701:
      if (lookahead == 'a') ADVANCE(1884);
      END_STATE();
    case 702:
      if (lookahead == 'a') ADVANCE(1884);
      if (lookahead == 'h') ADVANCE(709);
      END_STATE();
    case 703:
      if (lookahead == 'a') ADVANCE(2038);
      END_STATE();
    case 704:
      if (lookahead == 'a') ADVANCE(1885);
      if (lookahead == 'h') ADVANCE(709);
      if (lookahead == 's') ADVANCE(1738);
      END_STATE();
    case 705:
      if (lookahead == 'a') ADVANCE(1318);
      if (lookahead == 'n') ADVANCE(1899);
      END_STATE();
    case 706:
      if (lookahead == 'a') ADVANCE(1567);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'm') ADVANCE(1311);
      if (lookahead == 'p') ADVANCE(1444);
      if (lookahead == 's') ADVANCE(714);
      if (lookahead == 't') ADVANCE(1296);
      END_STATE();
    case 707:
      if (lookahead == 'a') ADVANCE(1890);
      END_STATE();
    case 708:
      if (lookahead == 'a') ADVANCE(1574);
      END_STATE();
    case 709:
      if (lookahead == 'a') ADVANCE(1892);
      END_STATE();
    case 710:
      if (lookahead == 'a') ADVANCE(1575);
      END_STATE();
    case 711:
      if (lookahead == 'a') ADVANCE(1577);
      END_STATE();
    case 712:
      if (lookahead == 'a') ADVANCE(1578);
      END_STATE();
    case 713:
      if (lookahead == 'a') ADVANCE(1579);
      END_STATE();
    case 714:
      if (lookahead == 'b') ADVANCE(148);
      END_STATE();
    case 715:
      if (lookahead == 'b') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(1585);
      END_STATE();
    case 716:
      if (lookahead == 'b') ADVANCE(339);
      if (lookahead == 'c') ADVANCE(860);
      if (lookahead == 'm') ADVANCE(148);
      if (lookahead == 'p') ADVANCE(266);
      END_STATE();
    case 717:
      if (lookahead == 'b') ADVANCE(165);
      if (lookahead == 'c') ADVANCE(771);
      if (lookahead == 'm') ADVANCE(148);
      if (lookahead == 'n') ADVANCE(1116);
      if (lookahead == 'p') ADVANCE(241);
      END_STATE();
    case 718:
      if (lookahead == 'b') ADVANCE(340);
      if (lookahead == 'c') ADVANCE(827);
      if (lookahead == 'p') ADVANCE(340);
      END_STATE();
    case 719:
      if (lookahead == 'b') ADVANCE(239);
      END_STATE();
    case 720:
      if (lookahead == 'b') ADVANCE(248);
      if (lookahead == 'p') ADVANCE(248);
      END_STATE();
    case 721:
      if (lookahead == 'b') ADVANCE(542);
      END_STATE();
    case 722:
      if (lookahead == 'b') ADVANCE(542);
      if (lookahead == 'g') ADVANCE(965);
      END_STATE();
    case 723:
      if (lookahead == 'b') ADVANCE(542);
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 724:
      if (lookahead == 'b') ADVANCE(542);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 725:
      if (lookahead == 'b') ADVANCE(542);
      if (lookahead == 't') ADVANCE(289);
      if (lookahead == 'y') ADVANCE(515);
      END_STATE();
    case 726:
      if (lookahead == 'b') ADVANCE(1350);
      if (lookahead == 'c') ADVANCE(1644);
      END_STATE();
    case 727:
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'p') ADVANCE(246);
      END_STATE();
    case 728:
      if (lookahead == 'b') ADVANCE(2090);
      if (lookahead == 'p') ADVANCE(1211);
      END_STATE();
    case 729:
      if (lookahead == 'b') ADVANCE(887);
      END_STATE();
    case 730:
      if (lookahead == 'b') ADVANCE(1800);
      END_STATE();
    case 731:
      if (lookahead == 'b') ADVANCE(922);
      if (lookahead == 'p') ADVANCE(922);
      END_STATE();
    case 732:
      if (lookahead == 'b') ADVANCE(1364);
      if (lookahead == 'c') ADVANCE(2091);
      if (lookahead == 'n') ADVANCE(1116);
      if (lookahead == 'p') ADVANCE(168);
      if (lookahead == 't') ADVANCE(2080);
      END_STATE();
    case 733:
      if (lookahead == 'b') ADVANCE(1905);
      END_STATE();
    case 734:
      if (lookahead == 'b') ADVANCE(529);
      END_STATE();
    case 735:
      if (lookahead == 'b') ADVANCE(1074);
      END_STATE();
    case 736:
      if (lookahead == 'b') ADVANCE(1507);
      if (lookahead == 'p') ADVANCE(1507);
      END_STATE();
    case 737:
      if (lookahead == 'b') ADVANCE(1949);
      if (lookahead == 'c') ADVANCE(859);
      if (lookahead == 'p') ADVANCE(1026);
      END_STATE();
    case 738:
      if (lookahead == 'b') ADVANCE(1949);
      if (lookahead == 'p') ADVANCE(1026);
      END_STATE();
    case 739:
      if (lookahead == 'b') ADVANCE(1420);
      END_STATE();
    case 740:
      if (lookahead == 'b') ADVANCE(1423);
      END_STATE();
    case 741:
      if (lookahead == 'b') ADVANCE(1866);
      END_STATE();
    case 742:
      if (lookahead == 'b') ADVANCE(1426);
      END_STATE();
    case 743:
      if (lookahead == 'b') ADVANCE(1427);
      END_STATE();
    case 744:
      if (lookahead == 'b') ADVANCE(1441);
      END_STATE();
    case 745:
      if (lookahead == 'b') ADVANCE(653);
      END_STATE();
    case 746:
      if (lookahead == 'b') ADVANCE(1432);
      END_STATE();
    case 747:
      if (lookahead == 'b') ADVANCE(1433);
      END_STATE();
    case 748:
      if (lookahead == 'b') ADVANCE(1434);
      END_STATE();
    case 749:
      if (lookahead == 'b') ADVANCE(1952);
      if (lookahead == 'p') ADVANCE(1952);
      END_STATE();
    case 750:
      if (lookahead == 'c') ADVANCE(2135);
      END_STATE();
    case 751:
      if (lookahead == 'c') ADVANCE(2135);
      if (lookahead == 'e') ADVANCE(2109);
      END_STATE();
    case 752:
      if (lookahead == 'c') ADVANCE(2135);
      if (lookahead == 'e') ADVANCE(832);
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 753:
      if (lookahead == 'c') ADVANCE(2135);
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1445);
      if (lookahead == 'o') ADVANCE(1678);
      if (lookahead == 's') ADVANCE(774);
      END_STATE();
    case 754:
      if (lookahead == 'c') ADVANCE(2135);
      if (lookahead == 'g') ADVANCE(1625);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 755:
      if (lookahead == 'c') ADVANCE(2135);
      if (lookahead == 'i') ADVANCE(1149);
      END_STATE();
    case 756:
      if (lookahead == 'c') ADVANCE(2135);
      if (lookahead == 'm') ADVANCE(293);
      END_STATE();
    case 757:
      if (lookahead == 'c') ADVANCE(2135);
      if (lookahead == 'x') ADVANCE(761);
      END_STATE();
    case 758:
      if (lookahead == 'c') ADVANCE(148);
      END_STATE();
    case 759:
      if (lookahead == 'c') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(1746);
      END_STATE();
    case 760:
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'l') ADVANCE(927);
      if (lookahead == 'p') ADVANCE(337);
      if (lookahead == 'r') ADVANCE(1347);
      END_STATE();
    case 761:
      if (lookahead == 'c') ADVANCE(293);
      END_STATE();
    case 762:
      ADVANCE_MAP(
        'c', 570,
        'd', 2012,
        'f', 1746,
        'h', 399,
        'i', 148,
        'l', 399,
        'm', 568,
        'n', 1255,
        'o', 874,
        'r', 399,
        's', 791,
        'u', 1705,
        'v', 999,
        'w', 962,
      );
      END_STATE();
    case 763:
      if (lookahead == 'c') ADVANCE(570);
      if (lookahead == 'o') ADVANCE(875);
      if (lookahead == 's') ADVANCE(1740);
      if (lookahead == 't') ADVANCE(1896);
      if (lookahead == 'u') ADVANCE(1704);
      if (lookahead == 'v') ADVANCE(999);
      if (lookahead == 'w') ADVANCE(962);
      END_STATE();
    case 764:
      if (lookahead == 'c') ADVANCE(1644);
      END_STATE();
    case 765:
      if (lookahead == 'c') ADVANCE(2166);
      if (lookahead == 'h') ADVANCE(750);
      if (lookahead == 't') ADVANCE(1817);
      END_STATE();
    case 766:
      if (lookahead == 'c') ADVANCE(2166);
      if (lookahead == 'o') ADVANCE(1354);
      if (lookahead == 't') ADVANCE(1817);
      END_STATE();
    case 767:
      if (lookahead == 'c') ADVANCE(234);
      if (lookahead == 'h') ADVANCE(1662);
      if (lookahead == 'i') ADVANCE(1476);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'p') ADVANCE(542);
      if (lookahead == 'q') ADVANCE(1933);
      if (lookahead == 'u') ADVANCE(718);
      END_STATE();
    case 768:
      if (lookahead == 'c') ADVANCE(928);
      if (lookahead == 'd') ADVANCE(1265);
      if (lookahead == 'e') ADVANCE(1477);
      if (lookahead == 'n') ADVANCE(1126);
      if (lookahead == 'q') ADVANCE(2050);
      if (lookahead == 'r') ADVANCE(1759);
      if (lookahead == 't') ADVANCE(676);
      END_STATE();
    case 769:
      if (lookahead == 'c') ADVANCE(2059);
      END_STATE();
    case 770:
      if (lookahead == 'c') ADVANCE(142);
      if (lookahead == 's') ADVANCE(1354);
      END_STATE();
    case 771:
      if (lookahead == 'c') ADVANCE(212);
      END_STATE();
    case 772:
      if (lookahead == 'c') ADVANCE(2161);
      END_STATE();
    case 773:
      if (lookahead == 'c') ADVANCE(923);
      END_STATE();
    case 774:
      if (lookahead == 'c') ADVANCE(1746);
      END_STATE();
    case 775:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'i') ADVANCE(1459);
      END_STATE();
    case 776:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1468);
      if (lookahead == 'i') ADVANCE(1469);
      if (lookahead == 'o') ADVANCE(1358);
      END_STATE();
    case 777:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(2002);
      if (lookahead == 'm') ADVANCE(1308);
      if (lookahead == 't') ADVANCE(646);
      END_STATE();
    case 778:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1779);
      END_STATE();
    case 779:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 't') ADVANCE(1179);
      END_STATE();
    case 780:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(1278);
      END_STATE();
    case 781:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 782:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 't') ADVANCE(1817);
      END_STATE();
    case 783:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 784:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1459);
      END_STATE();
    case 785:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1464);
      END_STATE();
    case 786:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1505);
      END_STATE();
    case 787:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(575);
      if (lookahead == 't') ADVANCE(1817);
      END_STATE();
    case 788:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1116);
      END_STATE();
    case 789:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(603);
      END_STATE();
    case 790:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(603);
      if (lookahead == 'o') ADVANCE(1354);
      END_STATE();
    case 791:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'q') ADVANCE(843);
      END_STATE();
    case 792:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1261);
      END_STATE();
    case 793:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == 'y') ADVANCE(1484);
      END_STATE();
    case 794:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1714);
      END_STATE();
    case 795:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1817);
      END_STATE();
    case 796:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(727);
      END_STATE();
    case 797:
      if (lookahead == 'c') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(736);
      END_STATE();
    case 798:
      if (lookahead == 'c') ADVANCE(528);
      if (lookahead == 'l') ADVANCE(908);
      if (lookahead == 'q') ADVANCE(2070);
      if (lookahead == 's') ADVANCE(1179);
      END_STATE();
    case 799:
      if (lookahead == 'c') ADVANCE(528);
      if (lookahead == 'q') ADVANCE(2070);
      if (lookahead == 'r') ADVANCE(909);
      if (lookahead == 's') ADVANCE(1179);
      END_STATE();
    case 800:
      if (lookahead == 'c') ADVANCE(1346);
      if (lookahead == 'r') ADVANCE(2105);
      END_STATE();
    case 801:
      if (lookahead == 'c') ADVANCE(1512);
      if (lookahead == 'i') ADVANCE(1583);
      if (lookahead == 'm') ADVANCE(1259);
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 't') ADVANCE(1015);
      END_STATE();
    case 802:
      if (lookahead == 'c') ADVANCE(615);
      if (lookahead == 's') ADVANCE(2051);
      if (lookahead == 'u') ADVANCE(211);
      END_STATE();
    case 803:
      if (lookahead == 'c') ADVANCE(1954);
      END_STATE();
    case 804:
      if (lookahead == 'c') ADVANCE(1337);
      if (lookahead == 'r') ADVANCE(2108);
      END_STATE();
    case 805:
      if (lookahead == 'c') ADVANCE(1286);
      if (lookahead == 's') ADVANCE(1253);
      if (lookahead == 'u') ADVANCE(622);
      if (lookahead == 'v') ADVANCE(1721);
      END_STATE();
    case 806:
      if (lookahead == 'c') ADVANCE(1285);
      if (lookahead == 'e') ADVANCE(882);
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(262);
      if (lookahead == 's') ADVANCE(774);
      END_STATE();
    case 807:
      if (lookahead == 'c') ADVANCE(1285);
      if (lookahead == 'e') ADVANCE(911);
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 's') ADVANCE(774);
      END_STATE();
    case 808:
      if (lookahead == 'c') ADVANCE(2058);
      END_STATE();
    case 809:
      if (lookahead == 'c') ADVANCE(2058);
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 810:
      if (lookahead == 'c') ADVANCE(2058);
      if (lookahead == 'r') ADVANCE(1782);
      END_STATE();
    case 811:
      if (lookahead == 'c') ADVANCE(2058);
      if (lookahead == 's') ADVANCE(1954);
      END_STATE();
    case 812:
      if (lookahead == 'c') ADVANCE(2058);
      if (lookahead == 's') ADVANCE(2008);
      END_STATE();
    case 813:
      if (lookahead == 'c') ADVANCE(1673);
      if (lookahead == 'd') ADVANCE(1746);
      END_STATE();
    case 814:
      if (lookahead == 'c') ADVANCE(2091);
      END_STATE();
    case 815:
      ADVANCE_MAP(
        'c', 2091,
        'e', 1477,
        'g', 1864,
        'm', 729,
        'n', 1124,
        'p', 148,
        'q', 2050,
        'r', 1757,
        't', 213,
      );
      END_STATE();
    case 816:
      if (lookahead == 'c') ADVANCE(2091);
      if (lookahead == 'm') ADVANCE(729);
      if (lookahead == 'n') ADVANCE(1116);
      if (lookahead == 'p') ADVANCE(1443);
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 817:
      if (lookahead == 'c') ADVANCE(2091);
      if (lookahead == 'm') ADVANCE(1487);
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 818:
      if (lookahead == 'c') ADVANCE(2091);
      if (lookahead == 'n') ADVANCE(1116);
      if (lookahead == 'r') ADVANCE(1792);
      END_STATE();
    case 819:
      if (lookahead == 'c') ADVANCE(2091);
      if (lookahead == 'p') ADVANCE(206);
      if (lookahead == 'r') ADVANCE(958);
      END_STATE();
    case 820:
      if (lookahead == 'c') ADVANCE(2091);
      if (lookahead == 'p') ADVANCE(288);
      if (lookahead == 'y') ADVANCE(1404);
      END_STATE();
    case 821:
      if (lookahead == 'c') ADVANCE(985);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 822:
      if (lookahead == 'c') ADVANCE(1625);
      END_STATE();
    case 823:
      if (lookahead == 'c') ADVANCE(1335);
      END_STATE();
    case 824:
      if (lookahead == 'c') ADVANCE(1344);
      END_STATE();
    case 825:
      if (lookahead == 'c') ADVANCE(1344);
      if (lookahead == 's') ADVANCE(959);
      END_STATE();
    case 826:
      if (lookahead == 'c') ADVANCE(1336);
      if (lookahead == 'n') ADVANCE(510);
      END_STATE();
    case 827:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 828:
      if (lookahead == 'c') ADVANCE(1212);
      END_STATE();
    case 829:
      if (lookahead == 'c') ADVANCE(1605);
      if (lookahead == 'i') ADVANCE(1512);
      END_STATE();
    case 830:
      if (lookahead == 'c') ADVANCE(1339);
      if (lookahead == 'n') ADVANCE(1335);
      END_STATE();
    case 831:
      if (lookahead == 'c') ADVANCE(568);
      END_STATE();
    case 832:
      if (lookahead == 'c') ADVANCE(1340);
      END_STATE();
    case 833:
      if (lookahead == 'c') ADVANCE(1354);
      if (lookahead == 'i') ADVANCE(1910);
      if (lookahead == 'p') ADVANCE(1054);
      END_STATE();
    case 834:
      if (lookahead == 'c') ADVANCE(1349);
      if (lookahead == 'n') ADVANCE(1919);
      END_STATE();
    case 835:
      if (lookahead == 'c') ADVANCE(677);
      if (lookahead == 'r') ADVANCE(1537);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 836:
      if (lookahead == 'c') ADVANCE(1341);
      if (lookahead == 'k') ADVANCE(2104);
      END_STATE();
    case 837:
      if (lookahead == 'c') ADVANCE(758);
      END_STATE();
    case 838:
      if (lookahead == 'c') ADVANCE(922);
      END_STATE();
    case 839:
      if (lookahead == 'c') ADVANCE(1193);
      END_STATE();
    case 840:
      if (lookahead == 'c') ADVANCE(1799);
      END_STATE();
    case 841:
      if (lookahead == 'c') ADVANCE(1799);
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'n') ADVANCE(2061);
      END_STATE();
    case 842:
      if (lookahead == 'c') ADVANCE(1919);
      END_STATE();
    case 843:
      if (lookahead == 'c') ADVANCE(2054);
      END_STATE();
    case 844:
      if (lookahead == 'c') ADVANCE(1953);
      END_STATE();
    case 845:
      if (lookahead == 'c') ADVANCE(596);
      END_STATE();
    case 846:
      if (lookahead == 'c') ADVANCE(1229);
      END_STATE();
    case 847:
      if (lookahead == 'c') ADVANCE(1229);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 848:
      if (lookahead == 'c') ADVANCE(1062);
      END_STATE();
    case 849:
      if (lookahead == 'c') ADVANCE(1788);
      if (lookahead == 'd') ADVANCE(202);
      if (lookahead == 'n') ADVANCE(2069);
      END_STATE();
    case 850:
      if (lookahead == 'c') ADVANCE(2040);
      END_STATE();
    case 851:
      if (lookahead == 'c') ADVANCE(2027);
      END_STATE();
    case 852:
      if (lookahead == 'c') ADVANCE(1058);
      END_STATE();
    case 853:
      if (lookahead == 'c') ADVANCE(2011);
      END_STATE();
    case 854:
      if (lookahead == 'c') ADVANCE(1287);
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'm') ADVANCE(595);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 's') ADVANCE(778);
      if (lookahead == 'u') ADVANCE(1342);
      END_STATE();
    case 855:
      if (lookahead == 'c') ADVANCE(1287);
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 's') ADVANCE(778);
      if (lookahead == 'u') ADVANCE(1342);
      END_STATE();
    case 856:
      if (lookahead == 'c') ADVANCE(1646);
      if (lookahead == 'i') ADVANCE(1521);
      if (lookahead == 't') ADVANCE(1781);
      END_STATE();
    case 857:
      if (lookahead == 'c') ADVANCE(1646);
      if (lookahead == 't') ADVANCE(1781);
      END_STATE();
    case 858:
      if (lookahead == 'c') ADVANCE(1348);
      END_STATE();
    case 859:
      if (lookahead == 'c') ADVANCE(1028);
      END_STATE();
    case 860:
      if (lookahead == 'c') ADVANCE(1028);
      if (lookahead == 'h') ADVANCE(516);
      END_STATE();
    case 861:
      if (lookahead == 'c') ADVANCE(635);
      END_STATE();
    case 862:
      if (lookahead == 'c') ADVANCE(1419);
      END_STATE();
    case 863:
      if (lookahead == 'c') ADVANCE(1843);
      if (lookahead == 'm') ADVANCE(1631);
      END_STATE();
    case 864:
      if (lookahead == 'c') ADVANCE(639);
      END_STATE();
    case 865:
      if (lookahead == 'c') ADVANCE(2026);
      END_STATE();
    case 866:
      if (lookahead == 'c') ADVANCE(1614);
      if (lookahead == 'e') ADVANCE(1672);
      if (lookahead == 'p') ADVANCE(1816);
      if (lookahead == 's') ADVANCE(1271);
      END_STATE();
    case 867:
      if (lookahead == 'c') ADVANCE(1403);
      END_STATE();
    case 868:
      if (lookahead == 'c') ADVANCE(642);
      END_STATE();
    case 869:
      if (lookahead == 'c') ADVANCE(680);
      if (lookahead == 'm') ADVANCE(1707);
      if (lookahead == 'p') ADVANCE(1914);
      if (lookahead == 'r') ADVANCE(1560);
      if (lookahead == 't') ADVANCE(2122);
      END_STATE();
    case 870:
      if (lookahead == 'c') ADVANCE(687);
      END_STATE();
    case 871:
      if (lookahead == 'c') ADVANCE(1086);
      END_STATE();
    case 872:
      if (lookahead == 'd') ADVANCE(1594);
      END_STATE();
    case 873:
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'i') ADVANCE(1436);
      if (lookahead == 'r') ADVANCE(1225);
      END_STATE();
    case 874:
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'p') ADVANCE(1093);
      if (lookahead == 't') ADVANCE(1296);
      END_STATE();
    case 875:
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'p') ADVANCE(1444);
      if (lookahead == 't') ADVANCE(1300);
      END_STATE();
    case 876:
      if (lookahead == 'd') ADVANCE(1594);
      if (lookahead == 'r') ADVANCE(1225);
      END_STATE();
    case 877:
      if (lookahead == 'd') ADVANCE(148);
      END_STATE();
    case 878:
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(601);
      if (lookahead == 'p') ADVANCE(344);
      END_STATE();
    case 879:
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(922);
      END_STATE();
    case 880:
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(293);
      END_STATE();
    case 881:
      if (lookahead == 'd') ADVANCE(207);
      if (lookahead == 'g') ADVANCE(247);
      END_STATE();
    case 882:
      if (lookahead == 'd') ADVANCE(722);
      if (lookahead == 'i') ADVANCE(1017);
      END_STATE();
    case 883:
      if (lookahead == 'd') ADVANCE(1440);
      END_STATE();
    case 884:
      if (lookahead == 'd') ADVANCE(509);
      END_STATE();
    case 885:
      if (lookahead == 'd') ADVANCE(485);
      END_STATE();
    case 886:
      if (lookahead == 'd') ADVANCE(475);
      END_STATE();
    case 887:
      if (lookahead == 'd') ADVANCE(528);
      END_STATE();
    case 888:
      if (lookahead == 'd') ADVANCE(750);
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 889:
      if (lookahead == 'd') ADVANCE(279);
      END_STATE();
    case 890:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 891:
      if (lookahead == 'd') ADVANCE(1001);
      if (lookahead == 'i') ADVANCE(1629);
      END_STATE();
    case 892:
      if (lookahead == 'd') ADVANCE(246);
      END_STATE();
    case 893:
      if (lookahead == 'd') ADVANCE(575);
      END_STATE();
    case 894:
      if (lookahead == 'd') ADVANCE(594);
      END_STATE();
    case 895:
      if (lookahead == 'd') ADVANCE(341);
      END_STATE();
    case 896:
      if (lookahead == 'd') ADVANCE(259);
      END_STATE();
    case 897:
      if (lookahead == 'd') ADVANCE(1262);
      END_STATE();
    case 898:
      if (lookahead == 'd') ADVANCE(1262);
      if (lookahead == 'l') ADVANCE(1452);
      END_STATE();
    case 899:
      if (lookahead == 'd') ADVANCE(922);
      END_STATE();
    case 900:
      if (lookahead == 'd') ADVANCE(2066);
      END_STATE();
    case 901:
      if (lookahead == 'd') ADVANCE(2066);
      if (lookahead == 'p') ADVANCE(1668);
      END_STATE();
    case 902:
      if (lookahead == 'd') ADVANCE(1220);
      END_STATE();
    case 903:
      if (lookahead == 'd') ADVANCE(1220);
      if (lookahead == 'm') ADVANCE(1707);
      if (lookahead == 'n') ADVANCE(345);
      END_STATE();
    case 904:
      if (lookahead == 'd') ADVANCE(1945);
      if (lookahead == 'u') ADVANCE(1189);
      END_STATE();
    case 905:
      if (lookahead == 'd') ADVANCE(936);
      END_STATE();
    case 906:
      if (lookahead == 'd') ADVANCE(1908);
      END_STATE();
    case 907:
      if (lookahead == 'd') ADVANCE(2001);
      END_STATE();
    case 908:
      if (lookahead == 'd') ADVANCE(1189);
      END_STATE();
    case 909:
      if (lookahead == 'd') ADVANCE(1189);
      if (lookahead == 'u') ADVANCE(1945);
      END_STATE();
    case 910:
      if (lookahead == 'd') ADVANCE(1295);
      if (lookahead == 'n') ADVANCE(2030);
      END_STATE();
    case 911:
      if (lookahead == 'd') ADVANCE(1141);
      END_STATE();
    case 912:
      if (lookahead == 'd') ADVANCE(1587);
      if (lookahead == 'u') ADVANCE(1673);
      END_STATE();
    case 913:
      if (lookahead == 'd') ADVANCE(1006);
      if (lookahead == 'p') ADVANCE(1092);
      END_STATE();
    case 914:
      if (lookahead == 'd') ADVANCE(1002);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 915:
      if (lookahead == 'd') ADVANCE(1019);
      END_STATE();
    case 916:
      if (lookahead == 'd') ADVANCE(1610);
      END_STATE();
    case 917:
      if (lookahead == 'd') ADVANCE(1259);
      END_STATE();
    case 918:
      if (lookahead == 'd') ADVANCE(1259);
      if (lookahead == 'i') ADVANCE(1354);
      END_STATE();
    case 919:
      if (lookahead == 'd') ADVANCE(1021);
      END_STATE();
    case 920:
      if (lookahead == 'd') ADVANCE(641);
      if (lookahead == 'e') ADVANCE(1689);
      if (lookahead == 'l') ADVANCE(662);
      if (lookahead == 'p') ADVANCE(222);
      if (lookahead == 'r') ADVANCE(669);
      if (lookahead == 'v') ADVANCE(999);
      if (lookahead == 'w') ADVANCE(921);
      END_STATE();
    case 921:
      if (lookahead == 'e') ADVANCE(877);
      END_STATE();
    case 922:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 923:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'k') ADVANCE(957);
      END_STATE();
    case 924:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(1268);
      if (lookahead == 'p') ADVANCE(648);
      END_STATE();
    case 925:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(725);
      END_STATE();
    case 926:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1360);
      END_STATE();
    case 927:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 928:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(2003);
      END_STATE();
    case 929:
      if (lookahead == 'e') ADVANCE(435);
      END_STATE();
    case 930:
      if (lookahead == 'e') ADVANCE(305);
      END_STATE();
    case 931:
      if (lookahead == 'e') ADVANCE(2109);
      END_STATE();
    case 932:
      if (lookahead == 'e') ADVANCE(2109);
      if (lookahead == 'v') ADVANCE(734);
      END_STATE();
    case 933:
      if (lookahead == 'e') ADVANCE(1101);
      if (lookahead == 'p') ADVANCE(1182);
      END_STATE();
    case 934:
      if (lookahead == 'e') ADVANCE(325);
      if (lookahead == 'o') ADVANCE(1954);
      END_STATE();
    case 935:
      if (lookahead == 'e') ADVANCE(221);
      if (lookahead == 'l') ADVANCE(1411);
      if (lookahead == 'r') ADVANCE(724);
      END_STATE();
    case 936:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 937:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 938:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 939:
      if (lookahead == 'e') ADVANCE(436);
      END_STATE();
    case 940:
      if (lookahead == 'e') ADVANCE(434);
      END_STATE();
    case 941:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 942:
      if (lookahead == 'e') ADVANCE(700);
      END_STATE();
    case 943:
      if (lookahead == 'e') ADVANCE(1490);
      END_STATE();
    case 944:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 945:
      if (lookahead == 'e') ADVANCE(462);
      END_STATE();
    case 946:
      if (lookahead == 'e') ADVANCE(493);
      END_STATE();
    case 947:
      if (lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 948:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 949:
      if (lookahead == 'e') ADVANCE(521);
      END_STATE();
    case 950:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 951:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 952:
      if (lookahead == 'e') ADVANCE(503);
      END_STATE();
    case 953:
      if (lookahead == 'e') ADVANCE(1746);
      END_STATE();
    case 954:
      if (lookahead == 'e') ADVANCE(528);
      if (lookahead == 'p') ADVANCE(215);
      if (lookahead == 's') ADVANCE(528);
      END_STATE();
    case 955:
      if (lookahead == 'e') ADVANCE(1512);
      END_STATE();
    case 956:
      if (lookahead == 'e') ADVANCE(1832);
      if (lookahead == 'i') ADVANCE(826);
      END_STATE();
    case 957:
      if (lookahead == 'e') ADVANCE(1954);
      END_STATE();
    case 958:
      if (lookahead == 'e') ADVANCE(1954);
      if (lookahead == 'o') ADVANCE(1500);
      END_STATE();
    case 959:
      if (lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 960:
      if (lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 961:
      if (lookahead == 'e') ADVANCE(2151);
      END_STATE();
    case 962:
      if (lookahead == 'e') ADVANCE(911);
      END_STATE();
    case 963:
      if (lookahead == 'e') ADVANCE(1848);
      if (lookahead == 'i') ADVANCE(834);
      if (lookahead == 'k') ADVANCE(571);
      if (lookahead == 'o') ADVANCE(1748);
      END_STATE();
    case 964:
      if (lookahead == 'e') ADVANCE(1102);
      END_STATE();
    case 965:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 966:
      if (lookahead == 'e') ADVANCE(464);
      END_STATE();
    case 967:
      if (lookahead == 'e') ADVANCE(511);
      END_STATE();
    case 968:
      if (lookahead == 'e') ADVANCE(1925);
      END_STATE();
    case 969:
      if (lookahead == 'e') ADVANCE(1728);
      END_STATE();
    case 970:
      if (lookahead == 'e') ADVANCE(912);
      END_STATE();
    case 971:
      if (lookahead == 'e') ADVANCE(542);
      END_STATE();
    case 972:
      if (lookahead == 'e') ADVANCE(542);
      if (lookahead == 'i') ADVANCE(1459);
      END_STATE();
    case 973:
      if (lookahead == 'e') ADVANCE(453);
      END_STATE();
    case 974:
      if (lookahead == 'e') ADVANCE(1106);
      END_STATE();
    case 975:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 976:
      if (lookahead == 'e') ADVANCE(917);
      if (lookahead == 'i') ADVANCE(1813);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 977:
      if (lookahead == 'e') ADVANCE(917);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 978:
      if (lookahead == 'e') ADVANCE(2147);
      END_STATE();
    case 979:
      if (lookahead == 'e') ADVANCE(408);
      END_STATE();
    case 980:
      if (lookahead == 'e') ADVANCE(1732);
      if (lookahead == 'v') ADVANCE(999);
      if (lookahead == 'w') ADVANCE(962);
      END_STATE();
    case 981:
      if (lookahead == 'e') ADVANCE(433);
      END_STATE();
    case 982:
      if (lookahead == 'e') ADVANCE(1097);
      END_STATE();
    case 983:
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 984:
      if (lookahead == 'e') ADVANCE(1734);
      END_STATE();
    case 985:
      if (lookahead == 'e') ADVANCE(1335);
      END_STATE();
    case 986:
      if (lookahead == 'e') ADVANCE(1513);
      END_STATE();
    case 987:
      if (lookahead == 'e') ADVANCE(1733);
      END_STATE();
    case 988:
      if (lookahead == 'e') ADVANCE(1975);
      END_STATE();
    case 989:
      if (lookahead == 'e') ADVANCE(1899);
      END_STATE();
    case 990:
      if (lookahead == 'e') ADVANCE(1910);
      END_STATE();
    case 991:
      if (lookahead == 'e') ADVANCE(1993);
      END_STATE();
    case 992:
      if (lookahead == 'e') ADVANCE(1354);
      END_STATE();
    case 993:
      if (lookahead == 'e') ADVANCE(884);
      END_STATE();
    case 994:
      if (lookahead == 'e') ADVANCE(695);
      END_STATE();
    case 995:
      if (lookahead == 'e') ADVANCE(886);
      END_STATE();
    case 996:
      if (lookahead == 'e') ADVANCE(1500);
      END_STATE();
    case 997:
      if (lookahead == 'e') ADVANCE(758);
      END_STATE();
    case 998:
      if (lookahead == 'e') ADVANCE(889);
      END_STATE();
    case 999:
      if (lookahead == 'e') ADVANCE(922);
      END_STATE();
    case 1000:
      if (lookahead == 'e') ADVANCE(906);
      END_STATE();
    case 1001:
      if (lookahead == 'e') ADVANCE(1754);
      END_STATE();
    case 1002:
      if (lookahead == 'e') ADVANCE(1905);
      END_STATE();
    case 1003:
      if (lookahead == 'e') ADVANCE(1672);
      if (lookahead == 'k') ADVANCE(566);
      if (lookahead == 'n') ADVANCE(1640);
      if (lookahead == 'p') ADVANCE(1188);
      if (lookahead == 'r') ADVANCE(282);
      if (lookahead == 's') ADVANCE(1234);
      if (lookahead == 't') ADVANCE(1205);
      END_STATE();
    case 1004:
      if (lookahead == 'e') ADVANCE(1672);
      if (lookahead == 'p') ADVANCE(1187);
      END_STATE();
    case 1005:
      if (lookahead == 'e') ADVANCE(1916);
      END_STATE();
    case 1006:
      if (lookahead == 'e') ADVANCE(1390);
      END_STATE();
    case 1007:
      if (lookahead == 'e') ADVANCE(865);
      END_STATE();
    case 1008:
      if (lookahead == 'e') ADVANCE(1554);
      END_STATE();
    case 1009:
      if (lookahead == 'e') ADVANCE(1947);
      END_STATE();
    case 1010:
      if (lookahead == 'e') ADVANCE(1999);
      END_STATE();
    case 1011:
      if (lookahead == 'e') ADVANCE(1918);
      END_STATE();
    case 1012:
      if (lookahead == 'e') ADVANCE(1977);
      END_STATE();
    case 1013:
      if (lookahead == 'e') ADVANCE(577);
      END_STATE();
    case 1014:
      if (lookahead == 'e') ADVANCE(937);
      END_STATE();
    case 1015:
      if (lookahead == 'e') ADVANCE(1526);
      END_STATE();
    case 1016:
      if (lookahead == 'e') ADVANCE(1417);
      END_STATE();
    case 1017:
      if (lookahead == 'e') ADVANCE(1794);
      END_STATE();
    case 1018:
      if (lookahead == 'e') ADVANCE(616);
      END_STATE();
    case 1019:
      if (lookahead == 'e') ADVANCE(1908);
      END_STATE();
    case 1020:
      if (lookahead == 'e') ADVANCE(600);
      END_STATE();
    case 1021:
      if (lookahead == 'e') ADVANCE(1909);
      END_STATE();
    case 1022:
      if (lookahead == 'e') ADVANCE(1964);
      if (lookahead == 'i') ADVANCE(1459);
      if (lookahead == 'u') ADVANCE(2158);
      END_STATE();
    case 1023:
      if (lookahead == 'e') ADVANCE(1760);
      END_STATE();
    case 1024:
      if (lookahead == 'e') ADVANCE(1867);
      END_STATE();
    case 1025:
      if (lookahead == 'e') ADVANCE(2000);
      END_STATE();
    case 1026:
      if (lookahead == 'e') ADVANCE(1831);
      END_STATE();
    case 1027:
      if (lookahead == 'e') ADVANCE(2007);
      END_STATE();
    case 1028:
      if (lookahead == 'e') ADVANCE(1000);
      END_STATE();
    case 1029:
      if (lookahead == 'e') ADVANCE(944);
      if (lookahead == 'r') ADVANCE(1331);
      END_STATE();
    case 1030:
      if (lookahead == 'e') ADVANCE(1747);
      END_STATE();
    case 1031:
      if (lookahead == 'e') ADVANCE(1841);
      if (lookahead == 'i') ADVANCE(1512);
      END_STATE();
    case 1032:
      if (lookahead == 'e') ADVANCE(1791);
      END_STATE();
    case 1033:
      if (lookahead == 'e') ADVANCE(1869);
      END_STATE();
    case 1034:
      if (lookahead == 'e') ADVANCE(1889);
      END_STATE();
    case 1035:
      if (lookahead == 'e') ADVANCE(949);
      END_STATE();
    case 1036:
      if (lookahead == 'e') ADVANCE(1804);
      END_STATE();
    case 1037:
      if (lookahead == 'e') ADVANCE(1076);
      END_STATE();
    case 1038:
      if (lookahead == 'e') ADVANCE(1801);
      END_STATE();
    case 1039:
      if (lookahead == 'e') ADVANCE(1764);
      END_STATE();
    case 1040:
      if (lookahead == 'e') ADVANCE(1809);
      END_STATE();
    case 1041:
      if (lookahead == 'e') ADVANCE(1767);
      END_STATE();
    case 1042:
      if (lookahead == 'e') ADVANCE(1107);
      END_STATE();
    case 1043:
      if (lookahead == 'e') ADVANCE(2111);
      if (lookahead == 'i') ADVANCE(1154);
      END_STATE();
    case 1044:
      if (lookahead == 'e') ADVANCE(1424);
      END_STATE();
    case 1045:
      if (lookahead == 'e') ADVANCE(520);
      END_STATE();
    case 1046:
      if (lookahead == 'e') ADVANCE(894);
      END_STATE();
    case 1047:
      if (lookahead == 'e') ADVANCE(674);
      if (lookahead == 'w') ADVANCE(674);
      END_STATE();
    case 1048:
      if (lookahead == 'e') ADVANCE(1104);
      END_STATE();
    case 1049:
      if (lookahead == 'e') ADVANCE(1104);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 't') ADVANCE(354);
      END_STATE();
    case 1050:
      if (lookahead == 'e') ADVANCE(996);
      END_STATE();
    case 1051:
      if (lookahead == 'e') ADVANCE(1936);
      END_STATE();
    case 1052:
      if (lookahead == 'e') ADVANCE(897);
      END_STATE();
    case 1053:
      if (lookahead == 'e') ADVANCE(1489);
      END_STATE();
    case 1054:
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'o') ADVANCE(1570);
      END_STATE();
    case 1055:
      if (lookahead == 'e') ADVANCE(663);
      END_STATE();
    case 1056:
      if (lookahead == 'e') ADVANCE(1725);
      END_STATE();
    case 1057:
      if (lookahead == 'e') ADVANCE(1829);
      END_STATE();
    case 1058:
      if (lookahead == 'e') ADVANCE(2022);
      END_STATE();
    case 1059:
      if (lookahead == 'e') ADVANCE(2022);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 1060:
      if (lookahead == 'e') ADVANCE(745);
      END_STATE();
    case 1061:
      if (lookahead == 'e') ADVANCE(1108);
      END_STATE();
    case 1062:
      if (lookahead == 'e') ADVANCE(915);
      END_STATE();
    case 1063:
      if (lookahead == 'e') ADVANCE(851);
      END_STATE();
    case 1064:
      if (lookahead == 'e') ADVANCE(1926);
      END_STATE();
    case 1065:
      if (lookahead == 'e') ADVANCE(1712);
      END_STATE();
    case 1066:
      if (lookahead == 'e') ADVANCE(1109);
      END_STATE();
    case 1067:
      if (lookahead == 'e') ADVANCE(1828);
      if (lookahead == 'n') ADVANCE(458);
      END_STATE();
    case 1068:
      if (lookahead == 'e') ADVANCE(853);
      END_STATE();
    case 1069:
      if (lookahead == 'e') ADVANCE(1580);
      END_STATE();
    case 1070:
      if (lookahead == 'e') ADVANCE(1110);
      END_STATE();
    case 1071:
      if (lookahead == 'e') ADVANCE(1111);
      END_STATE();
    case 1072:
      if (lookahead == 'e') ADVANCE(1563);
      END_STATE();
    case 1073:
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'o') ADVANCE(1540);
      END_STATE();
    case 1074:
      if (lookahead == 'e') ADVANCE(1847);
      END_STATE();
    case 1075:
      if (lookahead == 'e') ADVANCE(1105);
      END_STATE();
    case 1076:
      if (lookahead == 'e') ADVANCE(2041);
      END_STATE();
    case 1077:
      if (lookahead == 'e') ADVANCE(1894);
      END_STATE();
    case 1078:
      if (lookahead == 'e') ADVANCE(1548);
      END_STATE();
    case 1079:
      if (lookahead == 'e') ADVANCE(699);
      END_STATE();
    case 1080:
      if (lookahead == 'e') ADVANCE(1458);
      END_STATE();
    case 1081:
      if (lookahead == 'e') ADVANCE(1156);
      END_STATE();
    case 1082:
      if (lookahead == 'e') ADVANCE(1891);
      END_STATE();
    case 1083:
      if (lookahead == 'e') ADVANCE(2028);
      END_STATE();
    case 1084:
      if (lookahead == 'e') ADVANCE(1307);
      END_STATE();
    case 1085:
      if (lookahead == 'e') ADVANCE(1874);
      END_STATE();
    case 1086:
      if (lookahead == 'e') ADVANCE(919);
      END_STATE();
    case 1087:
      if (lookahead == 'e') ADVANCE(698);
      END_STATE();
    case 1088:
      if (lookahead == 'e') ADVANCE(1523);
      END_STATE();
    case 1089:
      if (lookahead == 'e') ADVANCE(703);
      END_STATE();
    case 1090:
      if (lookahead == 'e') ADVANCE(871);
      END_STATE();
    case 1091:
      if (lookahead == 'e') ADVANCE(1115);
      END_STATE();
    case 1092:
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 1093:
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(2061);
      END_STATE();
    case 1094:
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1620);
      END_STATE();
    case 1095:
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(148);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 's') ADVANCE(774);
      END_STATE();
    case 1096:
      if (lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1512);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 'p') ADVANCE(1816);
      if (lookahead == 's') ADVANCE(774);
      if (lookahead == 'u') ADVANCE(598);
      END_STATE();
    case 1097:
      if (lookahead == 'f') ADVANCE(1954);
      END_STATE();
    case 1098:
      if (lookahead == 'f') ADVANCE(1103);
      END_STATE();
    case 1099:
      if (lookahead == 'f') ADVANCE(1957);
      if (lookahead == 's') ADVANCE(1902);
      END_STATE();
    case 1100:
      if (lookahead == 'f') ADVANCE(1980);
      if (lookahead == 'l') ADVANCE(218);
      if (lookahead == 'p') ADVANCE(1092);
      END_STATE();
    case 1101:
      if (lookahead == 'f') ADVANCE(1921);
      if (lookahead == 'p') ADVANCE(1179);
      END_STATE();
    case 1102:
      if (lookahead == 'f') ADVANCE(2045);
      END_STATE();
    case 1103:
      if (lookahead == 'f') ADVANCE(1077);
      END_STATE();
    case 1104:
      if (lookahead == 'f') ADVANCE(1984);
      END_STATE();
    case 1105:
      if (lookahead == 'f') ADVANCE(1999);
      END_STATE();
    case 1106:
      if (lookahead == 'f') ADVANCE(1664);
      END_STATE();
    case 1107:
      if (lookahead == 'f') ADVANCE(1991);
      if (lookahead == 's') ADVANCE(1907);
      END_STATE();
    case 1108:
      if (lookahead == 'f') ADVANCE(1966);
      END_STATE();
    case 1109:
      if (lookahead == 'f') ADVANCE(1968);
      END_STATE();
    case 1110:
      if (lookahead == 'f') ADVANCE(1986);
      END_STATE();
    case 1111:
      if (lookahead == 'f') ADVANCE(2024);
      END_STATE();
    case 1112:
      if (lookahead == 'f') ADVANCE(1972);
      END_STATE();
    case 1113:
      if (lookahead == 'f') ADVANCE(1624);
      END_STATE();
    case 1114:
      if (lookahead == 'f') ADVANCE(1263);
      END_STATE();
    case 1115:
      if (lookahead == 'f') ADVANCE(2044);
      END_STATE();
    case 1116:
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 1117:
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1673);
      END_STATE();
    case 1118:
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 't') ADVANCE(354);
      END_STATE();
    case 1119:
      if (lookahead == 'g') ADVANCE(763);
      END_STATE();
    case 1120:
      if (lookahead == 'g') ADVANCE(236);
      END_STATE();
    case 1121:
      if (lookahead == 'g') ADVANCE(236);
      if (lookahead == 'i') ADVANCE(1512);
      END_STATE();
    case 1122:
      if (lookahead == 'g') ADVANCE(491);
      END_STATE();
    case 1123:
      if (lookahead == 'g') ADVANCE(510);
      END_STATE();
    case 1124:
      if (lookahead == 'g') ADVANCE(240);
      END_STATE();
    case 1125:
      if (lookahead == 'g') ADVANCE(1457);
      END_STATE();
    case 1126:
      if (lookahead == 'g') ADVANCE(299);
      END_STATE();
    case 1127:
      if (lookahead == 'g') ADVANCE(528);
      END_STATE();
    case 1128:
      if (lookahead == 'g') ADVANCE(1195);
      END_STATE();
    case 1129:
      if (lookahead == 'g') ADVANCE(2150);
      END_STATE();
    case 1130:
      if (lookahead == 'g') ADVANCE(1142);
      if (lookahead == 'l') ADVANCE(991);
      if (lookahead == 'r') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1183);
      END_STATE();
    case 1131:
      if (lookahead == 'g') ADVANCE(1142);
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 1132:
      if (lookahead == 'g') ADVANCE(1142);
      if (lookahead == 'r') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1185);
      END_STATE();
    case 1133:
      if (lookahead == 'g') ADVANCE(1586);
      END_STATE();
    case 1134:
      if (lookahead == 'g') ADVANCE(1625);
      if (lookahead == 'p') ADVANCE(1092);
      END_STATE();
    case 1135:
      if (lookahead == 'g') ADVANCE(1625);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 1136:
      if (lookahead == 'g') ADVANCE(1466);
      END_STATE();
    case 1137:
      if (lookahead == 'g') ADVANCE(1184);
      END_STATE();
    case 1138:
      if (lookahead == 'g') ADVANCE(1354);
      if (lookahead == 'i') ADVANCE(1386);
      if (lookahead == 'l') ADVANCE(1116);
      if (lookahead == 'r') ADVANCE(1327);
      END_STATE();
    case 1139:
      if (lookahead == 'g') ADVANCE(672);
      if (lookahead == 's') ADVANCE(2010);
      if (lookahead == 'w') ADVANCE(489);
      END_STATE();
    case 1140:
      if (lookahead == 'g') ADVANCE(1500);
      END_STATE();
    case 1141:
      if (lookahead == 'g') ADVANCE(922);
      END_STATE();
    case 1142:
      if (lookahead == 'g') ADVANCE(953);
      END_STATE();
    case 1143:
      if (lookahead == 'g') ADVANCE(957);
      END_STATE();
    case 1144:
      if (lookahead == 'g') ADVANCE(1873);
      END_STATE();
    case 1145:
      if (lookahead == 'g') ADVANCE(1873);
      if (lookahead == 'i') ADVANCE(1512);
      if (lookahead == 't') ADVANCE(1654);
      END_STATE();
    case 1146:
      if (lookahead == 'g') ADVANCE(1771);
      END_STATE();
    case 1147:
      if (lookahead == 'g') ADVANCE(1198);
      if (lookahead == 'n') ADVANCE(1116);
      if (lookahead == 's') ADVANCE(1297);
      END_STATE();
    case 1148:
      if (lookahead == 'g') ADVANCE(916);
      END_STATE();
    case 1149:
      if (lookahead == 'g') ADVANCE(1780);
      END_STATE();
    case 1150:
      if (lookahead == 'g') ADVANCE(1194);
      END_STATE();
    case 1151:
      if (lookahead == 'g') ADVANCE(1974);
      END_STATE();
    case 1152:
      if (lookahead == 'g') ADVANCE(1974);
      if (lookahead == 'l') ADVANCE(968);
      END_STATE();
    case 1153:
      if (lookahead == 'g') ADVANCE(1974);
      if (lookahead == 'q') ADVANCE(1151);
      END_STATE();
    case 1154:
      if (lookahead == 'g') ADVANCE(1199);
      END_STATE();
    case 1155:
      if (lookahead == 'g') ADVANCE(1492);
      if (lookahead == 'm') ADVANCE(237);
      END_STATE();
    case 1156:
      if (lookahead == 'g') ADVANCE(1824);
      END_STATE();
    case 1157:
      if (lookahead == 'g') ADVANCE(1824);
      if (lookahead == 'r') ADVANCE(1941);
      END_STATE();
    case 1158:
      if (lookahead == 'g') ADVANCE(1200);
      END_STATE();
    case 1159:
      if (lookahead == 'g') ADVANCE(1202);
      END_STATE();
    case 1160:
      if (lookahead == 'g') ADVANCE(1203);
      END_STATE();
    case 1161:
      if (lookahead == 'g') ADVANCE(1204);
      END_STATE();
    case 1162:
      if (lookahead == 'g') ADVANCE(1403);
      END_STATE();
    case 1163:
      if (lookahead == 'g') ADVANCE(1206);
      END_STATE();
    case 1164:
      if (lookahead == 'g') ADVANCE(1036);
      if (lookahead == 'r') ADVANCE(845);
      END_STATE();
    case 1165:
      if (lookahead == 'g') ADVANCE(1207);
      END_STATE();
    case 1166:
      if (lookahead == 'g') ADVANCE(1208);
      END_STATE();
    case 1167:
      if (lookahead == 'g') ADVANCE(1425);
      END_STATE();
    case 1168:
      if (lookahead == 'g') ADVANCE(1197);
      END_STATE();
    case 1169:
      if (lookahead == 'g') ADVANCE(1427);
      END_STATE();
    case 1170:
      if (lookahead == 'g') ADVANCE(1428);
      END_STATE();
    case 1171:
      if (lookahead == 'g') ADVANCE(1429);
      END_STATE();
    case 1172:
      if (lookahead == 'g') ADVANCE(1442);
      END_STATE();
    case 1173:
      if (lookahead == 'g') ADVANCE(1430);
      END_STATE();
    case 1174:
      if (lookahead == 'g') ADVANCE(1431);
      END_STATE();
    case 1175:
      if (lookahead == 'g') ADVANCE(490);
      END_STATE();
    case 1176:
      if (lookahead == 'g') ADVANCE(690);
      END_STATE();
    case 1177:
      if (lookahead == 'g') ADVANCE(1217);
      END_STATE();
    case 1178:
      if (lookahead == 'h') ADVANCE(877);
      END_STATE();
    case 1179:
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 1180:
      if (lookahead == 'h') ADVANCE(293);
      END_STATE();
    case 1181:
      if (lookahead == 'h') ADVANCE(510);
      END_STATE();
    case 1182:
      if (lookahead == 'h') ADVANCE(528);
      END_STATE();
    case 1183:
      if (lookahead == 'h') ADVANCE(354);
      END_STATE();
    case 1184:
      if (lookahead == 'h') ADVANCE(1954);
      END_STATE();
    case 1185:
      if (lookahead == 'h') ADVANCE(2104);
      END_STATE();
    case 1186:
      if (lookahead == 'h') ADVANCE(750);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1187:
      if (lookahead == 'h') ADVANCE(1219);
      END_STATE();
    case 1188:
      if (lookahead == 'h') ADVANCE(1219);
      if (lookahead == 'i') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1653);
      END_STATE();
    case 1189:
      if (lookahead == 'h') ADVANCE(542);
      END_STATE();
    case 1190:
      if (lookahead == 'h') ADVANCE(1673);
      END_STATE();
    case 1191:
      if (lookahead == 'h') ADVANCE(1335);
      END_STATE();
    case 1192:
      if (lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'r') ADVANCE(312);
      END_STATE();
    case 1193:
      if (lookahead == 'h') ADVANCE(922);
      END_STATE();
    case 1194:
      if (lookahead == 'h') ADVANCE(2045);
      END_STATE();
    case 1195:
      if (lookahead == 'h') ADVANCE(1961);
      END_STATE();
    case 1196:
      if (lookahead == 'h') ADVANCE(552);
      END_STATE();
    case 1197:
      if (lookahead == 'h') ADVANCE(1999);
      END_STATE();
    case 1198:
      if (lookahead == 'h') ADVANCE(1963);
      END_STATE();
    case 1199:
      if (lookahead == 'h') ADVANCE(1991);
      END_STATE();
    case 1200:
      if (lookahead == 'h') ADVANCE(1976);
      END_STATE();
    case 1201:
      if (lookahead == 'h') ADVANCE(1222);
      END_STATE();
    case 1202:
      if (lookahead == 'h') ADVANCE(1967);
      END_STATE();
    case 1203:
      if (lookahead == 'h') ADVANCE(1969);
      END_STATE();
    case 1204:
      if (lookahead == 'h') ADVANCE(1986);
      END_STATE();
    case 1205:
      if (lookahead == 'h') ADVANCE(988);
      if (lookahead == 'r') ADVANCE(1330);
      END_STATE();
    case 1206:
      if (lookahead == 'h') ADVANCE(1971);
      END_STATE();
    case 1207:
      if (lookahead == 'h') ADVANCE(1973);
      END_STATE();
    case 1208:
      if (lookahead == 'h') ADVANCE(1970);
      END_STATE();
    case 1209:
      if (lookahead == 'h') ADVANCE(1064);
      END_STATE();
    case 1210:
      if (lookahead == 'h') ADVANCE(1256);
      END_STATE();
    case 1211:
      if (lookahead == 'h') ADVANCE(996);
      END_STATE();
    case 1212:
      if (lookahead == 'h') ADVANCE(1113);
      END_STATE();
    case 1213:
      if (lookahead == 'h') ADVANCE(1795);
      if (lookahead == 'i') ADVANCE(1493);
      if (lookahead == 'r') ADVANCE(1227);
      END_STATE();
    case 1214:
      if (lookahead == 'h') ADVANCE(1018);
      END_STATE();
    case 1215:
      if (lookahead == 'h') ADVANCE(1280);
      END_STATE();
    case 1216:
      if (lookahead == 'h') ADVANCE(1876);
      END_STATE();
    case 1217:
      if (lookahead == 'h') ADVANCE(2044);
      END_STATE();
    case 1218:
      if (lookahead == 'i') ADVANCE(877);
      END_STATE();
    case 1219:
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 1220:
      if (lookahead == 'i') ADVANCE(293);
      END_STATE();
    case 1221:
      if (lookahead == 'i') ADVANCE(276);
      END_STATE();
    case 1222:
      if (lookahead == 'i') ADVANCE(826);
      END_STATE();
    case 1223:
      if (lookahead == 'i') ADVANCE(2133);
      if (lookahead == 'o') ADVANCE(1214);
      END_STATE();
    case 1224:
      if (lookahead == 'i') ADVANCE(2149);
      END_STATE();
    case 1225:
      if (lookahead == 'i') ADVANCE(270);
      END_STATE();
    case 1226:
      if (lookahead == 'i') ADVANCE(298);
      END_STATE();
    case 1227:
      if (lookahead == 'i') ADVANCE(295);
      END_STATE();
    case 1228:
      if (lookahead == 'i') ADVANCE(281);
      END_STATE();
    case 1229:
      if (lookahead == 'i') ADVANCE(1746);
      END_STATE();
    case 1230:
      if (lookahead == 'i') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1600);
      END_STATE();
    case 1231:
      if (lookahead == 'i') ADVANCE(1512);
      END_STATE();
    case 1232:
      if (lookahead == 'i') ADVANCE(1512);
      if (lookahead == 'n') ADVANCE(1954);
      END_STATE();
    case 1233:
      if (lookahead == 'i') ADVANCE(354);
      if (lookahead == 'm') ADVANCE(1491);
      if (lookahead == 'o') ADVANCE(1534);
      END_STATE();
    case 1234:
      if (lookahead == 'i') ADVANCE(1136);
      if (lookahead == 'u') ADVANCE(749);
      END_STATE();
    case 1235:
      if (lookahead == 'i') ADVANCE(1387);
      END_STATE();
    case 1236:
      if (lookahead == 'i') ADVANCE(297);
      END_STATE();
    case 1237:
      if (lookahead == 'i') ADVANCE(1954);
      END_STATE();
    case 1238:
      if (lookahead == 'i') ADVANCE(2104);
      END_STATE();
    case 1239:
      if (lookahead == 'i') ADVANCE(872);
      END_STATE();
    case 1240:
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'o') ADVANCE(2088);
      END_STATE();
    case 1241:
      if (lookahead == 'i') ADVANCE(1501);
      END_STATE();
    case 1242:
      if (lookahead == 'i') ADVANCE(355);
      END_STATE();
    case 1243:
      if (lookahead == 'i') ADVANCE(1948);
      END_STATE();
    case 1244:
      if (lookahead == 'i') ADVANCE(1948);
      if (lookahead == 'p') ADVANCE(1628);
      END_STATE();
    case 1245:
      if (lookahead == 'i') ADVANCE(246);
      END_STATE();
    case 1246:
      if (lookahead == 'i') ADVANCE(1382);
      END_STATE();
    case 1247:
      if (lookahead == 'i') ADVANCE(1673);
      END_STATE();
    case 1248:
      if (lookahead == 'i') ADVANCE(1116);
      END_STATE();
    case 1249:
      if (lookahead == 'i') ADVANCE(1116);
      if (lookahead == 'l') ADVANCE(1248);
      END_STATE();
    case 1250:
      if (lookahead == 'i') ADVANCE(1098);
      END_STATE();
    case 1251:
      if (lookahead == 'i') ADVANCE(1459);
      END_STATE();
    case 1252:
      if (lookahead == 'i') ADVANCE(1459);
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 1253:
      if (lookahead == 'i') ADVANCE(1459);
      if (lookahead == 'l') ADVANCE(670);
      END_STATE();
    case 1254:
      if (lookahead == 'i') ADVANCE(1625);
      END_STATE();
    case 1255:
      if (lookahead == 'i') ADVANCE(1899);
      END_STATE();
    case 1256:
      if (lookahead == 'i') ADVANCE(1521);
      END_STATE();
    case 1257:
      if (lookahead == 'i') ADVANCE(1924);
      if (lookahead == 'l') ADVANCE(1634);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1258:
      if (lookahead == 'i') ADVANCE(1924);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1259:
      if (lookahead == 'i') ADVANCE(1354);
      END_STATE();
    case 1260:
      if (lookahead == 'i') ADVANCE(1129);
      END_STATE();
    case 1261:
      if (lookahead == 'i') ADVANCE(1140);
      END_STATE();
    case 1262:
      if (lookahead == 'i') ADVANCE(2065);
      END_STATE();
    case 1263:
      if (lookahead == 'i') ADVANCE(1500);
      END_STATE();
    case 1264:
      if (lookahead == 'i') ADVANCE(1384);
      END_STATE();
    case 1265:
      if (lookahead == 'i') ADVANCE(758);
      END_STATE();
    case 1266:
      if (lookahead == 'i') ADVANCE(1776);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1267:
      if (lookahead == 'i') ADVANCE(922);
      END_STATE();
    case 1268:
      if (lookahead == 'i') ADVANCE(1534);
      END_STATE();
    case 1269:
      if (lookahead == 'i') ADVANCE(684);
      END_STATE();
    case 1270:
      if (lookahead == 'i') ADVANCE(907);
      END_STATE();
    case 1271:
      if (lookahead == 'i') ADVANCE(1478);
      END_STATE();
    case 1272:
      if (lookahead == 'i') ADVANCE(1176);
      END_STATE();
    case 1273:
      if (lookahead == 'i') ADVANCE(1820);
      if (lookahead == 'l') ADVANCE(1092);
      if (lookahead == 'm') ADVANCE(1275);
      if (lookahead == 'r') ADVANCE(888);
      END_STATE();
    case 1274:
      if (lookahead == 'i') ADVANCE(1525);
      END_STATE();
    case 1275:
      if (lookahead == 'i') ADVANCE(1370);
      END_STATE();
    case 1276:
      if (lookahead == 'i') ADVANCE(989);
      END_STATE();
    case 1277:
      if (lookahead == 'i') ADVANCE(2060);
      END_STATE();
    case 1278:
      if (lookahead == 'i') ADVANCE(1565);
      END_STATE();
    case 1279:
      if (lookahead == 'i') ADVANCE(1558);
      END_STATE();
    case 1280:
      if (lookahead == 'i') ADVANCE(1503);
      END_STATE();
    case 1281:
      if (lookahead == 'i') ADVANCE(1400);
      if (lookahead == 'l') ADVANCE(1249);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1282:
      if (lookahead == 'i') ADVANCE(1137);
      END_STATE();
    case 1283:
      if (lookahead == 'i') ADVANCE(1388);
      END_STATE();
    case 1284:
      if (lookahead == 'i') ADVANCE(1536);
      if (lookahead == 'p') ADVANCE(1092);
      END_STATE();
    case 1285:
      if (lookahead == 'i') ADVANCE(1813);
      END_STATE();
    case 1286:
      if (lookahead == 'i') ADVANCE(1813);
      if (lookahead == 'o') ADVANCE(1384);
      END_STATE();
    case 1287:
      if (lookahead == 'i') ADVANCE(1813);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1288:
      if (lookahead == 'i') ADVANCE(1386);
      END_STATE();
    case 1289:
      if (lookahead == 'i') ADVANCE(741);
      END_STATE();
    case 1290:
      if (lookahead == 'i') ADVANCE(632);
      END_STATE();
    case 1291:
      if (lookahead == 'i') ADVANCE(1939);
      END_STATE();
    case 1292:
      if (lookahead == 'i') ADVANCE(2110);
      END_STATE();
    case 1293:
      if (lookahead == 'i') ADVANCE(1719);
      END_STATE();
    case 1294:
      if (lookahead == 'i') ADVANCE(1544);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 'u') ADVANCE(1515);
      END_STATE();
    case 1295:
      if (lookahead == 'i') ADVANCE(1405);
      END_STATE();
    case 1296:
      if (lookahead == 'i') ADVANCE(1483);
      END_STATE();
    case 1297:
      if (lookahead == 'i') ADVANCE(1538);
      END_STATE();
    case 1298:
      if (lookahead == 'i') ADVANCE(1943);
      END_STATE();
    case 1299:
      if (lookahead == 'i') ADVANCE(1938);
      END_STATE();
    case 1300:
      if (lookahead == 'i') ADVANCE(1493);
      END_STATE();
    case 1301:
      if (lookahead == 'i') ADVANCE(1479);
      END_STATE();
    case 1302:
      if (lookahead == 'i') ADVANCE(2019);
      END_STATE();
    case 1303:
      if (lookahead == 'i') ADVANCE(1416);
      END_STATE();
    case 1304:
      if (lookahead == 'i') ADVANCE(1542);
      END_STATE();
    case 1305:
      if (lookahead == 'i') ADVANCE(1033);
      END_STATE();
    case 1306:
      if (lookahead == 'i') ADVANCE(640);
      END_STATE();
    case 1307:
      if (lookahead == 'i') ADVANCE(1435);
      END_STATE();
    case 1308:
      if (lookahead == 'i') ADVANCE(1403);
      END_STATE();
    case 1309:
      if (lookahead == 'i') ADVANCE(1642);
      END_STATE();
    case 1310:
      if (lookahead == 'i') ADVANCE(1621);
      END_STATE();
    case 1311:
      if (lookahead == 'i') ADVANCE(1559);
      END_STATE();
    case 1312:
      if (lookahead == 'i') ADVANCE(1559);
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 1313:
      if (lookahead == 'i') ADVANCE(1150);
      END_STATE();
    case 1314:
      if (lookahead == 'i') ADVANCE(1436);
      END_STATE();
    case 1315:
      if (lookahead == 'i') ADVANCE(864);
      END_STATE();
    case 1316:
      if (lookahead == 'i') ADVANCE(868);
      END_STATE();
    case 1317:
      if (lookahead == 'i') ADVANCE(742);
      END_STATE();
    case 1318:
      if (lookahead == 'i') ADVANCE(1158);
      END_STATE();
    case 1319:
      if (lookahead == 'i') ADVANCE(1159);
      END_STATE();
    case 1320:
      if (lookahead == 'i') ADVANCE(1160);
      END_STATE();
    case 1321:
      if (lookahead == 'i') ADVANCE(1161);
      END_STATE();
    case 1322:
      if (lookahead == 'i') ADVANCE(1163);
      END_STATE();
    case 1323:
      if (lookahead == 'i') ADVANCE(1165);
      END_STATE();
    case 1324:
      if (lookahead == 'i') ADVANCE(1166);
      END_STATE();
    case 1325:
      if (lookahead == 'i') ADVANCE(1168);
      END_STATE();
    case 1326:
      if (lookahead == 'i') ADVANCE(1887);
      END_STATE();
    case 1327:
      if (lookahead == 'i') ADVANCE(708);
      END_STATE();
    case 1328:
      if (lookahead == 'i') ADVANCE(1177);
      END_STATE();
    case 1329:
      if (lookahead == 'i') ADVANCE(710);
      END_STATE();
    case 1330:
      if (lookahead == 'i') ADVANCE(711);
      END_STATE();
    case 1331:
      if (lookahead == 'i') ADVANCE(712);
      END_STATE();
    case 1332:
      if (lookahead == 'i') ADVANCE(713);
      END_STATE();
    case 1333:
      if (lookahead == 'j') ADVANCE(148);
      END_STATE();
    case 1334:
      if (lookahead == 'j') ADVANCE(148);
      if (lookahead == 'n') ADVANCE(1333);
      END_STATE();
    case 1335:
      if (lookahead == 'k') ADVANCE(148);
      END_STATE();
    case 1336:
      if (lookahead == 'k') ADVANCE(510);
      END_STATE();
    case 1337:
      if (lookahead == 'k') ADVANCE(866);
      END_STATE();
    case 1338:
      if (lookahead == 'k') ADVANCE(1440);
      END_STATE();
    case 1339:
      if (lookahead == 'k') ADVANCE(1413);
      END_STATE();
    case 1340:
      if (lookahead == 'k') ADVANCE(304);
      END_STATE();
    case 1341:
      if (lookahead == 'k') ADVANCE(280);
      END_STATE();
    case 1342:
      if (lookahead == 'k') ADVANCE(750);
      END_STATE();
    case 1343:
      if (lookahead == 'k') ADVANCE(750);
      if (lookahead == 'm') ADVANCE(293);
      END_STATE();
    case 1344:
      if (lookahead == 'k') ADVANCE(2127);
      END_STATE();
    case 1345:
      if (lookahead == 'k') ADVANCE(346);
      END_STATE();
    case 1346:
      if (lookahead == 'k') ADVANCE(1935);
      END_STATE();
    case 1347:
      if (lookahead == 'k') ADVANCE(953);
      END_STATE();
    case 1348:
      if (lookahead == 'k') ADVANCE(957);
      END_STATE();
    case 1349:
      if (lookahead == 'k') ADVANCE(667);
      END_STATE();
    case 1350:
      if (lookahead == 'k') ADVANCE(674);
      END_STATE();
    case 1351:
      if (lookahead == 'k') ADVANCE(674);
      if (lookahead == 'l') ADVANCE(605);
      END_STATE();
    case 1352:
      if (lookahead == 'k') ADVANCE(1304);
      END_STATE();
    case 1353:
      if (lookahead == 'l') ADVANCE(877);
      END_STATE();
    case 1354:
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 1355:
      if (lookahead == 'l') ADVANCE(343);
      END_STATE();
    case 1356:
      if (lookahead == 'l') ADVANCE(489);
      END_STATE();
    case 1357:
      if (lookahead == 'l') ADVANCE(458);
      END_STATE();
    case 1358:
      if (lookahead == 'l') ADVANCE(217);
      END_STATE();
    case 1359:
      if (lookahead == 'l') ADVANCE(287);
      END_STATE();
    case 1360:
      if (lookahead == 'l') ADVANCE(2160);
      END_STATE();
    case 1361:
      if (lookahead == 'l') ADVANCE(422);
      END_STATE();
    case 1362:
      if (lookahead == 'l') ADVANCE(409);
      END_STATE();
    case 1363:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 1364:
      if (lookahead == 'l') ADVANCE(528);
      END_STATE();
    case 1365:
      if (lookahead == 'l') ADVANCE(2139);
      END_STATE();
    case 1366:
      if (lookahead == 'l') ADVANCE(1053);
      END_STATE();
    case 1367:
      if (lookahead == 'l') ADVANCE(1053);
      if (lookahead == 'q') ADVANCE(2078);
      END_STATE();
    case 1368:
      if (lookahead == 'l') ADVANCE(1053);
      if (lookahead == 'q') ADVANCE(2077);
      if (lookahead == 'x') ADVANCE(1243);
      END_STATE();
    case 1369:
      if (lookahead == 'l') ADVANCE(474);
      END_STATE();
    case 1370:
      if (lookahead == 'l') ADVANCE(1954);
      END_STATE();
    case 1371:
      if (lookahead == 'l') ADVANCE(186);
      END_STATE();
    case 1372:
      if (lookahead == 'l') ADVANCE(467);
      END_STATE();
    case 1373:
      if (lookahead == 'l') ADVANCE(735);
      END_STATE();
    case 1374:
      if (lookahead == 'l') ADVANCE(430);
      END_STATE();
    case 1375:
      if (lookahead == 'l') ADVANCE(421);
      END_STATE();
    case 1376:
      if (lookahead == 'l') ADVANCE(512);
      END_STATE();
    case 1377:
      if (lookahead == 'l') ADVANCE(542);
      END_STATE();
    case 1378:
      if (lookahead == 'l') ADVANCE(330);
      END_STATE();
    case 1379:
      if (lookahead == 'l') ADVANCE(575);
      END_STATE();
    case 1380:
      if (lookahead == 'l') ADVANCE(251);
      END_STATE();
    case 1381:
      if (lookahead == 'l') ADVANCE(441);
      END_STATE();
    case 1382:
      if (lookahead == 'l') ADVANCE(905);
      END_STATE();
    case 1383:
      if (lookahead == 'l') ADVANCE(452);
      END_STATE();
    case 1384:
      if (lookahead == 'l') ADVANCE(1625);
      END_STATE();
    case 1385:
      if (lookahead == 'l') ADVANCE(1335);
      END_STATE();
    case 1386:
      if (lookahead == 'l') ADVANCE(892);
      END_STATE();
    case 1387:
      if (lookahead == 'l') ADVANCE(892);
      if (lookahead == 'm') ADVANCE(989);
      END_STATE();
    case 1388:
      if (lookahead == 'l') ADVANCE(892);
      if (lookahead == 'm') ADVANCE(1011);
      END_STATE();
    case 1389:
      if (lookahead == 'l') ADVANCE(973);
      END_STATE();
    case 1390:
      if (lookahead == 'l') ADVANCE(1899);
      END_STATE();
    case 1391:
      if (lookahead == 'l') ADVANCE(844);
      END_STATE();
    case 1392:
      if (lookahead == 'l') ADVANCE(1255);
      END_STATE();
    case 1393:
      if (lookahead == 'l') ADVANCE(2138);
      END_STATE();
    case 1394:
      if (lookahead == 'l') ADVANCE(1221);
      END_STATE();
    case 1395:
      if (lookahead == 'l') ADVANCE(992);
      END_STATE();
    case 1396:
      if (lookahead == 'l') ADVANCE(1354);
      END_STATE();
    case 1397:
      if (lookahead == 'l') ADVANCE(2148);
      END_STATE();
    case 1398:
      if (lookahead == 'l') ADVANCE(1634);
      END_STATE();
    case 1399:
      if (lookahead == 'l') ADVANCE(2085);
      END_STATE();
    case 1400:
      if (lookahead == 'l') ADVANCE(1248);
      END_STATE();
    case 1401:
      if (lookahead == 'l') ADVANCE(1380);
      if (lookahead == 'm') ADVANCE(1685);
      END_STATE();
    case 1402:
      if (lookahead == 'l') ADVANCE(1377);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 't') ADVANCE(250);
      if (lookahead == 'u') ADVANCE(740);
      if (lookahead == 'w') ADVANCE(1504);
      END_STATE();
    case 1403:
      if (lookahead == 'l') ADVANCE(922);
      END_STATE();
    case 1404:
      if (lookahead == 'l') ADVANCE(978);
      END_STATE();
    case 1405:
      if (lookahead == 'l') ADVANCE(1364);
      END_STATE();
    case 1406:
      if (lookahead == 'l') ADVANCE(1374);
      END_STATE();
    case 1407:
      if (lookahead == 'l') ADVANCE(993);
      END_STATE();
    case 1408:
      if (lookahead == 'l') ADVANCE(1455);
      if (lookahead == 's') ADVANCE(1190);
      END_STATE();
    case 1409:
      if (lookahead == 'l') ADVANCE(1652);
      END_STATE();
    case 1410:
      if (lookahead == 'l') ADVANCE(1276);
      END_STATE();
    case 1411:
      if (lookahead == 'l') ADVANCE(1247);
      END_STATE();
    case 1412:
      if (lookahead == 'l') ADVANCE(1372);
      END_STATE();
    case 1413:
      if (lookahead == 'l') ADVANCE(1603);
      if (lookahead == 's') ADVANCE(1743);
      if (lookahead == 't') ADVANCE(1898);
      END_STATE();
    case 1414:
      if (lookahead == 'l') ADVANCE(968);
      END_STATE();
    case 1415:
      if (lookahead == 'l') ADVANCE(968);
      if (lookahead == 'q') ADVANCE(1414);
      END_STATE();
    case 1416:
      if (lookahead == 'l') ADVANCE(1289);
      END_STATE();
    case 1417:
      if (lookahead == 'l') ADVANCE(591);
      END_STATE();
    case 1418:
      if (lookahead == 'l') ADVANCE(1376);
      END_STATE();
    case 1419:
      if (lookahead == 'l') ADVANCE(939);
      END_STATE();
    case 1420:
      if (lookahead == 'l') ADVANCE(940);
      END_STATE();
    case 1421:
      if (lookahead == 'l') ADVANCE(1637);
      END_STATE();
    case 1422:
      if (lookahead == 'l') ADVANCE(929);
      END_STATE();
    case 1423:
      if (lookahead == 'l') ADVANCE(1060);
      END_STATE();
    case 1424:
      if (lookahead == 'l') ADVANCE(982);
      if (lookahead == 'r') ADVANCE(1282);
      END_STATE();
    case 1425:
      if (lookahead == 'l') ADVANCE(947);
      END_STATE();
    case 1426:
      if (lookahead == 'l') ADVANCE(948);
      END_STATE();
    case 1427:
      if (lookahead == 'l') ADVANCE(960);
      END_STATE();
    case 1428:
      if (lookahead == 'l') ADVANCE(1080);
      END_STATE();
    case 1429:
      if (lookahead == 'l') ADVANCE(970);
      END_STATE();
    case 1430:
      if (lookahead == 'l') ADVANCE(950);
      END_STATE();
    case 1431:
      if (lookahead == 'l') ADVANCE(951);
      END_STATE();
    case 1432:
      if (lookahead == 'l') ADVANCE(952);
      END_STATE();
    case 1433:
      if (lookahead == 'l') ADVANCE(979);
      END_STATE();
    case 1434:
      if (lookahead == 'l') ADVANCE(605);
      END_STATE();
    case 1435:
      if (lookahead == 'l') ADVANCE(1256);
      END_STATE();
    case 1436:
      if (lookahead == 'l') ADVANCE(899);
      END_STATE();
    case 1437:
      if (lookahead == 'l') ADVANCE(899);
      if (lookahead == 'm') ADVANCE(983);
      if (lookahead == 'n') ADVANCE(1954);
      END_STATE();
    case 1438:
      if (lookahead == 'l') ADVANCE(1627);
      if (lookahead == 'n') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1094);
      if (lookahead == 'u') ADVANCE(1566);
      END_STATE();
    case 1439:
      if (lookahead == 'l') ADVANCE(547);
      END_STATE();
    case 1440:
      if (lookahead == 'l') ADVANCE(964);
      if (lookahead == 'r') ADVANCE(1313);
      END_STATE();
    case 1441:
      if (lookahead == 'l') ADVANCE(1045);
      END_STATE();
    case 1442:
      if (lookahead == 'l') ADVANCE(1044);
      END_STATE();
    case 1443:
      if (lookahead == 'l') ADVANCE(660);
      END_STATE();
    case 1444:
      if (lookahead == 'l') ADVANCE(2061);
      END_STATE();
    case 1445:
      if (lookahead == 'l') ADVANCE(1407);
      END_STATE();
    case 1446:
      if (lookahead == 'l') ADVANCE(606);
      END_STATE();
    case 1447:
      if (lookahead == 'l') ADVANCE(1297);
      END_STATE();
    case 1448:
      if (lookahead == 'l') ADVANCE(1632);
      if (lookahead == 'm') ADVANCE(1488);
      if (lookahead == 'n') ADVANCE(1121);
      if (lookahead == 'p') ADVANCE(271);
      END_STATE();
    case 1449:
      if (lookahead == 'l') ADVANCE(1845);
      END_STATE();
    case 1450:
      if (lookahead == 'l') ADVANCE(1231);
      END_STATE();
    case 1451:
      if (lookahead == 'l') ADVANCE(1392);
      END_STATE();
    case 1452:
      if (lookahead == 'l') ADVANCE(1279);
      END_STATE();
    case 1453:
      if (lookahead == 'l') ADVANCE(1395);
      END_STATE();
    case 1454:
      if (lookahead == 'l') ADVANCE(682);
      END_STATE();
    case 1455:
      if (lookahead == 'l') ADVANCE(1951);
      END_STATE();
    case 1456:
      if (lookahead == 'l') ADVANCE(1447);
      END_STATE();
    case 1457:
      if (lookahead == 'l') ADVANCE(1048);
      if (lookahead == 'm') ADVANCE(627);
      if (lookahead == 'r') ADVANCE(1313);
      END_STATE();
    case 1458:
      if (lookahead == 'l') ADVANCE(1075);
      if (lookahead == 'r') ADVANCE(1325);
      END_STATE();
    case 1459:
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 1460:
      if (lookahead == 'm') ADVANCE(293);
      END_STATE();
    case 1461:
      if (lookahead == 'm') ADVANCE(293);
      if (lookahead == 'r') ADVANCE(1584);
      END_STATE();
    case 1462:
      if (lookahead == 'm') ADVANCE(510);
      END_STATE();
    case 1463:
      if (lookahead == 'm') ADVANCE(316);
      END_STATE();
    case 1464:
      if (lookahead == 'm') ADVANCE(362);
      END_STATE();
    case 1465:
      if (lookahead == 'm') ADVANCE(361);
      END_STATE();
    case 1466:
      if (lookahead == 'm') ADVANCE(528);
      END_STATE();
    case 1467:
      if (lookahead == 'm') ADVANCE(1312);
      END_STATE();
    case 1468:
      if (lookahead == 'm') ADVANCE(1219);
      END_STATE();
    case 1469:
      if (lookahead == 'm') ADVANCE(246);
      END_STATE();
    case 1470:
      if (lookahead == 'm') ADVANCE(1673);
      END_STATE();
    case 1471:
      if (lookahead == 'm') ADVANCE(1703);
      END_STATE();
    case 1472:
      if (lookahead == 'm') ADVANCE(1684);
      END_STATE();
    case 1473:
      if (lookahead == 'm') ADVANCE(1218);
      END_STATE();
    case 1474:
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'p') ADVANCE(679);
      END_STATE();
    case 1475:
      if (lookahead == 'm') ADVANCE(1466);
      END_STATE();
    case 1476:
      if (lookahead == 'm') ADVANCE(254);
      END_STATE();
    case 1477:
      if (lookahead == 'm') ADVANCE(1707);
      END_STATE();
    case 1478:
      if (lookahead == 'm') ADVANCE(255);
      END_STATE();
    case 1479:
      if (lookahead == 'm') ADVANCE(568);
      END_STATE();
    case 1480:
      if (lookahead == 'm') ADVANCE(992);
      END_STATE();
    case 1481:
      if (lookahead == 'm') ADVANCE(1354);
      END_STATE();
    case 1482:
      if (lookahead == 'm') ADVANCE(1500);
      END_STATE();
    case 1483:
      if (lookahead == 'm') ADVANCE(922);
      END_STATE();
    case 1484:
      if (lookahead == 'm') ADVANCE(1699);
      END_STATE();
    case 1485:
      if (lookahead == 'm') ADVANCE(1694);
      END_STATE();
    case 1486:
      if (lookahead == 'm') ADVANCE(684);
      END_STATE();
    case 1487:
      if (lookahead == 'm') ADVANCE(556);
      END_STATE();
    case 1488:
      if (lookahead == 'm') ADVANCE(563);
      if (lookahead == 'p') ADVANCE(274);
      END_STATE();
    case 1489:
      if (lookahead == 'm') ADVANCE(955);
      END_STATE();
    case 1490:
      if (lookahead == 'm') ADVANCE(955);
      if (lookahead == 'x') ADVANCE(989);
      END_STATE();
    case 1491:
      if (lookahead == 'm') ADVANCE(552);
      END_STATE();
    case 1492:
      if (lookahead == 'm') ADVANCE(536);
      END_STATE();
    case 1493:
      if (lookahead == 'm') ADVANCE(989);
      END_STATE();
    case 1494:
      if (lookahead == 'm') ADVANCE(1715);
      END_STATE();
    case 1495:
      if (lookahead == 'm') ADVANCE(975);
      END_STATE();
    case 1496:
      if (lookahead == 'm') ADVANCE(1487);
      END_STATE();
    case 1497:
      if (lookahead == 'm') ADVANCE(1311);
      END_STATE();
    case 1498:
      if (lookahead == 'm') ADVANCE(678);
      END_STATE();
    case 1499:
      if (lookahead == 'n') ADVANCE(877);
      END_STATE();
    case 1500:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 1501:
      if (lookahead == 'n') ADVANCE(276);
      END_STATE();
    case 1502:
      if (lookahead == 'n') ADVANCE(418);
      END_STATE();
    case 1503:
      if (lookahead == 'n') ADVANCE(510);
      END_STATE();
    case 1504:
      if (lookahead == 'n') ADVANCE(692);
      END_STATE();
    case 1505:
      if (lookahead == 'n') ADVANCE(238);
      END_STATE();
    case 1506:
      if (lookahead == 'n') ADVANCE(836);
      END_STATE();
    case 1507:
      if (lookahead == 'n') ADVANCE(2156);
      END_STATE();
    case 1508:
      if (lookahead == 'n') ADVANCE(166);
      END_STATE();
    case 1509:
      if (lookahead == 'n') ADVANCE(517);
      END_STATE();
    case 1510:
      if (lookahead == 'n') ADVANCE(521);
      END_STATE();
    case 1511:
      if (lookahead == 'n') ADVANCE(184);
      END_STATE();
    case 1512:
      if (lookahead == 'n') ADVANCE(1954);
      END_STATE();
    case 1513:
      if (lookahead == 'n') ADVANCE(432);
      END_STATE();
    case 1514:
      if (lookahead == 'n') ADVANCE(483);
      END_STATE();
    case 1515:
      if (lookahead == 'n') ADVANCE(239);
      END_STATE();
    case 1516:
      if (lookahead == 'n') ADVANCE(2132);
      END_STATE();
    case 1517:
      if (lookahead == 'n') ADVANCE(412);
      END_STATE();
    case 1518:
      if (lookahead == 'n') ADVANCE(1114);
      END_STATE();
    case 1519:
      if (lookahead == 'n') ADVANCE(912);
      END_STATE();
    case 1520:
      if (lookahead == 'n') ADVANCE(246);
      END_STATE();
    case 1521:
      if (lookahead == 'n') ADVANCE(1116);
      END_STATE();
    case 1522:
      if (lookahead == 'n') ADVANCE(1116);
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 1523:
      if (lookahead == 'n') ADVANCE(2014);
      END_STATE();
    case 1524:
      if (lookahead == 'n') ADVANCE(1122);
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 'w') ADVANCE(1023);
      END_STATE();
    case 1525:
      if (lookahead == 'n') ADVANCE(351);
      END_STATE();
    case 1526:
      if (lookahead == 'n') ADVANCE(1335);
      END_STATE();
    case 1527:
      if (lookahead == 'n') ADVANCE(254);
      END_STATE();
    case 1528:
      if (lookahead == 'n') ADVANCE(1899);
      END_STATE();
    case 1529:
      if (lookahead == 'n') ADVANCE(885);
      END_STATE();
    case 1530:
      if (lookahead == 'n') ADVANCE(249);
      END_STATE();
    case 1531:
      if (lookahead == 'n') ADVANCE(1146);
      if (lookahead == 'r') ADVANCE(1003);
      END_STATE();
    case 1532:
      if (lookahead == 'n') ADVANCE(842);
      END_STATE();
    case 1533:
      if (lookahead == 'n') ADVANCE(1162);
      END_STATE();
    case 1534:
      if (lookahead == 'n') ADVANCE(922);
      END_STATE();
    case 1535:
      if (lookahead == 'n') ADVANCE(1120);
      END_STATE();
    case 1536:
      if (lookahead == 'n') ADVANCE(870);
      END_STATE();
    case 1537:
      if (lookahead == 'n') ADVANCE(1630);
      END_STATE();
    case 1538:
      if (lookahead == 'n') ADVANCE(1148);
      END_STATE();
    case 1539:
      if (lookahead == 'n') ADVANCE(895);
      END_STATE();
    case 1540:
      if (lookahead == 'n') ADVANCE(1175);
      END_STATE();
    case 1541:
      if (lookahead == 'n') ADVANCE(953);
      END_STATE();
    case 1542:
      if (lookahead == 'n') ADVANCE(1123);
      END_STATE();
    case 1543:
      if (lookahead == 'n') ADVANCE(865);
      END_STATE();
    case 1544:
      if (lookahead == 'n') ADVANCE(2032);
      END_STATE();
    case 1545:
      if (lookahead == 'n') ADVANCE(1965);
      END_STATE();
    case 1546:
      if (lookahead == 'n') ADVANCE(1979);
      END_STATE();
    case 1547:
      if (lookahead == 'n') ADVANCE(2004);
      END_STATE();
    case 1548:
      if (lookahead == 'n') ADVANCE(2006);
      END_STATE();
    case 1549:
      if (lookahead == 'n') ADVANCE(984);
      END_STATE();
    case 1550:
      if (lookahead == 'n') ADVANCE(987);
      END_STATE();
    case 1551:
      if (lookahead == 'n') ADVANCE(1424);
      END_STATE();
    case 1552:
      if (lookahead == 'n') ADVANCE(2063);
      END_STATE();
    case 1553:
      if (lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 1554:
      if (lookahead == 'n') ADVANCE(1141);
      END_STATE();
    case 1555:
      if (lookahead == 'n') ADVANCE(1144);
      END_STATE();
    case 1556:
      if (lookahead == 'n') ADVANCE(1069);
      END_STATE();
    case 1557:
      if (lookahead == 'n') ADVANCE(1254);
      END_STATE();
    case 1558:
      if (lookahead == 'n') ADVANCE(2022);
      END_STATE();
    case 1559:
      if (lookahead == 'n') ADVANCE(2061);
      END_STATE();
    case 1560:
      if (lookahead == 'n') ADVANCE(1635);
      END_STATE();
    case 1561:
      if (lookahead == 'n') ADVANCE(2023);
      END_STATE();
    case 1562:
      if (lookahead == 'n') ADVANCE(1231);
      END_STATE();
    case 1563:
      if (lookahead == 'n') ADVANCE(2021);
      END_STATE();
    case 1564:
      if (lookahead == 'n') ADVANCE(2041);
      END_STATE();
    case 1565:
      if (lookahead == 'n') ADVANCE(652);
      END_STATE();
    case 1566:
      if (lookahead == 'n') ADVANCE(2033);
      END_STATE();
    case 1567:
      if (lookahead == 'n') ADVANCE(1167);
      END_STATE();
    case 1568:
      if (lookahead == 'n') ADVANCE(2031);
      END_STATE();
    case 1569:
      if (lookahead == 'n') ADVANCE(1310);
      END_STATE();
    case 1570:
      if (lookahead == 'n') ADVANCE(1072);
      END_STATE();
    case 1571:
      if (lookahead == 'n') ADVANCE(1169);
      if (lookahead == 'r') ADVANCE(1849);
      END_STATE();
    case 1572:
      if (lookahead == 'n') ADVANCE(1169);
      if (lookahead == 'r') ADVANCE(1853);
      END_STATE();
    case 1573:
      if (lookahead == 'n') ADVANCE(2035);
      END_STATE();
    case 1574:
      if (lookahead == 'n') ADVANCE(1170);
      END_STATE();
    case 1575:
      if (lookahead == 'n') ADVANCE(1171);
      END_STATE();
    case 1576:
      if (lookahead == 'n') ADVANCE(2037);
      END_STATE();
    case 1577:
      if (lookahead == 'n') ADVANCE(1172);
      END_STATE();
    case 1578:
      if (lookahead == 'n') ADVANCE(1173);
      END_STATE();
    case 1579:
      if (lookahead == 'n') ADVANCE(1174);
      END_STATE();
    case 1580:
      if (lookahead == 'n') ADVANCE(2042);
      END_STATE();
    case 1581:
      if (lookahead == 'n') ADVANCE(701);
      END_STATE();
    case 1582:
      if (lookahead == 'n') ADVANCE(690);
      END_STATE();
    case 1583:
      if (lookahead == 'o') ADVANCE(877);
      END_STATE();
    case 1584:
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 1585:
      if (lookahead == 'o') ADVANCE(326);
      END_STATE();
    case 1586:
      if (lookahead == 'o') ADVANCE(1092);
      END_STATE();
    case 1587:
      if (lookahead == 'o') ADVANCE(2123);
      END_STATE();
    case 1588:
      if (lookahead == 'o') ADVANCE(522);
      END_STATE();
    case 1589:
      if (lookahead == 'o') ADVANCE(2102);
      END_STATE();
    case 1590:
      if (lookahead == 'o') ADVANCE(243);
      END_STATE();
    case 1591:
      if (lookahead == 'o') ADVANCE(1956);
      END_STATE();
    case 1592:
      if (lookahead == 'o') ADVANCE(1955);
      END_STATE();
    case 1593:
      if (lookahead == 'o') ADVANCE(1746);
      END_STATE();
    case 1594:
      if (lookahead == 'o') ADVANCE(1954);
      END_STATE();
    case 1595:
      if (lookahead == 'o') ADVANCE(1954);
      if (lookahead == 's') ADVANCE(2055);
      END_STATE();
    case 1596:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 1597:
      if (lookahead == 'o') ADVANCE(2134);
      END_STATE();
    case 1598:
      if (lookahead == 'o') ADVANCE(825);
      END_STATE();
    case 1599:
      if (lookahead == 'o') ADVANCE(2132);
      END_STATE();
    case 1600:
      if (lookahead == 'o') ADVANCE(1925);
      END_STATE();
    case 1601:
      if (lookahead == 'o') ADVANCE(342);
      END_STATE();
    case 1602:
      if (lookahead == 'o') ADVANCE(2112);
      END_STATE();
    case 1603:
      if (lookahead == 'o') ADVANCE(2152);
      END_STATE();
    case 1604:
      if (lookahead == 'o') ADVANCE(1673);
      END_STATE();
    case 1605:
      if (lookahead == 'o') ADVANCE(1562);
      END_STATE();
    case 1606:
      if (lookahead == 'o') ADVANCE(2113);
      END_STATE();
    case 1607:
      if (lookahead == 'o') ADVANCE(2114);
      END_STATE();
    case 1608:
      if (lookahead == 'o') ADVANCE(1459);
      END_STATE();
    case 1609:
      if (lookahead == 'o') ADVANCE(1335);
      END_STATE();
    case 1610:
      if (lookahead == 'o') ADVANCE(2009);
      END_STATE();
    case 1611:
      if (lookahead == 'o') ADVANCE(2115);
      END_STATE();
    case 1612:
      if (lookahead == 'o') ADVANCE(2128);
      END_STATE();
    case 1613:
      if (lookahead == 'o') ADVANCE(1899);
      END_STATE();
    case 1614:
      if (lookahead == 'o') ADVANCE(1521);
      END_STATE();
    case 1615:
      if (lookahead == 'o') ADVANCE(1521);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1616:
      if (lookahead == 'o') ADVANCE(2129);
      END_STATE();
    case 1617:
      if (lookahead == 'o') ADVANCE(2121);
      END_STATE();
    case 1618:
      if (lookahead == 'o') ADVANCE(2116);
      END_STATE();
    case 1619:
      if (lookahead == 'o') ADVANCE(1354);
      if (lookahead == 'u') ADVANCE(714);
      END_STATE();
    case 1620:
      if (lookahead == 'o') ADVANCE(900);
      END_STATE();
    case 1621:
      if (lookahead == 'o') ADVANCE(1528);
      END_STATE();
    case 1622:
      if (lookahead == 'o') ADVANCE(2119);
      END_STATE();
    case 1623:
      if (lookahead == 'o') ADVANCE(1960);
      END_STATE();
    case 1624:
      if (lookahead == 'o') ADVANCE(1800);
      END_STATE();
    case 1625:
      if (lookahead == 'o') ADVANCE(1500);
      END_STATE();
    case 1626:
      if (lookahead == 'o') ADVANCE(1500);
      if (lookahead == 'r') ADVANCE(560);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 1627:
      if (lookahead == 'o') ADVANCE(1520);
      END_STATE();
    case 1628:
      if (lookahead == 'o') ADVANCE(1556);
      END_STATE();
    case 1629:
      if (lookahead == 'o') ADVANCE(1511);
      END_STATE();
    case 1630:
      if (lookahead == 'o') ADVANCE(2098);
      END_STATE();
    case 1631:
      if (lookahead == 'o') ADVANCE(1499);
      END_STATE();
    case 1632:
      if (lookahead == 'o') ADVANCE(1527);
      END_STATE();
    case 1633:
      if (lookahead == 'o') ADVANCE(2100);
      END_STATE();
    case 1634:
      if (lookahead == 'o') ADVANCE(1593);
      END_STATE();
    case 1635:
      if (lookahead == 'o') ADVANCE(2046);
      END_STATE();
    case 1636:
      if (lookahead == 'o') ADVANCE(1353);
      END_STATE();
    case 1637:
      if (lookahead == 'o') ADVANCE(824);
      END_STATE();
    case 1638:
      if (lookahead == 'o') ADVANCE(1995);
      END_STATE();
    case 1639:
      if (lookahead == 'o') ADVANCE(1997);
      END_STATE();
    case 1640:
      if (lookahead == 'o') ADVANCE(2039);
      END_STATE();
    case 1641:
      if (lookahead == 'o') ADVANCE(1551);
      END_STATE();
    case 1642:
      if (lookahead == 'o') ADVANCE(1553);
      END_STATE();
    case 1643:
      if (lookahead == 'o') ADVANCE(1519);
      END_STATE();
    case 1644:
      if (lookahead == 'o') ADVANCE(1812);
      if (lookahead == 'r') ADVANCE(1604);
      END_STATE();
    case 1645:
      if (lookahead == 'o') ADVANCE(1837);
      END_STATE();
    case 1646:
      if (lookahead == 'o') ADVANCE(1839);
      if (lookahead == 'r') ADVANCE(1604);
      END_STATE();
    case 1647:
      if (lookahead == 'o') ADVANCE(1763);
      END_STATE();
    case 1648:
      if (lookahead == 'o') ADVANCE(2124);
      END_STATE();
    case 1649:
      if (lookahead == 'o') ADVANCE(1475);
      END_STATE();
    case 1650:
      if (lookahead == 'o') ADVANCE(1475);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1651:
      if (lookahead == 'o') ADVANCE(1818);
      END_STATE();
    case 1652:
      if (lookahead == 'o') ADVANCE(1702);
      END_STATE();
    case 1653:
      if (lookahead == 'o') ADVANCE(1713);
      END_STATE();
    case 1654:
      if (lookahead == 'o') ADVANCE(2082);
      END_STATE();
    case 1655:
      if (lookahead == 'o') ADVANCE(2130);
      END_STATE();
    case 1656:
      if (lookahead == 'o') ADVANCE(2125);
      END_STATE();
    case 1657:
      if (lookahead == 'o') ADVANCE(2088);
      END_STATE();
    case 1658:
      if (lookahead == 'o') ADVANCE(2003);
      END_STATE();
    case 1659:
      if (lookahead == 'o') ADVANCE(1555);
      if (lookahead == 'u') ADVANCE(1693);
      END_STATE();
    case 1660:
      if (lookahead == 'o') ADVANCE(2126);
      END_STATE();
    case 1661:
      if (lookahead == 'o') ADVANCE(1568);
      END_STATE();
    case 1662:
      if (lookahead == 'o') ADVANCE(1833);
      END_STATE();
    case 1663:
      if (lookahead == 'o') ADVANCE(1641);
      END_STATE();
    case 1664:
      if (lookahead == 'o') ADVANCE(1814);
      END_STATE();
    case 1665:
      if (lookahead == 'o') ADVANCE(1547);
      END_STATE();
    case 1666:
      if (lookahead == 'o') ADVANCE(1621);
      END_STATE();
    case 1667:
      if (lookahead == 'o') ADVANCE(1643);
      END_STATE();
    case 1668:
      if (lookahead == 'o') ADVANCE(1879);
      END_STATE();
    case 1669:
      if (lookahead == 'o') ADVANCE(1450);
      END_STATE();
    case 1670:
      if (lookahead == 'o') ADVANCE(2103);
      END_STATE();
    case 1671:
      if (lookahead == 'o') ADVANCE(2131);
      END_STATE();
    case 1672:
      if (lookahead == 'p') ADVANCE(1950);
      END_STATE();
    case 1673:
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 1674:
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1625);
      END_STATE();
    case 1675:
      if (lookahead == 'p') ADVANCE(1182);
      END_STATE();
    case 1676:
      if (lookahead == 'p') ADVANCE(1092);
      END_STATE();
    case 1677:
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 'r') ADVANCE(671);
      END_STATE();
    case 1678:
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 'r') ADVANCE(410);
      if (lookahead == 'u') ADVANCE(1830);
      END_STATE();
    case 1679:
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 'r') ADVANCE(1224);
      END_STATE();
    case 1680:
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 't') ADVANCE(161);
      if (lookahead == 'u') ADVANCE(739);
      if (lookahead == 'w') ADVANCE(1502);
      END_STATE();
    case 1681:
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 't') ADVANCE(350);
      if (lookahead == 'w') ADVANCE(2015);
      if (lookahead == 'x') ADVANCE(445);
      END_STATE();
    case 1682:
      if (lookahead == 'p') ADVANCE(1092);
      if (lookahead == 'u') ADVANCE(1529);
      END_STATE();
    case 1683:
      if (lookahead == 'p') ADVANCE(160);
      END_STATE();
    case 1684:
      if (lookahead == 'p') ADVANCE(454);
      END_STATE();
    case 1685:
      if (lookahead == 'p') ADVANCE(167);
      END_STATE();
    case 1686:
      if (lookahead == 'p') ADVANCE(141);
      END_STATE();
    case 1687:
      if (lookahead == 'p') ADVANCE(455);
      END_STATE();
    case 1688:
      if (lookahead == 'p') ADVANCE(413);
      END_STATE();
    case 1689:
      if (lookahead == 'p') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(758);
      END_STATE();
    case 1690:
      if (lookahead == 'p') ADVANCE(528);
      END_STATE();
    case 1691:
      if (lookahead == 'p') ADVANCE(320);
      END_STATE();
    case 1692:
      if (lookahead == 'p') ADVANCE(412);
      END_STATE();
    case 1693:
      if (lookahead == 'p') ADVANCE(428);
      END_STATE();
    case 1694:
      if (lookahead == 'p') ADVANCE(246);
      END_STATE();
    case 1695:
      if (lookahead == 'p') ADVANCE(330);
      END_STATE();
    case 1696:
      if (lookahead == 'p') ADVANCE(1179);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 1697:
      if (lookahead == 'p') ADVANCE(1690);
      END_STATE();
    case 1698:
      if (lookahead == 'p') ADVANCE(1899);
      if (lookahead == 'r') ADVANCE(1625);
      END_STATE();
    case 1699:
      if (lookahead == 'p') ADVANCE(255);
      END_STATE();
    case 1700:
      if (lookahead == 'p') ADVANCE(1365);
      END_STATE();
    case 1701:
      if (lookahead == 'p') ADVANCE(1710);
      END_STATE();
    case 1702:
      if (lookahead == 'p') ADVANCE(922);
      END_STATE();
    case 1703:
      if (lookahead == 'p') ADVANCE(969);
      END_STATE();
    case 1704:
      if (lookahead == 'p') ADVANCE(1444);
      END_STATE();
    case 1705:
      if (lookahead == 'p') ADVANCE(1444);
      if (lookahead == 't') ADVANCE(1781);
      END_STATE();
    case 1706:
      if (lookahead == 'p') ADVANCE(1922);
      END_STATE();
    case 1707:
      if (lookahead == 'p') ADVANCE(1994);
      END_STATE();
    case 1708:
      if (lookahead == 'p') ADVANCE(1720);
      END_STATE();
    case 1709:
      if (lookahead == 'p') ADVANCE(1720);
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 1710:
      if (lookahead == 'p') ADVANCE(548);
      END_STATE();
    case 1711:
      if (lookahead == 'p') ADVANCE(1663);
      END_STATE();
    case 1712:
      if (lookahead == 'p') ADVANCE(1446);
      END_STATE();
    case 1713:
      if (lookahead == 'p') ADVANCE(1985);
      END_STATE();
    case 1714:
      if (lookahead == 'p') ADVANCE(1613);
      END_STATE();
    case 1715:
      if (lookahead == 'p') ADVANCE(1410);
      END_STATE();
    case 1716:
      if (lookahead == 'p') ADVANCE(668);
      END_STATE();
    case 1717:
      if (lookahead == 'p') ADVANCE(1940);
      END_STATE();
    case 1718:
      if (lookahead == 'p') ADVANCE(1845);
      if (lookahead == 's') ADVANCE(2073);
      END_STATE();
    case 1719:
      if (lookahead == 'p') ADVANCE(1422);
      END_STATE();
    case 1720:
      if (lookahead == 'p') ADVANCE(1825);
      END_STATE();
    case 1721:
      if (lookahead == 'p') ADVANCE(650);
      END_STATE();
    case 1722:
      if (lookahead == 'p') ADVANCE(699);
      END_STATE();
    case 1723:
      if (lookahead == 'p') ADVANCE(466);
      END_STATE();
    case 1724:
      if (lookahead == 'p') ADVANCE(1667);
      END_STATE();
    case 1725:
      if (lookahead == 'p') ADVANCE(683);
      END_STATE();
    case 1726:
      if (lookahead == 'p') ADVANCE(1666);
      END_STATE();
    case 1727:
      if (lookahead == 'p') ADVANCE(701);
      END_STATE();
    case 1728:
      if (lookahead == 'q') ADVANCE(148);
      END_STATE();
    case 1729:
      if (lookahead == 'q') ADVANCE(236);
      END_STATE();
    case 1730:
      if (lookahead == 'q') ADVANCE(1415);
      END_STATE();
    case 1731:
      if (lookahead == 'q') ADVANCE(1153);
      END_STATE();
    case 1732:
      if (lookahead == 'q') ADVANCE(1718);
      END_STATE();
    case 1733:
      if (lookahead == 'q') ADVANCE(321);
      END_STATE();
    case 1734:
      if (lookahead == 'q') ADVANCE(1728);
      END_STATE();
    case 1735:
      if (lookahead == 'q') ADVANCE(2049);
      END_STATE();
    case 1736:
      if (lookahead == 'q') ADVANCE(2068);
      END_STATE();
    case 1737:
      if (lookahead == 'q') ADVANCE(2101);
      if (lookahead == 'u') ADVANCE(737);
      END_STATE();
    case 1738:
      if (lookahead == 'q') ADVANCE(2089);
      END_STATE();
    case 1739:
      if (lookahead == 'q') ADVANCE(2078);
      END_STATE();
    case 1740:
      if (lookahead == 'q') ADVANCE(843);
      if (lookahead == 't') ADVANCE(542);
      END_STATE();
    case 1741:
      if (lookahead == 'q') ADVANCE(2092);
      END_STATE();
    case 1742:
      if (lookahead == 'q') ADVANCE(2096);
      END_STATE();
    case 1743:
      if (lookahead == 'q') ADVANCE(2099);
      END_STATE();
    case 1744:
      if (lookahead == 'r') ADVANCE(877);
      END_STATE();
    case 1745:
      if (lookahead == 'r') ADVANCE(931);
      END_STATE();
    case 1746:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1747:
      if (lookahead == 'r') ADVANCE(435);
      END_STATE();
    case 1748:
      if (lookahead == 'r') ADVANCE(305);
      END_STATE();
    case 1749:
      if (lookahead == 'r') ADVANCE(1092);
      END_STATE();
    case 1750:
      if (lookahead == 'r') ADVANCE(224);
      END_STATE();
    case 1751:
      if (lookahead == 'r') ADVANCE(318);
      END_STATE();
    case 1752:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 1753:
      if (lookahead == 'r') ADVANCE(801);
      END_STATE();
    case 1754:
      if (lookahead == 'r') ADVANCE(419);
      END_STATE();
    case 1755:
      if (lookahead == 'r') ADVANCE(2164);
      END_STATE();
    case 1756:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 1757:
      if (lookahead == 'r') ADVANCE(220);
      END_STATE();
    case 1758:
      if (lookahead == 'r') ADVANCE(1192);
      END_STATE();
    case 1759:
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 1760:
      if (lookahead == 'r') ADVANCE(492);
      END_STATE();
    case 1761:
      if (lookahead == 'r') ADVANCE(360);
      END_STATE();
    case 1762:
      if (lookahead == 'r') ADVANCE(2168);
      END_STATE();
    case 1763:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 1764:
      if (lookahead == 'r') ADVANCE(171);
      END_STATE();
    case 1765:
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 1766:
      if (lookahead == 'r') ADVANCE(311);
      END_STATE();
    case 1767:
      if (lookahead == 'r') ADVANCE(474);
      END_STATE();
    case 1768:
      if (lookahead == 'r') ADVANCE(751);
      END_STATE();
    case 1769:
      if (lookahead == 'r') ADVANCE(354);
      END_STATE();
    case 1770:
      if (lookahead == 'r') ADVANCE(278);
      END_STATE();
    case 1771:
      if (lookahead == 'r') ADVANCE(1954);
      END_STATE();
    case 1772:
      if (lookahead == 'r') ADVANCE(1954);
      if (lookahead == 'u') ADVANCE(685);
      END_STATE();
    case 1773:
      if (lookahead == 'r') ADVANCE(239);
      END_STATE();
    case 1774:
      if (lookahead == 'r') ADVANCE(904);
      END_STATE();
    case 1775:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 1776:
      if (lookahead == 'r') ADVANCE(223);
      END_STATE();
    case 1777:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 1778:
      if (lookahead == 'r') ADVANCE(486);
      END_STATE();
    case 1779:
      if (lookahead == 'r') ADVANCE(750);
      END_STATE();
    case 1780:
      if (lookahead == 'r') ADVANCE(579);
      END_STATE();
    case 1781:
      if (lookahead == 'r') ADVANCE(1219);
      END_STATE();
    case 1782:
      if (lookahead == 'r') ADVANCE(313);
      END_STATE();
    case 1783:
      if (lookahead == 'r') ADVANCE(296);
      END_STATE();
    case 1784:
      if (lookahead == 'r') ADVANCE(302);
      END_STATE();
    case 1785:
      if (lookahead == 'r') ADVANCE(880);
      END_STATE();
    case 1786:
      if (lookahead == 'r') ADVANCE(872);
      END_STATE();
    case 1787:
      if (lookahead == 'r') ADVANCE(1584);
      END_STATE();
    case 1788:
      if (lookahead == 'r') ADVANCE(307);
      END_STATE();
    case 1789:
      if (lookahead == 'r') ADVANCE(1345);
      END_STATE();
    case 1790:
      if (lookahead == 'r') ADVANCE(336);
      END_STATE();
    case 1791:
      if (lookahead == 'r') ADVANCE(431);
      END_STATE();
    case 1792:
      if (lookahead == 'r') ADVANCE(347);
      END_STATE();
    case 1793:
      if (lookahead == 'r') ADVANCE(862);
      END_STATE();
    case 1794:
      if (lookahead == 'r') ADVANCE(1673);
      END_STATE();
    case 1795:
      if (lookahead == 'r') ADVANCE(999);
      END_STATE();
    case 1796:
      if (lookahead == 'r') ADVANCE(2014);
      END_STATE();
    case 1797:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 1798:
      if (lookahead == 'r') ADVANCE(533);
      END_STATE();
    case 1799:
      if (lookahead == 'r') ADVANCE(1625);
      END_STATE();
    case 1800:
      if (lookahead == 'r') ADVANCE(1335);
      END_STATE();
    case 1801:
      if (lookahead == 'r') ADVANCE(2142);
      END_STATE();
    case 1802:
      if (lookahead == 'r') ADVANCE(2144);
      END_STATE();
    case 1803:
      if (lookahead == 'r') ADVANCE(1588);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 1804:
      if (lookahead == 'r') ADVANCE(1899);
      END_STATE();
    case 1805:
      if (lookahead == 'r') ADVANCE(992);
      END_STATE();
    case 1806:
      if (lookahead == 'r') ADVANCE(1583);
      END_STATE();
    case 1807:
      if (lookahead == 'r') ADVANCE(560);
      END_STATE();
    case 1808:
      if (lookahead == 'r') ADVANCE(2120);
      END_STATE();
    case 1809:
      if (lookahead == 'r') ADVANCE(2143);
      END_STATE();
    case 1810:
      if (lookahead == 'r') ADVANCE(1050);
      END_STATE();
    case 1811:
      if (lookahead == 'r') ADVANCE(1191);
      END_STATE();
    case 1812:
      if (lookahead == 'r') ADVANCE(1500);
      END_STATE();
    case 1813:
      if (lookahead == 'r') ADVANCE(758);
      END_STATE();
    case 1814:
      if (lookahead == 'r') ADVANCE(922);
      END_STATE();
    case 1815:
      if (lookahead == 'r') ADVANCE(1604);
      END_STATE();
    case 1816:
      if (lookahead == 'r') ADVANCE(1296);
      END_STATE();
    case 1817:
      if (lookahead == 'r') ADVANCE(1609);
      END_STATE();
    case 1818:
      if (lookahead == 'r') ADVANCE(1962);
      END_STATE();
    case 1819:
      if (lookahead == 'r') ADVANCE(1597);
      END_STATE();
    case 1820:
      if (lookahead == 'r') ADVANCE(1919);
      END_STATE();
    case 1821:
      if (lookahead == 'r') ADVANCE(831);
      END_STATE();
    case 1822:
      if (lookahead == 'r') ADVANCE(1602);
      END_STATE();
    case 1823:
      if (lookahead == 'r') ADVANCE(1755);
      END_STATE();
    case 1824:
      if (lookahead == 'r') ADVANCE(596);
      END_STATE();
    case 1825:
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 1826:
      if (lookahead == 'r') ADVANCE(2032);
      END_STATE();
    case 1827:
      if (lookahead == 'r') ADVANCE(1711);
      END_STATE();
    case 1828:
      if (lookahead == 'r') ADVANCE(2025);
      END_STATE();
    case 1829:
      if (lookahead == 'r') ADVANCE(1941);
      END_STATE();
    case 1830:
      if (lookahead == 'r') ADVANCE(1305);
      END_STATE();
    case 1831:
      if (lookahead == 'r') ADVANCE(1949);
      END_STATE();
    case 1832:
      if (lookahead == 'r') ADVANCE(974);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 1833:
      if (lookahead == 'r') ADVANCE(1978);
      END_STATE();
    case 1834:
      if (lookahead == 'r') ADVANCE(599);
      END_STATE();
    case 1835:
      if (lookahead == 'r') ADVANCE(1267);
      END_STATE();
    case 1836:
      if (lookahead == 'r') ADVANCE(1606);
      END_STATE();
    case 1837:
      if (lookahead == 'r') ADVANCE(1541);
      END_STATE();
    case 1838:
      if (lookahead == 'r') ADVANCE(1927);
      END_STATE();
    case 1839:
      if (lookahead == 'r') ADVANCE(1530);
      END_STATE();
    case 1840:
      if (lookahead == 'r') ADVANCE(1245);
      END_STATE();
    case 1841:
      if (lookahead == 'r') ADVANCE(1569);
      END_STATE();
    case 1842:
      if (lookahead == 'r') ADVANCE(1393);
      END_STATE();
    case 1843:
      if (lookahead == 'r') ADVANCE(1302);
      END_STATE();
    case 1844:
      if (lookahead == 'r') ADVANCE(1397);
      END_STATE();
    case 1845:
      if (lookahead == 'r') ADVANCE(997);
      END_STATE();
    case 1846:
      if (lookahead == 'r') ADVANCE(1607);
      END_STATE();
    case 1847:
      if (lookahead == 'r') ADVANCE(1958);
      END_STATE();
    case 1848:
      if (lookahead == 'r') ADVANCE(938);
      if (lookahead == 't') ADVANCE(559);
      END_STATE();
    case 1849:
      if (lookahead == 'r') ADVANCE(1611);
      END_STATE();
    case 1850:
      if (lookahead == 'r') ADVANCE(1612);
      END_STATE();
    case 1851:
      if (lookahead == 'r') ADVANCE(1616);
      END_STATE();
    case 1852:
      if (lookahead == 'r') ADVANCE(1617);
      END_STATE();
    case 1853:
      if (lookahead == 'r') ADVANCE(1618);
      END_STATE();
    case 1854:
      if (lookahead == 'r') ADVANCE(1090);
      END_STATE();
    case 1855:
      if (lookahead == 'r') ADVANCE(941);
      END_STATE();
    case 1856:
      if (lookahead == 'r') ADVANCE(1622);
      END_STATE();
    case 1857:
      if (lookahead == 'r') ADVANCE(1761);
      END_STATE();
    case 1858:
      if (lookahead == 'r') ADVANCE(1046);
      END_STATE();
    case 1859:
      if (lookahead == 'r') ADVANCE(1751);
      END_STATE();
    case 1860:
      if (lookahead == 'r') ADVANCE(1784);
      END_STATE();
    case 1861:
      if (lookahead == 'r') ADVANCE(1065);
      END_STATE();
    case 1862:
      if (lookahead == 'r') ADVANCE(967);
      END_STATE();
    case 1863:
      if (lookahead == 'r') ADVANCE(689);
      END_STATE();
    case 1864:
      if (lookahead == 'r') ADVANCE(604);
      END_STATE();
    case 1865:
      if (lookahead == 'r') ADVANCE(649);
      END_STATE();
    case 1866:
      if (lookahead == 'r') ADVANCE(1277);
      END_STATE();
    case 1867:
      if (lookahead == 'r') ADVANCE(1942);
      END_STATE();
    case 1868:
      if (lookahead == 'r') ADVANCE(843);
      END_STATE();
    case 1869:
      if (lookahead == 'r') ADVANCE(2022);
      END_STATE();
    case 1870:
      if (lookahead == 'r') ADVANCE(1013);
      END_STATE();
    case 1871:
      if (lookahead == 'r') ADVANCE(1143);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 1872:
      if (lookahead == 'r') ADVANCE(2005);
      END_STATE();
    case 1873:
      if (lookahead == 'r') ADVANCE(2067);
      END_STATE();
    case 1874:
      if (lookahead == 'r') ADVANCE(1944);
      END_STATE();
    case 1875:
      if (lookahead == 'r') ADVANCE(1020);
      END_STATE();
    case 1876:
      if (lookahead == 'r') ADVANCE(1037);
      END_STATE();
    case 1877:
      if (lookahead == 'r') ADVANCE(1822);
      END_STATE();
    case 1878:
      if (lookahead == 'r') ADVANCE(628);
      END_STATE();
    case 1879:
      if (lookahead == 'r') ADVANCE(2020);
      END_STATE();
    case 1880:
      if (lookahead == 'r') ADVANCE(1836);
      END_STATE();
    case 1881:
      if (lookahead == 'r') ADVANCE(1846);
      END_STATE();
    case 1882:
      if (lookahead == 'r') ADVANCE(1850);
      END_STATE();
    case 1883:
      if (lookahead == 'r') ADVANCE(1851);
      END_STATE();
    case 1884:
      if (lookahead == 'r') ADVANCE(1852);
      END_STATE();
    case 1885:
      if (lookahead == 'r') ADVANCE(1856);
      END_STATE();
    case 1886:
      if (lookahead == 'r') ADVANCE(1055);
      END_STATE();
    case 1887:
      if (lookahead == 'r') ADVANCE(867);
      END_STATE();
    case 1888:
      if (lookahead == 'r') ADVANCE(1078);
      END_STATE();
    case 1889:
      if (lookahead == 'r') ADVANCE(469);
      END_STATE();
    case 1890:
      if (lookahead == 'r') ADVANCE(1724);
      END_STATE();
    case 1891:
      if (lookahead == 'r') ADVANCE(2043);
      END_STATE();
    case 1892:
      if (lookahead == 'r') ADVANCE(1726);
      END_STATE();
    case 1893:
      if (lookahead == 'r') ADVANCE(1087);
      END_STATE();
    case 1894:
      if (lookahead == 'r') ADVANCE(1088);
      END_STATE();
    case 1895:
      if (lookahead == 'r') ADVANCE(1089);
      END_STATE();
    case 1896:
      if (lookahead == 'r') ADVANCE(1329);
      END_STATE();
    case 1897:
      if (lookahead == 'r') ADVANCE(1331);
      END_STATE();
    case 1898:
      if (lookahead == 'r') ADVANCE(1332);
      END_STATE();
    case 1899:
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 1900:
      if (lookahead == 's') ADVANCE(1047);
      END_STATE();
    case 1901:
      if (lookahead == 's') ADVANCE(318);
      if (lookahead == 'u') ADVANCE(1485);
      END_STATE();
    case 1902:
      if (lookahead == 's') ADVANCE(468);
      END_STATE();
    case 1903:
      if (lookahead == 's') ADVANCE(494);
      END_STATE();
    case 1904:
      if (lookahead == 's') ADVANCE(197);
      END_STATE();
    case 1905:
      if (lookahead == 's') ADVANCE(353);
      END_STATE();
    case 1906:
      if (lookahead == 's') ADVANCE(216);
      END_STATE();
    case 1907:
      if (lookahead == 's') ADVANCE(173);
      END_STATE();
    case 1908:
      if (lookahead == 's') ADVANCE(175);
      END_STATE();
    case 1909:
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 1910:
      if (lookahead == 's') ADVANCE(1954);
      END_STATE();
    case 1911:
      if (lookahead == 's') ADVANCE(488);
      END_STATE();
    case 1912:
      if (lookahead == 's') ADVANCE(1619);
      END_STATE();
    case 1913:
      if (lookahead == 's') ADVANCE(280);
      END_STATE();
    case 1914:
      if (lookahead == 's') ADVANCE(1219);
      END_STATE();
    case 1915:
      if (lookahead == 's') ADVANCE(502);
      END_STATE();
    case 1916:
      if (lookahead == 's') ADVANCE(342);
      END_STATE();
    case 1917:
      if (lookahead == 's') ADVANCE(246);
      END_STATE();
    case 1918:
      if (lookahead == 's') ADVANCE(201);
      END_STATE();
    case 1919:
      if (lookahead == 's') ADVANCE(1673);
      END_STATE();
    case 1920:
      if (lookahead == 's') ADVANCE(1179);
      END_STATE();
    case 1921:
      if (lookahead == 's') ADVANCE(2145);
      END_STATE();
    case 1922:
      if (lookahead == 's') ADVANCE(335);
      END_STATE();
    case 1923:
      if (lookahead == 's') ADVANCE(1180);
      END_STATE();
    case 1924:
      if (lookahead == 's') ADVANCE(1184);
      END_STATE();
    case 1925:
      if (lookahead == 's') ADVANCE(1899);
      END_STATE();
    case 1926:
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 1927:
      if (lookahead == 's') ADVANCE(1354);
      END_STATE();
    case 1928:
      if (lookahead == 's') ADVANCE(2048);
      END_STATE();
    case 1929:
      if (lookahead == 's') ADVANCE(890);
      END_STATE();
    case 1930:
      if (lookahead == 's') ADVANCE(922);
      END_STATE();
    case 1931:
      if (lookahead == 's') ADVANCE(969);
      END_STATE();
    case 1932:
      if (lookahead == 's') ADVANCE(2097);
      END_STATE();
    case 1933:
      if (lookahead == 's') ADVANCE(2053);
      END_STATE();
    case 1934:
      if (lookahead == 's') ADVANCE(1999);
      END_STATE();
    case 1935:
      if (lookahead == 's') ADVANCE(1379);
      END_STATE();
    case 1936:
      if (lookahead == 's') ADVANCE(1911);
      END_STATE();
    case 1937:
      if (lookahead == 's') ADVANCE(1988);
      END_STATE();
    case 1938:
      if (lookahead == 's') ADVANCE(1992);
      END_STATE();
    case 1939:
      if (lookahead == 's') ADVANCE(1317);
      END_STATE();
    case 1940:
      if (lookahead == 's') ADVANCE(1985);
      END_STATE();
    case 1941:
      if (lookahead == 's') ADVANCE(1007);
      END_STATE();
    case 1942:
      if (lookahead == 's') ADVANCE(945);
      END_STATE();
    case 1943:
      if (lookahead == 's') ADVANCE(981);
      END_STATE();
    case 1944:
      if (lookahead == 's') ADVANCE(966);
      END_STATE();
    case 1945:
      if (lookahead == 's') ADVANCE(1189);
      END_STATE();
    case 1946:
      if (lookahead == 's') ADVANCE(2055);
      END_STATE();
    case 1947:
      if (lookahead == 's') ADVANCE(2010);
      END_STATE();
    case 1948:
      if (lookahead == 's') ADVANCE(1998);
      END_STATE();
    case 1949:
      if (lookahead == 's') ADVANCE(1012);
      END_STATE();
    case 1950:
      if (lookahead == 's') ADVANCE(1264);
      END_STATE();
    case 1951:
      if (lookahead == 's') ADVANCE(1027);
      END_STATE();
    case 1952:
      if (lookahead == 's') ADVANCE(1083);
      END_STATE();
    case 1953:
      if (lookahead == 't') ADVANCE(2135);
      END_STATE();
    case 1954:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 1955:
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(747);
      END_STATE();
    case 1956:
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == 'w') ADVANCE(1517);
      END_STATE();
    case 1957:
      if (lookahead == 't') ADVANCE(392);
      END_STATE();
    case 1958:
      if (lookahead == 't') ADVANCE(510);
      END_STATE();
    case 1959:
      if (lookahead == 't') ADVANCE(697);
      END_STATE();
    case 1960:
      if (lookahead == 't') ADVANCE(359);
      END_STATE();
    case 1961:
      if (lookahead == 't') ADVANCE(411);
      END_STATE();
    case 1962:
      if (lookahead == 't') ADVANCE(451);
      END_STATE();
    case 1963:
      if (lookahead == 't') ADVANCE(696);
      END_STATE();
    case 1964:
      if (lookahead == 't') ADVANCE(261);
      END_STATE();
    case 1965:
      if (lookahead == 't') ADVANCE(1152);
      END_STATE();
    case 1966:
      if (lookahead == 't') ADVANCE(506);
      END_STATE();
    case 1967:
      if (lookahead == 't') ADVANCE(517);
      END_STATE();
    case 1968:
      if (lookahead == 't') ADVANCE(414);
      END_STATE();
    case 1969:
      if (lookahead == 't') ADVANCE(417);
      END_STATE();
    case 1970:
      if (lookahead == 't') ADVANCE(521);
      END_STATE();
    case 1971:
      if (lookahead == 't') ADVANCE(704);
      END_STATE();
    case 1972:
      if (lookahead == 't') ADVANCE(415);
      END_STATE();
    case 1973:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 1974:
      if (lookahead == 't') ADVANCE(1746);
      END_STATE();
    case 1975:
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 1976:
      if (lookahead == 't') ADVANCE(1004);
      END_STATE();
    case 1977:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 1978:
      if (lookahead == 't') ADVANCE(1474);
      END_STATE();
    case 1979:
      if (lookahead == 't') ADVANCE(467);
      END_STATE();
    case 1980:
      if (lookahead == 't') ADVANCE(750);
      END_STATE();
    case 1981:
      if (lookahead == 't') ADVANCE(2136);
      END_STATE();
    case 1982:
      if (lookahead == 't') ADVANCE(252);
      if (lookahead == 'v') ADVANCE(1291);
      END_STATE();
    case 1983:
      if (lookahead == 't') ADVANCE(356);
      END_STATE();
    case 1984:
      if (lookahead == 't') ADVANCE(693);
      END_STATE();
    case 1985:
      if (lookahead == 't') ADVANCE(1584);
      END_STATE();
    case 1986:
      if (lookahead == 't') ADVANCE(412);
      END_STATE();
    case 1987:
      if (lookahead == 't') ADVANCE(1031);
      END_STATE();
    case 1988:
      if (lookahead == 't') ADVANCE(208);
      END_STATE();
    case 1989:
      if (lookahead == 't') ADVANCE(2140);
      END_STATE();
    case 1990:
      if (lookahead == 't') ADVANCE(246);
      END_STATE();
    case 1991:
      if (lookahead == 't') ADVANCE(518);
      END_STATE();
    case 1992:
      if (lookahead == 't') ADVANCE(330);
      END_STATE();
    case 1993:
      if (lookahead == 't') ADVANCE(1179);
      END_STATE();
    case 1994:
      if (lookahead == 't') ADVANCE(2141);
      END_STATE();
    case 1995:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 1996:
      if (lookahead == 't') ADVANCE(1184);
      END_STATE();
    case 1997:
      if (lookahead == 't') ADVANCE(308);
      END_STATE();
    case 1998:
      if (lookahead == 't') ADVANCE(1899);
      END_STATE();
    case 1999:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 2000:
      if (lookahead == 't') ADVANCE(260);
      END_STATE();
    case 2001:
      if (lookahead == 't') ADVANCE(1181);
      END_STATE();
    case 2002:
      if (lookahead == 't') ADVANCE(1482);
      END_STATE();
    case 2003:
      if (lookahead == 't') ADVANCE(922);
      END_STATE();
    case 2004:
      if (lookahead == 't') ADVANCE(1654);
      END_STATE();
    case 2005:
      if (lookahead == 't') ADVANCE(1905);
      END_STATE();
    case 2006:
      if (lookahead == 't') ADVANCE(1209);
      END_STATE();
    case 2007:
      if (lookahead == 't') ADVANCE(1497);
      END_STATE();
    case 2008:
      if (lookahead == 't') ADVANCE(953);
      END_STATE();
    case 2009:
      if (lookahead == 't') ADVANCE(1931);
      END_STATE();
    case 2010:
      if (lookahead == 't') ADVANCE(995);
      END_STATE();
    case 2011:
      if (lookahead == 't') ADVANCE(1593);
      END_STATE();
    case 2012:
      if (lookahead == 't') ADVANCE(1781);
      END_STATE();
    case 2013:
      if (lookahead == 't') ADVANCE(630);
      END_STATE();
    case 2014:
      if (lookahead == 't') ADVANCE(1290);
      END_STATE();
    case 2015:
      if (lookahead == 't') ADVANCE(1267);
      END_STATE();
    case 2016:
      if (lookahead == 't') ADVANCE(1301);
      END_STATE();
    case 2017:
      if (lookahead == 't') ADVANCE(1590);
      END_STATE();
    case 2018:
      if (lookahead == 't') ADVANCE(1292);
      END_STATE();
    case 2019:
      if (lookahead == 't') ADVANCE(1315);
      END_STATE();
    case 2020:
      if (lookahead == 't') ADVANCE(1309);
      END_STATE();
    case 2021:
      if (lookahead == 't') ADVANCE(1269);
      END_STATE();
    case 2022:
      if (lookahead == 't') ADVANCE(1749);
      END_STATE();
    case 2023:
      if (lookahead == 't') ADVANCE(1081);
      END_STATE();
    case 2024:
      if (lookahead == 't') ADVANCE(702);
      END_STATE();
    case 2025:
      if (lookahead == 't') ADVANCE(1549);
      END_STATE();
    case 2026:
      if (lookahead == 't') ADVANCE(1254);
      END_STATE();
    case 2027:
      if (lookahead == 't') ADVANCE(1647);
      END_STATE();
    case 2028:
      if (lookahead == 't') ADVANCE(1550);
      END_STATE();
    case 2029:
      if (lookahead == 't') ADVANCE(1834);
      END_STATE();
    case 2030:
      if (lookahead == 't') ADVANCE(1030);
      END_STATE();
    case 2031:
      if (lookahead == 't') ADVANCE(638);
      END_STATE();
    case 2032:
      if (lookahead == 't') ADVANCE(1231);
      END_STATE();
    case 2033:
      if (lookahead == 't') ADVANCE(1032);
      END_STATE();
    case 2034:
      if (lookahead == 't') ADVANCE(1034);
      END_STATE();
    case 2035:
      if (lookahead == 't') ADVANCE(1036);
      END_STATE();
    case 2036:
      if (lookahead == 't') ADVANCE(1039);
      END_STATE();
    case 2037:
      if (lookahead == 't') ADVANCE(1057);
      END_STATE();
    case 2038:
      if (lookahead == 't') ADVANCE(1041);
      END_STATE();
    case 2039:
      if (lookahead == 't') ADVANCE(1210);
      END_STATE();
    case 2040:
      if (lookahead == 't') ADVANCE(681);
      END_STATE();
    case 2041:
      if (lookahead == 't') ADVANCE(1300);
      END_STATE();
    case 2042:
      if (lookahead == 't') ADVANCE(1306);
      END_STATE();
    case 2043:
      if (lookahead == 't') ADVANCE(1316);
      END_STATE();
    case 2044:
      if (lookahead == 't') ADVANCE(701);
      END_STATE();
    case 2045:
      if (lookahead == 't') ADVANCE(690);
      END_STATE();
    case 2046:
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2047:
      if (lookahead == 'u') ADVANCE(618);
      END_STATE();
    case 2048:
      if (lookahead == 'u') ADVANCE(2158);
      END_STATE();
    case 2049:
      if (lookahead == 'u') ADVANCE(1584);
      END_STATE();
    case 2050:
      if (lookahead == 'u') ADVANCE(307);
      END_STATE();
    case 2051:
      if (lookahead == 'u') ADVANCE(720);
      END_STATE();
    case 2052:
      if (lookahead == 'u') ADVANCE(733);
      END_STATE();
    case 2053:
      if (lookahead == 'u') ADVANCE(731);
      END_STATE();
    case 2054:
      if (lookahead == 'u') ADVANCE(1673);
      END_STATE();
    case 2055:
      if (lookahead == 'u') ADVANCE(714);
      END_STATE();
    case 2056:
      if (lookahead == 'u') ADVANCE(1903);
      END_STATE();
    case 2057:
      if (lookahead == 'u') ADVANCE(738);
      END_STATE();
    case 2058:
      if (lookahead == 'u') ADVANCE(1990);
      END_STATE();
    case 2059:
      if (lookahead == 'u') ADVANCE(1990);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 2060:
      if (lookahead == 'u') ADVANCE(1459);
      END_STATE();
    case 2061:
      if (lookahead == 'u') ADVANCE(1899);
      END_STATE();
    case 2062:
      if (lookahead == 'u') ADVANCE(1005);
      END_STATE();
    case 2063:
      if (lookahead == 'u') ADVANCE(1915);
      END_STATE();
    case 2064:
      if (lookahead == 'u') ADVANCE(922);
      END_STATE();
    case 2065:
      if (lookahead == 'u') ADVANCE(1462);
      END_STATE();
    case 2066:
      if (lookahead == 'u') ADVANCE(803);
      END_STATE();
    case 2067:
      if (lookahead == 'u') ADVANCE(955);
      END_STATE();
    case 2068:
      if (lookahead == 'u') ADVANCE(596);
      END_STATE();
    case 2069:
      if (lookahead == 'u') ADVANCE(1906);
      END_STATE();
    case 2070:
      if (lookahead == 'u') ADVANCE(1585);
      END_STATE();
    case 2071:
      if (lookahead == 'u') ADVANCE(1370);
      END_STATE();
    case 2072:
      if (lookahead == 'u') ADVANCE(1930);
      END_STATE();
    case 2073:
      if (lookahead == 'u') ADVANCE(837);
      END_STATE();
    case 2074:
      if (lookahead == 'u') ADVANCE(1917);
      END_STATE();
    case 2075:
      if (lookahead == 'u') ADVANCE(1238);
      END_STATE();
    case 2076:
      if (lookahead == 'u') ADVANCE(990);
      END_STATE();
    case 2077:
      if (lookahead == 'u') ADVANCE(617);
      END_STATE();
    case 2078:
      if (lookahead == 'u') ADVANCE(1303);
      END_STATE();
    case 2079:
      if (lookahead == 'u') ADVANCE(1237);
      END_STATE();
    case 2080:
      if (lookahead == 'u') ADVANCE(1777);
      END_STATE();
    case 2081:
      if (lookahead == 'u') ADVANCE(1749);
      END_STATE();
    case 2082:
      if (lookahead == 'u') ADVANCE(1778);
      END_STATE();
    case 2083:
      if (lookahead == 'u') ADVANCE(1842);
      END_STATE();
    case 2084:
      if (lookahead == 'u') ADVANCE(1844);
      END_STATE();
    case 2085:
      if (lookahead == 'u') ADVANCE(1189);
      END_STATE();
    case 2086:
      if (lookahead == 'u') ADVANCE(1472);
      END_STATE();
    case 2087:
      if (lookahead == 'u') ADVANCE(1543);
      END_STATE();
    case 2088:
      if (lookahead == 'u') ADVANCE(1937);
      END_STATE();
    case 2089:
      if (lookahead == 'u') ADVANCE(1272);
      END_STATE();
    case 2090:
      if (lookahead == 'u') ADVANCE(1396);
      END_STATE();
    case 2091:
      if (lookahead == 'u') ADVANCE(2003);
      END_STATE();
    case 2092:
      if (lookahead == 'u') ADVANCE(637);
      END_STATE();
    case 2093:
      if (lookahead == 'u') ADVANCE(1412);
      END_STATE();
    case 2094:
      if (lookahead == 'u') ADVANCE(1658);
      END_STATE();
    case 2095:
      if (lookahead == 'u') ADVANCE(1470);
      END_STATE();
    case 2096:
      if (lookahead == 'u') ADVANCE(643);
      END_STATE();
    case 2097:
      if (lookahead == 'u') ADVANCE(1858);
      END_STATE();
    case 2098:
      if (lookahead == 'u') ADVANCE(1451);
      END_STATE();
    case 2099:
      if (lookahead == 'u') ADVANCE(686);
      END_STATE();
    case 2100:
      if (lookahead == 'u') ADVANCE(744);
      END_STATE();
    case 2101:
      if (lookahead == 'u') ADVANCE(688);
      END_STATE();
    case 2102:
      if (lookahead == 'u') ADVANCE(743);
      if (lookahead == 'w') ADVANCE(1509);
      END_STATE();
    case 2103:
      if (lookahead == 'u') ADVANCE(746);
      END_STATE();
    case 2104:
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 2105:
      if (lookahead == 'v') ADVANCE(148);
      if (lookahead == 'w') ADVANCE(921);
      END_STATE();
    case 2106:
      if (lookahead == 'v') ADVANCE(162);
      END_STATE();
    case 2107:
      if (lookahead == 'v') ADVANCE(246);
      END_STATE();
    case 2108:
      if (lookahead == 'v') ADVANCE(999);
      if (lookahead == 'w') ADVANCE(998);
      END_STATE();
    case 2109:
      if (lookahead == 'v') ADVANCE(922);
      END_STATE();
    case 2110:
      if (lookahead == 'v') ADVANCE(946);
      END_STATE();
    case 2111:
      if (lookahead == 'v') ADVANCE(1085);
      END_STATE();
    case 2112:
      if (lookahead == 'w') ADVANCE(148);
      END_STATE();
    case 2113:
      if (lookahead == 'w') ADVANCE(154);
      END_STATE();
    case 2114:
      if (lookahead == 'w') ADVANCE(158);
      END_STATE();
    case 2115:
      if (lookahead == 'w') ADVANCE(157);
      END_STATE();
    case 2116:
      if (lookahead == 'w') ADVANCE(156);
      END_STATE();
    case 2117:
      if (lookahead == 'w') ADVANCE(1584);
      END_STATE();
    case 2118:
      if (lookahead == 'w') ADVANCE(542);
      END_STATE();
    case 2119:
      if (lookahead == 'w') ADVANCE(330);
      END_STATE();
    case 2120:
      if (lookahead == 'w') ADVANCE(962);
      END_STATE();
    case 2121:
      if (lookahead == 'w') ADVANCE(1899);
      END_STATE();
    case 2122:
      if (lookahead == 'w') ADVANCE(1050);
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 2123:
      if (lookahead == 'w') ADVANCE(1500);
      END_STATE();
    case 2124:
      if (lookahead == 'w') ADVANCE(1517);
      END_STATE();
    case 2125:
      if (lookahead == 'w') ADVANCE(1514);
      END_STATE();
    case 2126:
      if (lookahead == 'w') ADVANCE(1510);
      END_STATE();
    case 2127:
      if (lookahead == 'w') ADVANCE(1298);
      END_STATE();
    case 2128:
      if (lookahead == 'w') ADVANCE(349);
      END_STATE();
    case 2129:
      if (lookahead == 'w') ADVANCE(1424);
      END_STATE();
    case 2130:
      if (lookahead == 'w') ADVANCE(1582);
      END_STATE();
    case 2131:
      if (lookahead == 'w') ADVANCE(1581);
      END_STATE();
    case 2132:
      if (lookahead == 'x') ADVANCE(148);
      END_STATE();
    case 2133:
      if (lookahead == 'x') ADVANCE(1954);
      END_STATE();
    case 2134:
      if (lookahead == 'x') ADVANCE(255);
      END_STATE();
    case 2135:
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 2136:
      if (lookahead == 'y') ADVANCE(509);
      END_STATE();
    case 2137:
      if (lookahead == 'y') ADVANCE(980);
      END_STATE();
    case 2138:
      if (lookahead == 'y') ADVANCE(456);
      END_STATE();
    case 2139:
      if (lookahead == 'y') ADVANCE(471);
      END_STATE();
    case 2140:
      if (lookahead == 'y') ADVANCE(338);
      END_STATE();
    case 2141:
      if (lookahead == 'y') ADVANCE(2104);
      END_STATE();
    case 2142:
      if (lookahead == 'y') ADVANCE(508);
      END_STATE();
    case 2143:
      if (lookahead == 'y') ADVANCE(515);
      END_STATE();
    case 2144:
      if (lookahead == 'y') ADVANCE(484);
      END_STATE();
    case 2145:
      if (lookahead == 'y') ADVANCE(1459);
      END_STATE();
    case 2146:
      if (lookahead == 'y') ADVANCE(921);
      END_STATE();
    case 2147:
      if (lookahead == 'y') ADVANCE(1899);
      END_STATE();
    case 2148:
      if (lookahead == 'y') ADVANCE(969);
      END_STATE();
    case 2149:
      if (lookahead == 'z') ADVANCE(1661);
      END_STATE();
    case 2150:
      if (lookahead == 'z') ADVANCE(573);
      END_STATE();
    case 2151:
      if (lookahead == 'z') ADVANCE(1277);
      END_STATE();
    case 2152:
      if (lookahead == 'z') ADVANCE(1008);
      END_STATE();
    case 2153:
      if (lookahead == '2' ||
          lookahead == '4') ADVANCE(148);
      END_STATE();
    case 2154:
      if (lookahead == '3' ||
          lookahead == '5') ADVANCE(148);
      END_STATE();
    case 2155:
      if (lookahead == '6' ||
          lookahead == '8') ADVANCE(148);
      END_STATE();
    case 2156:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 2157:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(2172);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(376);
      END_STATE();
    case 2158:
      if (lookahead == 'b' ||
          lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 2159:
      if (lookahead == 'b' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2160:
      if (lookahead == 'd' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2161:
      if (lookahead == 'e' ||
          lookahead == 'k') ADVANCE(148);
      END_STATE();
    case 2162:
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(148);
      END_STATE();
    case 2163:
      if (lookahead == 'f' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 2164:
      if (lookahead == 'l' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 2165:
      if (lookahead == 'o' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2166:
      if (lookahead == 'r' ||
          lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 2167:
      if (lookahead == '3' ||
          lookahead == '4') ADVANCE(148);
      END_STATE();
    case 2168:
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 2169:
      if (('a' <= lookahead && lookahead <= 'c')) ADVANCE(148);
      END_STATE();
    case 2170:
      if (lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 2171:
      if (('a' <= lookahead && lookahead <= 'h')) ADVANCE(148);
      END_STATE();
    case 2172:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(381);
      END_STATE();
    case 2173:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(15);
      END_STATE();
    case 2174:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 2175:
      if (eof) ADVANCE(2179);
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2196,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2202,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2187,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2212,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 2176:
      if (eof) ADVANCE(2179);
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2196,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2187,
        '=', 2207,
        '>', 2189,
        '?', 2209,
        '@', 2210,
        '[', 2183,
        '\\', 2212,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 2177:
      if (eof) ADVANCE(2179);
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2196,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2187,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2212,
        ']', 2185,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 2178:
      if (eof) ADVANCE(2179);
      ADVANCE_MAP(
        '\t', 2238,
        '\n', 2222,
        '\r', 2223,
        ' ', 2240,
        '!', 2190,
        '"', 2191,
        '#', 2192,
        '$', 2193,
        '%', 2194,
        '&', 2196,
        '\'', 2197,
        '(', 2220,
        ')', 2221,
        '*', 2198,
        '+', 2199,
        ',', 2200,
        '-', 2201,
        '.', 2203,
        '/', 2204,
        ':', 2205,
        ';', 2206,
        '<', 2187,
        '=', 2207,
        '>', 2189,
        '?', 2208,
        '@', 2210,
        '[', 2183,
        '\\', 2212,
        ']', 2184,
        '^', 2213,
        '_', 2214,
        '`', 2215,
        '{', 2216,
        '|', 2217,
        '}', 2218,
        '~', 2219,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2242);
      if (lookahead != 0) ADVANCE(2241);
      END_STATE();
    case 2179:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2180:
      ACCEPT_TOKEN(sym__backslash_escape);
      END_STATE();
    case 2181:
      ACCEPT_TOKEN(sym_entity_reference);
      END_STATE();
    case 2182:
      ACCEPT_TOKEN(sym_numeric_character_reference);
      END_STATE();
    case 2183:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 2184:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 2185:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']') ADVANCE(383);
      END_STATE();
    case 2186:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 2187:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '?') ADVANCE(2232);
      if (('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(386);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(385);
      END_STATE();
    case 2188:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '?') ADVANCE(2231);
      END_STATE();
    case 2189:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 2190:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 2191:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 2192:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 2193:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 2194:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 2195:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 2196:
      ACCEPT_TOKEN(anon_sym_AMP);
      ADVANCE_MAP(
        '#', 2157,
        'A', 457,
        'B', 527,
        'C', 480,
        'D', 440,
        'E', 496,
        'F', 753,
        'G', 180,
        'H', 387,
        'I', 463,
        'J', 855,
        'K', 479,
        'L', 179,
        'M', 569,
        'N', 487,
        'O', 465,
        'P', 565,
        'Q', 519,
        'R', 420,
        'S', 476,
        'T', 477,
        'U', 546,
        'V', 449,
        'W', 807,
        'X', 1095,
        'Y', 390,
        'Z', 481,
        'a', 525,
        'b', 495,
        'c', 532,
        'd', 396,
        'e', 442,
        'f', 574,
        'g', 169,
        'h', 398,
        'i', 526,
        'j', 854,
        'k', 659,
        'l', 149,
        'm', 443,
        'n', 473,
        'o', 507,
        'p', 597,
        'q', 1096,
        'r', 388,
        's', 654,
        't', 549,
        'u', 397,
        'v', 394,
        'w', 806,
        'x', 762,
        'y', 564,
        'z', 655,
      );
      END_STATE();
    case 2197:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 2198:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 2199:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 2200:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 2201:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 2202:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(382);
      END_STATE();
    case 2203:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 2204:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 2205:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 2206:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 2207:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 2208:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 2209:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '>') ADVANCE(2233);
      END_STATE();
    case 2210:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 2211:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 2212:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (('!' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('[' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(2180);
      END_STATE();
    case 2213:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 2214:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 2215:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 2216:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 2217:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 2218:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 2219:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 2220:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 2221:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 2222:
      ACCEPT_TOKEN(sym__newline_token);
      END_STATE();
    case 2223:
      ACCEPT_TOKEN(sym__newline_token);
      if (lookahead == '\n') ADVANCE(2222);
      END_STATE();
    case 2224:
      ACCEPT_TOKEN(sym_uri_autolink);
      END_STATE();
    case 2225:
      ACCEPT_TOKEN(sym_email_autolink);
      END_STATE();
    case 2226:
      ACCEPT_TOKEN(sym__attribute_name);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2226);
      END_STATE();
    case 2227:
      ACCEPT_TOKEN(aux_sym__attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '`') ADVANCE(2227);
      END_STATE();
    case 2228:
      ACCEPT_TOKEN(anon_sym_LT_BANG_DASH_DASH);
      END_STATE();
    case 2229:
      ACCEPT_TOKEN(anon_sym_LT_BANG_DASH_DASH);
      if (lookahead == '@') ADVANCE(2173);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(386);
      END_STATE();
    case 2230:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_GT);
      END_STATE();
    case 2231:
      ACCEPT_TOKEN(anon_sym_LT_QMARK);
      END_STATE();
    case 2232:
      ACCEPT_TOKEN(anon_sym_LT_QMARK);
      if (lookahead == '@') ADVANCE(2173);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(386);
      END_STATE();
    case 2233:
      ACCEPT_TOKEN(anon_sym_QMARK_GT);
      END_STATE();
    case 2234:
      ACCEPT_TOKEN(aux_sym__declaration_token1);
      if (lookahead == '@') ADVANCE(2173);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2234);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(386);
      END_STATE();
    case 2235:
      ACCEPT_TOKEN(aux_sym__declaration_token1);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2235);
      END_STATE();
    case 2236:
      ACCEPT_TOKEN(anon_sym_LT_BANG_LBRACKCDATA_LBRACK);
      END_STATE();
    case 2237:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK_GT);
      END_STATE();
    case 2238:
      ACCEPT_TOKEN(sym__whitespace_ge_2);
      END_STATE();
    case 2239:
      ACCEPT_TOKEN(sym__whitespace_ge_2);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2239);
      END_STATE();
    case 2240:
      ACCEPT_TOKEN(aux_sym__whitespace_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2239);
      END_STATE();
    case 2241:
      ACCEPT_TOKEN(sym__word_no_digit);
      if (lookahead == '_') ADVANCE(524);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(2241);
      END_STATE();
    case 2242:
      ACCEPT_TOKEN(sym__digits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(2242);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 2178, .external_lex_state = 2},
  [2] = {.lex_state = 2178, .external_lex_state = 3},
  [3] = {.lex_state = 2178, .external_lex_state = 4},
  [4] = {.lex_state = 2178, .external_lex_state = 4},
  [5] = {.lex_state = 2178, .external_lex_state = 5},
  [6] = {.lex_state = 2178, .external_lex_state = 4},
  [7] = {.lex_state = 2178, .external_lex_state = 3},
  [8] = {.lex_state = 2178, .external_lex_state = 6},
  [9] = {.lex_state = 2178, .external_lex_state = 6},
  [10] = {.lex_state = 2178, .external_lex_state = 5},
  [11] = {.lex_state = 2178, .external_lex_state = 7},
  [12] = {.lex_state = 2178, .external_lex_state = 8},
  [13] = {.lex_state = 2178, .external_lex_state = 9},
  [14] = {.lex_state = 2178, .external_lex_state = 9},
  [15] = {.lex_state = 2178, .external_lex_state = 7},
  [16] = {.lex_state = 2178, .external_lex_state = 9},
  [17] = {.lex_state = 2178, .external_lex_state = 8},
  [18] = {.lex_state = 2178, .external_lex_state = 7},
  [19] = {.lex_state = 2178, .external_lex_state = 9},
  [20] = {.lex_state = 2178, .external_lex_state = 8},
  [21] = {.lex_state = 2178, .external_lex_state = 7},
  [22] = {.lex_state = 2178, .external_lex_state = 8},
  [23] = {.lex_state = 2178, .external_lex_state = 8},
  [24] = {.lex_state = 2178, .external_lex_state = 7},
  [25] = {.lex_state = 2178, .external_lex_state = 8},
  [26] = {.lex_state = 2178, .external_lex_state = 9},
  [27] = {.lex_state = 2178, .external_lex_state = 9},
  [28] = {.lex_state = 2178, .external_lex_state = 4},
  [29] = {.lex_state = 2178, .external_lex_state = 4},
  [30] = {.lex_state = 2178, .external_lex_state = 4},
  [31] = {.lex_state = 2178, .external_lex_state = 10},
  [32] = {.lex_state = 2178, .external_lex_state = 8},
  [33] = {.lex_state = 2178, .external_lex_state = 7},
  [34] = {.lex_state = 2178, .external_lex_state = 8},
  [35] = {.lex_state = 2178, .external_lex_state = 9},
  [36] = {.lex_state = 2178, .external_lex_state = 4},
  [37] = {.lex_state = 2178, .external_lex_state = 7},
  [38] = {.lex_state = 2178, .external_lex_state = 9},
  [39] = {.lex_state = 2178, .external_lex_state = 9},
  [40] = {.lex_state = 2178, .external_lex_state = 7},
  [41] = {.lex_state = 2178, .external_lex_state = 9},
  [42] = {.lex_state = 2178, .external_lex_state = 7},
  [43] = {.lex_state = 2178, .external_lex_state = 7},
  [44] = {.lex_state = 2178, .external_lex_state = 4},
  [45] = {.lex_state = 2178, .external_lex_state = 7},
  [46] = {.lex_state = 2178, .external_lex_state = 4},
  [47] = {.lex_state = 2178, .external_lex_state = 8},
  [48] = {.lex_state = 2178, .external_lex_state = 10},
  [49] = {.lex_state = 2178, .external_lex_state = 8},
  [50] = {.lex_state = 2178, .external_lex_state = 9},
  [51] = {.lex_state = 2178, .external_lex_state = 8},
  [52] = {.lex_state = 2178, .external_lex_state = 10},
  [53] = {.lex_state = 2178, .external_lex_state = 10},
  [54] = {.lex_state = 2178, .external_lex_state = 10},
  [55] = {.lex_state = 2178, .external_lex_state = 10},
  [56] = {.lex_state = 2178, .external_lex_state = 10},
  [57] = {.lex_state = 2178, .external_lex_state = 10},
  [58] = {.lex_state = 2178, .external_lex_state = 10},
  [59] = {.lex_state = 2178, .external_lex_state = 10},
  [60] = {.lex_state = 2178, .external_lex_state = 10},
  [61] = {.lex_state = 2178, .external_lex_state = 10},
  [62] = {.lex_state = 2178, .external_lex_state = 10},
  [63] = {.lex_state = 2178, .external_lex_state = 10},
  [64] = {.lex_state = 2178, .external_lex_state = 10},
  [65] = {.lex_state = 2178, .external_lex_state = 10},
  [66] = {.lex_state = 2178, .external_lex_state = 10},
  [67] = {.lex_state = 2178, .external_lex_state = 10},
  [68] = {.lex_state = 2178, .external_lex_state = 10},
  [69] = {.lex_state = 2178, .external_lex_state = 10},
  [70] = {.lex_state = 2178, .external_lex_state = 10},
  [71] = {.lex_state = 2178, .external_lex_state = 10},
  [72] = {.lex_state = 2178, .external_lex_state = 10},
  [73] = {.lex_state = 2178, .external_lex_state = 10},
  [74] = {.lex_state = 2178, .external_lex_state = 10},
  [75] = {.lex_state = 2178, .external_lex_state = 10},
  [76] = {.lex_state = 2178, .external_lex_state = 10},
  [77] = {.lex_state = 2178, .external_lex_state = 10},
  [78] = {.lex_state = 2178, .external_lex_state = 10},
  [79] = {.lex_state = 2178, .external_lex_state = 10},
  [80] = {.lex_state = 2178, .external_lex_state = 10},
  [81] = {.lex_state = 2178, .external_lex_state = 10},
  [82] = {.lex_state = 2178, .external_lex_state = 10},
  [83] = {.lex_state = 2178, .external_lex_state = 10},
  [84] = {.lex_state = 2178, .external_lex_state = 10},
  [85] = {.lex_state = 2178, .external_lex_state = 10},
  [86] = {.lex_state = 2178, .external_lex_state = 6},
  [87] = {.lex_state = 2178, .external_lex_state = 5},
  [88] = {.lex_state = 2178, .external_lex_state = 3},
  [89] = {.lex_state = 2178, .external_lex_state = 4},
  [90] = {.lex_state = 2178, .external_lex_state = 4},
  [91] = {.lex_state = 2178, .external_lex_state = 5},
  [92] = {.lex_state = 2178, .external_lex_state = 3},
  [93] = {.lex_state = 2178, .external_lex_state = 4},
  [94] = {.lex_state = 2178, .external_lex_state = 4},
  [95] = {.lex_state = 2178, .external_lex_state = 4},
  [96] = {.lex_state = 2178, .external_lex_state = 3},
  [97] = {.lex_state = 2178, .external_lex_state = 6},
  [98] = {.lex_state = 2178, .external_lex_state = 5},
  [99] = {.lex_state = 2178, .external_lex_state = 6},
  [100] = {.lex_state = 2178, .external_lex_state = 10},
  [101] = {.lex_state = 2178, .external_lex_state = 9},
  [102] = {.lex_state = 2178, .external_lex_state = 7},
  [103] = {.lex_state = 2178, .external_lex_state = 7},
  [104] = {.lex_state = 2178, .external_lex_state = 8},
  [105] = {.lex_state = 2178, .external_lex_state = 9},
  [106] = {.lex_state = 2178, .external_lex_state = 10},
  [107] = {.lex_state = 2178, .external_lex_state = 7},
  [108] = {.lex_state = 2178, .external_lex_state = 9},
  [109] = {.lex_state = 2178, .external_lex_state = 9},
  [110] = {.lex_state = 2178, .external_lex_state = 8},
  [111] = {.lex_state = 2178, .external_lex_state = 8},
  [112] = {.lex_state = 2178, .external_lex_state = 7},
  [113] = {.lex_state = 2178, .external_lex_state = 9},
  [114] = {.lex_state = 2178, .external_lex_state = 10},
  [115] = {.lex_state = 2178, .external_lex_state = 9},
  [116] = {.lex_state = 2178, .external_lex_state = 8},
  [117] = {.lex_state = 2178, .external_lex_state = 8},
  [118] = {.lex_state = 2178, .external_lex_state = 9},
  [119] = {.lex_state = 2178, .external_lex_state = 7},
  [120] = {.lex_state = 2178, .external_lex_state = 9},
  [121] = {.lex_state = 2178, .external_lex_state = 4},
  [122] = {.lex_state = 2178, .external_lex_state = 8},
  [123] = {.lex_state = 2178, .external_lex_state = 7},
  [124] = {.lex_state = 2178, .external_lex_state = 9},
  [125] = {.lex_state = 2178, .external_lex_state = 7},
  [126] = {.lex_state = 2178, .external_lex_state = 4},
  [127] = {.lex_state = 2178, .external_lex_state = 7},
  [128] = {.lex_state = 2178, .external_lex_state = 8},
  [129] = {.lex_state = 2178, .external_lex_state = 8},
  [130] = {.lex_state = 2178, .external_lex_state = 8},
  [131] = {.lex_state = 2178, .external_lex_state = 10},
  [132] = {.lex_state = 2178, .external_lex_state = 10},
  [133] = {.lex_state = 2178, .external_lex_state = 4},
  [134] = {.lex_state = 2178, .external_lex_state = 10},
  [135] = {.lex_state = 2178, .external_lex_state = 7},
  [136] = {.lex_state = 2178, .external_lex_state = 10},
  [137] = {.lex_state = 2178, .external_lex_state = 10},
  [138] = {.lex_state = 2178, .external_lex_state = 10},
  [139] = {.lex_state = 2178, .external_lex_state = 10},
  [140] = {.lex_state = 2178, .external_lex_state = 10},
  [141] = {.lex_state = 2178, .external_lex_state = 10},
  [142] = {.lex_state = 2178, .external_lex_state = 10},
  [143] = {.lex_state = 2178, .external_lex_state = 10},
  [144] = {.lex_state = 2178, .external_lex_state = 10},
  [145] = {.lex_state = 2178, .external_lex_state = 10},
  [146] = {.lex_state = 2178, .external_lex_state = 10},
  [147] = {.lex_state = 2178, .external_lex_state = 10},
  [148] = {.lex_state = 2178, .external_lex_state = 10},
  [149] = {.lex_state = 2178, .external_lex_state = 7},
  [150] = {.lex_state = 2178, .external_lex_state = 9},
  [151] = {.lex_state = 2178, .external_lex_state = 7},
  [152] = {.lex_state = 2178, .external_lex_state = 8},
  [153] = {.lex_state = 2178, .external_lex_state = 8},
  [154] = {.lex_state = 2178, .external_lex_state = 9},
  [155] = {.lex_state = 2178, .external_lex_state = 10},
  [156] = {.lex_state = 2178, .external_lex_state = 10},
  [157] = {.lex_state = 2178, .external_lex_state = 10},
  [158] = {.lex_state = 2178, .external_lex_state = 9},
  [159] = {.lex_state = 2178, .external_lex_state = 8},
  [160] = {.lex_state = 2178, .external_lex_state = 10},
  [161] = {.lex_state = 2178, .external_lex_state = 9},
  [162] = {.lex_state = 2178, .external_lex_state = 10},
  [163] = {.lex_state = 2178, .external_lex_state = 7},
  [164] = {.lex_state = 2178, .external_lex_state = 8},
  [165] = {.lex_state = 2178, .external_lex_state = 7},
  [166] = {.lex_state = 2177, .external_lex_state = 8},
  [167] = {.lex_state = 2176, .external_lex_state = 8},
  [168] = {.lex_state = 2176, .external_lex_state = 8},
  [169] = {.lex_state = 2176, .external_lex_state = 9},
  [170] = {.lex_state = 2176, .external_lex_state = 7},
  [171] = {.lex_state = 2177, .external_lex_state = 9},
  [172] = {.lex_state = 2177, .external_lex_state = 7},
  [173] = {.lex_state = 2176, .external_lex_state = 9},
  [174] = {.lex_state = 2177, .external_lex_state = 7},
  [175] = {.lex_state = 2176, .external_lex_state = 10},
  [176] = {.lex_state = 2177, .external_lex_state = 8},
  [177] = {.lex_state = 2177, .external_lex_state = 9},
  [178] = {.lex_state = 2177, .external_lex_state = 10},
  [179] = {.lex_state = 2176, .external_lex_state = 7},
  [180] = {.lex_state = 2175, .external_lex_state = 8},
  [181] = {.lex_state = 2175, .external_lex_state = 7},
  [182] = {.lex_state = 2175, .external_lex_state = 8},
  [183] = {.lex_state = 2175, .external_lex_state = 10},
  [184] = {.lex_state = 2176, .external_lex_state = 10},
  [185] = {.lex_state = 2175, .external_lex_state = 9},
  [186] = {.lex_state = 2176, .external_lex_state = 10},
  [187] = {.lex_state = 2175, .external_lex_state = 7},
  [188] = {.lex_state = 2177, .external_lex_state = 10},
  [189] = {.lex_state = 2175, .external_lex_state = 9},
  [190] = {.lex_state = 2177, .external_lex_state = 10},
  [191] = {.lex_state = 2175, .external_lex_state = 10},
  [192] = {.lex_state = 2175, .external_lex_state = 10},
  [193] = {.lex_state = 2178, .external_lex_state = 11},
  [194] = {.lex_state = 2178, .external_lex_state = 3},
  [195] = {.lex_state = 2178, .external_lex_state = 12},
  [196] = {.lex_state = 2178, .external_lex_state = 6},
  [197] = {.lex_state = 2178, .external_lex_state = 3},
  [198] = {.lex_state = 2178, .external_lex_state = 7},
  [199] = {.lex_state = 2178, .external_lex_state = 4},
  [200] = {.lex_state = 2178, .external_lex_state = 9},
  [201] = {.lex_state = 2178, .external_lex_state = 4},
  [202] = {.lex_state = 2178, .external_lex_state = 5},
  [203] = {.lex_state = 2178, .external_lex_state = 13},
  [204] = {.lex_state = 2178, .external_lex_state = 8},
  [205] = {.lex_state = 2178, .external_lex_state = 10},
  [206] = {.lex_state = 2178, .external_lex_state = 5},
  [207] = {.lex_state = 2178, .external_lex_state = 2},
  [208] = {.lex_state = 2178, .external_lex_state = 6},
  [209] = {.lex_state = 7, .external_lex_state = 14},
  [210] = {.lex_state = 2178, .external_lex_state = 5},
  [211] = {.lex_state = 7, .external_lex_state = 14},
  [212] = {.lex_state = 2178, .external_lex_state = 6},
  [213] = {.lex_state = 2178, .external_lex_state = 6},
  [214] = {.lex_state = 2178, .external_lex_state = 3},
  [215] = {.lex_state = 2178, .external_lex_state = 10},
  [216] = {.lex_state = 2178, .external_lex_state = 12},
  [217] = {.lex_state = 2178, .external_lex_state = 12},
  [218] = {.lex_state = 7, .external_lex_state = 15},
  [219] = {.lex_state = 2178, .external_lex_state = 3},
  [220] = {.lex_state = 7, .external_lex_state = 15},
  [221] = {.lex_state = 7, .external_lex_state = 14},
  [222] = {.lex_state = 7, .external_lex_state = 15},
  [223] = {.lex_state = 2178, .external_lex_state = 3},
  [224] = {.lex_state = 7, .external_lex_state = 14},
  [225] = {.lex_state = 2178, .external_lex_state = 3},
  [226] = {.lex_state = 2178, .external_lex_state = 6},
  [227] = {.lex_state = 2178, .external_lex_state = 2},
  [228] = {.lex_state = 7, .external_lex_state = 15},
  [229] = {.lex_state = 7, .external_lex_state = 15},
  [230] = {.lex_state = 7, .external_lex_state = 14},
  [231] = {.lex_state = 7, .external_lex_state = 14},
  [232] = {.lex_state = 2178, .external_lex_state = 5},
  [233] = {.lex_state = 2178, .external_lex_state = 4},
  [234] = {.lex_state = 2178, .external_lex_state = 11},
  [235] = {.lex_state = 7, .external_lex_state = 15},
  [236] = {.lex_state = 2178, .external_lex_state = 6},
  [237] = {.lex_state = 7, .external_lex_state = 14},
  [238] = {.lex_state = 7, .external_lex_state = 14},
  [239] = {.lex_state = 2178, .external_lex_state = 6},
  [240] = {.lex_state = 2178, .external_lex_state = 4},
  [241] = {.lex_state = 2178, .external_lex_state = 2},
  [242] = {.lex_state = 2178, .external_lex_state = 11},
  [243] = {.lex_state = 2178, .external_lex_state = 5},
  [244] = {.lex_state = 2178, .external_lex_state = 5},
  [245] = {.lex_state = 2178, .external_lex_state = 5},
  [246] = {.lex_state = 2178, .external_lex_state = 4},
  [247] = {.lex_state = 2178, .external_lex_state = 3},
  [248] = {.lex_state = 2178, .external_lex_state = 13},
  [249] = {.lex_state = 7, .external_lex_state = 15},
  [250] = {.lex_state = 7, .external_lex_state = 14},
  [251] = {.lex_state = 7, .external_lex_state = 14},
  [252] = {.lex_state = 2178, .external_lex_state = 2},
  [253] = {.lex_state = 2178, .external_lex_state = 4},
  [254] = {.lex_state = 2178, .external_lex_state = 4},
  [255] = {.lex_state = 7, .external_lex_state = 15},
  [256] = {.lex_state = 7, .external_lex_state = 15},
  [257] = {.lex_state = 7, .external_lex_state = 14},
  [258] = {.lex_state = 2178, .external_lex_state = 4},
  [259] = {.lex_state = 2178, .external_lex_state = 13},
  [260] = {.lex_state = 7, .external_lex_state = 15},
  [261] = {.lex_state = 7, .external_lex_state = 15},
  [262] = {.lex_state = 2178, .external_lex_state = 8},
  [263] = {.lex_state = 2178, .external_lex_state = 9},
  [264] = {.lex_state = 2178, .external_lex_state = 10},
  [265] = {.lex_state = 2178, .external_lex_state = 10},
  [266] = {.lex_state = 2178, .external_lex_state = 10},
  [267] = {.lex_state = 2178, .external_lex_state = 10},
  [268] = {.lex_state = 2178, .external_lex_state = 8},
  [269] = {.lex_state = 1, .external_lex_state = 16},
  [270] = {.lex_state = 2178, .external_lex_state = 5},
  [271] = {.lex_state = 2178, .external_lex_state = 7},
  [272] = {.lex_state = 2178, .external_lex_state = 10},
  [273] = {.lex_state = 1, .external_lex_state = 16},
  [274] = {.lex_state = 2178, .external_lex_state = 10},
  [275] = {.lex_state = 2178, .external_lex_state = 10},
  [276] = {.lex_state = 2178, .external_lex_state = 10},
  [277] = {.lex_state = 2178, .external_lex_state = 10},
  [278] = {.lex_state = 2178, .external_lex_state = 10},
  [279] = {.lex_state = 2178, .external_lex_state = 2},
  [280] = {.lex_state = 2178, .external_lex_state = 10},
  [281] = {.lex_state = 2178, .external_lex_state = 10},
  [282] = {.lex_state = 2178, .external_lex_state = 7},
  [283] = {.lex_state = 2178, .external_lex_state = 10},
  [284] = {.lex_state = 2178, .external_lex_state = 7},
  [285] = {.lex_state = 2178, .external_lex_state = 2},
  [286] = {.lex_state = 2178, .external_lex_state = 3},
  [287] = {.lex_state = 2178, .external_lex_state = 10},
  [288] = {.lex_state = 1, .external_lex_state = 16},
  [289] = {.lex_state = 2178, .external_lex_state = 4},
  [290] = {.lex_state = 2178, .external_lex_state = 8},
  [291] = {.lex_state = 2178, .external_lex_state = 8},
  [292] = {.lex_state = 2178, .external_lex_state = 9},
  [293] = {.lex_state = 2178, .external_lex_state = 10},
  [294] = {.lex_state = 2178, .external_lex_state = 10},
  [295] = {.lex_state = 2178, .external_lex_state = 10},
  [296] = {.lex_state = 2178, .external_lex_state = 10},
  [297] = {.lex_state = 2178, .external_lex_state = 10},
  [298] = {.lex_state = 2178, .external_lex_state = 10},
  [299] = {.lex_state = 2178, .external_lex_state = 10},
  [300] = {.lex_state = 1, .external_lex_state = 16},
  [301] = {.lex_state = 2178, .external_lex_state = 10},
  [302] = {.lex_state = 1, .external_lex_state = 16},
  [303] = {.lex_state = 2178, .external_lex_state = 10},
  [304] = {.lex_state = 2178, .external_lex_state = 4},
  [305] = {.lex_state = 1, .external_lex_state = 16},
  [306] = {.lex_state = 2178, .external_lex_state = 10},
  [307] = {.lex_state = 2178, .external_lex_state = 10},
  [308] = {.lex_state = 2178, .external_lex_state = 10},
  [309] = {.lex_state = 2178, .external_lex_state = 10},
  [310] = {.lex_state = 2178, .external_lex_state = 10},
  [311] = {.lex_state = 2178, .external_lex_state = 10},
  [312] = {.lex_state = 2178, .external_lex_state = 8},
  [313] = {.lex_state = 1, .external_lex_state = 16},
  [314] = {.lex_state = 2178, .external_lex_state = 7},
  [315] = {.lex_state = 2178, .external_lex_state = 10},
  [316] = {.lex_state = 2178, .external_lex_state = 10},
  [317] = {.lex_state = 2178, .external_lex_state = 7},
  [318] = {.lex_state = 2178, .external_lex_state = 10},
  [319] = {.lex_state = 2178, .external_lex_state = 6},
  [320] = {.lex_state = 2178, .external_lex_state = 8},
  [321] = {.lex_state = 2178, .external_lex_state = 9},
  [322] = {.lex_state = 2178, .external_lex_state = 9},
  [323] = {.lex_state = 2178, .external_lex_state = 9},
  [324] = {.lex_state = 2178, .external_lex_state = 9},
  [325] = {.lex_state = 2178, .external_lex_state = 9},
  [326] = {.lex_state = 2178, .external_lex_state = 10},
  [327] = {.lex_state = 2178, .external_lex_state = 10},
  [328] = {.lex_state = 1, .external_lex_state = 16},
  [329] = {.lex_state = 2178, .external_lex_state = 9},
  [330] = {.lex_state = 2178, .external_lex_state = 9},
  [331] = {.lex_state = 2178, .external_lex_state = 7},
  [332] = {.lex_state = 2178, .external_lex_state = 4},
  [333] = {.lex_state = 2178, .external_lex_state = 4},
  [334] = {.lex_state = 2178, .external_lex_state = 9},
  [335] = {.lex_state = 2178, .external_lex_state = 9},
  [336] = {.lex_state = 1, .external_lex_state = 16},
  [337] = {.lex_state = 1, .external_lex_state = 16},
  [338] = {.lex_state = 2178, .external_lex_state = 9},
  [339] = {.lex_state = 2178, .external_lex_state = 9},
  [340] = {.lex_state = 2178, .external_lex_state = 9},
  [341] = {.lex_state = 2178, .external_lex_state = 9},
  [342] = {.lex_state = 2178, .external_lex_state = 9},
  [343] = {.lex_state = 2178, .external_lex_state = 10},
  [344] = {.lex_state = 2178, .external_lex_state = 9},
  [345] = {.lex_state = 2178, .external_lex_state = 7},
  [346] = {.lex_state = 2178, .external_lex_state = 7},
  [347] = {.lex_state = 2178, .external_lex_state = 7},
  [348] = {.lex_state = 2178, .external_lex_state = 7},
  [349] = {.lex_state = 1, .external_lex_state = 16},
  [350] = {.lex_state = 2178, .external_lex_state = 9},
  [351] = {.lex_state = 2178, .external_lex_state = 9},
  [352] = {.lex_state = 2178, .external_lex_state = 9},
  [353] = {.lex_state = 2178, .external_lex_state = 7},
  [354] = {.lex_state = 2178, .external_lex_state = 7},
  [355] = {.lex_state = 2178, .external_lex_state = 9},
  [356] = {.lex_state = 2178, .external_lex_state = 9},
  [357] = {.lex_state = 2178, .external_lex_state = 7},
  [358] = {.lex_state = 2178, .external_lex_state = 10},
  [359] = {.lex_state = 2178, .external_lex_state = 9},
  [360] = {.lex_state = 2178, .external_lex_state = 10},
  [361] = {.lex_state = 1, .external_lex_state = 16},
  [362] = {.lex_state = 2178, .external_lex_state = 10},
  [363] = {.lex_state = 2178, .external_lex_state = 10},
  [364] = {.lex_state = 2178, .external_lex_state = 7},
  [365] = {.lex_state = 2178, .external_lex_state = 7},
  [366] = {.lex_state = 2178, .external_lex_state = 7},
  [367] = {.lex_state = 2178, .external_lex_state = 10},
  [368] = {.lex_state = 2178, .external_lex_state = 7},
  [369] = {.lex_state = 2178, .external_lex_state = 10},
  [370] = {.lex_state = 2178, .external_lex_state = 7},
  [371] = {.lex_state = 2178, .external_lex_state = 7},
  [372] = {.lex_state = 2178, .external_lex_state = 7},
  [373] = {.lex_state = 2178, .external_lex_state = 7},
  [374] = {.lex_state = 2178, .external_lex_state = 7},
  [375] = {.lex_state = 2178, .external_lex_state = 7},
  [376] = {.lex_state = 2178, .external_lex_state = 7},
  [377] = {.lex_state = 2178, .external_lex_state = 8},
  [378] = {.lex_state = 2178, .external_lex_state = 10},
  [379] = {.lex_state = 2178, .external_lex_state = 10},
  [380] = {.lex_state = 2178, .external_lex_state = 10},
  [381] = {.lex_state = 1, .external_lex_state = 16},
  [382] = {.lex_state = 2178, .external_lex_state = 4},
  [383] = {.lex_state = 1, .external_lex_state = 16},
  [384] = {.lex_state = 2178, .external_lex_state = 7},
  [385] = {.lex_state = 2178, .external_lex_state = 7},
  [386] = {.lex_state = 2178, .external_lex_state = 7},
  [387] = {.lex_state = 2178, .external_lex_state = 7},
  [388] = {.lex_state = 2178, .external_lex_state = 7},
  [389] = {.lex_state = 2178, .external_lex_state = 7},
  [390] = {.lex_state = 2178, .external_lex_state = 7},
  [391] = {.lex_state = 2178, .external_lex_state = 9},
  [392] = {.lex_state = 2178, .external_lex_state = 10},
  [393] = {.lex_state = 2178, .external_lex_state = 9},
  [394] = {.lex_state = 2178, .external_lex_state = 9},
  [395] = {.lex_state = 2178, .external_lex_state = 9},
  [396] = {.lex_state = 2178, .external_lex_state = 9},
  [397] = {.lex_state = 2178, .external_lex_state = 10},
  [398] = {.lex_state = 2178, .external_lex_state = 9},
  [399] = {.lex_state = 2178, .external_lex_state = 9},
  [400] = {.lex_state = 2178, .external_lex_state = 8},
  [401] = {.lex_state = 2178, .external_lex_state = 8},
  [402] = {.lex_state = 2178, .external_lex_state = 7},
  [403] = {.lex_state = 2178, .external_lex_state = 7},
  [404] = {.lex_state = 2178, .external_lex_state = 7},
  [405] = {.lex_state = 2178, .external_lex_state = 9},
  [406] = {.lex_state = 2178, .external_lex_state = 9},
  [407] = {.lex_state = 2178, .external_lex_state = 8},
  [408] = {.lex_state = 2178, .external_lex_state = 8},
  [409] = {.lex_state = 2178, .external_lex_state = 8},
  [410] = {.lex_state = 2178, .external_lex_state = 7},
  [411] = {.lex_state = 2178, .external_lex_state = 7},
  [412] = {.lex_state = 2178, .external_lex_state = 7},
  [413] = {.lex_state = 2178, .external_lex_state = 8},
  [414] = {.lex_state = 2178, .external_lex_state = 10},
  [415] = {.lex_state = 2178, .external_lex_state = 7},
  [416] = {.lex_state = 2178, .external_lex_state = 7},
  [417] = {.lex_state = 2178, .external_lex_state = 7},
  [418] = {.lex_state = 2178, .external_lex_state = 7},
  [419] = {.lex_state = 2178, .external_lex_state = 7},
  [420] = {.lex_state = 2178, .external_lex_state = 7},
  [421] = {.lex_state = 2178, .external_lex_state = 8},
  [422] = {.lex_state = 2178, .external_lex_state = 10},
  [423] = {.lex_state = 2178, .external_lex_state = 10},
  [424] = {.lex_state = 2178, .external_lex_state = 9},
  [425] = {.lex_state = 2178, .external_lex_state = 9},
  [426] = {.lex_state = 2178, .external_lex_state = 10},
  [427] = {.lex_state = 2178, .external_lex_state = 10},
  [428] = {.lex_state = 2178, .external_lex_state = 9},
  [429] = {.lex_state = 2178, .external_lex_state = 10},
  [430] = {.lex_state = 2178, .external_lex_state = 8},
  [431] = {.lex_state = 2178, .external_lex_state = 8},
  [432] = {.lex_state = 2178, .external_lex_state = 10},
  [433] = {.lex_state = 2178, .external_lex_state = 8},
  [434] = {.lex_state = 2178, .external_lex_state = 8},
  [435] = {.lex_state = 2178, .external_lex_state = 8},
  [436] = {.lex_state = 2178, .external_lex_state = 8},
  [437] = {.lex_state = 2178, .external_lex_state = 7},
  [438] = {.lex_state = 2178, .external_lex_state = 8},
  [439] = {.lex_state = 2178, .external_lex_state = 8},
  [440] = {.lex_state = 2178, .external_lex_state = 8},
  [441] = {.lex_state = 2178, .external_lex_state = 7},
  [442] = {.lex_state = 2178, .external_lex_state = 8},
  [443] = {.lex_state = 2178, .external_lex_state = 7},
  [444] = {.lex_state = 2178, .external_lex_state = 7},
  [445] = {.lex_state = 2178, .external_lex_state = 7},
  [446] = {.lex_state = 2178, .external_lex_state = 7},
  [447] = {.lex_state = 2178, .external_lex_state = 7},
  [448] = {.lex_state = 2178, .external_lex_state = 8},
  [449] = {.lex_state = 2178, .external_lex_state = 8},
  [450] = {.lex_state = 2178, .external_lex_state = 8},
  [451] = {.lex_state = 2178, .external_lex_state = 8},
  [452] = {.lex_state = 2178, .external_lex_state = 8},
  [453] = {.lex_state = 2178, .external_lex_state = 8},
  [454] = {.lex_state = 2178, .external_lex_state = 8},
  [455] = {.lex_state = 2178, .external_lex_state = 8},
  [456] = {.lex_state = 2178, .external_lex_state = 8},
  [457] = {.lex_state = 2178, .external_lex_state = 8},
  [458] = {.lex_state = 2178, .external_lex_state = 8},
  [459] = {.lex_state = 2178, .external_lex_state = 7},
  [460] = {.lex_state = 2178, .external_lex_state = 7},
  [461] = {.lex_state = 2178, .external_lex_state = 7},
  [462] = {.lex_state = 2178, .external_lex_state = 7},
  [463] = {.lex_state = 2178, .external_lex_state = 7},
  [464] = {.lex_state = 2178, .external_lex_state = 8},
  [465] = {.lex_state = 2178, .external_lex_state = 8},
  [466] = {.lex_state = 2178, .external_lex_state = 8},
  [467] = {.lex_state = 2178, .external_lex_state = 8},
  [468] = {.lex_state = 2178, .external_lex_state = 8},
  [469] = {.lex_state = 2178, .external_lex_state = 8},
  [470] = {.lex_state = 2178, .external_lex_state = 8},
  [471] = {.lex_state = 2178, .external_lex_state = 7},
  [472] = {.lex_state = 2178, .external_lex_state = 7},
  [473] = {.lex_state = 2178, .external_lex_state = 10},
  [474] = {.lex_state = 1, .external_lex_state = 16},
  [475] = {.lex_state = 2178, .external_lex_state = 7},
  [476] = {.lex_state = 2178, .external_lex_state = 7},
  [477] = {.lex_state = 2178, .external_lex_state = 8},
  [478] = {.lex_state = 2178, .external_lex_state = 8},
  [479] = {.lex_state = 2178, .external_lex_state = 8},
  [480] = {.lex_state = 2178, .external_lex_state = 7},
  [481] = {.lex_state = 2178, .external_lex_state = 7},
  [482] = {.lex_state = 2178, .external_lex_state = 7},
  [483] = {.lex_state = 2178, .external_lex_state = 8},
  [484] = {.lex_state = 2178, .external_lex_state = 8},
  [485] = {.lex_state = 2178, .external_lex_state = 7},
  [486] = {.lex_state = 2178, .external_lex_state = 7},
  [487] = {.lex_state = 2178, .external_lex_state = 8},
  [488] = {.lex_state = 2178, .external_lex_state = 8},
  [489] = {.lex_state = 2178, .external_lex_state = 8},
  [490] = {.lex_state = 2178, .external_lex_state = 8},
  [491] = {.lex_state = 2178, .external_lex_state = 8},
  [492] = {.lex_state = 2178, .external_lex_state = 8},
  [493] = {.lex_state = 2178, .external_lex_state = 9},
  [494] = {.lex_state = 2178, .external_lex_state = 10},
  [495] = {.lex_state = 2178, .external_lex_state = 10},
  [496] = {.lex_state = 2178, .external_lex_state = 10},
  [497] = {.lex_state = 2178, .external_lex_state = 10},
  [498] = {.lex_state = 2178, .external_lex_state = 10},
  [499] = {.lex_state = 2178, .external_lex_state = 4},
  [500] = {.lex_state = 2178, .external_lex_state = 10},
  [501] = {.lex_state = 1, .external_lex_state = 16},
  [502] = {.lex_state = 2178, .external_lex_state = 9},
  [503] = {.lex_state = 2178, .external_lex_state = 9},
  [504] = {.lex_state = 2178, .external_lex_state = 9},
  [505] = {.lex_state = 2178, .external_lex_state = 9},
  [506] = {.lex_state = 2178, .external_lex_state = 8},
  [507] = {.lex_state = 2178, .external_lex_state = 9},
  [508] = {.lex_state = 2178, .external_lex_state = 9},
  [509] = {.lex_state = 2178, .external_lex_state = 8},
  [510] = {.lex_state = 2178, .external_lex_state = 9},
  [511] = {.lex_state = 2178, .external_lex_state = 8},
  [512] = {.lex_state = 2178, .external_lex_state = 8},
  [513] = {.lex_state = 2178, .external_lex_state = 8},
  [514] = {.lex_state = 2178, .external_lex_state = 8},
  [515] = {.lex_state = 2178, .external_lex_state = 8},
  [516] = {.lex_state = 2178, .external_lex_state = 9},
  [517] = {.lex_state = 2178, .external_lex_state = 9},
  [518] = {.lex_state = 2178, .external_lex_state = 9},
  [519] = {.lex_state = 2178, .external_lex_state = 9},
  [520] = {.lex_state = 2178, .external_lex_state = 9},
  [521] = {.lex_state = 2178, .external_lex_state = 9},
  [522] = {.lex_state = 2178, .external_lex_state = 9},
  [523] = {.lex_state = 2178, .external_lex_state = 9},
  [524] = {.lex_state = 2178, .external_lex_state = 9},
  [525] = {.lex_state = 2178, .external_lex_state = 9},
  [526] = {.lex_state = 2178, .external_lex_state = 8},
  [527] = {.lex_state = 2178, .external_lex_state = 8},
  [528] = {.lex_state = 2178, .external_lex_state = 8},
  [529] = {.lex_state = 2178, .external_lex_state = 8},
  [530] = {.lex_state = 2178, .external_lex_state = 9},
  [531] = {.lex_state = 2178, .external_lex_state = 9},
  [532] = {.lex_state = 2178, .external_lex_state = 9},
  [533] = {.lex_state = 2178, .external_lex_state = 9},
  [534] = {.lex_state = 2178, .external_lex_state = 9},
  [535] = {.lex_state = 2178, .external_lex_state = 9},
  [536] = {.lex_state = 2178, .external_lex_state = 10},
  [537] = {.lex_state = 2178, .external_lex_state = 10},
  [538] = {.lex_state = 2178, .external_lex_state = 8},
  [539] = {.lex_state = 2178, .external_lex_state = 10},
  [540] = {.lex_state = 2178, .external_lex_state = 9},
  [541] = {.lex_state = 2178, .external_lex_state = 7},
  [542] = {.lex_state = 2178, .external_lex_state = 10},
  [543] = {.lex_state = 2178, .external_lex_state = 10},
  [544] = {.lex_state = 2178, .external_lex_state = 10},
  [545] = {.lex_state = 2178, .external_lex_state = 10},
  [546] = {.lex_state = 2178, .external_lex_state = 10},
  [547] = {.lex_state = 2178, .external_lex_state = 10},
  [548] = {.lex_state = 2178, .external_lex_state = 10},
  [549] = {.lex_state = 2178, .external_lex_state = 10},
  [550] = {.lex_state = 2178, .external_lex_state = 10},
  [551] = {.lex_state = 2178, .external_lex_state = 10},
  [552] = {.lex_state = 2178, .external_lex_state = 10},
  [553] = {.lex_state = 2178, .external_lex_state = 10},
  [554] = {.lex_state = 2178, .external_lex_state = 10},
  [555] = {.lex_state = 2178, .external_lex_state = 10},
  [556] = {.lex_state = 2178, .external_lex_state = 10},
  [557] = {.lex_state = 2178, .external_lex_state = 10},
  [558] = {.lex_state = 2178, .external_lex_state = 10},
  [559] = {.lex_state = 2178, .external_lex_state = 10},
  [560] = {.lex_state = 2178, .external_lex_state = 10},
  [561] = {.lex_state = 2178, .external_lex_state = 10},
  [562] = {.lex_state = 2178, .external_lex_state = 10},
  [563] = {.lex_state = 2178, .external_lex_state = 10},
  [564] = {.lex_state = 2178, .external_lex_state = 10},
  [565] = {.lex_state = 2178, .external_lex_state = 10},
  [566] = {.lex_state = 2178, .external_lex_state = 10},
  [567] = {.lex_state = 2178, .external_lex_state = 10},
  [568] = {.lex_state = 2178, .external_lex_state = 10},
  [569] = {.lex_state = 2178, .external_lex_state = 10},
  [570] = {.lex_state = 2178, .external_lex_state = 10},
  [571] = {.lex_state = 2178, .external_lex_state = 10},
  [572] = {.lex_state = 2178, .external_lex_state = 10},
  [573] = {.lex_state = 2178, .external_lex_state = 10},
  [574] = {.lex_state = 2178, .external_lex_state = 10},
  [575] = {.lex_state = 2178, .external_lex_state = 10},
  [576] = {.lex_state = 2178, .external_lex_state = 10},
  [577] = {.lex_state = 2178, .external_lex_state = 10},
  [578] = {.lex_state = 2178, .external_lex_state = 10},
  [579] = {.lex_state = 2178, .external_lex_state = 10},
  [580] = {.lex_state = 2178, .external_lex_state = 10},
  [581] = {.lex_state = 2178, .external_lex_state = 10},
  [582] = {.lex_state = 2178, .external_lex_state = 10},
  [583] = {.lex_state = 2178, .external_lex_state = 10},
  [584] = {.lex_state = 2178, .external_lex_state = 10},
  [585] = {.lex_state = 2178, .external_lex_state = 10},
  [586] = {.lex_state = 2178, .external_lex_state = 10},
  [587] = {.lex_state = 2178, .external_lex_state = 10},
  [588] = {.lex_state = 2178, .external_lex_state = 10},
  [589] = {.lex_state = 2178, .external_lex_state = 10},
  [590] = {.lex_state = 2178, .external_lex_state = 10},
  [591] = {.lex_state = 2178, .external_lex_state = 10},
  [592] = {.lex_state = 2178, .external_lex_state = 10},
  [593] = {.lex_state = 2178, .external_lex_state = 10},
  [594] = {.lex_state = 2178, .external_lex_state = 10},
  [595] = {.lex_state = 2178, .external_lex_state = 10},
  [596] = {.lex_state = 2178, .external_lex_state = 10},
  [597] = {.lex_state = 2178, .external_lex_state = 10},
  [598] = {.lex_state = 2178, .external_lex_state = 10},
  [599] = {.lex_state = 2178, .external_lex_state = 10},
  [600] = {.lex_state = 2178, .external_lex_state = 9},
  [601] = {.lex_state = 2178, .external_lex_state = 9},
  [602] = {.lex_state = 2178, .external_lex_state = 7},
  [603] = {.lex_state = 2178, .external_lex_state = 8},
  [604] = {.lex_state = 2178, .external_lex_state = 10},
  [605] = {.lex_state = 2178, .external_lex_state = 10},
  [606] = {.lex_state = 2178, .external_lex_state = 10},
  [607] = {.lex_state = 2178, .external_lex_state = 8},
  [608] = {.lex_state = 2178, .external_lex_state = 7},
  [609] = {.lex_state = 2178, .external_lex_state = 7},
  [610] = {.lex_state = 2178, .external_lex_state = 7},
  [611] = {.lex_state = 2178, .external_lex_state = 7},
  [612] = {.lex_state = 2178, .external_lex_state = 10},
  [613] = {.lex_state = 2178, .external_lex_state = 10},
  [614] = {.lex_state = 2178, .external_lex_state = 10},
  [615] = {.lex_state = 2178, .external_lex_state = 7},
  [616] = {.lex_state = 2178, .external_lex_state = 7},
  [617] = {.lex_state = 2178, .external_lex_state = 7},
  [618] = {.lex_state = 2178, .external_lex_state = 7},
  [619] = {.lex_state = 2178, .external_lex_state = 10},
  [620] = {.lex_state = 2178, .external_lex_state = 10},
  [621] = {.lex_state = 2178, .external_lex_state = 8},
  [622] = {.lex_state = 2178, .external_lex_state = 9},
  [623] = {.lex_state = 2178, .external_lex_state = 8},
  [624] = {.lex_state = 2178, .external_lex_state = 9},
  [625] = {.lex_state = 2178, .external_lex_state = 10},
  [626] = {.lex_state = 2178, .external_lex_state = 10},
  [627] = {.lex_state = 2178, .external_lex_state = 8},
  [628] = {.lex_state = 2178, .external_lex_state = 7},
  [629] = {.lex_state = 2178, .external_lex_state = 9},
  [630] = {.lex_state = 2178, .external_lex_state = 9},
  [631] = {.lex_state = 2178, .external_lex_state = 9},
  [632] = {.lex_state = 2178, .external_lex_state = 8},
  [633] = {.lex_state = 2178, .external_lex_state = 9},
  [634] = {.lex_state = 2178, .external_lex_state = 7},
  [635] = {.lex_state = 2178, .external_lex_state = 9},
  [636] = {.lex_state = 2178, .external_lex_state = 8},
  [637] = {.lex_state = 2178, .external_lex_state = 8},
  [638] = {.lex_state = 2178, .external_lex_state = 8},
  [639] = {.lex_state = 2178, .external_lex_state = 8},
  [640] = {.lex_state = 2178, .external_lex_state = 8},
  [641] = {.lex_state = 2178, .external_lex_state = 7},
  [642] = {.lex_state = 2178, .external_lex_state = 7},
  [643] = {.lex_state = 2178, .external_lex_state = 8},
  [644] = {.lex_state = 2178, .external_lex_state = 8},
  [645] = {.lex_state = 2},
  [646] = {.lex_state = 2},
  [647] = {.lex_state = 2},
  [648] = {.lex_state = 2},
  [649] = {.lex_state = 2},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 2},
  [652] = {.lex_state = 2},
  [653] = {.lex_state = 2},
  [654] = {.lex_state = 2},
  [655] = {.lex_state = 2, .external_lex_state = 17},
  [656] = {.lex_state = 2, .external_lex_state = 17},
  [657] = {.lex_state = 2},
  [658] = {.lex_state = 2},
  [659] = {.lex_state = 2},
  [660] = {.lex_state = 2},
  [661] = {.lex_state = 2},
  [662] = {.lex_state = 2},
  [663] = {.lex_state = 2},
  [664] = {.lex_state = 2},
  [665] = {.lex_state = 2},
  [666] = {.lex_state = 2},
  [667] = {.lex_state = 1, .external_lex_state = 18},
  [668] = {.lex_state = 6, .external_lex_state = 15},
  [669] = {.lex_state = 1, .external_lex_state = 19},
  [670] = {.lex_state = 2},
  [671] = {.lex_state = 6, .external_lex_state = 14},
  [672] = {.lex_state = 5, .external_lex_state = 14},
  [673] = {.lex_state = 5, .external_lex_state = 15},
  [674] = {.lex_state = 1, .external_lex_state = 18},
  [675] = {.lex_state = 1, .external_lex_state = 16},
  [676] = {.lex_state = 1, .external_lex_state = 16},
  [677] = {.lex_state = 3, .external_lex_state = 14},
  [678] = {.lex_state = 1, .external_lex_state = 16},
  [679] = {.lex_state = 1, .external_lex_state = 16},
  [680] = {.lex_state = 3, .external_lex_state = 15},
  [681] = {.lex_state = 2},
  [682] = {.lex_state = 2, .external_lex_state = 17},
  [683] = {.lex_state = 2},
  [684] = {.lex_state = 2},
  [685] = {.lex_state = 2, .external_lex_state = 17},
  [686] = {.lex_state = 2, .external_lex_state = 17},
  [687] = {.lex_state = 2},
  [688] = {.lex_state = 2},
  [689] = {.lex_state = 2},
  [690] = {.lex_state = 7, .external_lex_state = 20},
  [691] = {.lex_state = 2},
  [692] = {.lex_state = 2},
  [693] = {.lex_state = 7, .external_lex_state = 15},
  [694] = {.lex_state = 2},
  [695] = {.lex_state = 2},
  [696] = {.lex_state = 2},
  [697] = {.lex_state = 2},
  [698] = {.lex_state = 2},
  [699] = {.lex_state = 2},
  [700] = {.lex_state = 7, .external_lex_state = 21},
  [701] = {.lex_state = 7, .external_lex_state = 14},
  [702] = {.lex_state = 4, .external_lex_state = 17},
  [703] = {.lex_state = 4, .external_lex_state = 17},
  [704] = {.lex_state = 7, .external_lex_state = 20},
  [705] = {.lex_state = 7, .external_lex_state = 22},
  [706] = {.lex_state = 7, .external_lex_state = 21},
  [707] = {.lex_state = 7, .external_lex_state = 22},
  [708] = {.lex_state = 4, .external_lex_state = 17},
  [709] = {.lex_state = 4, .external_lex_state = 17},
  [710] = {.lex_state = 2178},
  [711] = {.lex_state = 4, .external_lex_state = 17},
  [712] = {.lex_state = 4, .external_lex_state = 17},
  [713] = {.lex_state = 4, .external_lex_state = 17},
  [714] = {.lex_state = 4, .external_lex_state = 17},
  [715] = {.lex_state = 4, .external_lex_state = 17},
  [716] = {.lex_state = 4, .external_lex_state = 17},
  [717] = {.lex_state = 2},
  [718] = {.lex_state = 4, .external_lex_state = 17},
  [719] = {.lex_state = 4, .external_lex_state = 17},
  [720] = {.lex_state = 2178},
  [721] = {.lex_state = 2178},
  [722] = {.lex_state = 4, .external_lex_state = 17},
  [723] = {.lex_state = 4, .external_lex_state = 17},
  [724] = {.lex_state = 7, .external_lex_state = 23},
  [725] = {.lex_state = 7, .external_lex_state = 23},
  [726] = {.lex_state = 8},
  [727] = {.lex_state = 4},
  [728] = {.lex_state = 7, .external_lex_state = 15},
  [729] = {.lex_state = 7, .external_lex_state = 15},
  [730] = {.lex_state = 7, .external_lex_state = 15},
  [731] = {.lex_state = 7, .external_lex_state = 15},
  [732] = {.lex_state = 7, .external_lex_state = 15},
  [733] = {.lex_state = 7, .external_lex_state = 15},
  [734] = {.lex_state = 7, .external_lex_state = 15},
  [735] = {.lex_state = 7, .external_lex_state = 15},
  [736] = {.lex_state = 7, .external_lex_state = 15},
  [737] = {.lex_state = 7, .external_lex_state = 15},
  [738] = {.lex_state = 7, .external_lex_state = 15},
  [739] = {.lex_state = 7, .external_lex_state = 15},
  [740] = {.lex_state = 7, .external_lex_state = 15},
  [741] = {.lex_state = 7, .external_lex_state = 15},
  [742] = {.lex_state = 7, .external_lex_state = 15},
  [743] = {.lex_state = 7, .external_lex_state = 15},
  [744] = {.lex_state = 7, .external_lex_state = 15},
  [745] = {.lex_state = 7, .external_lex_state = 15},
  [746] = {.lex_state = 7, .external_lex_state = 15},
  [747] = {.lex_state = 4},
  [748] = {.lex_state = 4},
  [749] = {.lex_state = 4},
  [750] = {.lex_state = 4},
  [751] = {.lex_state = 4},
  [752] = {.lex_state = 4},
  [753] = {.lex_state = 9},
  [754] = {.lex_state = 8},
  [755] = {.lex_state = 4},
  [756] = {.lex_state = 7, .external_lex_state = 15},
  [757] = {.lex_state = 4},
  [758] = {.lex_state = 4},
  [759] = {.lex_state = 4},
  [760] = {.lex_state = 4},
  [761] = {.lex_state = 4},
  [762] = {.lex_state = 4},
  [763] = {.lex_state = 4},
  [764] = {.lex_state = 8},
  [765] = {.lex_state = 9},
  [766] = {.lex_state = 4},
  [767] = {.lex_state = 9},
  [768] = {.lex_state = 4},
  [769] = {.lex_state = 4},
  [770] = {.lex_state = 4},
  [771] = {.lex_state = 4},
  [772] = {.lex_state = 4},
  [773] = {.lex_state = 4},
  [774] = {.lex_state = 8},
  [775] = {.lex_state = 4},
  [776] = {.lex_state = 4},
  [777] = {.lex_state = 9},
  [778] = {.lex_state = 7, .external_lex_state = 15},
  [779] = {.lex_state = 7, .external_lex_state = 14},
  [780] = {.lex_state = 4},
  [781] = {.lex_state = 4},
  [782] = {.lex_state = 4},
  [783] = {.lex_state = 7, .external_lex_state = 14},
  [784] = {.lex_state = 7, .external_lex_state = 14},
  [785] = {.lex_state = 7, .external_lex_state = 14},
  [786] = {.lex_state = 7, .external_lex_state = 14},
  [787] = {.lex_state = 8},
  [788] = {.lex_state = 7, .external_lex_state = 14},
  [789] = {.lex_state = 7, .external_lex_state = 14},
  [790] = {.lex_state = 9},
  [791] = {.lex_state = 7, .external_lex_state = 14},
  [792] = {.lex_state = 4},
  [793] = {.lex_state = 8},
  [794] = {.lex_state = 4},
  [795] = {.lex_state = 9},
  [796] = {.lex_state = 7, .external_lex_state = 14},
  [797] = {.lex_state = 7, .external_lex_state = 14},
  [798] = {.lex_state = 7, .external_lex_state = 14},
  [799] = {.lex_state = 9},
  [800] = {.lex_state = 7, .external_lex_state = 14},
  [801] = {.lex_state = 4},
  [802] = {.lex_state = 7, .external_lex_state = 14},
  [803] = {.lex_state = 7, .external_lex_state = 14},
  [804] = {.lex_state = 7, .external_lex_state = 14},
  [805] = {.lex_state = 7, .external_lex_state = 14},
  [806] = {.lex_state = 7, .external_lex_state = 14},
  [807] = {.lex_state = 4},
  [808] = {.lex_state = 4},
  [809] = {.lex_state = 8},
  [810] = {.lex_state = 9},
  [811] = {.lex_state = 4},
  [812] = {.lex_state = 7, .external_lex_state = 14},
  [813] = {.lex_state = 4},
  [814] = {.lex_state = 4},
  [815] = {.lex_state = 7, .external_lex_state = 14},
  [816] = {.lex_state = 4},
  [817] = {.lex_state = 7, .external_lex_state = 14},
  [818] = {.lex_state = 4},
  [819] = {.lex_state = 4},
  [820] = {.lex_state = 7, .external_lex_state = 14},
  [821] = {.lex_state = 4},
  [822] = {.lex_state = 4},
  [823] = {.lex_state = 4},
  [824] = {.lex_state = 8},
  [825] = {.lex_state = 4},
  [826] = {.lex_state = 4},
  [827] = {.lex_state = 10},
  [828] = {.lex_state = 10},
  [829] = {.lex_state = 2, .external_lex_state = 17},
  [830] = {.lex_state = 2},
  [831] = {.lex_state = 10},
  [832] = {.lex_state = 10},
  [833] = {.lex_state = 10},
  [834] = {.lex_state = 10},
  [835] = {.lex_state = 10},
  [836] = {.lex_state = 10},
  [837] = {.lex_state = 10},
  [838] = {.lex_state = 2},
  [839] = {.lex_state = 2, .external_lex_state = 17},
  [840] = {.lex_state = 10},
  [841] = {.lex_state = 2, .external_lex_state = 17},
  [842] = {.lex_state = 10},
  [843] = {.lex_state = 2},
  [844] = {.lex_state = 2, .external_lex_state = 17},
  [845] = {.lex_state = 2, .external_lex_state = 17},
  [846] = {.lex_state = 10},
  [847] = {.lex_state = 10},
  [848] = {.lex_state = 10},
  [849] = {.lex_state = 2, .external_lex_state = 17},
  [850] = {.lex_state = 2, .external_lex_state = 24},
  [851] = {.lex_state = 10},
  [852] = {.lex_state = 2},
  [853] = {.lex_state = 10},
  [854] = {.lex_state = 10},
  [855] = {.lex_state = 10},
  [856] = {.lex_state = 2, .external_lex_state = 17},
  [857] = {.lex_state = 10},
  [858] = {.lex_state = 10},
  [859] = {.lex_state = 2, .external_lex_state = 24},
  [860] = {.lex_state = 10},
  [861] = {.lex_state = 2},
  [862] = {.lex_state = 2},
  [863] = {.lex_state = 2},
  [864] = {.lex_state = 2},
  [865] = {.lex_state = 2},
  [866] = {.lex_state = 2},
  [867] = {.lex_state = 2},
  [868] = {.lex_state = 2},
  [869] = {.lex_state = 2},
  [870] = {.lex_state = 2},
  [871] = {.lex_state = 2},
  [872] = {.lex_state = 2},
  [873] = {.lex_state = 2, .external_lex_state = 17},
  [874] = {.lex_state = 2},
  [875] = {.lex_state = 2},
  [876] = {.lex_state = 2},
  [877] = {.lex_state = 2},
  [878] = {.lex_state = 2},
  [879] = {.lex_state = 2},
  [880] = {.lex_state = 2},
  [881] = {.lex_state = 2},
  [882] = {.lex_state = 8, .external_lex_state = 17},
  [883] = {.lex_state = 4, .external_lex_state = 17},
  [884] = {.lex_state = 2178, .external_lex_state = 17},
  [885] = {.lex_state = 9, .external_lex_state = 17},
  [886] = {.lex_state = 8, .external_lex_state = 24},
  [887] = {.lex_state = 9, .external_lex_state = 24},
  [888] = {.lex_state = 8, .external_lex_state = 24},
  [889] = {.lex_state = 4, .external_lex_state = 17},
  [890] = {.lex_state = 9, .external_lex_state = 24},
  [891] = {.lex_state = 4, .external_lex_state = 24},
  [892] = {.lex_state = 4, .external_lex_state = 24},
  [893] = {.lex_state = 4},
  [894] = {.lex_state = 8},
  [895] = {.lex_state = 8},
  [896] = {.lex_state = 10, .external_lex_state = 17},
  [897] = {.lex_state = 4},
  [898] = {.lex_state = 9},
  [899] = {.lex_state = 2178},
  [900] = {.lex_state = 4},
  [901] = {.lex_state = 10, .external_lex_state = 17},
  [902] = {.lex_state = 9},
  [903] = {.lex_state = 9},
  [904] = {.lex_state = 4},
  [905] = {.lex_state = 8},
  [906] = {.lex_state = 10, .external_lex_state = 17},
  [907] = {.lex_state = 4},
  [908] = {.lex_state = 10, .external_lex_state = 24},
  [909] = {.lex_state = 10, .external_lex_state = 24},
  [910] = {.lex_state = 10},
  [911] = {.lex_state = 10},
  [912] = {.lex_state = 10},
  [913] = {.lex_state = 10},
  [914] = {.lex_state = 10},
  [915] = {.lex_state = 10},
  [916] = {.lex_state = 10},
  [917] = {.lex_state = 10},
  [918] = {.lex_state = 10},
  [919] = {.lex_state = 10},
  [920] = {.lex_state = 10},
  [921] = {.lex_state = 10},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 11},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 11},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 11},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 11},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 12},
  [963] = {.lex_state = 12},
  [964] = {.lex_state = 2178},
  [965] = {.lex_state = 12},
  [966] = {.lex_state = 12},
  [967] = {.lex_state = 12},
  [968] = {.lex_state = 12},
  [969] = {.lex_state = 12},
  [970] = {.lex_state = 12},
  [971] = {.lex_state = 2178},
  [972] = {.lex_state = 12},
  [973] = {.lex_state = 12},
  [974] = {.lex_state = 12},
  [975] = {.lex_state = 11},
  [976] = {.lex_state = 12},
  [977] = {.lex_state = 12},
  [978] = {.lex_state = 12},
  [979] = {.lex_state = 2178},
  [980] = {.lex_state = 12},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 12, .external_lex_state = 24},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 11, .external_lex_state = 24},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 11, .external_lex_state = 24},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 12},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 12, .external_lex_state = 24},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 12},
  [1103] = {.lex_state = 11},
  [1104] = {.lex_state = 12},
  [1105] = {.lex_state = 11},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0, .external_lex_state = 25},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0, .external_lex_state = 26},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0, .external_lex_state = 26},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0, .external_lex_state = 26},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0, .external_lex_state = 26},
  [1159] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__backslash_escape] = ACTIONS(1),
    [sym_entity_reference] = ACTIONS(1),
    [sym_numeric_character_reference] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym__newline_token] = ACTIONS(1),
    [sym_uri_autolink] = ACTIONS(1),
    [sym_email_autolink] = ACTIONS(1),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1),
    [anon_sym_DASH_DASH_GT] = ACTIONS(1),
    [anon_sym_LT_QMARK] = ACTIONS(1),
    [anon_sym_QMARK_GT] = ACTIONS(1),
    [aux_sym__declaration_token1] = ACTIONS(1),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK_GT] = ACTIONS(1),
    [sym__whitespace_ge_2] = ACTIONS(1),
    [aux_sym__whitespace_token1] = ACTIONS(1),
    [sym__word_no_digit] = ACTIONS(1),
    [sym__digits] = ACTIONS(1),
    [sym__error] = ACTIONS(1),
    [sym__trigger_error] = ACTIONS(1),
    [sym__code_span_start] = ACTIONS(1),
    [sym__code_span_close] = ACTIONS(1),
    [sym__emphasis_open_star] = ACTIONS(1),
    [sym__emphasis_open_underscore] = ACTIONS(1),
    [sym__emphasis_close_star] = ACTIONS(1),
    [sym__emphasis_close_underscore] = ACTIONS(1),
    [sym__last_token_whitespace] = ACTIONS(1),
    [sym__last_token_punctuation] = ACTIONS(1),
    [sym__strikethrough_open] = ACTIONS(1),
    [sym__strikethrough_close] = ACTIONS(1),
    [sym__latex_span_start] = ACTIONS(1),
    [sym__latex_span_close] = ACTIONS(1),
    [sym__unclosed_span] = ACTIONS(1),
  },
  [1] = {
    [sym_inline] = STATE(1140),
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(31),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__last_token_whitespace] = ACTIONS(41),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [2] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(19),
    [aux_sym__inline_no_tilde] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(47),
    [sym_entity_reference] = ACTIONS(50),
    [sym_numeric_character_reference] = ACTIONS(50),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(56),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(62),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(62),
    [anon_sym_POUND] = ACTIONS(62),
    [anon_sym_DOLLAR] = ACTIONS(62),
    [anon_sym_PERCENT] = ACTIONS(62),
    [anon_sym_AMP] = ACTIONS(68),
    [anon_sym_SQUOTE] = ACTIONS(62),
    [anon_sym_STAR] = ACTIONS(62),
    [anon_sym_PLUS] = ACTIONS(62),
    [anon_sym_COMMA] = ACTIONS(62),
    [anon_sym_DASH] = ACTIONS(62),
    [anon_sym_DOT] = ACTIONS(62),
    [anon_sym_SLASH] = ACTIONS(62),
    [anon_sym_COLON] = ACTIONS(62),
    [anon_sym_SEMI] = ACTIONS(62),
    [anon_sym_EQ] = ACTIONS(62),
    [anon_sym_QMARK] = ACTIONS(62),
    [anon_sym_AT] = ACTIONS(62),
    [anon_sym_BSLASH] = ACTIONS(71),
    [anon_sym_CARET] = ACTIONS(62),
    [anon_sym__] = ACTIONS(62),
    [anon_sym_BQUOTE] = ACTIONS(62),
    [anon_sym_LBRACE] = ACTIONS(62),
    [anon_sym_PIPE] = ACTIONS(62),
    [anon_sym_RBRACE] = ACTIONS(62),
    [anon_sym_TILDE] = ACTIONS(62),
    [anon_sym_LPAREN] = ACTIONS(62),
    [anon_sym_RPAREN] = ACTIONS(62),
    [sym__newline_token] = ACTIONS(74),
    [sym_uri_autolink] = ACTIONS(50),
    [sym_email_autolink] = ACTIONS(50),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(77),
    [anon_sym_LT_QMARK] = ACTIONS(80),
    [aux_sym__declaration_token1] = ACTIONS(83),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(86),
    [sym__whitespace_ge_2] = ACTIONS(89),
    [aux_sym__whitespace_token1] = ACTIONS(92),
    [sym__word_no_digit] = ACTIONS(50),
    [sym__digits] = ACTIONS(50),
    [sym__code_span_start] = ACTIONS(95),
    [sym__emphasis_open_star] = ACTIONS(98),
    [sym__emphasis_open_underscore] = ACTIONS(101),
    [sym__emphasis_close_underscore] = ACTIONS(104),
    [sym__last_token_punctuation] = ACTIONS(106),
    [sym__strikethrough_open] = ACTIONS(108),
    [sym__latex_span_start] = ACTIONS(111),
    [sym__unclosed_span] = ACTIONS(50),
  },
  [3] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(42),
    [sym_full_reference_link] = STATE(42),
    [sym_collapsed_reference_link] = STATE(42),
    [sym_inline_link] = STATE(42),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(42),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(42),
    [aux_sym__inline_no_star] = STATE(42),
    [sym__strikethrough] = STATE(42),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(42),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(42),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(116),
    [sym_entity_reference] = ACTIONS(119),
    [sym_numeric_character_reference] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(122),
    [anon_sym_RBRACK] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(131),
    [anon_sym_BANG] = ACTIONS(134),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(131),
    [anon_sym_DOLLAR] = ACTIONS(131),
    [anon_sym_PERCENT] = ACTIONS(131),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(131),
    [anon_sym_COMMA] = ACTIONS(131),
    [anon_sym_DASH] = ACTIONS(131),
    [anon_sym_DOT] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(131),
    [anon_sym_COLON] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(131),
    [anon_sym_EQ] = ACTIONS(131),
    [anon_sym_QMARK] = ACTIONS(131),
    [anon_sym_AT] = ACTIONS(131),
    [anon_sym_BSLASH] = ACTIONS(140),
    [anon_sym_CARET] = ACTIONS(131),
    [anon_sym__] = ACTIONS(131),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_PIPE] = ACTIONS(131),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_TILDE] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(131),
    [sym__newline_token] = ACTIONS(143),
    [sym_uri_autolink] = ACTIONS(119),
    [sym_email_autolink] = ACTIONS(119),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(146),
    [anon_sym_LT_QMARK] = ACTIONS(149),
    [aux_sym__declaration_token1] = ACTIONS(152),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(155),
    [sym__whitespace_ge_2] = ACTIONS(158),
    [aux_sym__whitespace_token1] = ACTIONS(161),
    [sym__word_no_digit] = ACTIONS(119),
    [sym__digits] = ACTIONS(119),
    [sym__code_span_start] = ACTIONS(164),
    [sym__emphasis_open_star] = ACTIONS(167),
    [sym__emphasis_open_underscore] = ACTIONS(170),
    [sym__last_token_punctuation] = ACTIONS(173),
    [sym__strikethrough_open] = ACTIONS(175),
    [sym__latex_span_start] = ACTIONS(178),
    [sym__unclosed_span] = ACTIONS(119),
  },
  [4] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(49),
    [sym_full_reference_link] = STATE(49),
    [sym_collapsed_reference_link] = STATE(49),
    [sym_inline_link] = STATE(49),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(49),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(49),
    [aux_sym__inline_no_underscore] = STATE(49),
    [sym__strikethrough] = STATE(49),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(49),
    [sym__emphasis_underscore] = STATE(291),
    [sym__strong_emphasis_underscore] = STATE(49),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(181),
    [sym_entity_reference] = ACTIONS(184),
    [sym_numeric_character_reference] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(190),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(196),
    [anon_sym_BANG] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(196),
    [anon_sym_POUND] = ACTIONS(196),
    [anon_sym_DOLLAR] = ACTIONS(196),
    [anon_sym_PERCENT] = ACTIONS(196),
    [anon_sym_AMP] = ACTIONS(202),
    [anon_sym_SQUOTE] = ACTIONS(196),
    [anon_sym_STAR] = ACTIONS(196),
    [anon_sym_PLUS] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(196),
    [anon_sym_DASH] = ACTIONS(196),
    [anon_sym_DOT] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(196),
    [anon_sym_COLON] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(196),
    [anon_sym_EQ] = ACTIONS(196),
    [anon_sym_QMARK] = ACTIONS(196),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_CARET] = ACTIONS(196),
    [anon_sym__] = ACTIONS(196),
    [anon_sym_BQUOTE] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_PIPE] = ACTIONS(196),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_TILDE] = ACTIONS(196),
    [anon_sym_LPAREN] = ACTIONS(196),
    [anon_sym_RPAREN] = ACTIONS(196),
    [sym__newline_token] = ACTIONS(208),
    [sym_uri_autolink] = ACTIONS(184),
    [sym_email_autolink] = ACTIONS(184),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(211),
    [anon_sym_LT_QMARK] = ACTIONS(214),
    [aux_sym__declaration_token1] = ACTIONS(217),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(220),
    [sym__whitespace_ge_2] = ACTIONS(223),
    [aux_sym__whitespace_token1] = ACTIONS(226),
    [sym__word_no_digit] = ACTIONS(184),
    [sym__digits] = ACTIONS(184),
    [sym__code_span_start] = ACTIONS(229),
    [sym__emphasis_open_star] = ACTIONS(232),
    [sym__emphasis_open_underscore] = ACTIONS(235),
    [sym__last_token_punctuation] = ACTIONS(238),
    [sym__strikethrough_open] = ACTIONS(240),
    [sym__latex_span_start] = ACTIONS(243),
    [sym__unclosed_span] = ACTIONS(184),
  },
  [5] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(47),
    [sym_full_reference_link] = STATE(47),
    [sym_collapsed_reference_link] = STATE(47),
    [sym_inline_link] = STATE(47),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(47),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(47),
    [aux_sym__inline_no_underscore] = STATE(47),
    [sym__strikethrough] = STATE(47),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(47),
    [sym__emphasis_underscore] = STATE(268),
    [sym__strong_emphasis_underscore] = STATE(47),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(246),
    [sym_entity_reference] = ACTIONS(249),
    [sym_numeric_character_reference] = ACTIONS(249),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_RBRACK] = ACTIONS(255),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(261),
    [anon_sym_POUND] = ACTIONS(261),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_PERCENT] = ACTIONS(261),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_SQUOTE] = ACTIONS(261),
    [anon_sym_STAR] = ACTIONS(261),
    [anon_sym_PLUS] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(261),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(261),
    [anon_sym_SLASH] = ACTIONS(261),
    [anon_sym_COLON] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(261),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [anon_sym_BSLASH] = ACTIONS(270),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym__] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_PIPE] = ACTIONS(261),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_RPAREN] = ACTIONS(261),
    [sym__newline_token] = ACTIONS(273),
    [sym_uri_autolink] = ACTIONS(249),
    [sym_email_autolink] = ACTIONS(249),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(276),
    [anon_sym_LT_QMARK] = ACTIONS(279),
    [aux_sym__declaration_token1] = ACTIONS(282),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(285),
    [sym__whitespace_ge_2] = ACTIONS(288),
    [aux_sym__whitespace_token1] = ACTIONS(291),
    [sym__word_no_digit] = ACTIONS(249),
    [sym__digits] = ACTIONS(249),
    [sym__code_span_start] = ACTIONS(294),
    [sym__emphasis_open_star] = ACTIONS(297),
    [sym__emphasis_open_underscore] = ACTIONS(300),
    [sym__last_token_punctuation] = ACTIONS(303),
    [sym__strikethrough_open] = ACTIONS(305),
    [sym__strikethrough_close] = ACTIONS(308),
    [sym__latex_span_start] = ACTIONS(310),
    [sym__unclosed_span] = ACTIONS(249),
  },
  [6] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(41),
    [sym_full_reference_link] = STATE(41),
    [sym_collapsed_reference_link] = STATE(41),
    [sym_inline_link] = STATE(41),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(41),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(41),
    [aux_sym__inline_no_tilde] = STATE(41),
    [sym__strikethrough] = STATE(41),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(41),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(41),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(313),
    [sym_entity_reference] = ACTIONS(316),
    [sym_numeric_character_reference] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_RBRACK] = ACTIONS(322),
    [anon_sym_LT] = ACTIONS(325),
    [anon_sym_GT] = ACTIONS(328),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_DQUOTE] = ACTIONS(328),
    [anon_sym_POUND] = ACTIONS(328),
    [anon_sym_DOLLAR] = ACTIONS(328),
    [anon_sym_PERCENT] = ACTIONS(328),
    [anon_sym_AMP] = ACTIONS(334),
    [anon_sym_SQUOTE] = ACTIONS(328),
    [anon_sym_STAR] = ACTIONS(328),
    [anon_sym_PLUS] = ACTIONS(328),
    [anon_sym_COMMA] = ACTIONS(328),
    [anon_sym_DASH] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(328),
    [anon_sym_SLASH] = ACTIONS(328),
    [anon_sym_COLON] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_EQ] = ACTIONS(328),
    [anon_sym_QMARK] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(328),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(328),
    [anon_sym__] = ACTIONS(328),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [anon_sym_LBRACE] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(328),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_LPAREN] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [sym__newline_token] = ACTIONS(340),
    [sym_uri_autolink] = ACTIONS(316),
    [sym_email_autolink] = ACTIONS(316),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(343),
    [anon_sym_LT_QMARK] = ACTIONS(346),
    [aux_sym__declaration_token1] = ACTIONS(349),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(352),
    [sym__whitespace_ge_2] = ACTIONS(355),
    [aux_sym__whitespace_token1] = ACTIONS(358),
    [sym__word_no_digit] = ACTIONS(316),
    [sym__digits] = ACTIONS(316),
    [sym__code_span_start] = ACTIONS(361),
    [sym__emphasis_open_star] = ACTIONS(364),
    [sym__emphasis_open_underscore] = ACTIONS(367),
    [sym__last_token_punctuation] = ACTIONS(370),
    [sym__strikethrough_open] = ACTIONS(372),
    [sym__latex_span_start] = ACTIONS(375),
    [sym__unclosed_span] = ACTIONS(316),
  },
  [7] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(24),
    [sym_full_reference_link] = STATE(24),
    [sym_collapsed_reference_link] = STATE(24),
    [sym_inline_link] = STATE(24),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(24),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(24),
    [aux_sym__inline_no_star] = STATE(24),
    [sym__strikethrough] = STATE(24),
    [sym__emphasis_star] = STATE(314),
    [sym__strong_emphasis_star] = STATE(24),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(24),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(378),
    [sym_entity_reference] = ACTIONS(381),
    [sym_numeric_character_reference] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_RBRACK] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(390),
    [anon_sym_GT] = ACTIONS(393),
    [anon_sym_BANG] = ACTIONS(396),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_POUND] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(393),
    [anon_sym_PLUS] = ACTIONS(393),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_DASH] = ACTIONS(393),
    [anon_sym_DOT] = ACTIONS(393),
    [anon_sym_SLASH] = ACTIONS(393),
    [anon_sym_COLON] = ACTIONS(393),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_AT] = ACTIONS(393),
    [anon_sym_BSLASH] = ACTIONS(402),
    [anon_sym_CARET] = ACTIONS(393),
    [anon_sym__] = ACTIONS(393),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(393),
    [anon_sym_RBRACE] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_RPAREN] = ACTIONS(393),
    [sym__newline_token] = ACTIONS(405),
    [sym_uri_autolink] = ACTIONS(381),
    [sym_email_autolink] = ACTIONS(381),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(408),
    [anon_sym_LT_QMARK] = ACTIONS(411),
    [aux_sym__declaration_token1] = ACTIONS(414),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(417),
    [sym__whitespace_ge_2] = ACTIONS(420),
    [aux_sym__whitespace_token1] = ACTIONS(423),
    [sym__word_no_digit] = ACTIONS(381),
    [sym__digits] = ACTIONS(381),
    [sym__code_span_start] = ACTIONS(426),
    [sym__emphasis_open_star] = ACTIONS(429),
    [sym__emphasis_open_underscore] = ACTIONS(432),
    [sym__emphasis_close_underscore] = ACTIONS(104),
    [sym__last_token_punctuation] = ACTIONS(435),
    [sym__strikethrough_open] = ACTIONS(437),
    [sym__latex_span_start] = ACTIONS(440),
    [sym__unclosed_span] = ACTIONS(381),
  },
  [8] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(38),
    [sym_full_reference_link] = STATE(38),
    [sym_collapsed_reference_link] = STATE(38),
    [sym_inline_link] = STATE(38),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(38),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(38),
    [aux_sym__inline_no_tilde] = STATE(38),
    [sym__strikethrough] = STATE(38),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(38),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(38),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(443),
    [sym_entity_reference] = ACTIONS(446),
    [sym_numeric_character_reference] = ACTIONS(446),
    [anon_sym_LBRACK] = ACTIONS(449),
    [anon_sym_RBRACK] = ACTIONS(452),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_GT] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_DOLLAR] = ACTIONS(458),
    [anon_sym_PERCENT] = ACTIONS(458),
    [anon_sym_AMP] = ACTIONS(464),
    [anon_sym_SQUOTE] = ACTIONS(458),
    [anon_sym_STAR] = ACTIONS(458),
    [anon_sym_PLUS] = ACTIONS(458),
    [anon_sym_COMMA] = ACTIONS(458),
    [anon_sym_DASH] = ACTIONS(458),
    [anon_sym_DOT] = ACTIONS(458),
    [anon_sym_SLASH] = ACTIONS(458),
    [anon_sym_COLON] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(458),
    [anon_sym_EQ] = ACTIONS(458),
    [anon_sym_QMARK] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(458),
    [anon_sym_BSLASH] = ACTIONS(467),
    [anon_sym_CARET] = ACTIONS(458),
    [anon_sym__] = ACTIONS(458),
    [anon_sym_BQUOTE] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(458),
    [anon_sym_PIPE] = ACTIONS(458),
    [anon_sym_RBRACE] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(458),
    [anon_sym_LPAREN] = ACTIONS(458),
    [anon_sym_RPAREN] = ACTIONS(458),
    [sym__newline_token] = ACTIONS(470),
    [sym_uri_autolink] = ACTIONS(446),
    [sym_email_autolink] = ACTIONS(446),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(473),
    [anon_sym_LT_QMARK] = ACTIONS(476),
    [aux_sym__declaration_token1] = ACTIONS(479),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(482),
    [sym__whitespace_ge_2] = ACTIONS(485),
    [aux_sym__whitespace_token1] = ACTIONS(488),
    [sym__word_no_digit] = ACTIONS(446),
    [sym__digits] = ACTIONS(446),
    [sym__code_span_start] = ACTIONS(491),
    [sym__emphasis_open_star] = ACTIONS(494),
    [sym__emphasis_open_underscore] = ACTIONS(497),
    [sym__emphasis_close_star] = ACTIONS(500),
    [sym__last_token_punctuation] = ACTIONS(502),
    [sym__strikethrough_open] = ACTIONS(504),
    [sym__latex_span_start] = ACTIONS(507),
    [sym__unclosed_span] = ACTIONS(446),
  },
  [9] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(12),
    [sym_full_reference_link] = STATE(12),
    [sym_collapsed_reference_link] = STATE(12),
    [sym_inline_link] = STATE(12),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(12),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(12),
    [aux_sym__inline_no_underscore] = STATE(12),
    [sym__strikethrough] = STATE(12),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(12),
    [sym__emphasis_underscore] = STATE(408),
    [sym__strong_emphasis_underscore] = STATE(12),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(510),
    [sym_entity_reference] = ACTIONS(513),
    [sym_numeric_character_reference] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(516),
    [anon_sym_RBRACK] = ACTIONS(519),
    [anon_sym_LT] = ACTIONS(522),
    [anon_sym_GT] = ACTIONS(525),
    [anon_sym_BANG] = ACTIONS(528),
    [anon_sym_DQUOTE] = ACTIONS(525),
    [anon_sym_POUND] = ACTIONS(525),
    [anon_sym_DOLLAR] = ACTIONS(525),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_AMP] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [anon_sym_STAR] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(525),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_DASH] = ACTIONS(525),
    [anon_sym_DOT] = ACTIONS(525),
    [anon_sym_SLASH] = ACTIONS(525),
    [anon_sym_COLON] = ACTIONS(525),
    [anon_sym_SEMI] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(525),
    [anon_sym_AT] = ACTIONS(525),
    [anon_sym_BSLASH] = ACTIONS(534),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym__] = ACTIONS(525),
    [anon_sym_BQUOTE] = ACTIONS(525),
    [anon_sym_LBRACE] = ACTIONS(525),
    [anon_sym_PIPE] = ACTIONS(525),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_TILDE] = ACTIONS(525),
    [anon_sym_LPAREN] = ACTIONS(525),
    [anon_sym_RPAREN] = ACTIONS(525),
    [sym__newline_token] = ACTIONS(537),
    [sym_uri_autolink] = ACTIONS(513),
    [sym_email_autolink] = ACTIONS(513),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(540),
    [anon_sym_LT_QMARK] = ACTIONS(543),
    [aux_sym__declaration_token1] = ACTIONS(546),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(549),
    [sym__whitespace_ge_2] = ACTIONS(552),
    [aux_sym__whitespace_token1] = ACTIONS(555),
    [sym__word_no_digit] = ACTIONS(513),
    [sym__digits] = ACTIONS(513),
    [sym__code_span_start] = ACTIONS(558),
    [sym__emphasis_open_star] = ACTIONS(561),
    [sym__emphasis_open_underscore] = ACTIONS(564),
    [sym__emphasis_close_star] = ACTIONS(500),
    [sym__last_token_punctuation] = ACTIONS(567),
    [sym__strikethrough_open] = ACTIONS(569),
    [sym__latex_span_start] = ACTIONS(572),
    [sym__unclosed_span] = ACTIONS(513),
  },
  [10] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(45),
    [sym_full_reference_link] = STATE(45),
    [sym_collapsed_reference_link] = STATE(45),
    [sym_inline_link] = STATE(45),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(45),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(45),
    [aux_sym__inline_no_star] = STATE(45),
    [sym__strikethrough] = STATE(45),
    [sym__emphasis_star] = STATE(271),
    [sym__strong_emphasis_star] = STATE(45),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(45),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(575),
    [sym_entity_reference] = ACTIONS(578),
    [sym_numeric_character_reference] = ACTIONS(578),
    [anon_sym_LBRACK] = ACTIONS(581),
    [anon_sym_RBRACK] = ACTIONS(584),
    [anon_sym_LT] = ACTIONS(587),
    [anon_sym_GT] = ACTIONS(590),
    [anon_sym_BANG] = ACTIONS(593),
    [anon_sym_DQUOTE] = ACTIONS(590),
    [anon_sym_POUND] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(590),
    [anon_sym_PERCENT] = ACTIONS(590),
    [anon_sym_AMP] = ACTIONS(596),
    [anon_sym_SQUOTE] = ACTIONS(590),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(590),
    [anon_sym_COMMA] = ACTIONS(590),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_DOT] = ACTIONS(590),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_COLON] = ACTIONS(590),
    [anon_sym_SEMI] = ACTIONS(590),
    [anon_sym_EQ] = ACTIONS(590),
    [anon_sym_QMARK] = ACTIONS(590),
    [anon_sym_AT] = ACTIONS(590),
    [anon_sym_BSLASH] = ACTIONS(599),
    [anon_sym_CARET] = ACTIONS(590),
    [anon_sym__] = ACTIONS(590),
    [anon_sym_BQUOTE] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_PIPE] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(590),
    [anon_sym_LPAREN] = ACTIONS(590),
    [anon_sym_RPAREN] = ACTIONS(590),
    [sym__newline_token] = ACTIONS(602),
    [sym_uri_autolink] = ACTIONS(578),
    [sym_email_autolink] = ACTIONS(578),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(605),
    [anon_sym_LT_QMARK] = ACTIONS(608),
    [aux_sym__declaration_token1] = ACTIONS(611),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(614),
    [sym__whitespace_ge_2] = ACTIONS(617),
    [aux_sym__whitespace_token1] = ACTIONS(620),
    [sym__word_no_digit] = ACTIONS(578),
    [sym__digits] = ACTIONS(578),
    [sym__code_span_start] = ACTIONS(623),
    [sym__emphasis_open_star] = ACTIONS(626),
    [sym__emphasis_open_underscore] = ACTIONS(629),
    [sym__last_token_punctuation] = ACTIONS(632),
    [sym__strikethrough_open] = ACTIONS(634),
    [sym__strikethrough_close] = ACTIONS(308),
    [sym__latex_span_start] = ACTIONS(637),
    [sym__unclosed_span] = ACTIONS(578),
  },
  [11] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(678),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [12] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(722),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [13] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(768),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [14] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(772),
    [sym_entity_reference] = ACTIONS(775),
    [sym_numeric_character_reference] = ACTIONS(775),
    [anon_sym_LBRACK] = ACTIONS(778),
    [anon_sym_RBRACK] = ACTIONS(781),
    [anon_sym_LT] = ACTIONS(784),
    [anon_sym_GT] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_POUND] = ACTIONS(787),
    [anon_sym_DOLLAR] = ACTIONS(787),
    [anon_sym_PERCENT] = ACTIONS(787),
    [anon_sym_AMP] = ACTIONS(793),
    [anon_sym_SQUOTE] = ACTIONS(787),
    [anon_sym_STAR] = ACTIONS(787),
    [anon_sym_PLUS] = ACTIONS(787),
    [anon_sym_COMMA] = ACTIONS(787),
    [anon_sym_DASH] = ACTIONS(787),
    [anon_sym_DOT] = ACTIONS(787),
    [anon_sym_SLASH] = ACTIONS(787),
    [anon_sym_COLON] = ACTIONS(787),
    [anon_sym_SEMI] = ACTIONS(787),
    [anon_sym_EQ] = ACTIONS(787),
    [anon_sym_QMARK] = ACTIONS(787),
    [anon_sym_AT] = ACTIONS(787),
    [anon_sym_BSLASH] = ACTIONS(796),
    [anon_sym_CARET] = ACTIONS(787),
    [anon_sym__] = ACTIONS(787),
    [anon_sym_BQUOTE] = ACTIONS(787),
    [anon_sym_LBRACE] = ACTIONS(787),
    [anon_sym_PIPE] = ACTIONS(787),
    [anon_sym_RBRACE] = ACTIONS(787),
    [anon_sym_TILDE] = ACTIONS(787),
    [anon_sym_LPAREN] = ACTIONS(787),
    [anon_sym_RPAREN] = ACTIONS(787),
    [sym__newline_token] = ACTIONS(799),
    [sym_uri_autolink] = ACTIONS(775),
    [sym_email_autolink] = ACTIONS(775),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(802),
    [anon_sym_LT_QMARK] = ACTIONS(805),
    [aux_sym__declaration_token1] = ACTIONS(808),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(811),
    [sym__whitespace_ge_2] = ACTIONS(814),
    [aux_sym__whitespace_token1] = ACTIONS(817),
    [sym__word_no_digit] = ACTIONS(775),
    [sym__digits] = ACTIONS(775),
    [sym__code_span_start] = ACTIONS(820),
    [sym__emphasis_open_star] = ACTIONS(823),
    [sym__emphasis_open_underscore] = ACTIONS(826),
    [sym__strikethrough_open] = ACTIONS(829),
    [sym__strikethrough_close] = ACTIONS(832),
    [sym__latex_span_start] = ACTIONS(834),
    [sym__unclosed_span] = ACTIONS(775),
  },
  [15] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(837),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [16] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(839),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [17] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(841),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [18] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(843),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [19] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(845),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [20] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(847),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [21] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(849),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [22] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(851),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [23] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(853),
    [sym_entity_reference] = ACTIONS(856),
    [sym_numeric_character_reference] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(859),
    [anon_sym_RBRACK] = ACTIONS(862),
    [anon_sym_LT] = ACTIONS(865),
    [anon_sym_GT] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(871),
    [anon_sym_DQUOTE] = ACTIONS(868),
    [anon_sym_POUND] = ACTIONS(868),
    [anon_sym_DOLLAR] = ACTIONS(868),
    [anon_sym_PERCENT] = ACTIONS(868),
    [anon_sym_AMP] = ACTIONS(874),
    [anon_sym_SQUOTE] = ACTIONS(868),
    [anon_sym_STAR] = ACTIONS(868),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_COMMA] = ACTIONS(868),
    [anon_sym_DASH] = ACTIONS(868),
    [anon_sym_DOT] = ACTIONS(868),
    [anon_sym_SLASH] = ACTIONS(868),
    [anon_sym_COLON] = ACTIONS(868),
    [anon_sym_SEMI] = ACTIONS(868),
    [anon_sym_EQ] = ACTIONS(868),
    [anon_sym_QMARK] = ACTIONS(868),
    [anon_sym_AT] = ACTIONS(868),
    [anon_sym_BSLASH] = ACTIONS(877),
    [anon_sym_CARET] = ACTIONS(868),
    [anon_sym__] = ACTIONS(868),
    [anon_sym_BQUOTE] = ACTIONS(868),
    [anon_sym_LBRACE] = ACTIONS(868),
    [anon_sym_PIPE] = ACTIONS(868),
    [anon_sym_RBRACE] = ACTIONS(868),
    [anon_sym_TILDE] = ACTIONS(868),
    [anon_sym_LPAREN] = ACTIONS(868),
    [anon_sym_RPAREN] = ACTIONS(868),
    [sym__newline_token] = ACTIONS(880),
    [sym_uri_autolink] = ACTIONS(856),
    [sym_email_autolink] = ACTIONS(856),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(883),
    [anon_sym_LT_QMARK] = ACTIONS(886),
    [aux_sym__declaration_token1] = ACTIONS(889),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(892),
    [sym__whitespace_ge_2] = ACTIONS(895),
    [aux_sym__whitespace_token1] = ACTIONS(898),
    [sym__word_no_digit] = ACTIONS(856),
    [sym__digits] = ACTIONS(856),
    [sym__code_span_start] = ACTIONS(901),
    [sym__emphasis_open_star] = ACTIONS(904),
    [sym__emphasis_open_underscore] = ACTIONS(907),
    [sym__emphasis_close_underscore] = ACTIONS(910),
    [sym__strikethrough_open] = ACTIONS(912),
    [sym__latex_span_start] = ACTIONS(915),
    [sym__unclosed_span] = ACTIONS(856),
  },
  [24] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(918),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [25] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(920),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [26] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(922),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [27] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(924),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [28] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(317),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(116),
    [sym_entity_reference] = ACTIONS(119),
    [sym_numeric_character_reference] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(122),
    [anon_sym_RBRACK] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(131),
    [anon_sym_BANG] = ACTIONS(134),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(131),
    [anon_sym_DOLLAR] = ACTIONS(131),
    [anon_sym_PERCENT] = ACTIONS(131),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(131),
    [anon_sym_COMMA] = ACTIONS(131),
    [anon_sym_DASH] = ACTIONS(131),
    [anon_sym_DOT] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(131),
    [anon_sym_COLON] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(131),
    [anon_sym_EQ] = ACTIONS(131),
    [anon_sym_QMARK] = ACTIONS(131),
    [anon_sym_AT] = ACTIONS(131),
    [anon_sym_BSLASH] = ACTIONS(140),
    [anon_sym_CARET] = ACTIONS(131),
    [anon_sym__] = ACTIONS(131),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_PIPE] = ACTIONS(131),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_TILDE] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(131),
    [sym__newline_token] = ACTIONS(143),
    [sym_uri_autolink] = ACTIONS(119),
    [sym_email_autolink] = ACTIONS(119),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(146),
    [anon_sym_LT_QMARK] = ACTIONS(149),
    [aux_sym__declaration_token1] = ACTIONS(152),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(155),
    [sym__whitespace_ge_2] = ACTIONS(158),
    [aux_sym__whitespace_token1] = ACTIONS(161),
    [sym__word_no_digit] = ACTIONS(119),
    [sym__digits] = ACTIONS(119),
    [sym__code_span_start] = ACTIONS(164),
    [sym__emphasis_open_star] = ACTIONS(167),
    [sym__emphasis_open_underscore] = ACTIONS(170),
    [sym__last_token_punctuation] = ACTIONS(926),
    [sym__strikethrough_open] = ACTIONS(175),
    [sym__latex_span_start] = ACTIONS(178),
    [sym__unclosed_span] = ACTIONS(119),
  },
  [29] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(25),
    [sym_full_reference_link] = STATE(25),
    [sym_collapsed_reference_link] = STATE(25),
    [sym_inline_link] = STATE(25),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(25),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(25),
    [aux_sym__inline_no_underscore] = STATE(25),
    [sym__strikethrough] = STATE(25),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(25),
    [sym__emphasis_underscore] = STATE(320),
    [sym__strong_emphasis_underscore] = STATE(25),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(181),
    [sym_entity_reference] = ACTIONS(184),
    [sym_numeric_character_reference] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(190),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(196),
    [anon_sym_BANG] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(196),
    [anon_sym_POUND] = ACTIONS(196),
    [anon_sym_DOLLAR] = ACTIONS(196),
    [anon_sym_PERCENT] = ACTIONS(196),
    [anon_sym_AMP] = ACTIONS(202),
    [anon_sym_SQUOTE] = ACTIONS(196),
    [anon_sym_STAR] = ACTIONS(196),
    [anon_sym_PLUS] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(196),
    [anon_sym_DASH] = ACTIONS(196),
    [anon_sym_DOT] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(196),
    [anon_sym_COLON] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(196),
    [anon_sym_EQ] = ACTIONS(196),
    [anon_sym_QMARK] = ACTIONS(196),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_CARET] = ACTIONS(196),
    [anon_sym__] = ACTIONS(196),
    [anon_sym_BQUOTE] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_PIPE] = ACTIONS(196),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_TILDE] = ACTIONS(196),
    [anon_sym_LPAREN] = ACTIONS(196),
    [anon_sym_RPAREN] = ACTIONS(196),
    [sym__newline_token] = ACTIONS(208),
    [sym_uri_autolink] = ACTIONS(184),
    [sym_email_autolink] = ACTIONS(184),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(211),
    [anon_sym_LT_QMARK] = ACTIONS(214),
    [aux_sym__declaration_token1] = ACTIONS(217),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(220),
    [sym__whitespace_ge_2] = ACTIONS(223),
    [aux_sym__whitespace_token1] = ACTIONS(226),
    [sym__word_no_digit] = ACTIONS(184),
    [sym__digits] = ACTIONS(184),
    [sym__code_span_start] = ACTIONS(229),
    [sym__emphasis_open_star] = ACTIONS(232),
    [sym__emphasis_open_underscore] = ACTIONS(235),
    [sym__last_token_punctuation] = ACTIONS(928),
    [sym__strikethrough_open] = ACTIONS(240),
    [sym__latex_span_start] = ACTIONS(243),
    [sym__unclosed_span] = ACTIONS(184),
  },
  [30] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(27),
    [sym_full_reference_link] = STATE(27),
    [sym_collapsed_reference_link] = STATE(27),
    [sym_inline_link] = STATE(27),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(27),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(27),
    [aux_sym__inline_no_tilde] = STATE(27),
    [sym__strikethrough] = STATE(27),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(27),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(27),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(313),
    [sym_entity_reference] = ACTIONS(316),
    [sym_numeric_character_reference] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_RBRACK] = ACTIONS(322),
    [anon_sym_LT] = ACTIONS(325),
    [anon_sym_GT] = ACTIONS(328),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_DQUOTE] = ACTIONS(328),
    [anon_sym_POUND] = ACTIONS(328),
    [anon_sym_DOLLAR] = ACTIONS(328),
    [anon_sym_PERCENT] = ACTIONS(328),
    [anon_sym_AMP] = ACTIONS(334),
    [anon_sym_SQUOTE] = ACTIONS(328),
    [anon_sym_STAR] = ACTIONS(328),
    [anon_sym_PLUS] = ACTIONS(328),
    [anon_sym_COMMA] = ACTIONS(328),
    [anon_sym_DASH] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(328),
    [anon_sym_SLASH] = ACTIONS(328),
    [anon_sym_COLON] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_EQ] = ACTIONS(328),
    [anon_sym_QMARK] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(328),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(328),
    [anon_sym__] = ACTIONS(328),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [anon_sym_LBRACE] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(328),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_LPAREN] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [sym__newline_token] = ACTIONS(340),
    [sym_uri_autolink] = ACTIONS(316),
    [sym_email_autolink] = ACTIONS(316),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(343),
    [anon_sym_LT_QMARK] = ACTIONS(346),
    [aux_sym__declaration_token1] = ACTIONS(349),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(352),
    [sym__whitespace_ge_2] = ACTIONS(355),
    [aux_sym__whitespace_token1] = ACTIONS(358),
    [sym__word_no_digit] = ACTIONS(316),
    [sym__digits] = ACTIONS(316),
    [sym__code_span_start] = ACTIONS(361),
    [sym__emphasis_open_star] = ACTIONS(364),
    [sym__emphasis_open_underscore] = ACTIONS(367),
    [sym__last_token_punctuation] = ACTIONS(930),
    [sym__strikethrough_open] = ACTIONS(372),
    [sym__latex_span_start] = ACTIONS(375),
    [sym__unclosed_span] = ACTIONS(316),
  },
  [31] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(48),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(932),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [32] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(934),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [33] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(936),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [34] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(938),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [35] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(940),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [36] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(11),
    [sym_full_reference_link] = STATE(11),
    [sym_collapsed_reference_link] = STATE(11),
    [sym_inline_link] = STATE(11),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(11),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(11),
    [aux_sym__inline_no_star] = STATE(11),
    [sym__strikethrough] = STATE(11),
    [sym__emphasis_star] = STATE(410),
    [sym__strong_emphasis_star] = STATE(11),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(11),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__last_token_punctuation] = ACTIONS(942),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [37] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(944),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [38] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(946),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [39] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(948),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [40] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(950),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [41] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(952),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [42] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(954),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [43] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(956),
    [sym_entity_reference] = ACTIONS(959),
    [sym_numeric_character_reference] = ACTIONS(959),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_RBRACK] = ACTIONS(965),
    [anon_sym_LT] = ACTIONS(968),
    [anon_sym_GT] = ACTIONS(971),
    [anon_sym_BANG] = ACTIONS(974),
    [anon_sym_DQUOTE] = ACTIONS(971),
    [anon_sym_POUND] = ACTIONS(971),
    [anon_sym_DOLLAR] = ACTIONS(971),
    [anon_sym_PERCENT] = ACTIONS(971),
    [anon_sym_AMP] = ACTIONS(977),
    [anon_sym_SQUOTE] = ACTIONS(971),
    [anon_sym_STAR] = ACTIONS(971),
    [anon_sym_PLUS] = ACTIONS(971),
    [anon_sym_COMMA] = ACTIONS(971),
    [anon_sym_DASH] = ACTIONS(971),
    [anon_sym_DOT] = ACTIONS(971),
    [anon_sym_SLASH] = ACTIONS(971),
    [anon_sym_COLON] = ACTIONS(971),
    [anon_sym_SEMI] = ACTIONS(971),
    [anon_sym_EQ] = ACTIONS(971),
    [anon_sym_QMARK] = ACTIONS(971),
    [anon_sym_AT] = ACTIONS(971),
    [anon_sym_BSLASH] = ACTIONS(980),
    [anon_sym_CARET] = ACTIONS(971),
    [anon_sym__] = ACTIONS(971),
    [anon_sym_BQUOTE] = ACTIONS(971),
    [anon_sym_LBRACE] = ACTIONS(971),
    [anon_sym_PIPE] = ACTIONS(971),
    [anon_sym_RBRACE] = ACTIONS(971),
    [anon_sym_TILDE] = ACTIONS(971),
    [anon_sym_LPAREN] = ACTIONS(971),
    [anon_sym_RPAREN] = ACTIONS(971),
    [sym__newline_token] = ACTIONS(983),
    [sym_uri_autolink] = ACTIONS(959),
    [sym_email_autolink] = ACTIONS(959),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(986),
    [anon_sym_LT_QMARK] = ACTIONS(989),
    [aux_sym__declaration_token1] = ACTIONS(992),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(995),
    [sym__whitespace_ge_2] = ACTIONS(998),
    [aux_sym__whitespace_token1] = ACTIONS(1001),
    [sym__word_no_digit] = ACTIONS(959),
    [sym__digits] = ACTIONS(959),
    [sym__code_span_start] = ACTIONS(1004),
    [sym__emphasis_open_star] = ACTIONS(1007),
    [sym__emphasis_open_underscore] = ACTIONS(1010),
    [sym__emphasis_close_star] = ACTIONS(1013),
    [sym__strikethrough_open] = ACTIONS(1015),
    [sym__latex_span_start] = ACTIONS(1018),
    [sym__unclosed_span] = ACTIONS(959),
  },
  [44] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(26),
    [sym_full_reference_link] = STATE(26),
    [sym_collapsed_reference_link] = STATE(26),
    [sym_inline_link] = STATE(26),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(26),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(26),
    [aux_sym__inline_no_tilde] = STATE(26),
    [sym__strikethrough] = STATE(26),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(26),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(26),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__last_token_punctuation] = ACTIONS(1021),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [45] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(1023),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [46] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(20),
    [sym_full_reference_link] = STATE(20),
    [sym_collapsed_reference_link] = STATE(20),
    [sym_inline_link] = STATE(20),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(20),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(20),
    [aux_sym__inline_no_underscore] = STATE(20),
    [sym__strikethrough] = STATE(20),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(20),
    [sym__emphasis_underscore] = STATE(312),
    [sym__strong_emphasis_underscore] = STATE(20),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__last_token_punctuation] = ACTIONS(1025),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [47] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(1027),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [48] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(48),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(1029),
    [sym__backslash_escape] = ACTIONS(1031),
    [sym_entity_reference] = ACTIONS(1034),
    [sym_numeric_character_reference] = ACTIONS(1034),
    [anon_sym_LBRACK] = ACTIONS(1037),
    [anon_sym_RBRACK] = ACTIONS(1040),
    [anon_sym_LT] = ACTIONS(1043),
    [anon_sym_GT] = ACTIONS(1046),
    [anon_sym_BANG] = ACTIONS(1049),
    [anon_sym_DQUOTE] = ACTIONS(1046),
    [anon_sym_POUND] = ACTIONS(1046),
    [anon_sym_DOLLAR] = ACTIONS(1046),
    [anon_sym_PERCENT] = ACTIONS(1046),
    [anon_sym_AMP] = ACTIONS(1052),
    [anon_sym_SQUOTE] = ACTIONS(1046),
    [anon_sym_STAR] = ACTIONS(1046),
    [anon_sym_PLUS] = ACTIONS(1046),
    [anon_sym_COMMA] = ACTIONS(1046),
    [anon_sym_DASH] = ACTIONS(1046),
    [anon_sym_DOT] = ACTIONS(1046),
    [anon_sym_SLASH] = ACTIONS(1046),
    [anon_sym_COLON] = ACTIONS(1046),
    [anon_sym_SEMI] = ACTIONS(1046),
    [anon_sym_EQ] = ACTIONS(1046),
    [anon_sym_QMARK] = ACTIONS(1046),
    [anon_sym_AT] = ACTIONS(1046),
    [anon_sym_BSLASH] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1046),
    [anon_sym__] = ACTIONS(1046),
    [anon_sym_BQUOTE] = ACTIONS(1046),
    [anon_sym_LBRACE] = ACTIONS(1046),
    [anon_sym_PIPE] = ACTIONS(1046),
    [anon_sym_RBRACE] = ACTIONS(1046),
    [anon_sym_TILDE] = ACTIONS(1046),
    [anon_sym_LPAREN] = ACTIONS(1046),
    [anon_sym_RPAREN] = ACTIONS(1046),
    [sym__newline_token] = ACTIONS(1058),
    [sym_uri_autolink] = ACTIONS(1034),
    [sym_email_autolink] = ACTIONS(1034),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1061),
    [anon_sym_LT_QMARK] = ACTIONS(1064),
    [aux_sym__declaration_token1] = ACTIONS(1067),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1070),
    [sym__whitespace_ge_2] = ACTIONS(1073),
    [aux_sym__whitespace_token1] = ACTIONS(1076),
    [sym__word_no_digit] = ACTIONS(1034),
    [sym__digits] = ACTIONS(1034),
    [sym__code_span_start] = ACTIONS(1079),
    [sym__emphasis_open_star] = ACTIONS(1082),
    [sym__emphasis_open_underscore] = ACTIONS(1085),
    [sym__strikethrough_open] = ACTIONS(1088),
    [sym__latex_span_start] = ACTIONS(1091),
    [sym__unclosed_span] = ACTIONS(1034),
  },
  [49] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(1094),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [50] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(1096),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [51] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(1098),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [52] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(48),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(1100),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [53] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [54] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(37),
    [sym_full_reference_link] = STATE(37),
    [sym_collapsed_reference_link] = STATE(37),
    [sym_inline_link] = STATE(37),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(37),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(37),
    [aux_sym__inline_no_star] = STATE(37),
    [sym__strikethrough] = STATE(37),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(37),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(37),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [55] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(32),
    [sym_full_reference_link] = STATE(32),
    [sym_collapsed_reference_link] = STATE(32),
    [sym_inline_link] = STATE(32),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(32),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(32),
    [aux_sym__inline_no_underscore] = STATE(32),
    [sym__strikethrough] = STATE(32),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(32),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(32),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [56] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(52),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [57] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(39),
    [sym_full_reference_link] = STATE(39),
    [sym_collapsed_reference_link] = STATE(39),
    [sym_inline_link] = STATE(39),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(39),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(39),
    [aux_sym__inline_no_tilde] = STATE(39),
    [sym__strikethrough] = STATE(39),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(39),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(39),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [58] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(22),
    [sym_full_reference_link] = STATE(22),
    [sym_collapsed_reference_link] = STATE(22),
    [sym_inline_link] = STATE(22),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(22),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(22),
    [aux_sym__inline_no_underscore] = STATE(22),
    [sym__strikethrough] = STATE(22),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(22),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(22),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [59] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1144),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [60] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1146),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [61] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1148),
    [sym_entity_reference] = ACTIONS(1151),
    [sym_numeric_character_reference] = ACTIONS(1151),
    [anon_sym_LBRACK] = ACTIONS(1154),
    [anon_sym_RBRACK] = ACTIONS(1157),
    [anon_sym_LT] = ACTIONS(1160),
    [anon_sym_GT] = ACTIONS(1163),
    [anon_sym_BANG] = ACTIONS(1166),
    [anon_sym_DQUOTE] = ACTIONS(1163),
    [anon_sym_POUND] = ACTIONS(1163),
    [anon_sym_DOLLAR] = ACTIONS(1163),
    [anon_sym_PERCENT] = ACTIONS(1163),
    [anon_sym_AMP] = ACTIONS(1169),
    [anon_sym_SQUOTE] = ACTIONS(1163),
    [anon_sym_STAR] = ACTIONS(1163),
    [anon_sym_PLUS] = ACTIONS(1163),
    [anon_sym_COMMA] = ACTIONS(1163),
    [anon_sym_DASH] = ACTIONS(1163),
    [anon_sym_DOT] = ACTIONS(1163),
    [anon_sym_SLASH] = ACTIONS(1163),
    [anon_sym_COLON] = ACTIONS(1163),
    [anon_sym_SEMI] = ACTIONS(1163),
    [anon_sym_EQ] = ACTIONS(1163),
    [anon_sym_QMARK] = ACTIONS(1163),
    [anon_sym_AT] = ACTIONS(1163),
    [anon_sym_BSLASH] = ACTIONS(1172),
    [anon_sym_CARET] = ACTIONS(1163),
    [anon_sym__] = ACTIONS(1163),
    [anon_sym_BQUOTE] = ACTIONS(1163),
    [anon_sym_LBRACE] = ACTIONS(1163),
    [anon_sym_PIPE] = ACTIONS(1163),
    [anon_sym_RBRACE] = ACTIONS(1163),
    [anon_sym_TILDE] = ACTIONS(1163),
    [anon_sym_LPAREN] = ACTIONS(1163),
    [anon_sym_RPAREN] = ACTIONS(1163),
    [sym__newline_token] = ACTIONS(1175),
    [sym_uri_autolink] = ACTIONS(1151),
    [sym_email_autolink] = ACTIONS(1151),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1178),
    [anon_sym_LT_QMARK] = ACTIONS(1181),
    [aux_sym__declaration_token1] = ACTIONS(1184),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1187),
    [sym__whitespace_ge_2] = ACTIONS(1190),
    [aux_sym__whitespace_token1] = ACTIONS(1193),
    [sym__word_no_digit] = ACTIONS(1151),
    [sym__digits] = ACTIONS(1151),
    [sym__code_span_start] = ACTIONS(1196),
    [sym__emphasis_open_star] = ACTIONS(1199),
    [sym__emphasis_open_underscore] = ACTIONS(1202),
    [sym__strikethrough_open] = ACTIONS(1205),
    [sym__latex_span_start] = ACTIONS(1208),
    [sym__unclosed_span] = ACTIONS(1151),
  },
  [62] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1211),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [63] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(13),
    [sym_full_reference_link] = STATE(13),
    [sym_collapsed_reference_link] = STATE(13),
    [sym_inline_link] = STATE(13),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(13),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(13),
    [aux_sym__inline_no_tilde] = STATE(13),
    [sym__strikethrough] = STATE(13),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(13),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(13),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [64] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(15),
    [aux_sym__inline_no_star] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [65] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(85),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [66] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1215),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [67] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(40),
    [sym_full_reference_link] = STATE(40),
    [sym_collapsed_reference_link] = STATE(40),
    [sym_inline_link] = STATE(40),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(40),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(40),
    [aux_sym__inline_no_star] = STATE(40),
    [sym__strikethrough] = STATE(40),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(40),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(40),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [68] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(51),
    [sym_full_reference_link] = STATE(51),
    [sym_collapsed_reference_link] = STATE(51),
    [sym_inline_link] = STATE(51),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(51),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(51),
    [aux_sym__inline_no_underscore] = STATE(51),
    [sym__strikethrough] = STATE(51),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(51),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(51),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [69] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(62),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [70] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(50),
    [sym_full_reference_link] = STATE(50),
    [sym_collapsed_reference_link] = STATE(50),
    [sym_inline_link] = STATE(50),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(50),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(50),
    [aux_sym__inline_no_tilde] = STATE(50),
    [sym__strikethrough] = STATE(50),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(50),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(50),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [71] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(53),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [72] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(18),
    [sym_full_reference_link] = STATE(18),
    [sym_collapsed_reference_link] = STATE(18),
    [sym_inline_link] = STATE(18),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(18),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(18),
    [aux_sym__inline_no_star] = STATE(18),
    [sym__strikethrough] = STATE(18),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(18),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(18),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [73] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(17),
    [sym_full_reference_link] = STATE(17),
    [sym_collapsed_reference_link] = STATE(17),
    [sym_inline_link] = STATE(17),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(17),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(17),
    [aux_sym__inline_no_underscore] = STATE(17),
    [sym__strikethrough] = STATE(17),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(17),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(17),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [74] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(35),
    [sym_full_reference_link] = STATE(35),
    [sym_collapsed_reference_link] = STATE(35),
    [sym_inline_link] = STATE(35),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(35),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(35),
    [aux_sym__inline_no_tilde] = STATE(35),
    [sym__strikethrough] = STATE(35),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(35),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(35),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [75] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(34),
    [sym_full_reference_link] = STATE(34),
    [sym_collapsed_reference_link] = STATE(34),
    [sym_inline_link] = STATE(34),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(34),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(34),
    [aux_sym__inline_no_underscore] = STATE(34),
    [sym__strikethrough] = STATE(34),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(34),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(34),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [76] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(33),
    [sym_full_reference_link] = STATE(33),
    [sym_collapsed_reference_link] = STATE(33),
    [sym_inline_link] = STATE(33),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(33),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(33),
    [aux_sym__inline_no_star] = STATE(33),
    [sym__strikethrough] = STATE(33),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(33),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(33),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [77] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [78] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(16),
    [sym_full_reference_link] = STATE(16),
    [sym_collapsed_reference_link] = STATE(16),
    [sym_inline_link] = STATE(16),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(16),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(16),
    [aux_sym__inline_no_tilde] = STATE(16),
    [sym__strikethrough] = STATE(16),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(16),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(16),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [79] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1217),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [80] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(59),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [81] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1219),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [82] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(81),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [83] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(60),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [84] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(66),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [85] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1221),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [86] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(114),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1223),
    [sym_entity_reference] = ACTIONS(1226),
    [sym_numeric_character_reference] = ACTIONS(1226),
    [anon_sym_LBRACK] = ACTIONS(500),
    [anon_sym_RBRACK] = ACTIONS(1229),
    [anon_sym_LT] = ACTIONS(1232),
    [anon_sym_GT] = ACTIONS(1235),
    [anon_sym_BANG] = ACTIONS(1238),
    [anon_sym_DQUOTE] = ACTIONS(1235),
    [anon_sym_POUND] = ACTIONS(1235),
    [anon_sym_DOLLAR] = ACTIONS(1235),
    [anon_sym_PERCENT] = ACTIONS(1235),
    [anon_sym_AMP] = ACTIONS(1241),
    [anon_sym_SQUOTE] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1235),
    [anon_sym_PLUS] = ACTIONS(1235),
    [anon_sym_COMMA] = ACTIONS(1235),
    [anon_sym_DASH] = ACTIONS(1235),
    [anon_sym_DOT] = ACTIONS(1235),
    [anon_sym_SLASH] = ACTIONS(1235),
    [anon_sym_COLON] = ACTIONS(1235),
    [anon_sym_SEMI] = ACTIONS(1235),
    [anon_sym_EQ] = ACTIONS(1235),
    [anon_sym_QMARK] = ACTIONS(1235),
    [anon_sym_AT] = ACTIONS(1235),
    [anon_sym_BSLASH] = ACTIONS(1244),
    [anon_sym_CARET] = ACTIONS(1235),
    [anon_sym__] = ACTIONS(1235),
    [anon_sym_BQUOTE] = ACTIONS(1235),
    [anon_sym_LBRACE] = ACTIONS(1235),
    [anon_sym_PIPE] = ACTIONS(1235),
    [anon_sym_RBRACE] = ACTIONS(1235),
    [anon_sym_TILDE] = ACTIONS(1235),
    [anon_sym_LPAREN] = ACTIONS(1235),
    [anon_sym_RPAREN] = ACTIONS(1235),
    [sym__newline_token] = ACTIONS(1247),
    [sym_uri_autolink] = ACTIONS(1226),
    [sym_email_autolink] = ACTIONS(1226),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1250),
    [anon_sym_LT_QMARK] = ACTIONS(1253),
    [aux_sym__declaration_token1] = ACTIONS(1256),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1259),
    [sym__whitespace_ge_2] = ACTIONS(1262),
    [aux_sym__whitespace_token1] = ACTIONS(1265),
    [sym__word_no_digit] = ACTIONS(1226),
    [sym__digits] = ACTIONS(1226),
    [sym__code_span_start] = ACTIONS(1268),
    [sym__emphasis_open_star] = ACTIONS(1271),
    [sym__emphasis_open_underscore] = ACTIONS(1274),
    [sym__emphasis_close_star] = ACTIONS(500),
    [sym__last_token_punctuation] = ACTIONS(1277),
    [sym__strikethrough_open] = ACTIONS(1279),
    [sym__latex_span_start] = ACTIONS(1282),
    [sym__unclosed_span] = ACTIONS(1226),
  },
  [87] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(131),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1285),
    [sym_entity_reference] = ACTIONS(1288),
    [sym_numeric_character_reference] = ACTIONS(1288),
    [anon_sym_LBRACK] = ACTIONS(308),
    [anon_sym_RBRACK] = ACTIONS(1291),
    [anon_sym_LT] = ACTIONS(1294),
    [anon_sym_GT] = ACTIONS(1297),
    [anon_sym_BANG] = ACTIONS(1300),
    [anon_sym_DQUOTE] = ACTIONS(1297),
    [anon_sym_POUND] = ACTIONS(1297),
    [anon_sym_DOLLAR] = ACTIONS(1297),
    [anon_sym_PERCENT] = ACTIONS(1297),
    [anon_sym_AMP] = ACTIONS(1303),
    [anon_sym_SQUOTE] = ACTIONS(1297),
    [anon_sym_STAR] = ACTIONS(1297),
    [anon_sym_PLUS] = ACTIONS(1297),
    [anon_sym_COMMA] = ACTIONS(1297),
    [anon_sym_DASH] = ACTIONS(1297),
    [anon_sym_DOT] = ACTIONS(1297),
    [anon_sym_SLASH] = ACTIONS(1297),
    [anon_sym_COLON] = ACTIONS(1297),
    [anon_sym_SEMI] = ACTIONS(1297),
    [anon_sym_EQ] = ACTIONS(1297),
    [anon_sym_QMARK] = ACTIONS(1297),
    [anon_sym_AT] = ACTIONS(1297),
    [anon_sym_BSLASH] = ACTIONS(1306),
    [anon_sym_CARET] = ACTIONS(1297),
    [anon_sym__] = ACTIONS(1297),
    [anon_sym_BQUOTE] = ACTIONS(1297),
    [anon_sym_LBRACE] = ACTIONS(1297),
    [anon_sym_PIPE] = ACTIONS(1297),
    [anon_sym_RBRACE] = ACTIONS(1297),
    [anon_sym_TILDE] = ACTIONS(1297),
    [anon_sym_LPAREN] = ACTIONS(1297),
    [anon_sym_RPAREN] = ACTIONS(1297),
    [sym__newline_token] = ACTIONS(1309),
    [sym_uri_autolink] = ACTIONS(1288),
    [sym_email_autolink] = ACTIONS(1288),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1312),
    [anon_sym_LT_QMARK] = ACTIONS(1315),
    [aux_sym__declaration_token1] = ACTIONS(1318),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1321),
    [sym__whitespace_ge_2] = ACTIONS(1324),
    [aux_sym__whitespace_token1] = ACTIONS(1327),
    [sym__word_no_digit] = ACTIONS(1288),
    [sym__digits] = ACTIONS(1288),
    [sym__code_span_start] = ACTIONS(1330),
    [sym__emphasis_open_star] = ACTIONS(1333),
    [sym__emphasis_open_underscore] = ACTIONS(1336),
    [sym__last_token_punctuation] = ACTIONS(1339),
    [sym__strikethrough_open] = ACTIONS(1341),
    [sym__strikethrough_close] = ACTIONS(308),
    [sym__latex_span_start] = ACTIONS(1344),
    [sym__unclosed_span] = ACTIONS(1288),
  },
  [88] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(132),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1347),
    [sym_entity_reference] = ACTIONS(1350),
    [sym_numeric_character_reference] = ACTIONS(1350),
    [anon_sym_LBRACK] = ACTIONS(104),
    [anon_sym_RBRACK] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(1356),
    [anon_sym_GT] = ACTIONS(1359),
    [anon_sym_BANG] = ACTIONS(1362),
    [anon_sym_DQUOTE] = ACTIONS(1359),
    [anon_sym_POUND] = ACTIONS(1359),
    [anon_sym_DOLLAR] = ACTIONS(1359),
    [anon_sym_PERCENT] = ACTIONS(1359),
    [anon_sym_AMP] = ACTIONS(1365),
    [anon_sym_SQUOTE] = ACTIONS(1359),
    [anon_sym_STAR] = ACTIONS(1359),
    [anon_sym_PLUS] = ACTIONS(1359),
    [anon_sym_COMMA] = ACTIONS(1359),
    [anon_sym_DASH] = ACTIONS(1359),
    [anon_sym_DOT] = ACTIONS(1359),
    [anon_sym_SLASH] = ACTIONS(1359),
    [anon_sym_COLON] = ACTIONS(1359),
    [anon_sym_SEMI] = ACTIONS(1359),
    [anon_sym_EQ] = ACTIONS(1359),
    [anon_sym_QMARK] = ACTIONS(1359),
    [anon_sym_AT] = ACTIONS(1359),
    [anon_sym_BSLASH] = ACTIONS(1368),
    [anon_sym_CARET] = ACTIONS(1359),
    [anon_sym__] = ACTIONS(1359),
    [anon_sym_BQUOTE] = ACTIONS(1359),
    [anon_sym_LBRACE] = ACTIONS(1359),
    [anon_sym_PIPE] = ACTIONS(1359),
    [anon_sym_RBRACE] = ACTIONS(1359),
    [anon_sym_TILDE] = ACTIONS(1359),
    [anon_sym_LPAREN] = ACTIONS(1359),
    [anon_sym_RPAREN] = ACTIONS(1359),
    [sym__newline_token] = ACTIONS(1371),
    [sym_uri_autolink] = ACTIONS(1350),
    [sym_email_autolink] = ACTIONS(1350),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1374),
    [anon_sym_LT_QMARK] = ACTIONS(1377),
    [aux_sym__declaration_token1] = ACTIONS(1380),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1383),
    [sym__whitespace_ge_2] = ACTIONS(1386),
    [aux_sym__whitespace_token1] = ACTIONS(1389),
    [sym__word_no_digit] = ACTIONS(1350),
    [sym__digits] = ACTIONS(1350),
    [sym__code_span_start] = ACTIONS(1392),
    [sym__emphasis_open_star] = ACTIONS(1395),
    [sym__emphasis_open_underscore] = ACTIONS(1398),
    [sym__emphasis_close_underscore] = ACTIONS(104),
    [sym__last_token_punctuation] = ACTIONS(1401),
    [sym__strikethrough_open] = ACTIONS(1403),
    [sym__latex_span_start] = ACTIONS(1406),
    [sym__unclosed_span] = ACTIONS(1350),
  },
  [89] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(1409),
    [sym_entity_reference] = ACTIONS(1412),
    [sym_numeric_character_reference] = ACTIONS(1412),
    [anon_sym_LBRACK] = ACTIONS(114),
    [anon_sym_RBRACK] = ACTIONS(1415),
    [anon_sym_LT] = ACTIONS(1418),
    [anon_sym_GT] = ACTIONS(1421),
    [anon_sym_BANG] = ACTIONS(1424),
    [anon_sym_DQUOTE] = ACTIONS(1421),
    [anon_sym_POUND] = ACTIONS(1421),
    [anon_sym_DOLLAR] = ACTIONS(1421),
    [anon_sym_PERCENT] = ACTIONS(1421),
    [anon_sym_AMP] = ACTIONS(1427),
    [anon_sym_SQUOTE] = ACTIONS(1421),
    [anon_sym_STAR] = ACTIONS(1421),
    [anon_sym_PLUS] = ACTIONS(1421),
    [anon_sym_COMMA] = ACTIONS(1421),
    [anon_sym_DASH] = ACTIONS(1421),
    [anon_sym_DOT] = ACTIONS(1421),
    [anon_sym_SLASH] = ACTIONS(1421),
    [anon_sym_COLON] = ACTIONS(1421),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_EQ] = ACTIONS(1421),
    [anon_sym_QMARK] = ACTIONS(1421),
    [anon_sym_AT] = ACTIONS(1421),
    [anon_sym_BSLASH] = ACTIONS(1430),
    [anon_sym_CARET] = ACTIONS(1421),
    [anon_sym__] = ACTIONS(1421),
    [anon_sym_BQUOTE] = ACTIONS(1421),
    [anon_sym_LBRACE] = ACTIONS(1421),
    [anon_sym_PIPE] = ACTIONS(1421),
    [anon_sym_RBRACE] = ACTIONS(1421),
    [anon_sym_TILDE] = ACTIONS(1421),
    [anon_sym_LPAREN] = ACTIONS(1421),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [sym__newline_token] = ACTIONS(1433),
    [sym_uri_autolink] = ACTIONS(1412),
    [sym_email_autolink] = ACTIONS(1412),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1436),
    [anon_sym_LT_QMARK] = ACTIONS(1439),
    [aux_sym__declaration_token1] = ACTIONS(1442),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1445),
    [sym__whitespace_ge_2] = ACTIONS(1448),
    [aux_sym__whitespace_token1] = ACTIONS(1451),
    [sym__word_no_digit] = ACTIONS(1412),
    [sym__digits] = ACTIONS(1412),
    [sym__code_span_start] = ACTIONS(1454),
    [sym__emphasis_open_star] = ACTIONS(1457),
    [sym__emphasis_open_underscore] = ACTIONS(1460),
    [sym__last_token_punctuation] = ACTIONS(1463),
    [sym__strikethrough_open] = ACTIONS(1465),
    [sym__latex_span_start] = ACTIONS(1468),
    [sym__unclosed_span] = ACTIONS(1412),
  },
  [90] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(100),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1409),
    [sym_entity_reference] = ACTIONS(1412),
    [sym_numeric_character_reference] = ACTIONS(1412),
    [anon_sym_LBRACK] = ACTIONS(114),
    [anon_sym_RBRACK] = ACTIONS(1415),
    [anon_sym_LT] = ACTIONS(1418),
    [anon_sym_GT] = ACTIONS(1421),
    [anon_sym_BANG] = ACTIONS(1424),
    [anon_sym_DQUOTE] = ACTIONS(1421),
    [anon_sym_POUND] = ACTIONS(1421),
    [anon_sym_DOLLAR] = ACTIONS(1421),
    [anon_sym_PERCENT] = ACTIONS(1421),
    [anon_sym_AMP] = ACTIONS(1427),
    [anon_sym_SQUOTE] = ACTIONS(1421),
    [anon_sym_STAR] = ACTIONS(1421),
    [anon_sym_PLUS] = ACTIONS(1421),
    [anon_sym_COMMA] = ACTIONS(1421),
    [anon_sym_DASH] = ACTIONS(1421),
    [anon_sym_DOT] = ACTIONS(1421),
    [anon_sym_SLASH] = ACTIONS(1421),
    [anon_sym_COLON] = ACTIONS(1421),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_EQ] = ACTIONS(1421),
    [anon_sym_QMARK] = ACTIONS(1421),
    [anon_sym_AT] = ACTIONS(1421),
    [anon_sym_BSLASH] = ACTIONS(1430),
    [anon_sym_CARET] = ACTIONS(1421),
    [anon_sym__] = ACTIONS(1421),
    [anon_sym_BQUOTE] = ACTIONS(1421),
    [anon_sym_LBRACE] = ACTIONS(1421),
    [anon_sym_PIPE] = ACTIONS(1421),
    [anon_sym_RBRACE] = ACTIONS(1421),
    [anon_sym_TILDE] = ACTIONS(1421),
    [anon_sym_LPAREN] = ACTIONS(1421),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [sym__newline_token] = ACTIONS(1433),
    [sym_uri_autolink] = ACTIONS(1412),
    [sym_email_autolink] = ACTIONS(1412),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1436),
    [anon_sym_LT_QMARK] = ACTIONS(1439),
    [aux_sym__declaration_token1] = ACTIONS(1442),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1445),
    [sym__whitespace_ge_2] = ACTIONS(1448),
    [aux_sym__whitespace_token1] = ACTIONS(1451),
    [sym__word_no_digit] = ACTIONS(1412),
    [sym__digits] = ACTIONS(1412),
    [sym__code_span_start] = ACTIONS(1454),
    [sym__emphasis_open_star] = ACTIONS(1457),
    [sym__emphasis_open_underscore] = ACTIONS(1460),
    [sym__last_token_punctuation] = ACTIONS(1471),
    [sym__strikethrough_open] = ACTIONS(1465),
    [sym__latex_span_start] = ACTIONS(1468),
    [sym__unclosed_span] = ACTIONS(1412),
  },
  [91] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(116),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(116),
    [aux_sym__inline_no_underscore_no_link] = STATE(116),
    [sym__strikethrough_no_link] = STATE(116),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(116),
    [sym__emphasis_underscore_no_link] = STATE(621),
    [sym__strong_emphasis_underscore_no_link] = STATE(116),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(1473),
    [sym_entity_reference] = ACTIONS(1476),
    [sym_numeric_character_reference] = ACTIONS(1476),
    [anon_sym_LT] = ACTIONS(1479),
    [anon_sym_GT] = ACTIONS(1482),
    [anon_sym_BANG] = ACTIONS(1485),
    [anon_sym_DQUOTE] = ACTIONS(1482),
    [anon_sym_POUND] = ACTIONS(1482),
    [anon_sym_DOLLAR] = ACTIONS(1482),
    [anon_sym_PERCENT] = ACTIONS(1482),
    [anon_sym_AMP] = ACTIONS(1488),
    [anon_sym_SQUOTE] = ACTIONS(1482),
    [anon_sym_STAR] = ACTIONS(1482),
    [anon_sym_PLUS] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1482),
    [anon_sym_DASH] = ACTIONS(1482),
    [anon_sym_DOT] = ACTIONS(1482),
    [anon_sym_SLASH] = ACTIONS(1482),
    [anon_sym_COLON] = ACTIONS(1482),
    [anon_sym_SEMI] = ACTIONS(1482),
    [anon_sym_EQ] = ACTIONS(1482),
    [anon_sym_QMARK] = ACTIONS(1482),
    [anon_sym_AT] = ACTIONS(1482),
    [anon_sym_BSLASH] = ACTIONS(1491),
    [anon_sym_CARET] = ACTIONS(1482),
    [anon_sym__] = ACTIONS(1482),
    [anon_sym_BQUOTE] = ACTIONS(1482),
    [anon_sym_LBRACE] = ACTIONS(1482),
    [anon_sym_PIPE] = ACTIONS(1482),
    [anon_sym_RBRACE] = ACTIONS(1482),
    [anon_sym_TILDE] = ACTIONS(1482),
    [anon_sym_LPAREN] = ACTIONS(1482),
    [anon_sym_RPAREN] = ACTIONS(1482),
    [sym__newline_token] = ACTIONS(1494),
    [sym_uri_autolink] = ACTIONS(1476),
    [sym_email_autolink] = ACTIONS(1476),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1497),
    [anon_sym_LT_QMARK] = ACTIONS(1500),
    [aux_sym__declaration_token1] = ACTIONS(1503),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1506),
    [sym__whitespace_ge_2] = ACTIONS(1509),
    [aux_sym__whitespace_token1] = ACTIONS(1512),
    [sym__word_no_digit] = ACTIONS(1476),
    [sym__digits] = ACTIONS(1476),
    [sym__code_span_start] = ACTIONS(1515),
    [sym__emphasis_open_star] = ACTIONS(1518),
    [sym__emphasis_open_underscore] = ACTIONS(1521),
    [sym__last_token_punctuation] = ACTIONS(1524),
    [sym__strikethrough_open] = ACTIONS(1526),
    [sym__strikethrough_close] = ACTIONS(1529),
    [sym__latex_span_start] = ACTIONS(1531),
    [sym__unclosed_span] = ACTIONS(1476),
  },
  [92] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(119),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(119),
    [aux_sym__inline_no_star_no_link] = STATE(119),
    [sym__strikethrough_no_link] = STATE(119),
    [sym__emphasis_star_no_link] = STATE(618),
    [sym__strong_emphasis_star_no_link] = STATE(119),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(119),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1534),
    [sym_entity_reference] = ACTIONS(1537),
    [sym_numeric_character_reference] = ACTIONS(1537),
    [anon_sym_LT] = ACTIONS(1540),
    [anon_sym_GT] = ACTIONS(1543),
    [anon_sym_BANG] = ACTIONS(1546),
    [anon_sym_DQUOTE] = ACTIONS(1543),
    [anon_sym_POUND] = ACTIONS(1543),
    [anon_sym_DOLLAR] = ACTIONS(1543),
    [anon_sym_PERCENT] = ACTIONS(1543),
    [anon_sym_AMP] = ACTIONS(1549),
    [anon_sym_SQUOTE] = ACTIONS(1543),
    [anon_sym_STAR] = ACTIONS(1543),
    [anon_sym_PLUS] = ACTIONS(1543),
    [anon_sym_COMMA] = ACTIONS(1543),
    [anon_sym_DASH] = ACTIONS(1543),
    [anon_sym_DOT] = ACTIONS(1543),
    [anon_sym_SLASH] = ACTIONS(1543),
    [anon_sym_COLON] = ACTIONS(1543),
    [anon_sym_SEMI] = ACTIONS(1543),
    [anon_sym_EQ] = ACTIONS(1543),
    [anon_sym_QMARK] = ACTIONS(1543),
    [anon_sym_AT] = ACTIONS(1543),
    [anon_sym_BSLASH] = ACTIONS(1552),
    [anon_sym_CARET] = ACTIONS(1543),
    [anon_sym__] = ACTIONS(1543),
    [anon_sym_BQUOTE] = ACTIONS(1543),
    [anon_sym_LBRACE] = ACTIONS(1543),
    [anon_sym_PIPE] = ACTIONS(1543),
    [anon_sym_RBRACE] = ACTIONS(1543),
    [anon_sym_TILDE] = ACTIONS(1543),
    [anon_sym_LPAREN] = ACTIONS(1543),
    [anon_sym_RPAREN] = ACTIONS(1543),
    [sym__newline_token] = ACTIONS(1555),
    [sym_uri_autolink] = ACTIONS(1537),
    [sym_email_autolink] = ACTIONS(1537),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1558),
    [anon_sym_LT_QMARK] = ACTIONS(1561),
    [aux_sym__declaration_token1] = ACTIONS(1564),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1567),
    [sym__whitespace_ge_2] = ACTIONS(1570),
    [aux_sym__whitespace_token1] = ACTIONS(1573),
    [sym__word_no_digit] = ACTIONS(1537),
    [sym__digits] = ACTIONS(1537),
    [sym__code_span_start] = ACTIONS(1576),
    [sym__emphasis_open_star] = ACTIONS(1579),
    [sym__emphasis_open_underscore] = ACTIONS(1582),
    [sym__emphasis_close_underscore] = ACTIONS(1585),
    [sym__last_token_punctuation] = ACTIONS(1587),
    [sym__strikethrough_open] = ACTIONS(1589),
    [sym__latex_span_start] = ACTIONS(1592),
    [sym__unclosed_span] = ACTIONS(1537),
  },
  [93] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(123),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(123),
    [aux_sym__inline_no_star_no_link] = STATE(123),
    [sym__strikethrough_no_link] = STATE(123),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(123),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(123),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1595),
    [sym_entity_reference] = ACTIONS(1598),
    [sym_numeric_character_reference] = ACTIONS(1598),
    [anon_sym_RBRACK] = ACTIONS(1601),
    [anon_sym_LT] = ACTIONS(1603),
    [anon_sym_GT] = ACTIONS(1606),
    [anon_sym_BANG] = ACTIONS(1609),
    [anon_sym_DQUOTE] = ACTIONS(1606),
    [anon_sym_POUND] = ACTIONS(1606),
    [anon_sym_DOLLAR] = ACTIONS(1606),
    [anon_sym_PERCENT] = ACTIONS(1606),
    [anon_sym_AMP] = ACTIONS(1612),
    [anon_sym_SQUOTE] = ACTIONS(1606),
    [anon_sym_STAR] = ACTIONS(1606),
    [anon_sym_PLUS] = ACTIONS(1606),
    [anon_sym_COMMA] = ACTIONS(1606),
    [anon_sym_DASH] = ACTIONS(1606),
    [anon_sym_DOT] = ACTIONS(1606),
    [anon_sym_SLASH] = ACTIONS(1606),
    [anon_sym_COLON] = ACTIONS(1606),
    [anon_sym_SEMI] = ACTIONS(1606),
    [anon_sym_EQ] = ACTIONS(1606),
    [anon_sym_QMARK] = ACTIONS(1606),
    [anon_sym_AT] = ACTIONS(1606),
    [anon_sym_BSLASH] = ACTIONS(1615),
    [anon_sym_CARET] = ACTIONS(1606),
    [anon_sym__] = ACTIONS(1606),
    [anon_sym_BQUOTE] = ACTIONS(1606),
    [anon_sym_LBRACE] = ACTIONS(1606),
    [anon_sym_PIPE] = ACTIONS(1606),
    [anon_sym_RBRACE] = ACTIONS(1606),
    [anon_sym_TILDE] = ACTIONS(1606),
    [anon_sym_LPAREN] = ACTIONS(1606),
    [anon_sym_RPAREN] = ACTIONS(1606),
    [sym__newline_token] = ACTIONS(1618),
    [sym_uri_autolink] = ACTIONS(1598),
    [sym_email_autolink] = ACTIONS(1598),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1621),
    [anon_sym_LT_QMARK] = ACTIONS(1624),
    [aux_sym__declaration_token1] = ACTIONS(1627),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1630),
    [sym__whitespace_ge_2] = ACTIONS(1633),
    [aux_sym__whitespace_token1] = ACTIONS(1636),
    [sym__word_no_digit] = ACTIONS(1598),
    [sym__digits] = ACTIONS(1598),
    [sym__code_span_start] = ACTIONS(1639),
    [sym__emphasis_open_star] = ACTIONS(1642),
    [sym__emphasis_open_underscore] = ACTIONS(1645),
    [sym__last_token_punctuation] = ACTIONS(1648),
    [sym__strikethrough_open] = ACTIONS(1650),
    [sym__latex_span_start] = ACTIONS(1653),
    [sym__unclosed_span] = ACTIONS(1598),
  },
  [94] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(128),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(128),
    [aux_sym__inline_no_underscore_no_link] = STATE(128),
    [sym__strikethrough_no_link] = STATE(128),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(128),
    [sym__emphasis_underscore_no_link] = STATE(623),
    [sym__strong_emphasis_underscore_no_link] = STATE(128),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(1656),
    [sym_entity_reference] = ACTIONS(1659),
    [sym_numeric_character_reference] = ACTIONS(1659),
    [anon_sym_RBRACK] = ACTIONS(1601),
    [anon_sym_LT] = ACTIONS(1662),
    [anon_sym_GT] = ACTIONS(1665),
    [anon_sym_BANG] = ACTIONS(1668),
    [anon_sym_DQUOTE] = ACTIONS(1665),
    [anon_sym_POUND] = ACTIONS(1665),
    [anon_sym_DOLLAR] = ACTIONS(1665),
    [anon_sym_PERCENT] = ACTIONS(1665),
    [anon_sym_AMP] = ACTIONS(1671),
    [anon_sym_SQUOTE] = ACTIONS(1665),
    [anon_sym_STAR] = ACTIONS(1665),
    [anon_sym_PLUS] = ACTIONS(1665),
    [anon_sym_COMMA] = ACTIONS(1665),
    [anon_sym_DASH] = ACTIONS(1665),
    [anon_sym_DOT] = ACTIONS(1665),
    [anon_sym_SLASH] = ACTIONS(1665),
    [anon_sym_COLON] = ACTIONS(1665),
    [anon_sym_SEMI] = ACTIONS(1665),
    [anon_sym_EQ] = ACTIONS(1665),
    [anon_sym_QMARK] = ACTIONS(1665),
    [anon_sym_AT] = ACTIONS(1665),
    [anon_sym_BSLASH] = ACTIONS(1674),
    [anon_sym_CARET] = ACTIONS(1665),
    [anon_sym__] = ACTIONS(1665),
    [anon_sym_BQUOTE] = ACTIONS(1665),
    [anon_sym_LBRACE] = ACTIONS(1665),
    [anon_sym_PIPE] = ACTIONS(1665),
    [anon_sym_RBRACE] = ACTIONS(1665),
    [anon_sym_TILDE] = ACTIONS(1665),
    [anon_sym_LPAREN] = ACTIONS(1665),
    [anon_sym_RPAREN] = ACTIONS(1665),
    [sym__newline_token] = ACTIONS(1677),
    [sym_uri_autolink] = ACTIONS(1659),
    [sym_email_autolink] = ACTIONS(1659),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1680),
    [anon_sym_LT_QMARK] = ACTIONS(1683),
    [aux_sym__declaration_token1] = ACTIONS(1686),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1689),
    [sym__whitespace_ge_2] = ACTIONS(1692),
    [aux_sym__whitespace_token1] = ACTIONS(1695),
    [sym__word_no_digit] = ACTIONS(1659),
    [sym__digits] = ACTIONS(1659),
    [sym__code_span_start] = ACTIONS(1698),
    [sym__emphasis_open_star] = ACTIONS(1701),
    [sym__emphasis_open_underscore] = ACTIONS(1704),
    [sym__last_token_punctuation] = ACTIONS(1707),
    [sym__strikethrough_open] = ACTIONS(1709),
    [sym__latex_span_start] = ACTIONS(1712),
    [sym__unclosed_span] = ACTIONS(1659),
  },
  [95] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(101),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(101),
    [aux_sym__inline_no_tilde_no_link] = STATE(101),
    [sym__strikethrough_no_link] = STATE(101),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(101),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(101),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1715),
    [sym_entity_reference] = ACTIONS(1718),
    [sym_numeric_character_reference] = ACTIONS(1718),
    [anon_sym_RBRACK] = ACTIONS(1601),
    [anon_sym_LT] = ACTIONS(1721),
    [anon_sym_GT] = ACTIONS(1724),
    [anon_sym_BANG] = ACTIONS(1727),
    [anon_sym_DQUOTE] = ACTIONS(1724),
    [anon_sym_POUND] = ACTIONS(1724),
    [anon_sym_DOLLAR] = ACTIONS(1724),
    [anon_sym_PERCENT] = ACTIONS(1724),
    [anon_sym_AMP] = ACTIONS(1730),
    [anon_sym_SQUOTE] = ACTIONS(1724),
    [anon_sym_STAR] = ACTIONS(1724),
    [anon_sym_PLUS] = ACTIONS(1724),
    [anon_sym_COMMA] = ACTIONS(1724),
    [anon_sym_DASH] = ACTIONS(1724),
    [anon_sym_DOT] = ACTIONS(1724),
    [anon_sym_SLASH] = ACTIONS(1724),
    [anon_sym_COLON] = ACTIONS(1724),
    [anon_sym_SEMI] = ACTIONS(1724),
    [anon_sym_EQ] = ACTIONS(1724),
    [anon_sym_QMARK] = ACTIONS(1724),
    [anon_sym_AT] = ACTIONS(1724),
    [anon_sym_BSLASH] = ACTIONS(1733),
    [anon_sym_CARET] = ACTIONS(1724),
    [anon_sym__] = ACTIONS(1724),
    [anon_sym_BQUOTE] = ACTIONS(1724),
    [anon_sym_LBRACE] = ACTIONS(1724),
    [anon_sym_PIPE] = ACTIONS(1724),
    [anon_sym_RBRACE] = ACTIONS(1724),
    [anon_sym_TILDE] = ACTIONS(1724),
    [anon_sym_LPAREN] = ACTIONS(1724),
    [anon_sym_RPAREN] = ACTIONS(1724),
    [sym__newline_token] = ACTIONS(1736),
    [sym_uri_autolink] = ACTIONS(1718),
    [sym_email_autolink] = ACTIONS(1718),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1739),
    [anon_sym_LT_QMARK] = ACTIONS(1742),
    [aux_sym__declaration_token1] = ACTIONS(1745),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1748),
    [sym__whitespace_ge_2] = ACTIONS(1751),
    [aux_sym__whitespace_token1] = ACTIONS(1754),
    [sym__word_no_digit] = ACTIONS(1718),
    [sym__digits] = ACTIONS(1718),
    [sym__code_span_start] = ACTIONS(1757),
    [sym__emphasis_open_star] = ACTIONS(1760),
    [sym__emphasis_open_underscore] = ACTIONS(1763),
    [sym__last_token_punctuation] = ACTIONS(1766),
    [sym__strikethrough_open] = ACTIONS(1768),
    [sym__latex_span_start] = ACTIONS(1771),
    [sym__unclosed_span] = ACTIONS(1718),
  },
  [96] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(115),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(115),
    [aux_sym__inline_no_tilde_no_link] = STATE(115),
    [sym__strikethrough_no_link] = STATE(115),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(115),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(115),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1774),
    [sym_entity_reference] = ACTIONS(1777),
    [sym_numeric_character_reference] = ACTIONS(1777),
    [anon_sym_LT] = ACTIONS(1780),
    [anon_sym_GT] = ACTIONS(1783),
    [anon_sym_BANG] = ACTIONS(1786),
    [anon_sym_DQUOTE] = ACTIONS(1783),
    [anon_sym_POUND] = ACTIONS(1783),
    [anon_sym_DOLLAR] = ACTIONS(1783),
    [anon_sym_PERCENT] = ACTIONS(1783),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_SQUOTE] = ACTIONS(1783),
    [anon_sym_STAR] = ACTIONS(1783),
    [anon_sym_PLUS] = ACTIONS(1783),
    [anon_sym_COMMA] = ACTIONS(1783),
    [anon_sym_DASH] = ACTIONS(1783),
    [anon_sym_DOT] = ACTIONS(1783),
    [anon_sym_SLASH] = ACTIONS(1783),
    [anon_sym_COLON] = ACTIONS(1783),
    [anon_sym_SEMI] = ACTIONS(1783),
    [anon_sym_EQ] = ACTIONS(1783),
    [anon_sym_QMARK] = ACTIONS(1783),
    [anon_sym_AT] = ACTIONS(1783),
    [anon_sym_BSLASH] = ACTIONS(1792),
    [anon_sym_CARET] = ACTIONS(1783),
    [anon_sym__] = ACTIONS(1783),
    [anon_sym_BQUOTE] = ACTIONS(1783),
    [anon_sym_LBRACE] = ACTIONS(1783),
    [anon_sym_PIPE] = ACTIONS(1783),
    [anon_sym_RBRACE] = ACTIONS(1783),
    [anon_sym_TILDE] = ACTIONS(1783),
    [anon_sym_LPAREN] = ACTIONS(1783),
    [anon_sym_RPAREN] = ACTIONS(1783),
    [sym__newline_token] = ACTIONS(1795),
    [sym_uri_autolink] = ACTIONS(1777),
    [sym_email_autolink] = ACTIONS(1777),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1798),
    [anon_sym_LT_QMARK] = ACTIONS(1801),
    [aux_sym__declaration_token1] = ACTIONS(1804),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1807),
    [sym__whitespace_ge_2] = ACTIONS(1810),
    [aux_sym__whitespace_token1] = ACTIONS(1813),
    [sym__word_no_digit] = ACTIONS(1777),
    [sym__digits] = ACTIONS(1777),
    [sym__code_span_start] = ACTIONS(1816),
    [sym__emphasis_open_star] = ACTIONS(1819),
    [sym__emphasis_open_underscore] = ACTIONS(1822),
    [sym__emphasis_close_underscore] = ACTIONS(1585),
    [sym__last_token_punctuation] = ACTIONS(1825),
    [sym__strikethrough_open] = ACTIONS(1827),
    [sym__latex_span_start] = ACTIONS(1830),
    [sym__unclosed_span] = ACTIONS(1777),
  },
  [97] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(122),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(122),
    [aux_sym__inline_no_underscore_no_link] = STATE(122),
    [sym__strikethrough_no_link] = STATE(122),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(122),
    [sym__emphasis_underscore_no_link] = STATE(632),
    [sym__strong_emphasis_underscore_no_link] = STATE(122),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(1833),
    [sym_entity_reference] = ACTIONS(1836),
    [sym_numeric_character_reference] = ACTIONS(1836),
    [anon_sym_LT] = ACTIONS(1839),
    [anon_sym_GT] = ACTIONS(1842),
    [anon_sym_BANG] = ACTIONS(1845),
    [anon_sym_DQUOTE] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(1842),
    [anon_sym_DOLLAR] = ACTIONS(1842),
    [anon_sym_PERCENT] = ACTIONS(1842),
    [anon_sym_AMP] = ACTIONS(1848),
    [anon_sym_SQUOTE] = ACTIONS(1842),
    [anon_sym_STAR] = ACTIONS(1842),
    [anon_sym_PLUS] = ACTIONS(1842),
    [anon_sym_COMMA] = ACTIONS(1842),
    [anon_sym_DASH] = ACTIONS(1842),
    [anon_sym_DOT] = ACTIONS(1842),
    [anon_sym_SLASH] = ACTIONS(1842),
    [anon_sym_COLON] = ACTIONS(1842),
    [anon_sym_SEMI] = ACTIONS(1842),
    [anon_sym_EQ] = ACTIONS(1842),
    [anon_sym_QMARK] = ACTIONS(1842),
    [anon_sym_AT] = ACTIONS(1842),
    [anon_sym_BSLASH] = ACTIONS(1851),
    [anon_sym_CARET] = ACTIONS(1842),
    [anon_sym__] = ACTIONS(1842),
    [anon_sym_BQUOTE] = ACTIONS(1842),
    [anon_sym_LBRACE] = ACTIONS(1842),
    [anon_sym_PIPE] = ACTIONS(1842),
    [anon_sym_RBRACE] = ACTIONS(1842),
    [anon_sym_TILDE] = ACTIONS(1842),
    [anon_sym_LPAREN] = ACTIONS(1842),
    [anon_sym_RPAREN] = ACTIONS(1842),
    [sym__newline_token] = ACTIONS(1854),
    [sym_uri_autolink] = ACTIONS(1836),
    [sym_email_autolink] = ACTIONS(1836),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1857),
    [anon_sym_LT_QMARK] = ACTIONS(1860),
    [aux_sym__declaration_token1] = ACTIONS(1863),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1866),
    [sym__whitespace_ge_2] = ACTIONS(1869),
    [aux_sym__whitespace_token1] = ACTIONS(1872),
    [sym__word_no_digit] = ACTIONS(1836),
    [sym__digits] = ACTIONS(1836),
    [sym__code_span_start] = ACTIONS(1875),
    [sym__emphasis_open_star] = ACTIONS(1878),
    [sym__emphasis_open_underscore] = ACTIONS(1881),
    [sym__emphasis_close_star] = ACTIONS(1884),
    [sym__last_token_punctuation] = ACTIONS(1886),
    [sym__strikethrough_open] = ACTIONS(1888),
    [sym__latex_span_start] = ACTIONS(1891),
    [sym__unclosed_span] = ACTIONS(1836),
  },
  [98] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(107),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(107),
    [aux_sym__inline_no_star_no_link] = STATE(107),
    [sym__strikethrough_no_link] = STATE(107),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(107),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(107),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1894),
    [sym_entity_reference] = ACTIONS(1897),
    [sym_numeric_character_reference] = ACTIONS(1897),
    [anon_sym_LT] = ACTIONS(1900),
    [anon_sym_GT] = ACTIONS(1903),
    [anon_sym_BANG] = ACTIONS(1906),
    [anon_sym_DQUOTE] = ACTIONS(1903),
    [anon_sym_POUND] = ACTIONS(1903),
    [anon_sym_DOLLAR] = ACTIONS(1903),
    [anon_sym_PERCENT] = ACTIONS(1903),
    [anon_sym_AMP] = ACTIONS(1909),
    [anon_sym_SQUOTE] = ACTIONS(1903),
    [anon_sym_STAR] = ACTIONS(1903),
    [anon_sym_PLUS] = ACTIONS(1903),
    [anon_sym_COMMA] = ACTIONS(1903),
    [anon_sym_DASH] = ACTIONS(1903),
    [anon_sym_DOT] = ACTIONS(1903),
    [anon_sym_SLASH] = ACTIONS(1903),
    [anon_sym_COLON] = ACTIONS(1903),
    [anon_sym_SEMI] = ACTIONS(1903),
    [anon_sym_EQ] = ACTIONS(1903),
    [anon_sym_QMARK] = ACTIONS(1903),
    [anon_sym_AT] = ACTIONS(1903),
    [anon_sym_BSLASH] = ACTIONS(1912),
    [anon_sym_CARET] = ACTIONS(1903),
    [anon_sym__] = ACTIONS(1903),
    [anon_sym_BQUOTE] = ACTIONS(1903),
    [anon_sym_LBRACE] = ACTIONS(1903),
    [anon_sym_PIPE] = ACTIONS(1903),
    [anon_sym_RBRACE] = ACTIONS(1903),
    [anon_sym_TILDE] = ACTIONS(1903),
    [anon_sym_LPAREN] = ACTIONS(1903),
    [anon_sym_RPAREN] = ACTIONS(1903),
    [sym__newline_token] = ACTIONS(1915),
    [sym_uri_autolink] = ACTIONS(1897),
    [sym_email_autolink] = ACTIONS(1897),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1918),
    [anon_sym_LT_QMARK] = ACTIONS(1921),
    [aux_sym__declaration_token1] = ACTIONS(1924),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1927),
    [sym__whitespace_ge_2] = ACTIONS(1930),
    [aux_sym__whitespace_token1] = ACTIONS(1933),
    [sym__word_no_digit] = ACTIONS(1897),
    [sym__digits] = ACTIONS(1897),
    [sym__code_span_start] = ACTIONS(1936),
    [sym__emphasis_open_star] = ACTIONS(1939),
    [sym__emphasis_open_underscore] = ACTIONS(1942),
    [sym__last_token_punctuation] = ACTIONS(1945),
    [sym__strikethrough_open] = ACTIONS(1947),
    [sym__strikethrough_close] = ACTIONS(1529),
    [sym__latex_span_start] = ACTIONS(1950),
    [sym__unclosed_span] = ACTIONS(1897),
  },
  [99] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(124),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(124),
    [aux_sym__inline_no_tilde_no_link] = STATE(124),
    [sym__strikethrough_no_link] = STATE(124),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(124),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(124),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1953),
    [sym_entity_reference] = ACTIONS(1956),
    [sym_numeric_character_reference] = ACTIONS(1956),
    [anon_sym_LT] = ACTIONS(1959),
    [anon_sym_GT] = ACTIONS(1962),
    [anon_sym_BANG] = ACTIONS(1965),
    [anon_sym_DQUOTE] = ACTIONS(1962),
    [anon_sym_POUND] = ACTIONS(1962),
    [anon_sym_DOLLAR] = ACTIONS(1962),
    [anon_sym_PERCENT] = ACTIONS(1962),
    [anon_sym_AMP] = ACTIONS(1968),
    [anon_sym_SQUOTE] = ACTIONS(1962),
    [anon_sym_STAR] = ACTIONS(1962),
    [anon_sym_PLUS] = ACTIONS(1962),
    [anon_sym_COMMA] = ACTIONS(1962),
    [anon_sym_DASH] = ACTIONS(1962),
    [anon_sym_DOT] = ACTIONS(1962),
    [anon_sym_SLASH] = ACTIONS(1962),
    [anon_sym_COLON] = ACTIONS(1962),
    [anon_sym_SEMI] = ACTIONS(1962),
    [anon_sym_EQ] = ACTIONS(1962),
    [anon_sym_QMARK] = ACTIONS(1962),
    [anon_sym_AT] = ACTIONS(1962),
    [anon_sym_BSLASH] = ACTIONS(1971),
    [anon_sym_CARET] = ACTIONS(1962),
    [anon_sym__] = ACTIONS(1962),
    [anon_sym_BQUOTE] = ACTIONS(1962),
    [anon_sym_LBRACE] = ACTIONS(1962),
    [anon_sym_PIPE] = ACTIONS(1962),
    [anon_sym_RBRACE] = ACTIONS(1962),
    [anon_sym_TILDE] = ACTIONS(1962),
    [anon_sym_LPAREN] = ACTIONS(1962),
    [anon_sym_RPAREN] = ACTIONS(1962),
    [sym__newline_token] = ACTIONS(1974),
    [sym_uri_autolink] = ACTIONS(1956),
    [sym_email_autolink] = ACTIONS(1956),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1977),
    [anon_sym_LT_QMARK] = ACTIONS(1980),
    [aux_sym__declaration_token1] = ACTIONS(1983),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1986),
    [sym__whitespace_ge_2] = ACTIONS(1989),
    [aux_sym__whitespace_token1] = ACTIONS(1992),
    [sym__word_no_digit] = ACTIONS(1956),
    [sym__digits] = ACTIONS(1956),
    [sym__code_span_start] = ACTIONS(1995),
    [sym__emphasis_open_star] = ACTIONS(1998),
    [sym__emphasis_open_underscore] = ACTIONS(2001),
    [sym__emphasis_close_star] = ACTIONS(1884),
    [sym__last_token_punctuation] = ACTIONS(2004),
    [sym__strikethrough_open] = ACTIONS(2006),
    [sym__latex_span_start] = ACTIONS(2009),
    [sym__unclosed_span] = ACTIONS(1956),
  },
  [100] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2014),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [101] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2046),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [102] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2062),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [103] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2066),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [104] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2082),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [105] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2086),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [106] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2088),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [107] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2090),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [108] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2092),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [109] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2094),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [110] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2096),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [111] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2098),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [112] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2100),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [113] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(2102),
    [sym_entity_reference] = ACTIONS(2105),
    [sym_numeric_character_reference] = ACTIONS(2105),
    [anon_sym_LT] = ACTIONS(2108),
    [anon_sym_GT] = ACTIONS(2111),
    [anon_sym_BANG] = ACTIONS(2114),
    [anon_sym_DQUOTE] = ACTIONS(2111),
    [anon_sym_POUND] = ACTIONS(2111),
    [anon_sym_DOLLAR] = ACTIONS(2111),
    [anon_sym_PERCENT] = ACTIONS(2111),
    [anon_sym_AMP] = ACTIONS(2117),
    [anon_sym_SQUOTE] = ACTIONS(2111),
    [anon_sym_STAR] = ACTIONS(2111),
    [anon_sym_PLUS] = ACTIONS(2111),
    [anon_sym_COMMA] = ACTIONS(2111),
    [anon_sym_DASH] = ACTIONS(2111),
    [anon_sym_DOT] = ACTIONS(2111),
    [anon_sym_SLASH] = ACTIONS(2111),
    [anon_sym_COLON] = ACTIONS(2111),
    [anon_sym_SEMI] = ACTIONS(2111),
    [anon_sym_EQ] = ACTIONS(2111),
    [anon_sym_QMARK] = ACTIONS(2111),
    [anon_sym_AT] = ACTIONS(2111),
    [anon_sym_BSLASH] = ACTIONS(2120),
    [anon_sym_CARET] = ACTIONS(2111),
    [anon_sym__] = ACTIONS(2111),
    [anon_sym_BQUOTE] = ACTIONS(2111),
    [anon_sym_LBRACE] = ACTIONS(2111),
    [anon_sym_PIPE] = ACTIONS(2111),
    [anon_sym_RBRACE] = ACTIONS(2111),
    [anon_sym_TILDE] = ACTIONS(2111),
    [anon_sym_LPAREN] = ACTIONS(2111),
    [anon_sym_RPAREN] = ACTIONS(2111),
    [sym__newline_token] = ACTIONS(2123),
    [sym_uri_autolink] = ACTIONS(2105),
    [sym_email_autolink] = ACTIONS(2105),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2126),
    [anon_sym_LT_QMARK] = ACTIONS(2129),
    [aux_sym__declaration_token1] = ACTIONS(2132),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2135),
    [sym__whitespace_ge_2] = ACTIONS(2138),
    [aux_sym__whitespace_token1] = ACTIONS(2141),
    [sym__word_no_digit] = ACTIONS(2105),
    [sym__digits] = ACTIONS(2105),
    [sym__code_span_start] = ACTIONS(2144),
    [sym__emphasis_open_star] = ACTIONS(2147),
    [sym__emphasis_open_underscore] = ACTIONS(2150),
    [sym__strikethrough_open] = ACTIONS(2153),
    [sym__strikethrough_close] = ACTIONS(2156),
    [sym__latex_span_start] = ACTIONS(2158),
    [sym__unclosed_span] = ACTIONS(2105),
  },
  [114] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2161),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [115] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2163),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [116] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2165),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [117] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2167),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [118] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2169),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [119] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2171),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [120] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2173),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [121] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(602),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__last_token_punctuation] = ACTIONS(2175),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [122] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2177),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [123] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2179),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [124] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2181),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [125] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2183),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [126] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(117),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(117),
    [aux_sym__inline_no_underscore_no_link] = STATE(117),
    [sym__strikethrough_no_link] = STATE(117),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(117),
    [sym__emphasis_underscore_no_link] = STATE(607),
    [sym__strong_emphasis_underscore_no_link] = STATE(117),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__last_token_punctuation] = ACTIONS(2185),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [127] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__emphasis_close_star] = ACTIONS(2187),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [128] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2189),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [129] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(2191),
    [sym_entity_reference] = ACTIONS(2194),
    [sym_numeric_character_reference] = ACTIONS(2194),
    [anon_sym_LT] = ACTIONS(2197),
    [anon_sym_GT] = ACTIONS(2200),
    [anon_sym_BANG] = ACTIONS(2203),
    [anon_sym_DQUOTE] = ACTIONS(2200),
    [anon_sym_POUND] = ACTIONS(2200),
    [anon_sym_DOLLAR] = ACTIONS(2200),
    [anon_sym_PERCENT] = ACTIONS(2200),
    [anon_sym_AMP] = ACTIONS(2206),
    [anon_sym_SQUOTE] = ACTIONS(2200),
    [anon_sym_STAR] = ACTIONS(2200),
    [anon_sym_PLUS] = ACTIONS(2200),
    [anon_sym_COMMA] = ACTIONS(2200),
    [anon_sym_DASH] = ACTIONS(2200),
    [anon_sym_DOT] = ACTIONS(2200),
    [anon_sym_SLASH] = ACTIONS(2200),
    [anon_sym_COLON] = ACTIONS(2200),
    [anon_sym_SEMI] = ACTIONS(2200),
    [anon_sym_EQ] = ACTIONS(2200),
    [anon_sym_QMARK] = ACTIONS(2200),
    [anon_sym_AT] = ACTIONS(2200),
    [anon_sym_BSLASH] = ACTIONS(2209),
    [anon_sym_CARET] = ACTIONS(2200),
    [anon_sym__] = ACTIONS(2200),
    [anon_sym_BQUOTE] = ACTIONS(2200),
    [anon_sym_LBRACE] = ACTIONS(2200),
    [anon_sym_PIPE] = ACTIONS(2200),
    [anon_sym_RBRACE] = ACTIONS(2200),
    [anon_sym_TILDE] = ACTIONS(2200),
    [anon_sym_LPAREN] = ACTIONS(2200),
    [anon_sym_RPAREN] = ACTIONS(2200),
    [sym__newline_token] = ACTIONS(2212),
    [sym_uri_autolink] = ACTIONS(2194),
    [sym_email_autolink] = ACTIONS(2194),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2215),
    [anon_sym_LT_QMARK] = ACTIONS(2218),
    [aux_sym__declaration_token1] = ACTIONS(2221),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2224),
    [sym__whitespace_ge_2] = ACTIONS(2227),
    [aux_sym__whitespace_token1] = ACTIONS(2230),
    [sym__word_no_digit] = ACTIONS(2194),
    [sym__digits] = ACTIONS(2194),
    [sym__code_span_start] = ACTIONS(2233),
    [sym__emphasis_open_star] = ACTIONS(2236),
    [sym__emphasis_open_underscore] = ACTIONS(2239),
    [sym__emphasis_close_underscore] = ACTIONS(2242),
    [sym__strikethrough_open] = ACTIONS(2244),
    [sym__latex_span_start] = ACTIONS(2247),
    [sym__unclosed_span] = ACTIONS(2194),
  },
  [130] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__emphasis_close_underscore] = ACTIONS(2250),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [131] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2252),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [132] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2254),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [133] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(118),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(118),
    [aux_sym__inline_no_tilde_no_link] = STATE(118),
    [sym__strikethrough_no_link] = STATE(118),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(118),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(118),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__last_token_punctuation] = ACTIONS(2256),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [134] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(625),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(625),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(625),
    [sym__emphasis_star_no_link] = STATE(626),
    [sym__strong_emphasis_star_no_link] = STATE(625),
    [sym__emphasis_underscore_no_link] = STATE(626),
    [sym__strong_emphasis_underscore_no_link] = STATE(625),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(2258),
    [sym_entity_reference] = ACTIONS(2261),
    [sym_numeric_character_reference] = ACTIONS(2261),
    [anon_sym_RBRACK] = ACTIONS(2264),
    [anon_sym_LT] = ACTIONS(2266),
    [anon_sym_GT] = ACTIONS(2269),
    [anon_sym_BANG] = ACTIONS(2272),
    [anon_sym_DQUOTE] = ACTIONS(2269),
    [anon_sym_POUND] = ACTIONS(2269),
    [anon_sym_DOLLAR] = ACTIONS(2269),
    [anon_sym_PERCENT] = ACTIONS(2269),
    [anon_sym_AMP] = ACTIONS(2275),
    [anon_sym_SQUOTE] = ACTIONS(2269),
    [anon_sym_STAR] = ACTIONS(2269),
    [anon_sym_PLUS] = ACTIONS(2269),
    [anon_sym_COMMA] = ACTIONS(2269),
    [anon_sym_DASH] = ACTIONS(2269),
    [anon_sym_DOT] = ACTIONS(2269),
    [anon_sym_SLASH] = ACTIONS(2269),
    [anon_sym_COLON] = ACTIONS(2269),
    [anon_sym_SEMI] = ACTIONS(2269),
    [anon_sym_EQ] = ACTIONS(2269),
    [anon_sym_QMARK] = ACTIONS(2269),
    [anon_sym_AT] = ACTIONS(2269),
    [anon_sym_BSLASH] = ACTIONS(2278),
    [anon_sym_CARET] = ACTIONS(2269),
    [anon_sym__] = ACTIONS(2269),
    [anon_sym_BQUOTE] = ACTIONS(2269),
    [anon_sym_LBRACE] = ACTIONS(2269),
    [anon_sym_PIPE] = ACTIONS(2269),
    [anon_sym_RBRACE] = ACTIONS(2269),
    [anon_sym_TILDE] = ACTIONS(2269),
    [anon_sym_LPAREN] = ACTIONS(2269),
    [anon_sym_RPAREN] = ACTIONS(2269),
    [sym__newline_token] = ACTIONS(2281),
    [sym_uri_autolink] = ACTIONS(2261),
    [sym_email_autolink] = ACTIONS(2261),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2284),
    [anon_sym_LT_QMARK] = ACTIONS(2287),
    [aux_sym__declaration_token1] = ACTIONS(2290),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2293),
    [sym__whitespace_ge_2] = ACTIONS(2296),
    [aux_sym__whitespace_token1] = ACTIONS(2299),
    [sym__word_no_digit] = ACTIONS(2261),
    [sym__digits] = ACTIONS(2261),
    [sym__code_span_start] = ACTIONS(2302),
    [sym__emphasis_open_star] = ACTIONS(2305),
    [sym__emphasis_open_underscore] = ACTIONS(2308),
    [sym__strikethrough_open] = ACTIONS(2311),
    [sym__latex_span_start] = ACTIONS(2314),
    [sym__unclosed_span] = ACTIONS(2261),
  },
  [135] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(2317),
    [sym_entity_reference] = ACTIONS(2320),
    [sym_numeric_character_reference] = ACTIONS(2320),
    [anon_sym_LT] = ACTIONS(2323),
    [anon_sym_GT] = ACTIONS(2326),
    [anon_sym_BANG] = ACTIONS(2329),
    [anon_sym_DQUOTE] = ACTIONS(2326),
    [anon_sym_POUND] = ACTIONS(2326),
    [anon_sym_DOLLAR] = ACTIONS(2326),
    [anon_sym_PERCENT] = ACTIONS(2326),
    [anon_sym_AMP] = ACTIONS(2332),
    [anon_sym_SQUOTE] = ACTIONS(2326),
    [anon_sym_STAR] = ACTIONS(2326),
    [anon_sym_PLUS] = ACTIONS(2326),
    [anon_sym_COMMA] = ACTIONS(2326),
    [anon_sym_DASH] = ACTIONS(2326),
    [anon_sym_DOT] = ACTIONS(2326),
    [anon_sym_SLASH] = ACTIONS(2326),
    [anon_sym_COLON] = ACTIONS(2326),
    [anon_sym_SEMI] = ACTIONS(2326),
    [anon_sym_EQ] = ACTIONS(2326),
    [anon_sym_QMARK] = ACTIONS(2326),
    [anon_sym_AT] = ACTIONS(2326),
    [anon_sym_BSLASH] = ACTIONS(2335),
    [anon_sym_CARET] = ACTIONS(2326),
    [anon_sym__] = ACTIONS(2326),
    [anon_sym_BQUOTE] = ACTIONS(2326),
    [anon_sym_LBRACE] = ACTIONS(2326),
    [anon_sym_PIPE] = ACTIONS(2326),
    [anon_sym_RBRACE] = ACTIONS(2326),
    [anon_sym_TILDE] = ACTIONS(2326),
    [anon_sym_LPAREN] = ACTIONS(2326),
    [anon_sym_RPAREN] = ACTIONS(2326),
    [sym__newline_token] = ACTIONS(2338),
    [sym_uri_autolink] = ACTIONS(2320),
    [sym_email_autolink] = ACTIONS(2320),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2341),
    [anon_sym_LT_QMARK] = ACTIONS(2344),
    [aux_sym__declaration_token1] = ACTIONS(2347),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2350),
    [sym__whitespace_ge_2] = ACTIONS(2353),
    [aux_sym__whitespace_token1] = ACTIONS(2356),
    [sym__word_no_digit] = ACTIONS(2320),
    [sym__digits] = ACTIONS(2320),
    [sym__code_span_start] = ACTIONS(2359),
    [sym__emphasis_open_star] = ACTIONS(2362),
    [sym__emphasis_open_underscore] = ACTIONS(2365),
    [sym__emphasis_close_star] = ACTIONS(2368),
    [sym__strikethrough_open] = ACTIONS(2370),
    [sym__latex_span_start] = ACTIONS(2373),
    [sym__unclosed_span] = ACTIONS(2320),
  },
  [136] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(105),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(105),
    [aux_sym__inline_no_tilde_no_link] = STATE(105),
    [sym__strikethrough_no_link] = STATE(105),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(105),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(105),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [137] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(110),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(110),
    [aux_sym__inline_no_underscore_no_link] = STATE(110),
    [sym__strikethrough_no_link] = STATE(110),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(110),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(110),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [138] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [139] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(108),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(108),
    [aux_sym__inline_no_tilde_no_link] = STATE(108),
    [sym__strikethrough_no_link] = STATE(108),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(108),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(108),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [140] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(130),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(130),
    [aux_sym__inline_no_underscore_no_link] = STATE(130),
    [sym__strikethrough_no_link] = STATE(130),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(130),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(130),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [141] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(111),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(111),
    [aux_sym__inline_no_underscore_no_link] = STATE(111),
    [sym__strikethrough_no_link] = STATE(111),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(111),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(111),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [142] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(112),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(112),
    [aux_sym__inline_no_star_no_link] = STATE(112),
    [sym__strikethrough_no_link] = STATE(112),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(112),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(112),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [143] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(109),
    [aux_sym__inline_no_tilde_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [144] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(125),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(125),
    [aux_sym__inline_no_star_no_link] = STATE(125),
    [sym__strikethrough_no_link] = STATE(125),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(125),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(125),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [145] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(103),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(103),
    [aux_sym__inline_no_star_no_link] = STATE(103),
    [sym__strikethrough_no_link] = STATE(103),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(103),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(103),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [146] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(104),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(104),
    [aux_sym__inline_no_underscore_no_link] = STATE(104),
    [sym__strikethrough_no_link] = STATE(104),
    [sym__emphasis_star_no_link] = STATE(640),
    [sym__strong_emphasis_star_no_link] = STATE(104),
    [sym__emphasis_underscore_no_link] = STATE(640),
    [sym__strong_emphasis_underscore_no_link] = STATE(104),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2068),
    [sym_numeric_character_reference] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2068),
    [sym_email_autolink] = ACTIONS(2068),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2068),
    [sym__digits] = ACTIONS(2068),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2078),
    [sym__emphasis_open_underscore] = ACTIONS(2080),
    [sym__strikethrough_open] = ACTIONS(2084),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2068),
  },
  [147] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(127),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(127),
    [aux_sym__inline_no_star_no_link] = STATE(127),
    [sym__strikethrough_no_link] = STATE(127),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(127),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(127),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2048),
    [sym_numeric_character_reference] = ACTIONS(2048),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2048),
    [sym_email_autolink] = ACTIONS(2048),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2048),
    [sym__digits] = ACTIONS(2048),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2058),
    [sym__emphasis_open_underscore] = ACTIONS(2060),
    [sym__strikethrough_open] = ACTIONS(2064),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2048),
  },
  [148] = {
    [sym_backslash_escape] = STATE(148),
    [sym_code_span] = STATE(148),
    [sym_latex_block] = STATE(148),
    [sym_image] = STATE(148),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(148),
    [sym__whitespace] = STATE(148),
    [sym__word] = STATE(148),
    [sym__soft_line_break] = STATE(148),
    [sym__text_base] = STATE(148),
    [aux_sym__inline_base_repeat1] = STATE(148),
    [ts_builtin_sym_end] = ACTIONS(2376),
    [sym__backslash_escape] = ACTIONS(2378),
    [sym_entity_reference] = ACTIONS(2381),
    [sym_numeric_character_reference] = ACTIONS(2381),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2384),
    [anon_sym_GT] = ACTIONS(2387),
    [anon_sym_BANG] = ACTIONS(2390),
    [anon_sym_DQUOTE] = ACTIONS(2387),
    [anon_sym_POUND] = ACTIONS(2387),
    [anon_sym_DOLLAR] = ACTIONS(2387),
    [anon_sym_PERCENT] = ACTIONS(2387),
    [anon_sym_AMP] = ACTIONS(2393),
    [anon_sym_SQUOTE] = ACTIONS(2387),
    [anon_sym_STAR] = ACTIONS(2387),
    [anon_sym_PLUS] = ACTIONS(2387),
    [anon_sym_COMMA] = ACTIONS(2387),
    [anon_sym_DASH] = ACTIONS(2387),
    [anon_sym_DOT] = ACTIONS(2387),
    [anon_sym_SLASH] = ACTIONS(2387),
    [anon_sym_COLON] = ACTIONS(2387),
    [anon_sym_SEMI] = ACTIONS(2387),
    [anon_sym_EQ] = ACTIONS(2387),
    [anon_sym_QMARK] = ACTIONS(2387),
    [anon_sym_AT] = ACTIONS(2387),
    [anon_sym_BSLASH] = ACTIONS(2396),
    [anon_sym_CARET] = ACTIONS(2387),
    [anon_sym__] = ACTIONS(2387),
    [anon_sym_BQUOTE] = ACTIONS(2387),
    [anon_sym_LBRACE] = ACTIONS(2387),
    [anon_sym_PIPE] = ACTIONS(2387),
    [anon_sym_RBRACE] = ACTIONS(2387),
    [anon_sym_TILDE] = ACTIONS(2387),
    [anon_sym_LPAREN] = ACTIONS(2387),
    [anon_sym_RPAREN] = ACTIONS(2387),
    [sym__newline_token] = ACTIONS(2399),
    [sym_uri_autolink] = ACTIONS(2381),
    [sym_email_autolink] = ACTIONS(2381),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2402),
    [anon_sym_LT_QMARK] = ACTIONS(2405),
    [aux_sym__declaration_token1] = ACTIONS(2408),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2411),
    [sym__whitespace_ge_2] = ACTIONS(2414),
    [aux_sym__whitespace_token1] = ACTIONS(2417),
    [sym__word_no_digit] = ACTIONS(2381),
    [sym__digits] = ACTIONS(2381),
    [sym__code_span_start] = ACTIONS(2420),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2423),
    [sym__unclosed_span] = ACTIONS(2381),
  },
  [149] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__text_base] = STATE(151),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2426),
    [sym_numeric_character_reference] = ACTIONS(2426),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2426),
    [sym_email_autolink] = ACTIONS(2426),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2426),
    [sym__digits] = ACTIONS(2426),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_star] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2426),
  },
  [150] = {
    [sym_backslash_escape] = STATE(150),
    [sym_code_span] = STATE(150),
    [sym_latex_block] = STATE(150),
    [sym_image] = STATE(150),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(150),
    [sym__whitespace] = STATE(150),
    [sym__word] = STATE(150),
    [sym__soft_line_break] = STATE(150),
    [sym__text_base] = STATE(150),
    [aux_sym__inline_base_repeat1] = STATE(150),
    [sym__backslash_escape] = ACTIONS(2430),
    [sym_entity_reference] = ACTIONS(2433),
    [sym_numeric_character_reference] = ACTIONS(2433),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2436),
    [anon_sym_GT] = ACTIONS(2439),
    [anon_sym_BANG] = ACTIONS(2442),
    [anon_sym_DQUOTE] = ACTIONS(2439),
    [anon_sym_POUND] = ACTIONS(2439),
    [anon_sym_DOLLAR] = ACTIONS(2439),
    [anon_sym_PERCENT] = ACTIONS(2439),
    [anon_sym_AMP] = ACTIONS(2445),
    [anon_sym_SQUOTE] = ACTIONS(2439),
    [anon_sym_STAR] = ACTIONS(2439),
    [anon_sym_PLUS] = ACTIONS(2439),
    [anon_sym_COMMA] = ACTIONS(2439),
    [anon_sym_DASH] = ACTIONS(2439),
    [anon_sym_DOT] = ACTIONS(2439),
    [anon_sym_SLASH] = ACTIONS(2439),
    [anon_sym_COLON] = ACTIONS(2439),
    [anon_sym_SEMI] = ACTIONS(2439),
    [anon_sym_EQ] = ACTIONS(2439),
    [anon_sym_QMARK] = ACTIONS(2439),
    [anon_sym_AT] = ACTIONS(2439),
    [anon_sym_BSLASH] = ACTIONS(2448),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym__] = ACTIONS(2439),
    [anon_sym_BQUOTE] = ACTIONS(2439),
    [anon_sym_LBRACE] = ACTIONS(2439),
    [anon_sym_PIPE] = ACTIONS(2439),
    [anon_sym_RBRACE] = ACTIONS(2439),
    [anon_sym_TILDE] = ACTIONS(2439),
    [anon_sym_LPAREN] = ACTIONS(2439),
    [anon_sym_RPAREN] = ACTIONS(2439),
    [sym__newline_token] = ACTIONS(2451),
    [sym_uri_autolink] = ACTIONS(2433),
    [sym_email_autolink] = ACTIONS(2433),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2454),
    [anon_sym_LT_QMARK] = ACTIONS(2457),
    [aux_sym__declaration_token1] = ACTIONS(2460),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2463),
    [sym__whitespace_ge_2] = ACTIONS(2466),
    [aux_sym__whitespace_token1] = ACTIONS(2469),
    [sym__word_no_digit] = ACTIONS(2433),
    [sym__digits] = ACTIONS(2433),
    [sym__code_span_start] = ACTIONS(2472),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__strikethrough_close] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2475),
    [sym__unclosed_span] = ACTIONS(2433),
  },
  [151] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__text_base] = STATE(151),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(2478),
    [sym_entity_reference] = ACTIONS(2481),
    [sym_numeric_character_reference] = ACTIONS(2481),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2484),
    [anon_sym_GT] = ACTIONS(2487),
    [anon_sym_BANG] = ACTIONS(2490),
    [anon_sym_DQUOTE] = ACTIONS(2487),
    [anon_sym_POUND] = ACTIONS(2487),
    [anon_sym_DOLLAR] = ACTIONS(2487),
    [anon_sym_PERCENT] = ACTIONS(2487),
    [anon_sym_AMP] = ACTIONS(2493),
    [anon_sym_SQUOTE] = ACTIONS(2487),
    [anon_sym_STAR] = ACTIONS(2487),
    [anon_sym_PLUS] = ACTIONS(2487),
    [anon_sym_COMMA] = ACTIONS(2487),
    [anon_sym_DASH] = ACTIONS(2487),
    [anon_sym_DOT] = ACTIONS(2487),
    [anon_sym_SLASH] = ACTIONS(2487),
    [anon_sym_COLON] = ACTIONS(2487),
    [anon_sym_SEMI] = ACTIONS(2487),
    [anon_sym_EQ] = ACTIONS(2487),
    [anon_sym_QMARK] = ACTIONS(2487),
    [anon_sym_AT] = ACTIONS(2487),
    [anon_sym_BSLASH] = ACTIONS(2496),
    [anon_sym_CARET] = ACTIONS(2487),
    [anon_sym__] = ACTIONS(2487),
    [anon_sym_BQUOTE] = ACTIONS(2487),
    [anon_sym_LBRACE] = ACTIONS(2487),
    [anon_sym_PIPE] = ACTIONS(2487),
    [anon_sym_RBRACE] = ACTIONS(2487),
    [anon_sym_TILDE] = ACTIONS(2487),
    [anon_sym_LPAREN] = ACTIONS(2487),
    [anon_sym_RPAREN] = ACTIONS(2487),
    [sym__newline_token] = ACTIONS(2499),
    [sym_uri_autolink] = ACTIONS(2481),
    [sym_email_autolink] = ACTIONS(2481),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2502),
    [anon_sym_LT_QMARK] = ACTIONS(2505),
    [aux_sym__declaration_token1] = ACTIONS(2508),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2511),
    [sym__whitespace_ge_2] = ACTIONS(2514),
    [aux_sym__whitespace_token1] = ACTIONS(2517),
    [sym__word_no_digit] = ACTIONS(2481),
    [sym__digits] = ACTIONS(2481),
    [sym__code_span_start] = ACTIONS(2520),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_star] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2523),
    [sym__unclosed_span] = ACTIONS(2481),
  },
  [152] = {
    [sym_backslash_escape] = STATE(152),
    [sym_code_span] = STATE(152),
    [sym_latex_block] = STATE(152),
    [sym_image] = STATE(152),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(152),
    [sym__whitespace] = STATE(152),
    [sym__word] = STATE(152),
    [sym__soft_line_break] = STATE(152),
    [sym__text_base] = STATE(152),
    [aux_sym__inline_base_repeat1] = STATE(152),
    [sym__backslash_escape] = ACTIONS(2526),
    [sym_entity_reference] = ACTIONS(2529),
    [sym_numeric_character_reference] = ACTIONS(2529),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2532),
    [anon_sym_GT] = ACTIONS(2535),
    [anon_sym_BANG] = ACTIONS(2538),
    [anon_sym_DQUOTE] = ACTIONS(2535),
    [anon_sym_POUND] = ACTIONS(2535),
    [anon_sym_DOLLAR] = ACTIONS(2535),
    [anon_sym_PERCENT] = ACTIONS(2535),
    [anon_sym_AMP] = ACTIONS(2541),
    [anon_sym_SQUOTE] = ACTIONS(2535),
    [anon_sym_STAR] = ACTIONS(2535),
    [anon_sym_PLUS] = ACTIONS(2535),
    [anon_sym_COMMA] = ACTIONS(2535),
    [anon_sym_DASH] = ACTIONS(2535),
    [anon_sym_DOT] = ACTIONS(2535),
    [anon_sym_SLASH] = ACTIONS(2535),
    [anon_sym_COLON] = ACTIONS(2535),
    [anon_sym_SEMI] = ACTIONS(2535),
    [anon_sym_EQ] = ACTIONS(2535),
    [anon_sym_QMARK] = ACTIONS(2535),
    [anon_sym_AT] = ACTIONS(2535),
    [anon_sym_BSLASH] = ACTIONS(2544),
    [anon_sym_CARET] = ACTIONS(2535),
    [anon_sym__] = ACTIONS(2535),
    [anon_sym_BQUOTE] = ACTIONS(2535),
    [anon_sym_LBRACE] = ACTIONS(2535),
    [anon_sym_PIPE] = ACTIONS(2535),
    [anon_sym_RBRACE] = ACTIONS(2535),
    [anon_sym_TILDE] = ACTIONS(2535),
    [anon_sym_LPAREN] = ACTIONS(2535),
    [anon_sym_RPAREN] = ACTIONS(2535),
    [sym__newline_token] = ACTIONS(2547),
    [sym_uri_autolink] = ACTIONS(2529),
    [sym_email_autolink] = ACTIONS(2529),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2550),
    [anon_sym_LT_QMARK] = ACTIONS(2553),
    [aux_sym__declaration_token1] = ACTIONS(2556),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2559),
    [sym__whitespace_ge_2] = ACTIONS(2562),
    [aux_sym__whitespace_token1] = ACTIONS(2565),
    [sym__word_no_digit] = ACTIONS(2529),
    [sym__digits] = ACTIONS(2529),
    [sym__code_span_start] = ACTIONS(2568),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2571),
    [sym__unclosed_span] = ACTIONS(2529),
  },
  [153] = {
    [sym_backslash_escape] = STATE(152),
    [sym_code_span] = STATE(152),
    [sym_latex_block] = STATE(152),
    [sym_image] = STATE(152),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(152),
    [sym__whitespace] = STATE(152),
    [sym__word] = STATE(152),
    [sym__soft_line_break] = STATE(152),
    [sym__text_base] = STATE(152),
    [aux_sym__inline_base_repeat1] = STATE(152),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2574),
    [sym_numeric_character_reference] = ACTIONS(2574),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2574),
    [sym_email_autolink] = ACTIONS(2574),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2574),
    [sym__digits] = ACTIONS(2574),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2574),
  },
  [154] = {
    [sym_backslash_escape] = STATE(150),
    [sym_code_span] = STATE(150),
    [sym_latex_block] = STATE(150),
    [sym_image] = STATE(150),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(150),
    [sym__whitespace] = STATE(150),
    [sym__word] = STATE(150),
    [sym__soft_line_break] = STATE(150),
    [sym__text_base] = STATE(150),
    [aux_sym__inline_base_repeat1] = STATE(150),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2576),
    [sym_numeric_character_reference] = ACTIONS(2576),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2576),
    [sym_email_autolink] = ACTIONS(2576),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2576),
    [sym__digits] = ACTIONS(2576),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__strikethrough_close] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2576),
  },
  [155] = {
    [sym_backslash_escape] = STATE(148),
    [sym_code_span] = STATE(148),
    [sym_latex_block] = STATE(148),
    [sym_image] = STATE(148),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(148),
    [sym__whitespace] = STATE(148),
    [sym__word] = STATE(148),
    [sym__soft_line_break] = STATE(148),
    [sym__text_base] = STATE(148),
    [aux_sym__inline_base_repeat1] = STATE(148),
    [ts_builtin_sym_end] = ACTIONS(2428),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(2578),
    [sym_numeric_character_reference] = ACTIONS(2578),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(2578),
    [sym_email_autolink] = ACTIONS(2578),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(2578),
    [sym__digits] = ACTIONS(2578),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(2578),
  },
  [156] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__text_base] = STATE(156),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(2580),
    [sym_entity_reference] = ACTIONS(2583),
    [sym_numeric_character_reference] = ACTIONS(2583),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2586),
    [anon_sym_GT] = ACTIONS(2589),
    [anon_sym_BANG] = ACTIONS(2592),
    [anon_sym_DQUOTE] = ACTIONS(2589),
    [anon_sym_POUND] = ACTIONS(2589),
    [anon_sym_DOLLAR] = ACTIONS(2589),
    [anon_sym_PERCENT] = ACTIONS(2589),
    [anon_sym_AMP] = ACTIONS(2595),
    [anon_sym_SQUOTE] = ACTIONS(2589),
    [anon_sym_STAR] = ACTIONS(2589),
    [anon_sym_PLUS] = ACTIONS(2589),
    [anon_sym_COMMA] = ACTIONS(2589),
    [anon_sym_DASH] = ACTIONS(2589),
    [anon_sym_DOT] = ACTIONS(2589),
    [anon_sym_SLASH] = ACTIONS(2589),
    [anon_sym_COLON] = ACTIONS(2589),
    [anon_sym_SEMI] = ACTIONS(2589),
    [anon_sym_EQ] = ACTIONS(2589),
    [anon_sym_QMARK] = ACTIONS(2589),
    [anon_sym_AT] = ACTIONS(2589),
    [anon_sym_BSLASH] = ACTIONS(2598),
    [anon_sym_CARET] = ACTIONS(2589),
    [anon_sym__] = ACTIONS(2589),
    [anon_sym_BQUOTE] = ACTIONS(2589),
    [anon_sym_LBRACE] = ACTIONS(2589),
    [anon_sym_PIPE] = ACTIONS(2589),
    [anon_sym_RBRACE] = ACTIONS(2589),
    [anon_sym_TILDE] = ACTIONS(2589),
    [anon_sym_LPAREN] = ACTIONS(2589),
    [anon_sym_RPAREN] = ACTIONS(2589),
    [sym__newline_token] = ACTIONS(2601),
    [sym_uri_autolink] = ACTIONS(2583),
    [sym_email_autolink] = ACTIONS(2583),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2604),
    [anon_sym_LT_QMARK] = ACTIONS(2607),
    [aux_sym__declaration_token1] = ACTIONS(2610),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2613),
    [sym__whitespace_ge_2] = ACTIONS(2616),
    [aux_sym__whitespace_token1] = ACTIONS(2619),
    [sym__word_no_digit] = ACTIONS(2583),
    [sym__digits] = ACTIONS(2583),
    [sym__code_span_start] = ACTIONS(2622),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2625),
    [sym__unclosed_span] = ACTIONS(2583),
  },
  [157] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__text_base] = STATE(156),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2628),
    [sym_numeric_character_reference] = ACTIONS(2628),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2628),
    [sym_email_autolink] = ACTIONS(2628),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2628),
    [sym__digits] = ACTIONS(2628),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2628),
  },
  [158] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__text_base] = STATE(161),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2630),
    [sym_numeric_character_reference] = ACTIONS(2630),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2630),
    [sym_email_autolink] = ACTIONS(2630),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2630),
    [sym__digits] = ACTIONS(2630),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__strikethrough_close] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2630),
  },
  [159] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__text_base] = STATE(159),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(2526),
    [sym_entity_reference] = ACTIONS(2632),
    [sym_numeric_character_reference] = ACTIONS(2632),
    [anon_sym_LT] = ACTIONS(2532),
    [anon_sym_GT] = ACTIONS(2535),
    [anon_sym_BANG] = ACTIONS(2635),
    [anon_sym_DQUOTE] = ACTIONS(2535),
    [anon_sym_POUND] = ACTIONS(2535),
    [anon_sym_DOLLAR] = ACTIONS(2535),
    [anon_sym_PERCENT] = ACTIONS(2535),
    [anon_sym_AMP] = ACTIONS(2541),
    [anon_sym_SQUOTE] = ACTIONS(2535),
    [anon_sym_STAR] = ACTIONS(2535),
    [anon_sym_PLUS] = ACTIONS(2535),
    [anon_sym_COMMA] = ACTIONS(2535),
    [anon_sym_DASH] = ACTIONS(2535),
    [anon_sym_DOT] = ACTIONS(2535),
    [anon_sym_SLASH] = ACTIONS(2535),
    [anon_sym_COLON] = ACTIONS(2535),
    [anon_sym_SEMI] = ACTIONS(2535),
    [anon_sym_EQ] = ACTIONS(2535),
    [anon_sym_QMARK] = ACTIONS(2535),
    [anon_sym_AT] = ACTIONS(2535),
    [anon_sym_BSLASH] = ACTIONS(2544),
    [anon_sym_CARET] = ACTIONS(2535),
    [anon_sym__] = ACTIONS(2535),
    [anon_sym_BQUOTE] = ACTIONS(2535),
    [anon_sym_LBRACE] = ACTIONS(2535),
    [anon_sym_PIPE] = ACTIONS(2535),
    [anon_sym_RBRACE] = ACTIONS(2535),
    [anon_sym_TILDE] = ACTIONS(2535),
    [anon_sym_LPAREN] = ACTIONS(2535),
    [anon_sym_RPAREN] = ACTIONS(2535),
    [sym__newline_token] = ACTIONS(2547),
    [sym_uri_autolink] = ACTIONS(2632),
    [sym_email_autolink] = ACTIONS(2632),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2638),
    [anon_sym_LT_QMARK] = ACTIONS(2641),
    [aux_sym__declaration_token1] = ACTIONS(2556),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2644),
    [sym__whitespace_ge_2] = ACTIONS(2562),
    [aux_sym__whitespace_token1] = ACTIONS(2565),
    [sym__word_no_digit] = ACTIONS(2632),
    [sym__digits] = ACTIONS(2632),
    [sym__code_span_start] = ACTIONS(2568),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2571),
    [sym__unclosed_span] = ACTIONS(2632),
  },
  [160] = {
    [sym_backslash_escape] = STATE(162),
    [sym_code_span] = STATE(162),
    [sym_latex_block] = STATE(162),
    [sym_image] = STATE(162),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(162),
    [sym__whitespace] = STATE(162),
    [sym__word] = STATE(162),
    [sym__soft_line_break] = STATE(162),
    [sym__text_base] = STATE(162),
    [aux_sym__inline_base_repeat1] = STATE(162),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2647),
    [sym_numeric_character_reference] = ACTIONS(2647),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2647),
    [sym_email_autolink] = ACTIONS(2647),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2647),
    [sym__digits] = ACTIONS(2647),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2647),
  },
  [161] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__text_base] = STATE(161),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(2430),
    [sym_entity_reference] = ACTIONS(2649),
    [sym_numeric_character_reference] = ACTIONS(2649),
    [anon_sym_LT] = ACTIONS(2436),
    [anon_sym_GT] = ACTIONS(2439),
    [anon_sym_BANG] = ACTIONS(2652),
    [anon_sym_DQUOTE] = ACTIONS(2439),
    [anon_sym_POUND] = ACTIONS(2439),
    [anon_sym_DOLLAR] = ACTIONS(2439),
    [anon_sym_PERCENT] = ACTIONS(2439),
    [anon_sym_AMP] = ACTIONS(2445),
    [anon_sym_SQUOTE] = ACTIONS(2439),
    [anon_sym_STAR] = ACTIONS(2439),
    [anon_sym_PLUS] = ACTIONS(2439),
    [anon_sym_COMMA] = ACTIONS(2439),
    [anon_sym_DASH] = ACTIONS(2439),
    [anon_sym_DOT] = ACTIONS(2439),
    [anon_sym_SLASH] = ACTIONS(2439),
    [anon_sym_COLON] = ACTIONS(2439),
    [anon_sym_SEMI] = ACTIONS(2439),
    [anon_sym_EQ] = ACTIONS(2439),
    [anon_sym_QMARK] = ACTIONS(2439),
    [anon_sym_AT] = ACTIONS(2439),
    [anon_sym_BSLASH] = ACTIONS(2448),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym__] = ACTIONS(2439),
    [anon_sym_BQUOTE] = ACTIONS(2439),
    [anon_sym_LBRACE] = ACTIONS(2439),
    [anon_sym_PIPE] = ACTIONS(2439),
    [anon_sym_RBRACE] = ACTIONS(2439),
    [anon_sym_TILDE] = ACTIONS(2439),
    [anon_sym_LPAREN] = ACTIONS(2439),
    [anon_sym_RPAREN] = ACTIONS(2439),
    [sym__newline_token] = ACTIONS(2451),
    [sym_uri_autolink] = ACTIONS(2649),
    [sym_email_autolink] = ACTIONS(2649),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2655),
    [anon_sym_LT_QMARK] = ACTIONS(2658),
    [aux_sym__declaration_token1] = ACTIONS(2460),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2661),
    [sym__whitespace_ge_2] = ACTIONS(2466),
    [aux_sym__whitespace_token1] = ACTIONS(2469),
    [sym__word_no_digit] = ACTIONS(2649),
    [sym__digits] = ACTIONS(2649),
    [sym__code_span_start] = ACTIONS(2472),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__strikethrough_close] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2475),
    [sym__unclosed_span] = ACTIONS(2649),
  },
  [162] = {
    [sym_backslash_escape] = STATE(162),
    [sym_code_span] = STATE(162),
    [sym_latex_block] = STATE(162),
    [sym_image] = STATE(162),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(162),
    [sym__whitespace] = STATE(162),
    [sym__word] = STATE(162),
    [sym__soft_line_break] = STATE(162),
    [sym__text_base] = STATE(162),
    [aux_sym__inline_base_repeat1] = STATE(162),
    [sym__backslash_escape] = ACTIONS(2580),
    [sym_entity_reference] = ACTIONS(2664),
    [sym_numeric_character_reference] = ACTIONS(2664),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2586),
    [anon_sym_GT] = ACTIONS(2589),
    [anon_sym_BANG] = ACTIONS(2667),
    [anon_sym_DQUOTE] = ACTIONS(2589),
    [anon_sym_POUND] = ACTIONS(2589),
    [anon_sym_DOLLAR] = ACTIONS(2589),
    [anon_sym_PERCENT] = ACTIONS(2589),
    [anon_sym_AMP] = ACTIONS(2595),
    [anon_sym_SQUOTE] = ACTIONS(2589),
    [anon_sym_STAR] = ACTIONS(2589),
    [anon_sym_PLUS] = ACTIONS(2589),
    [anon_sym_COMMA] = ACTIONS(2589),
    [anon_sym_DASH] = ACTIONS(2589),
    [anon_sym_DOT] = ACTIONS(2589),
    [anon_sym_SLASH] = ACTIONS(2589),
    [anon_sym_COLON] = ACTIONS(2589),
    [anon_sym_SEMI] = ACTIONS(2589),
    [anon_sym_EQ] = ACTIONS(2589),
    [anon_sym_QMARK] = ACTIONS(2589),
    [anon_sym_AT] = ACTIONS(2589),
    [anon_sym_BSLASH] = ACTIONS(2598),
    [anon_sym_CARET] = ACTIONS(2589),
    [anon_sym__] = ACTIONS(2589),
    [anon_sym_BQUOTE] = ACTIONS(2589),
    [anon_sym_LBRACE] = ACTIONS(2589),
    [anon_sym_PIPE] = ACTIONS(2589),
    [anon_sym_RBRACE] = ACTIONS(2589),
    [anon_sym_TILDE] = ACTIONS(2589),
    [anon_sym_LPAREN] = ACTIONS(2589),
    [anon_sym_RPAREN] = ACTIONS(2589),
    [sym__newline_token] = ACTIONS(2601),
    [sym_uri_autolink] = ACTIONS(2664),
    [sym_email_autolink] = ACTIONS(2664),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2670),
    [anon_sym_LT_QMARK] = ACTIONS(2673),
    [aux_sym__declaration_token1] = ACTIONS(2610),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2676),
    [sym__whitespace_ge_2] = ACTIONS(2616),
    [aux_sym__whitespace_token1] = ACTIONS(2619),
    [sym__word_no_digit] = ACTIONS(2664),
    [sym__digits] = ACTIONS(2664),
    [sym__code_span_start] = ACTIONS(2622),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2625),
    [sym__unclosed_span] = ACTIONS(2664),
  },
  [163] = {
    [sym_backslash_escape] = STATE(165),
    [sym_code_span] = STATE(165),
    [sym_latex_block] = STATE(165),
    [sym_image] = STATE(165),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(165),
    [sym__whitespace] = STATE(165),
    [sym__word] = STATE(165),
    [sym__soft_line_break] = STATE(165),
    [sym__text_base] = STATE(165),
    [aux_sym__inline_base_repeat1] = STATE(165),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2679),
    [sym_numeric_character_reference] = ACTIONS(2679),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2050),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2679),
    [sym_email_autolink] = ACTIONS(2679),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2052),
    [anon_sym_LT_QMARK] = ACTIONS(2054),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2056),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2679),
    [sym__digits] = ACTIONS(2679),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_star] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2679),
  },
  [164] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__text_base] = STATE(159),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2681),
    [sym_numeric_character_reference] = ACTIONS(2681),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2070),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2681),
    [sym_email_autolink] = ACTIONS(2681),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2074),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2076),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2681),
    [sym__digits] = ACTIONS(2681),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2681),
  },
  [165] = {
    [sym_backslash_escape] = STATE(165),
    [sym_code_span] = STATE(165),
    [sym_latex_block] = STATE(165),
    [sym_image] = STATE(165),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(165),
    [sym__whitespace] = STATE(165),
    [sym__word] = STATE(165),
    [sym__soft_line_break] = STATE(165),
    [sym__text_base] = STATE(165),
    [aux_sym__inline_base_repeat1] = STATE(165),
    [sym__backslash_escape] = ACTIONS(2478),
    [sym_entity_reference] = ACTIONS(2683),
    [sym_numeric_character_reference] = ACTIONS(2683),
    [anon_sym_LT] = ACTIONS(2484),
    [anon_sym_GT] = ACTIONS(2487),
    [anon_sym_BANG] = ACTIONS(2686),
    [anon_sym_DQUOTE] = ACTIONS(2487),
    [anon_sym_POUND] = ACTIONS(2487),
    [anon_sym_DOLLAR] = ACTIONS(2487),
    [anon_sym_PERCENT] = ACTIONS(2487),
    [anon_sym_AMP] = ACTIONS(2493),
    [anon_sym_SQUOTE] = ACTIONS(2487),
    [anon_sym_STAR] = ACTIONS(2487),
    [anon_sym_PLUS] = ACTIONS(2487),
    [anon_sym_COMMA] = ACTIONS(2487),
    [anon_sym_DASH] = ACTIONS(2487),
    [anon_sym_DOT] = ACTIONS(2487),
    [anon_sym_SLASH] = ACTIONS(2487),
    [anon_sym_COLON] = ACTIONS(2487),
    [anon_sym_SEMI] = ACTIONS(2487),
    [anon_sym_EQ] = ACTIONS(2487),
    [anon_sym_QMARK] = ACTIONS(2487),
    [anon_sym_AT] = ACTIONS(2487),
    [anon_sym_BSLASH] = ACTIONS(2496),
    [anon_sym_CARET] = ACTIONS(2487),
    [anon_sym__] = ACTIONS(2487),
    [anon_sym_BQUOTE] = ACTIONS(2487),
    [anon_sym_LBRACE] = ACTIONS(2487),
    [anon_sym_PIPE] = ACTIONS(2487),
    [anon_sym_RBRACE] = ACTIONS(2487),
    [anon_sym_TILDE] = ACTIONS(2487),
    [anon_sym_LPAREN] = ACTIONS(2487),
    [anon_sym_RPAREN] = ACTIONS(2487),
    [sym__newline_token] = ACTIONS(2499),
    [sym_uri_autolink] = ACTIONS(2683),
    [sym_email_autolink] = ACTIONS(2683),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2689),
    [anon_sym_LT_QMARK] = ACTIONS(2692),
    [aux_sym__declaration_token1] = ACTIONS(2508),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2695),
    [sym__whitespace_ge_2] = ACTIONS(2514),
    [aux_sym__whitespace_token1] = ACTIONS(2517),
    [sym__word_no_digit] = ACTIONS(2683),
    [sym__digits] = ACTIONS(2683),
    [sym__code_span_start] = ACTIONS(2520),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_star] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2523),
    [sym__unclosed_span] = ACTIONS(2683),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(2700), 1,
      anon_sym_LBRACK,
    ACTIONS(2702), 1,
      anon_sym_RBRACK,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2715), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2723), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2704), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(753), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [83] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2735), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2743), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(754), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [162] = 11,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2735), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2743), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2746), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(754), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [243] = 11,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2748), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2746), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2750), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(764), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [324] = 11,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2753), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2746), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2755), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(726), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [405] = 10,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2758), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2760), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2704), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(765), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [484] = 10,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2763), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2765), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2704), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(767), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [563] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2748), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2750), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(764), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [642] = 12,
    ACTIONS(2700), 1,
      anon_sym_LBRACK,
    ACTIONS(2702), 1,
      anon_sym_RBRACK,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2763), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2765), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2704), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(767), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [725] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2768), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2770), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(774), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      ts_builtin_sym_end,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [804] = 10,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2715), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2723), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2704), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(753), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [883] = 12,
    ACTIONS(2700), 1,
      anon_sym_LBRACK,
    ACTIONS(2702), 1,
      anon_sym_RBRACK,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2758), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2760), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2704), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(765), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [966] = 10,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2773), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2775), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2704), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(777), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      ts_builtin_sym_end,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1045] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2753), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2755), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(726), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1124] = 11,
    ACTIONS(2784), 1,
      anon_sym_DASH,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2790), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2798), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2781), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(755), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2778), 27,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1204] = 11,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2807), 1,
      anon_sym_DASH,
    ACTIONS(2810), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2812), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2804), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(769), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2801), 27,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1284] = 12,
    ACTIONS(2784), 1,
      anon_sym_DASH,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2790), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2798), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2815), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2781), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(755), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2778), 25,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1366] = 11,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2823), 1,
      anon_sym_DASH,
    ACTIONS(2826), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2828), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2820), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(772), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      ts_builtin_sym_end,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2817), 27,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1446] = 11,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2746), 1,
      anon_sym_LBRACK,
    ACTIONS(2831), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2833), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(824), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 12,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 27,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1526] = 11,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2842), 1,
      anon_sym_DASH,
    ACTIONS(2845), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2847), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2839), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(763), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2836), 27,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1606] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2831), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2833), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(824), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 12,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1684] = 12,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2807), 1,
      anon_sym_DASH,
    ACTIONS(2810), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2812), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2850), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2804), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(769), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2801), 25,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_